/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.conv;

import java.io.IOException;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordSysBuilder;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.projection.Sinusoidal;

public class HdfEosModisConvention
extends CoordSysBuilder {
    private static final String CRS = "Projection";
    private static final String DATA_GROUP = "Data_Fields";
    private static final String DIMX_NAME = "XDim";
    private static final String DIMY_NAME = "YDim";
    private static final String TIME_NAME = "time";
    private boolean addTimeCoord;

    public static boolean isMine(NetcdfFile ncfile) {
        if (!ncfile.getFileTypeId().equals("HDF4-EOS")) {
            return false;
        }
        String typeName = ncfile.findAttValueIgnoreCase(null, "featureType", null);
        if (typeName == null) {
            return false;
        }
        if (!typeName.equals(FeatureType.GRID.toString()) && !typeName.equals(FeatureType.SWATH.toString())) {
            return false;
        }
        return HdfEosModisConvention.checkGroup(ncfile.getRootGroup());
    }

    private static boolean checkGroup(Group g) {
        Attribute att;
        Variable crs = g.findVariable("_HDFEOS_CRS");
        Group dataG = g.findGroup(DATA_GROUP);
        if (crs != null && dataG != null && (att = crs.findAttribute(CRS)) != null && att.getStringValue().equals("GCTP_SNSOID")) {
            return true;
        }
        for (Group ng : g.getGroups()) {
            if (!HdfEosModisConvention.checkGroup(ng)) continue;
            return true;
        }
        return false;
    }

    public HdfEosModisConvention() {
        this.conventionName = "HDF4-EOS-MODIS";
    }

    @Override
    public void augmentDataset(NetcdfDataset ds, CancelTask cancelTask) throws IOException {
        this.addTimeCoord = this.addTimeCoordinate(ds);
        this.findGroup(ds, ds.getRootGroup());
        ds.addAttribute(ds.getRootGroup(), new Attribute("Conventions", "CF-1.0"));
        ds.finish();
    }

    private boolean addTimeCoordinate(NetcdfDataset ds) {
        CalendarDate cd = this.parseFilenameForDate(ds.getLocation());
        if (cd == null) {
            return false;
        }
        ds.addAttribute(ds.getRootGroup(), new Attribute("_MODIS_Date", cd.toString()));
        int nTimesDim = 1;
        Dimension newDim = new Dimension(TIME_NAME, nTimesDim);
        ds.addDimension(null, newDim);
        String units = "seconds since " + cd.toString();
        String desc = "time coordinate";
        Array data = Array.makeArray(DataType.DOUBLE, 1, 0.0, 0.0);
        CoordinateAxis1D timeCoord = new CoordinateAxis1D(ds, null, TIME_NAME, DataType.DOUBLE, "", units, desc);
        timeCoord.setCachedData(data, true);
        timeCoord.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Time.toString()));
        ds.addCoordinateAxis(timeCoord);
        return true;
    }

    private CalendarDate parseFilenameForDate(String filename) {
        String[] tokes = filename.split("\\.");
        if (tokes.length < 2) {
            return null;
        }
        if (tokes[1].length() < 8) {
            return null;
        }
        String want = tokes[1];
        String yearS = want.substring(1, 5);
        String jdayS = want.substring(5, 8);
        try {
            int year = Integer.parseInt(yearS);
            int jday = Integer.parseInt(jdayS);
            return CalendarDate.withDoy(null, year, jday, 0, 0, 0);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void findGroup(NetcdfDataset ds, Group g) {
        if (g.findVariable("_HDFEOS_CRS") != null) {
            this.augmentGroup(ds, g);
        }
        for (Group ng : g.getGroups()) {
            this.findGroup(ds, ng);
        }
    }

    private void augmentGroup(NetcdfDataset ds, Group g) {
        Dimension dimX = null;
        Dimension dimY = null;
        Group dataG = g.findGroup(DATA_GROUP);
        if (dataG != null) {
            dimX = dataG.findDimensionLocal(DIMX_NAME);
            dimY = dataG.findDimensionLocal(DIMY_NAME);
        }
        if (dimX == null || dimY == null) {
            return;
        }
        Variable crs = g.findVariable("_HDFEOS_CRS");
        Attribute att = crs.findAttribute(CRS);
        if (att != null && att.getStringValue().equals("GCTP_SNSOID")) {
            Attribute upperLeft = crs.findAttribute("UpperLeftPointMtrs");
            Attribute lowerRight = crs.findAttribute("LowerRightMtrs");
            Attribute projParams = crs.findAttribute("ProjParams");
            ProjectionCT ct = this.makeSinusoidalProjection(CRS, projParams);
            VariableDS crss = this.makeCoordinateTransformVariable(ds, ct);
            crss.addAttribute(new Attribute("_CoordinateAxisTypes", "GeoX GeoY"));
            ds.addVariable(dataG, crss);
            double minX = upperLeft.getNumericValue(0).doubleValue();
            double minY = upperLeft.getNumericValue(1).doubleValue();
            double maxX = lowerRight.getNumericValue(0).doubleValue();
            double maxY = lowerRight.getNumericValue(1).doubleValue();
            ds.addCoordinateAxis(this.makeCoordAxis(ds, dataG, DIMX_NAME, dimX.getLength(), minX, maxX, true));
            ds.addCoordinateAxis(this.makeCoordAxis(ds, dataG, DIMY_NAME, dimY.getLength(), minY, maxY, false));
            for (Variable v : dataG.getVariables()) {
                if (v.getRank() != 2 || !v.getDimension(0).equals(dimY) || !v.getDimension(1).equals(dimX)) continue;
                v.addAttribute(new Attribute("grid_mapping", CRS));
                if (!this.addTimeCoord) continue;
                v.addAttribute(new Attribute("_CoordinateAxes", "time XDim YDim"));
            }
        }
    }

    private CoordinateAxis makeCoordAxis(NetcdfDataset ds, Group g, String name, int n, double start, double end, boolean isX) {
        CoordinateAxis1D v = new CoordinateAxis1D(ds, g, name, DataType.DOUBLE, name, "km", isX ? "x coordinate" : "y coordinate");
        double incr = (end - start) / (double)n;
        v.setValues(n, start * 0.001, incr * 0.001);
        v.addAttribute(new Attribute("_CoordinateAxisType", isX ? AxisType.GeoX.toString() : AxisType.GeoY.toString()));
        return v;
    }

    private ProjectionCT makeSinusoidalProjection(String name, Attribute projParams) {
        double radius = projParams.getNumericValue(0).doubleValue();
        double centMer = projParams.getNumericValue(4).doubleValue();
        double falseEast = projParams.getNumericValue(6).doubleValue();
        double falseNorth = projParams.getNumericValue(7).doubleValue();
        Sinusoidal proj = new Sinusoidal(centMer, falseEast * 0.001, falseNorth * 0.001, radius * 0.001);
        return new ProjectionCT(name, "FGDC", proj);
    }
}

