/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.trajectory;

import java.io.IOException;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.TrajectoryObsDataset;
import ucar.nc2.dt.trajectory.ARMTrajectoryObsDataset;
import ucar.nc2.dt.trajectory.Float10TrajectoryObsDataset;
import ucar.nc2.dt.trajectory.RafTrajectoryObsDataset;
import ucar.nc2.dt.trajectory.SimpleTrajectoryObsDataset;
import ucar.nc2.dt.trajectory.ZebraClassTrajectoryObsDataset;
import ucar.nc2.util.CancelTask;

public class TrajectoryObsDatasetFactory {
    public static TrajectoryObsDataset open(String netcdfFileURI) throws IOException {
        return TrajectoryObsDatasetFactory.open(netcdfFileURI, null);
    }

    public static TrajectoryObsDataset open(String netcdfFileURI, CancelTask cancelTask) throws IOException {
        NetcdfDataset ds = NetcdfDataset.acquireDataset(netcdfFileURI, cancelTask);
        if (RafTrajectoryObsDataset.isValidFile(ds)) {
            return new RafTrajectoryObsDataset(ds);
        }
        if (SimpleTrajectoryObsDataset.isValidFile(ds)) {
            return new SimpleTrajectoryObsDataset(ds);
        }
        if (Float10TrajectoryObsDataset.isValidFile(ds)) {
            return new Float10TrajectoryObsDataset(ds);
        }
        if (ZebraClassTrajectoryObsDataset.isValidFile(ds)) {
            return new ZebraClassTrajectoryObsDataset(ds);
        }
        if (ARMTrajectoryObsDataset.isValidFile(ds)) {
            return new ARMTrajectoryObsDataset(ds);
        }
        return null;
    }
}

