/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.hdf5;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.iosp.hdf5.H5header;
import ucar.nc2.iosp.hdf5.MemTracker;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.SpecialMathFunction;

public class FractalHeap {
    private static Logger log = LoggerFactory.getLogger(FractalHeap.class);
    private PrintStream debugOut = System.out;
    private boolean debugDetail;
    private boolean debugFractalHeap;
    private boolean debugPos;
    private MemTracker memTracker;
    int version;
    short heapIdLen;
    byte flags;
    int maxSizeOfObjects;
    long nextHugeObjectId;
    long freeSpace;
    long managedSpace;
    long allocatedManagedSpace;
    long offsetDirectBlock;
    long nManagedObjects;
    long sizeHugeObjects;
    long nHugeObjects;
    long sizeTinyObjects;
    long nTinyObjects;
    long btreeAddress;
    long freeSpaceTrackerAddress;
    short maxHeapSize;
    short startingNumRows;
    short currentNumRows;
    long maxDirectBlockSize;
    short tableWidth;
    long startingBlockSize;
    long rootBlockAddress;
    IndirectBlock rootBlock;
    short ioFilterLen;
    long sizeFilteredRootDirectBlock;
    int ioFilterMask;
    byte[] ioFilterInfo;
    DoublingTable doublingTable;
    H5header h5;
    RandomAccessFile raf;

    public void setMemTracker(MemTracker memTracker) {
        this.memTracker = memTracker;
    }

    FractalHeap(H5header h5, String forWho, long address) throws IOException {
        boolean hasFilters;
        this.h5 = h5;
        this.raf = h5.raf;
        this.raf.order(1);
        this.raf.seek(h5.getFileOffset(address));
        if (this.debugDetail) {
            this.debugOut.println("-- readFractalHeap position=" + this.raf.getFilePointer());
        }
        byte[] heapname = new byte[4];
        this.raf.read(heapname);
        String magic = new String(heapname);
        if (!magic.equals("FRHP")) {
            throw new IllegalStateException(magic + " should equal FRHP");
        }
        this.version = this.raf.readByte();
        this.heapIdLen = this.raf.readShort();
        this.ioFilterLen = this.raf.readShort();
        this.flags = this.raf.readByte();
        this.maxSizeOfObjects = this.raf.readInt();
        this.nextHugeObjectId = h5.readLength();
        this.btreeAddress = h5.readOffset();
        this.freeSpace = h5.readLength();
        this.freeSpaceTrackerAddress = h5.readOffset();
        this.managedSpace = h5.readLength();
        this.allocatedManagedSpace = h5.readLength();
        this.offsetDirectBlock = h5.readLength();
        this.nManagedObjects = h5.readLength();
        this.sizeHugeObjects = h5.readLength();
        this.nHugeObjects = h5.readLength();
        this.sizeTinyObjects = h5.readLength();
        this.nTinyObjects = h5.readLength();
        this.tableWidth = this.raf.readShort();
        this.startingBlockSize = h5.readLength();
        this.maxDirectBlockSize = h5.readLength();
        this.maxHeapSize = this.raf.readShort();
        this.startingNumRows = this.raf.readShort();
        this.rootBlockAddress = h5.readOffset();
        this.currentNumRows = this.raf.readShort();
        boolean bl = hasFilters = this.ioFilterLen > 0;
        if (hasFilters) {
            this.sizeFilteredRootDirectBlock = h5.readLength();
            this.ioFilterMask = this.raf.readInt();
            this.ioFilterInfo = new byte[this.ioFilterLen];
            this.raf.read(this.ioFilterInfo);
        }
        int checksum = this.raf.readInt();
        if (this.debugDetail || this.debugFractalHeap) {
            this.debugOut.println("FractalHeap for " + forWho + " version=" + this.version + " heapIdLen=" + this.heapIdLen + " ioFilterLen=" + this.ioFilterLen + " flags= " + this.flags);
            this.debugOut.println(" maxSizeOfObjects=" + this.maxSizeOfObjects + " nextHugeObjectId=" + this.nextHugeObjectId + " btreeAddress=" + this.btreeAddress + " managedSpace=" + this.managedSpace + " allocatedManagedSpace=" + this.allocatedManagedSpace + " freeSpace=" + this.freeSpace);
            this.debugOut.println(" nManagedObjects=" + this.nManagedObjects + " nHugeObjects= " + this.nHugeObjects + " nTinyObjects=" + this.nTinyObjects + " maxDirectBlockSize=" + this.maxDirectBlockSize + " maxHeapSize= 2^" + this.maxHeapSize);
            this.debugOut.println(" DoublingTable: tableWidth=" + this.tableWidth + " startingBlockSize=" + this.startingBlockSize);
            this.debugOut.println(" rootBlockAddress=" + this.rootBlockAddress + " startingNumRows=" + this.startingNumRows + " currentNumRows=" + this.currentNumRows);
        }
        if (this.debugPos) {
            this.debugOut.println("    *now at position=" + this.raf.getFilePointer());
        }
        long pos = this.raf.getFilePointer();
        if (this.debugDetail) {
            this.debugOut.println("-- end FractalHeap position=" + this.raf.getFilePointer());
        }
        int hsize = 8 + 2 * h5.sizeLengths + h5.sizeOffsets;
        if (this.memTracker != null) {
            this.memTracker.add("Group FractalHeap (" + forWho + ")", address, pos);
        }
        this.doublingTable = new DoublingTable(this.tableWidth, this.startingBlockSize, this.allocatedManagedSpace, this.maxDirectBlockSize);
        this.rootBlock = new IndirectBlock(this.currentNumRows, this.startingBlockSize);
        if (this.currentNumRows == 0) {
            DataBlock dblock = new DataBlock();
            this.doublingTable.blockList.add(dblock);
            this.readDirectBlock(h5.getFileOffset(this.rootBlockAddress), address, dblock);
            dblock.size = this.startingBlockSize - (long)dblock.extraBytes;
            this.rootBlock.add(dblock);
        } else {
            this.readIndirectBlock(this.rootBlock, h5.getFileOffset(this.rootBlockAddress), address, hasFilters);
            for (DataBlock dblock : this.doublingTable.blockList) {
                if (dblock.address <= 0L) continue;
                this.readDirectBlock(h5.getFileOffset(dblock.address), address, dblock);
                dblock.size -= (long)dblock.extraBytes;
            }
        }
    }

    void showDetails(Formatter f) {
        f.format("FractalHeap version=" + this.version + " heapIdLen=" + this.heapIdLen + " ioFilterLen=" + this.ioFilterLen + " flags= " + this.flags + "\n", new Object[0]);
        f.format(" maxSizeOfObjects=" + this.maxSizeOfObjects + " nextHugeObjectId=" + this.nextHugeObjectId + " btreeAddress=" + this.btreeAddress + " managedSpace=" + this.managedSpace + " allocatedManagedSpace=" + this.allocatedManagedSpace + " freeSpace=" + this.freeSpace + "\n", new Object[0]);
        f.format(" nManagedObjects=" + this.nManagedObjects + " nHugeObjects= " + this.nHugeObjects + " nTinyObjects=" + this.nTinyObjects + " maxDirectBlockSize=" + this.maxDirectBlockSize + " maxHeapSize= 2^" + this.maxHeapSize + "\n", new Object[0]);
        f.format(" rootBlockAddress=" + this.rootBlockAddress + " startingNumRows=" + this.startingNumRows + " currentNumRows=" + this.currentNumRows + "\n\n", new Object[0]);
        this.rootBlock.showDetails(f);
    }

    DHeapId getHeapId(byte[] heapId) throws IOException {
        return new DHeapId(heapId);
    }

    void readIndirectBlock(IndirectBlock iblock, long pos, long heapAddress, boolean hasFilter) throws IOException {
        int i;
        int row;
        this.raf.seek(pos);
        byte[] heapname = new byte[4];
        this.raf.read(heapname);
        String magic = new String(heapname);
        if (!magic.equals("FHIB")) {
            throw new IllegalStateException(magic + " should equal FHIB");
        }
        byte version = this.raf.readByte();
        long heapHeaderAddress = this.h5.readOffset();
        if (heapAddress != heapHeaderAddress) {
            throw new IllegalStateException();
        }
        int nbytes = this.maxHeapSize / 8;
        if (this.maxHeapSize % 8 != 0) {
            ++nbytes;
        }
        long blockOffset = this.h5.readVariableSizeUnsigned(nbytes);
        if (this.debugDetail || this.debugFractalHeap) {
            this.debugOut.println(" -- FH IndirectBlock version=" + version + " blockOffset= " + blockOffset);
        }
        long npos = this.raf.getFilePointer();
        if (this.debugPos) {
            this.debugOut.println("    *now at position=" + npos);
        }
        long blockSize = this.startingBlockSize;
        for (row = 0; row < iblock.directRows; ++row) {
            if (row > 1) {
                blockSize *= 2L;
            }
            for (i = 0; i < this.doublingTable.tableWidth; ++i) {
                DataBlock directBlock = new DataBlock();
                iblock.add(directBlock);
                directBlock.address = this.h5.readOffset();
                if (hasFilter) {
                    directBlock.sizeFilteredDirectBlock = this.h5.readLength();
                    directBlock.filterMask = this.raf.readInt();
                }
                if (this.debugDetail || this.debugFractalHeap) {
                    this.debugOut.println("  DirectChild " + i + " address= " + directBlock.address);
                }
                directBlock.size = blockSize;
                this.doublingTable.blockList.add(directBlock);
            }
        }
        for (row = 0; row < iblock.indirectRows; ++row) {
            blockSize *= 2L;
            for (i = 0; i < this.doublingTable.tableWidth; ++i) {
                IndirectBlock iblock2 = new IndirectBlock(-1, blockSize);
                iblock.add(iblock2);
                long childIndirectAddress = this.h5.readOffset();
                if (this.debugDetail || this.debugFractalHeap) {
                    this.debugOut.println("  InDirectChild " + row + " address= " + childIndirectAddress);
                }
                if (childIndirectAddress < 0L) continue;
                this.readIndirectBlock(iblock2, childIndirectAddress, heapAddress, hasFilter);
            }
        }
    }

    void readDirectBlock(long pos, long heapAddress, DataBlock dblock) throws IOException {
        this.raf.seek(pos);
        byte[] heapname = new byte[4];
        this.raf.read(heapname);
        String magic = new String(heapname);
        if (!magic.equals("FHDB")) {
            throw new IllegalStateException(magic + " should equal FHDB");
        }
        byte version = this.raf.readByte();
        long heapHeaderAddress = this.h5.readOffset();
        if (heapAddress != heapHeaderAddress) {
            throw new IllegalStateException();
        }
        dblock.extraBytes = 5;
        dblock.extraBytes = dblock.extraBytes + (this.h5.isOffsetLong ? 8 : 4);
        int nbytes = this.maxHeapSize / 8;
        if (this.maxHeapSize % 8 != 0) {
            ++nbytes;
        }
        dblock.offset = this.h5.readVariableSizeUnsigned(nbytes);
        dblock.dataPos = pos;
        dblock.extraBytes += nbytes;
        if ((this.flags & 2) != 0) {
            dblock.extraBytes += 4;
        }
        if (this.debugDetail || this.debugFractalHeap) {
            this.debugOut.println("  DirectBlock offset= " + dblock.offset + " dataPos = " + dblock.dataPos);
        }
    }

    private class DataBlock {
        long address;
        long sizeFilteredDirectBlock;
        int filterMask;
        long dataPos;
        long offset;
        long size;
        int extraBytes;

        private DataBlock() {
        }

        public String toString() {
            return "DataBlock{offset=" + this.offset + ", size=" + this.size + ", dataPos=" + this.dataPos + '}';
        }
    }

    private class IndirectBlock {
        long size;
        int nrows;
        int directRows;
        int indirectRows;
        List<DataBlock> directBlocks;
        List<IndirectBlock> indirectBlocks;

        IndirectBlock(int nrows, long iblock_size) {
            int maxrows_directBlocks;
            this.nrows = nrows;
            this.size = iblock_size;
            if (nrows < 0) {
                double n = SpecialMathFunction.log2(iblock_size) - SpecialMathFunction.log2(FractalHeap.this.startingBlockSize * (long)FractalHeap.this.tableWidth) + 1.0;
                nrows = (int)n;
            }
            if (nrows < (maxrows_directBlocks = (int)(SpecialMathFunction.log2(FractalHeap.this.maxDirectBlockSize) - SpecialMathFunction.log2(FractalHeap.this.startingBlockSize)) + 2)) {
                this.directRows = nrows;
                this.indirectRows = 0;
            } else {
                this.directRows = maxrows_directBlocks;
                this.indirectRows = nrows - maxrows_directBlocks;
            }
            if (FractalHeap.this.debugFractalHeap) {
                FractalHeap.this.debugOut.println("  readIndirectBlock directChildren" + this.directRows + " indirectChildren= " + this.indirectRows);
            }
        }

        void add(DataBlock dblock) {
            if (this.directBlocks == null) {
                this.directBlocks = new ArrayList<DataBlock>();
            }
            this.directBlocks.add(dblock);
        }

        void add(IndirectBlock iblock) {
            if (this.indirectBlocks == null) {
                this.indirectBlocks = new ArrayList<IndirectBlock>();
            }
            this.indirectBlocks.add(iblock);
        }

        void showDetails(Formatter f) {
            f.format("%n IndirectBlock: nrows= %d directRows = %d indirectRows=%d startingSize=%d%n", this.nrows, this.directRows, this.indirectRows, this.size);
            f.format(" DataBlocks:\n", new Object[0]);
            f.format("  address            dataPos            offset size end\n", new Object[0]);
            if (this.directBlocks != null) {
                for (DataBlock dblock : this.directBlocks) {
                    f.format("  %#-18x %#-18x %5d  %4d %5d %n", dblock.address, dblock.dataPos, dblock.offset, dblock.size, dblock.offset + dblock.size);
                }
            }
            if (this.indirectBlocks != null) {
                for (IndirectBlock iblock : this.indirectBlocks) {
                    iblock.showDetails(f);
                }
            }
        }
    }

    private class DoublingTable {
        int tableWidth;
        long startingBlockSize;
        long managedSpace;
        long maxDirectBlockSize;
        List<DataBlock> blockList;

        DoublingTable(int tableWidth, long startingBlockSize, long managedSpace, long maxDirectBlockSize) {
            this.tableWidth = tableWidth;
            this.startingBlockSize = startingBlockSize;
            this.managedSpace = managedSpace;
            this.maxDirectBlockSize = maxDirectBlockSize;
            this.blockList = new ArrayList<DataBlock>(tableWidth * FractalHeap.this.currentNumRows);
        }

        private int calcNrows(long max) {
            int n = 0;
            long blockSize = this.startingBlockSize;
            for (long sizeInBytes = 0L; sizeInBytes < max; sizeInBytes += blockSize * (long)this.tableWidth) {
                if (++n <= 1) continue;
                blockSize *= 2L;
            }
            return n;
        }

        private void assignSizes() {
            int block = 0;
            long blockSize = this.startingBlockSize;
            for (DataBlock db : this.blockList) {
                db.size = blockSize;
                if (++block % this.tableWidth != 0 || block / this.tableWidth <= 1) continue;
                blockSize *= 2L;
            }
        }

        long getPos(long offset) {
            int block = 0;
            for (DataBlock db : this.blockList) {
                if (db.address < 0L) continue;
                if (offset >= db.offset && offset <= db.offset + db.size) {
                    long localOffset = offset - db.offset;
                    return db.dataPos + localOffset;
                }
                ++block;
            }
            log.error("DoublingTable: illegal offset=" + offset);
            return -1L;
        }

        void showDetails(Formatter f) {
            f.format(" DoublingTable: tableWidth= %d startingBlockSize = %d managedSpace=%d maxDirectBlockSize=%d%n", this.tableWidth, this.startingBlockSize, this.managedSpace, this.maxDirectBlockSize);
            f.format(" DataBlocks:\n", new Object[0]);
            f.format("  address            dataPos            offset size\n", new Object[0]);
            for (DataBlock dblock : this.blockList) {
                f.format("  %#-18x %#-18x %5d  %4d%n", dblock.address, dblock.dataPos, dblock.offset, dblock.size);
            }
        }
    }

    class DHeapId {
        int type;
        int n;
        int m;
        int offset;
        int size;

        DHeapId(byte[] heapId) throws IOException {
            this.type = (heapId[0] & 0x30) >> 4;
            this.n = FractalHeap.this.maxHeapSize / 8;
            this.m = FractalHeap.this.h5.getNumBytesFromMax(FractalHeap.this.maxDirectBlockSize - 1L);
            this.offset = FractalHeap.this.h5.makeIntFromBytes(heapId, 1, this.n);
            this.size = FractalHeap.this.h5.makeIntFromBytes(heapId, 1 + this.n, this.m);
        }

        long getPos() {
            return FractalHeap.this.doublingTable.getPos(this.offset);
        }

        public String toString() {
            return this.type + " " + this.n + " " + this.m + " " + this.offset + " " + this.size;
        }
    }
}

