/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.xml;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.SortedMap;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriteable;
import ucar.nc2.Variable;
import ucar.unidata.io.RandomAccessFile;

public class TestUnicode
extends TestCase {
    static int[] helloGreekCode = new int[]{206, 154, 206, 177, 206, 187, 206, 183, 206, 188, 225, 189, 179, 207, 129, 206, 177};
    static final byte[] MAGIC_HEADER = new byte[]{-83, -20, -50, -38};
    static final byte[] MAGIC_DATA = new byte[]{-85, -20, -50, -70};

    public static void testCharsets() {
        SortedMap<String, Charset> map = Charset.availableCharsets();
        for (String key : map.keySet()) {
            Charset cs = (Charset)map.get(key);
            System.out.println(" " + cs);
        }
        System.out.println("default= " + Charset.defaultCharset());
        System.out.println("\nFont names:");
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (String s : env.getAvailableFontFamilyNames()) {
            System.out.println(" " + s);
        }
        int c1 = 8051;
        System.out.println("\nFonts:");
        for (Font f : env.getAllFonts()) {
            f.canDisplay(c1);
            System.out.println(f.canDisplay(c1) + " " + f.getFontName());
        }
    }

    public void testMagic() throws IOException {
        String s = new String(MAGIC_HEADER);
        TestUnicode.write(s, null);
        TestUnicode.write(s, "UTF-8");
        s = new String(MAGIC_HEADER, "UTF-8");
        TestUnicode.write(s, null);
        TestUnicode.write(s, "UTF-8");
    }

    String makeString(int[] codes, boolean debug) throws UnsupportedEncodingException {
        byte[] b = new byte[codes.length];
        for (int i = 0; i < codes.length; ++i) {
            b[i] = (byte)codes[i];
        }
        if (debug) {
            System.out.println(" orgBytes= " + TestUnicode.showBytes(b));
        }
        String s = new String(b, "UTF-8");
        if (debug) {
            System.out.println("convBytes= " + TestUnicode.showString(s));
        }
        return s;
    }

    public void testString() throws IOException {
        String helloGreek = this.makeString(helloGreekCode, true);
        String s2 = "";
        System.out.println(" helloGreek= " + helloGreek);
        System.out.println("char values= " + TestUnicode.showString(helloGreek));
        System.out.println("      UTF-8= " + TestUnicode.showBytes(helloGreek.getBytes("UTF-8")));
        System.out.println("     UTF-16= " + TestUnicode.showBytes(helloGreek.getBytes("UTF-16")));
        System.out.println("    default= " + TestUnicode.showBytes(helloGreek.getBytes()));
        System.out.println("norm values= " + TestUnicode.showString(s2));
        System.out.println("      UTF-8= " + TestUnicode.showBytes(s2.getBytes("UTF-8")));
        System.out.println("     UTF-16= " + TestUnicode.showBytes(s2.getBytes("UTF-16")));
        System.out.println("    default= " + TestUnicode.showBytes(s2.getBytes()));
        TestUnicode.write(helloGreek, null);
        TestUnicode.write(helloGreek, "UTF-8");
    }

    public void makeNetCDF() throws IOException, InvalidRangeException {
        String helloGreek = this.makeString(helloGreekCode, true);
        helloGreek = "";
        System.out.println("normalized= " + TestUnicode.showString(helloGreek));
        String filename = "C:/data/unicode/helloNorm.nc";
        NetcdfFileWriteable ncfile = NetcdfFileWriteable.createNew((String)filename);
        Dimension dim = ncfile.addDimension(helloGreek, 20);
        ncfile.addVariable(helloGreek, DataType.CHAR, helloGreek);
        ncfile.addVariableAttribute(helloGreek, "units", helloGreek);
        ncfile.create();
        ArrayChar.D1 data = new ArrayChar.D1(dim.getLength());
        data.setString(helloGreek);
        ncfile.write(helloGreek, (Array)data);
        ncfile.close();
        NetcdfFile nc = NetcdfFile.open((String)filename);
        Variable v = ncfile.findVariable(helloGreek);
        assert (v != null);
        assert (v.getShortName().equals(helloGreek));
        Attribute att = v.findAttribute("units");
        assert (att != null);
        assert (att.isString());
        assert (helloGreek.equals(att.getStringValue()));
        nc.close();
    }

    static void testRAF(String filename) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int nelems = 37;
        byte[] b = new byte[nelems];
        raf.read(b);
        String line = new String(b, "UTF-8");
        System.out.println(line);
        System.out.println(TestUnicode.showBytes(b));
        System.out.println(TestUnicode.showBytes(line.getBytes()));
    }

    static void write(String s, String charset) throws IOException {
        Charset cs = charset == null ? Charset.defaultCharset() : Charset.forName(charset);
        OutputStreamWriter outw = new OutputStreamWriter((OutputStream)System.out, cs);
        outw.write("OutputWriter (" + cs + ")=(");
        outw.write(s);
        outw.write(")\n");
        outw.flush();
    }

    static void writeFile(String s, String charset, String filename) throws IOException {
        FileOutputStream fout = new FileOutputStream(filename);
        Charset cs = charset == null ? Charset.defaultCharset() : Charset.forName(charset);
        OutputStreamWriter outw = new OutputStreamWriter((OutputStream)fout, cs);
        outw.write("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"\n    \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n    <body>\n<pre>");
        outw.write("OutputWriter (" + cs + ")=(");
        outw.write(s);
        outw.write(")</pre>\n\n</body>\n</html>");
        outw.flush();
        fout.close();
    }

    static void testRead(String filename) throws IOException {
        String line;
        DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(filename)));
        int count = 0;
        while (null != (line = in.readLine())) {
            System.out.println("Line " + count++);
            System.out.println(line);
            System.out.println(TestUnicode.showBytes(line.getBytes()));
        }
        in.close();
    }

    static void testUnicodeRead(String filename) throws IOException {
        String line;
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8"));
        int count = 0;
        while (null != (line = in.readLine())) {
            System.out.println("ULine " + count++);
            System.out.println(line);
            System.out.println(TestUnicode.showBytes(line.getBytes()));
        }
        in.close();
    }

    public static String showBytes(byte[] buff) {
        StringBuffer sbuff = new StringBuffer();
        for (int i = 0; i < buff.length; ++i) {
            int ub;
            int b = buff[i];
            int n = ub = b < 0 ? b + 256 : b;
            if (i > 0) {
                sbuff.append(" ");
            }
            sbuff.append(Integer.toHexString(ub));
        }
        return sbuff.toString();
    }

    public static String showString(String s) {
        StringBuffer sbuff = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (i > 0) {
                sbuff.append(" ");
            }
            sbuff.append(Integer.toHexString(c));
        }
        return sbuff.toString();
    }

    public static void main(String[] args) throws IOException {
        TestUnicode.write("hello", null);
        TestUnicode.write("hello", "UTF-8");
        TestUnicode.write("hello", "EUC-JP");
    }
}

