/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.net;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.junit.Test;
import ucar.nc2.util.UnitTestCommon;
import ucar.nc2.util.net.HTTPMethod;
import ucar.nc2.util.net.HTTPMethodStream;
import ucar.nc2.util.net.HTTPSession;

public class TestState
extends UnitTestCommon {
    static final String SESSIONURL = "http://thredds-test.ucar.edu:8081/dts";
    static final String TESTSOURCE1 = "http://thredds-test.ucar.edu:8081/dts/test.01.dds";
    static final String TESTSOURCE2 = "http://thredds-test.ucar.edu:8081/dts/test.02.dds";
    public static final Charset UTF8 = Charset.forName("UTF-8");
    boolean verbose = false;
    boolean pass = false;

    public TestState() {
        this.setTitle("HTTP Session and Method State tests");
    }

    @Test
    public void testState() throws Exception {
        String compare;
        HTTPSession session = new HTTPSession(SESSIONURL);
        TestState.assertFalse((boolean)session.isClosed());
        HTTPMethod method = HTTPMethod.Get((HTTPSession)session, (String)TESTSOURCE1);
        TestState.assertFalse((boolean)method.isClosed());
        int methodcount = session.getMethodcount();
        TestState.assertTrue((methodcount == 1 ? 1 : 0) != 0);
        method.execute();
        HTTPMethodStream stream = (HTTPMethodStream)method.getResponseBodyAsStream();
        TestState.assertTrue((boolean)method.hasStreamOpen());
        stream.close();
        TestState.assertTrue((boolean)method.isClosed());
        TestState.assertFalse((boolean)method.hasStreamOpen());
        methodcount = session.getMethodcount();
        TestState.assertTrue((methodcount == 0 ? 1 : 0) != 0);
        method = HTTPMethod.Get((HTTPSession)session, (String)TESTSOURCE1);
        methodcount = session.getMethodcount();
        TestState.assertTrue((methodcount == 1 ? 1 : 0) != 0);
        method.execute();
        stream = (HTTPMethodStream)method.getResponseBodyAsStream();
        method.close();
        TestState.assertTrue((boolean)stream.isClosed());
        TestState.assertFalse((boolean)method.hasStreamOpen());
        TestState.assertTrue((boolean)method.isClosed());
        method = HTTPMethod.Get((HTTPSession)session);
        methodcount = session.getMethodcount();
        TestState.assertTrue((methodcount == 1 ? 1 : 0) != 0);
        method.execute();
        stream = (HTTPMethodStream)method.getResponseBodyAsStream();
        session.close();
        TestState.assertTrue((boolean)stream.isClosed());
        TestState.assertTrue((boolean)method.isClosed());
        methodcount = session.getMethodcount();
        TestState.assertTrue((methodcount == 0 ? 1 : 0) != 0);
        TestState.assertTrue((boolean)session.isClosed());
        method = HTTPMethod.Get();
        TestState.assertTrue((boolean)method.isSessionLocal());
        session = method.getSession();
        methodcount = session.getMethodcount();
        TestState.assertTrue((methodcount == 1 ? 1 : 0) != 0);
        method.execute(TESTSOURCE1);
        String body = method.getResponseAsString();
        stream = (HTTPMethodStream)method.getResponseBodyAsStream();
        byte[] bbody = TestState.readbinaryfile((InputStream)stream);
        method.close();
        TestState.assertTrue((boolean)stream.isClosed());
        TestState.assertFalse((boolean)method.hasStreamOpen());
        TestState.assertTrue((boolean)method.isClosed());
        methodcount = session.getMethodcount();
        TestState.assertTrue((methodcount == 0 ? 1 : 0) != 0);
        TestState.assertTrue((boolean)session.isClosed());
        String s = new String(bbody, UTF8);
        if (this.verbose) {
            System.err.println("Body as String:\n" + body);
            System.err.println("Body as Bytes:\n" + s);
        }
        if ((compare = this.compare("TestState", body, s)) != null) {
            System.out.println(compare);
            this.pass = false;
        } else {
            this.pass = true;
        }
        TestState.assertTrue((boolean)this.pass);
    }

    public static byte[] readbinaryfile(InputStream stream) throws IOException {
        int cnt;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        byte[] tmp = new byte[65536];
        while ((cnt = stream.read(tmp)) > 0) {
            bytes.write(tmp, 0, cnt);
        }
        return bytes.toByteArray();
    }
}

