/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.filesystem.ControllerOS;
import thredds.inventory.CatalogCollectionManager;
import thredds.inventory.CollectionManager;
import thredds.inventory.CollectionManagerAbstract;
import thredds.inventory.CollectionSpecParser;
import thredds.inventory.DateExtractor;
import thredds.inventory.DateExtractorFromName;
import thredds.inventory.DateExtractorNone;
import thredds.inventory.MCollection;
import thredds.inventory.MController;
import thredds.inventory.MFile;
import thredds.inventory.MFileFilter;
import thredds.inventory.filter.Composite;
import thredds.inventory.filter.LastModifiedLimit;
import thredds.inventory.filter.RegExpMatchOnName;
import thredds.inventory.filter.WildcardMatchOnName;
import thredds.inventory.filter.WildcardMatchOnPath;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.units.TimeDuration;

@ThreadSafe
public class MFileCollectionManager
extends CollectionManagerAbstract {
    public static final String CATALOG = "catalog:";
    private static MController controller;
    protected DateExtractor dateExtractor;
    protected CalendarDate startPartition;
    private final List<MCollection> scanList = new ArrayList<MCollection>();
    private final long olderThanInMsecs;
    private final String rootDir;
    protected FeatureCollectionConfig config;
    private Map<String, MFile> map;
    private long lastScanned;
    private AtomicLong lastChanged = new AtomicLong();

    public static void setController(MController _controller) {
        controller = _controller;
    }

    public static MController getController() {
        if (null == controller) {
            controller = new ControllerOS();
        }
        return controller;
    }

    public static MFileCollectionManager open(String collectionName, String olderThan, Formatter errlog) throws IOException {
        if (collectionName.startsWith(CATALOG)) {
            return new CatalogCollectionManager(collectionName);
        }
        return new MFileCollectionManager(collectionName, olderThan, errlog);
    }

    public static MFileCollectionManager openWithRecheck(String collectionName, String recheckS) {
        return new MFileCollectionManager(collectionName, recheckS);
    }

    private MFileCollectionManager(String collectionSpec, String olderThan, Formatter errlog) {
        super(collectionSpec, null);
        CollectionSpecParser sp = new CollectionSpecParser(collectionSpec, errlog);
        this.recheck = null;
        this.protoChoice = FeatureCollectionConfig.ProtoChoice.Penultimate;
        this.rootDir = sp.getRootDir();
        ArrayList<MFileFilter> filters = new ArrayList<MFileFilter>(2);
        if (null != sp.getFilter()) {
            filters.add(new WildcardMatchOnName(sp.getFilter()));
        }
        this.olderThanInMsecs = this.parseOlderThanFilter(olderThan);
        this.dateExtractor = sp.getDateFormatMark() == null ? new DateExtractorNone() : new DateExtractorFromName(sp.getDateFormatMark(), true);
        this.scanList.add(new MCollection(sp.getRootDir(), sp.getRootDir(), sp.wantSubdirs(), filters, null));
    }

    public MFileCollectionManager(FeatureCollectionConfig config, Formatter errlog, Logger logger) {
        super(config.name != null ? config.name : config.spec, logger);
        this.config = config;
        CollectionSpecParser sp = new CollectionSpecParser(config.spec, errlog);
        this.rootDir = sp.getRootDir();
        ArrayList<MFileFilter> filters = new ArrayList<MFileFilter>(3);
        if (null != sp.getFilter()) {
            filters.add(new WildcardMatchOnName(sp.getFilter()));
        }
        this.olderThanInMsecs = this.parseOlderThanFilter(config.olderThan);
        this.dateExtractor = config.dateFormatMark != null ? new DateExtractorFromName(config.dateFormatMark, false) : (sp.getDateFormatMark() != null ? new DateExtractorFromName(sp.getDateFormatMark(), true) : new DateExtractorNone());
        this.scanList.add(new MCollection(sp.getRootDir(), sp.getRootDir(), sp.wantSubdirs(), filters, null));
        this.recheck = this.makeRecheck(config.updateConfig.recheckAfter);
        this.protoChoice = config.protoConfig.choice;
        if (config.updateConfig.recheckAfter == null && config.updateConfig.rescan == null && config.updateConfig.deleteAfter == null) {
            this.setStatic(true);
        }
    }

    private long parseOlderThanFilter(String olderThan) {
        if (olderThan != null) {
            try {
                TimeDuration tu = new TimeDuration(olderThan);
                return (long)(1000.0 * tu.getValueInSeconds());
            }
            catch (Exception e) {
                this.logger.error(this.collectionName + ": Invalid time unit for olderThan = {}", (Object)olderThan);
            }
        }
        return -1L;
    }

    private TimeDuration makeRecheck(String recheckS) {
        if (recheckS != null) {
            try {
                return new TimeDuration(recheckS);
            }
            catch (Exception e) {
                this.logger.error(this.collectionName + ": Invalid time unit for recheckEvery = {}", (Object)recheckS);
            }
        }
        return null;
    }

    protected MFileCollectionManager(String name, Logger logger) {
        super(name, logger);
        this.recheck = null;
        this.olderThanInMsecs = -1L;
        this.protoChoice = FeatureCollectionConfig.ProtoChoice.Penultimate;
        this.rootDir = null;
    }

    public MFileCollectionManager(String name, String spec, Formatter errlog, Logger logger) {
        super(name, logger);
        CollectionSpecParser sp = new CollectionSpecParser(spec, errlog);
        this.rootDir = sp.getRootDir();
        ArrayList<MFileFilter> filters = new ArrayList<MFileFilter>(3);
        if (null != sp.getFilter()) {
            filters.add(new WildcardMatchOnName(sp.getFilter()));
        }
        this.dateExtractor = sp.getDateFormatMark() == null ? new DateExtractorNone() : new DateExtractorFromName(sp.getDateFormatMark(), true);
        this.scanList.add(new MCollection(sp.getRootDir(), sp.getRootDir(), sp.wantSubdirs(), filters, null));
        this.recheck = null;
        this.protoChoice = FeatureCollectionConfig.ProtoChoice.Penultimate;
        this.olderThanInMsecs = -1L;
    }

    public MFileCollectionManager(String name, MCollection mc, CalendarDate startPartition, Logger logger) {
        super(name, logger);
        this.startPartition = startPartition;
        this.scanList.add(mc);
        this.rootDir = mc.getDirectoryName();
        this.recheck = null;
        this.protoChoice = FeatureCollectionConfig.ProtoChoice.Penultimate;
        this.olderThanInMsecs = -1L;
    }

    @Override
    public CalendarDate getStartCollection() {
        return this.startPartition;
    }

    private MFileCollectionManager(String collectionName, String recheckS) {
        super(collectionName, null);
        this.recheck = this.makeRecheck(recheckS);
        this.olderThanInMsecs = -1L;
        this.protoChoice = FeatureCollectionConfig.ProtoChoice.Penultimate;
        this.rootDir = null;
    }

    public void setDateExtractor(DateExtractor dateExtractor) {
        this.dateExtractor = dateExtractor;
    }

    public void addDirectoryScan(String dirName, String suffix, String regexpPatternString, String subdirsS, String olderS, Object auxInfo) {
        ArrayList<MFileFilter> filters = new ArrayList<MFileFilter>(3);
        if (null != regexpPatternString) {
            filters.add(new RegExpMatchOnName(regexpPatternString));
        } else if (suffix != null) {
            filters.add(new WildcardMatchOnPath("*" + suffix + "$"));
        }
        if (olderS != null) {
            try {
                TimeDuration tu = new TimeDuration(olderS);
                filters.add(new LastModifiedLimit((long)(1000.0 * tu.getValueInSeconds())));
            }
            catch (Exception e) {
                this.logger.error(this.collectionName + ": Invalid time unit for olderThan = {}", (Object)olderS);
            }
        }
        boolean wantSubdirs = true;
        if (subdirsS != null && subdirsS.equalsIgnoreCase("false")) {
            wantSubdirs = false;
        }
        Composite filter = filters.size() == 0 ? null : (filters.size() == 1 ? (MFileFilter)filters.get(0) : new Composite(filters));
        MCollection mc = new MCollection(dirName, dirName, wantSubdirs, filter, auxInfo);
        StringBuilder sb = new StringBuilder(dirName);
        if (wantSubdirs) {
            sb.append("**/");
        }
        if (null != regexpPatternString) {
            sb.append(regexpPatternString);
        } else if (suffix != null) {
            sb.append(suffix);
        } else {
            sb.append("noFilter");
        }
        this.collectionName = sb.toString();
        this.scanList.add(mc);
    }

    @Override
    public String getRoot() {
        return this.rootDir;
    }

    @Override
    public long getOlderThanFilterInMSecs() {
        return this.olderThanInMsecs;
    }

    @Override
    public long getLastScanned() {
        return this.lastScanned;
    }

    @Override
    public long getLastChanged() {
        return this.lastChanged.get();
    }

    @Override
    public boolean scanIfNeeded() throws IOException {
        if (this.map == null && !this.isStatic()) {
            return true;
        }
        return this.isScanNeeded() && this.scan(true);
    }

    protected boolean hasScans() {
        return !this.scanList.isEmpty();
    }

    @Override
    public boolean isScanNeeded() {
        if (this.recheck == null) {
            this.logger.debug("{}: scan not needed, recheck null", (Object)this.collectionName);
            return false;
        }
        if (!this.hasScans()) {
            this.logger.debug("{}: scan not needed, no scanners", (Object)this.collectionName);
            return false;
        }
        if (this.map == null && !this.isStatic()) {
            this.logger.debug("{}: scan needed, never scanned", (Object)this.collectionName);
            return true;
        }
        Date now = new Date();
        Date lastCheckedDate = new Date(this.lastScanned);
        Date need = this.recheck.add(lastCheckedDate);
        if (now.before(need)) {
            this.logger.debug("{}: scan not needed, last scanned={}, now={}", new Object[]{this.collectionName, lastCheckedDate, now});
            return false;
        }
        return true;
    }

    public void scanDebug(Formatter f) throws IOException {
        MFileCollectionManager.getController();
        for (MCollection mc : this.scanList) {
            Iterator<MFile> iter;
            Iterator<MFile> iterator = iter = mc.wantSubdirs() ? controller.getInventoryAll(mc, true) : controller.getInventoryTop(mc, true);
            if (iter == null) {
                this.logger.error(this.collectionName + ": Invalid collection= " + mc);
                continue;
            }
            int count = 0;
            while (iter.hasNext()) {
                MFile mfile = iter.next();
                mfile.setAuxInfo(mc.getAuxInfo());
                this.map.put(mfile.getPath(), mfile);
                ++count;
            }
            this.logger.debug("{} : was scanned nfiles= {} ", (Object)this.collectionName, (Object)count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean scan(boolean sendEvent) throws IOException {
        MFileCollectionManager mFileCollectionManager;
        boolean changed;
        if (this.map == null) {
            boolean changed2 = this.scanFirstTime();
            if (changed2 && sendEvent) {
                this.sendEvent(new CollectionManager.TriggerEvent(this, CollectionManager.TriggerType.update));
            }
            return changed2;
        }
        long olderThan = this.olderThanInMsecs <= 0L ? -1L : System.currentTimeMillis() - this.olderThanInMsecs;
        Map<String, MFile> oldMap = this.map;
        HashMap<String, MFile> newMap = new HashMap<String, MFile>();
        this.reallyScan(newMap);
        int nnew = 0;
        int nchange = 0;
        Iterator iter = newMap.values().iterator();
        while (iter.hasNext()) {
            MFile newFile = (MFile)iter.next();
            String path = newFile.getPath();
            MFile oldFile = oldMap.get(path);
            if (oldFile != null) {
                if (newFile.getLastModified() > oldFile.getLastModified()) {
                    ++nchange;
                    this.logger.debug("{}: scan found Dataset changed= {}", (Object)this.collectionName, (Object)path);
                    continue;
                }
                if (this.changeChecker == null || !this.changeChecker.hasntChangedSince(newFile, oldFile.getLastModified())) continue;
                ++nchange;
                this.logger.debug("{}: scan changeChecker found Dataset changed= {}", (Object)this.collectionName, (Object)path);
                continue;
            }
            if (olderThan > 0L && newFile.getLastModified() > olderThan) {
                iter.remove();
                this.logger.debug("{}: scan found new Dataset but its too recently modified = {}", (Object)this.collectionName, (Object)path);
                continue;
            }
            ++nnew;
            this.logger.debug("{}: scan found new Dataset= {} ", (Object)this.collectionName, (Object)path);
        }
        int ndelete = 0;
        for (MFile oldDataset : oldMap.values()) {
            String path = oldDataset.getPath();
            MFile newDataset = (MFile)newMap.get(path);
            if (newDataset != null) continue;
            ++ndelete;
            this.logger.debug("{}: scan found deleted Dataset={}", (Object)this.collectionName, (Object)path);
        }
        boolean bl = changed = nnew > 0 || ndelete > 0 || nchange > 0;
        if (changed) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("{}: scan found changes {}: nnew={}, nchange={}, ndelete={}", new Object[]{this.collectionName, new Date(), nnew, nchange, ndelete});
            }
            mFileCollectionManager = this;
            synchronized (mFileCollectionManager) {
                this.map = newMap;
                this.lastScanned = System.currentTimeMillis();
                this.lastChanged.set(this.lastScanned);
            }
        }
        mFileCollectionManager = this;
        synchronized (mFileCollectionManager) {
            this.lastScanned = System.currentTimeMillis();
        }
        if (changed && sendEvent) {
            this.sendEvent(new CollectionManager.TriggerEvent(this, CollectionManager.TriggerType.update));
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFiles(Iterable<MFile> files) {
        HashMap<String, MFile> newMap = new HashMap<String, MFile>();
        for (MFile file : files) {
            newMap.put(file.getPath(), file);
        }
        MFileCollectionManager mFileCollectionManager = this;
        synchronized (mFileCollectionManager) {
            this.map = newMap;
            this.lastScanned = System.currentTimeMillis();
            this.lastChanged.set(this.lastScanned);
        }
    }

    @Override
    public Iterable<MFile> getFiles() {
        if (this.map == null) {
            try {
                this.scanFirstTime();
            }
            catch (IOException e) {
                e.printStackTrace();
                return Collections.emptyList();
            }
        }
        ArrayList<MFile> result = new ArrayList<MFile>(this.map.values());
        if (this.hasDateExtractor()) {
            Collections.sort(result, new DateSorter());
        } else {
            Collections.sort(result);
        }
        return result;
    }

    @Override
    public CalendarDate extractRunDate(MFile mfile) {
        return this.dateExtractor == null ? null : this.dateExtractor.getCalendarDate(mfile);
    }

    private CalendarDate extractRunDateWithError(MFile mfile) {
        CalendarDate result = this.extractRunDate(mfile);
        if (result == null) {
            this.logger.error("Failed to extract date from file {} with Extractor {}", (Object)mfile.getPath(), (Object)this.dateExtractor);
        }
        return result;
    }

    @Override
    public boolean hasDateExtractor() {
        return this.dateExtractor != null && !(this.dateExtractor instanceof DateExtractorNone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean scanFirstTime() throws IOException {
        HashMap<String, MFile> newMap = new HashMap<String, MFile>();
        if (!this.hasScans()) {
            this.map = newMap;
            return false;
        }
        this.reallyScan(newMap);
        if (this.olderThanInMsecs > 0L) {
            long olderThan = System.currentTimeMillis() - this.olderThanInMsecs;
            Iterator iter = newMap.values().iterator();
            while (iter.hasNext()) {
                MFile newFile = (MFile)iter.next();
                String path = newFile.getPath();
                if (newFile.getLastModified() <= olderThan) continue;
                iter.remove();
                this.logger.debug("{}: scan found new Dataset but its too recently modified = {}", (Object)this.collectionName, (Object)path);
            }
        }
        MFileCollectionManager mFileCollectionManager = this;
        synchronized (mFileCollectionManager) {
            this.map = newMap;
            this.lastScanned = System.currentTimeMillis();
            this.lastChanged.set(this.lastScanned);
        }
        this.logger.debug("{} : initial scan found n datasets = {} ", (Object)this.collectionName, (Object)this.map.keySet().size());
        return this.map.keySet().size() > 0;
    }

    protected void reallyScan(Map<String, MFile> map) throws IOException {
        MFileCollectionManager.getController();
        for (MCollection mc : this.scanList) {
            Iterator<MFile> iter;
            Iterator<MFile> iterator = iter = mc.wantSubdirs() ? controller.getInventoryAll(mc, true) : controller.getInventoryTop(mc, true);
            if (iter == null) {
                this.logger.error(this.collectionName + ": Invalid collection= " + mc);
                continue;
            }
            int count = 0;
            while (iter.hasNext()) {
                MFile mfile = iter.next();
                mfile.setAuxInfo(mc.getAuxInfo());
                map.put(mfile.getPath(), mfile);
                ++count;
            }
            this.logger.debug("{} : was scanned nfiles= {} ", (Object)this.collectionName, (Object)count);
        }
        if (map.size() == 0) {
            this.logger.warn("MFileCollectionManager: No files found for {}", (Object)this.collectionName);
        }
    }

    public String toString() {
        Formatter f = new Formatter();
        f.format("DatasetCollectionManager{ collectionName='%s' recheck=%s ", this.collectionName, this.recheck);
        for (MCollection mc : this.scanList) {
            f.format("%n dir=%s filter=%s", mc.getDirectoryName(), mc.getFileFilter());
        }
        return f.toString();
    }

    private class DateSorter
    implements Comparator<MFile> {
        private DateSorter() {
        }

        @Override
        public int compare(MFile m1, MFile m2) {
            return MFileCollectionManager.this.extractRunDateWithError(m1).compareTo(MFileCollectionManager.this.extractRunDateWithError(m2));
        }
    }
}

