/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.jni.netcdf;

import com.google.common.collect.ImmutableMap;
import com.sun.jna.ptr.IntByReference;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;
import ucar.array.ArrayType;
import ucar.ma2.Array;
import ucar.ma2.ArrayStructure;
import ucar.ma2.ArrayStructureBB;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataDeep;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.EnumTypedef;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.CDM;
import ucar.nc2.ffi.netcdf.NetcdfClibrary;
import ucar.nc2.internal.iosp.IospFileWriter;
import ucar.nc2.iosp.IospHelper;
import ucar.nc2.iosp.NetcdfFileFormat;
import ucar.nc2.jni.netcdf.Nc4reader;
import ucar.nc2.jni.netcdf.SizeT;
import ucar.nc2.jni.netcdf.SizeTByReference;
import ucar.nc2.util.CancelTask;
import ucar.nc2.write.Nc4Chunking;
import ucar.nc2.write.Nc4ChunkingDefault;

public class Nc4writer
extends Nc4reader
implements IospFileWriter {
    private static final Logger log = LoggerFactory.getLogger(Nc4writer.class);
    public static final String UCARTAGOPAQUE = "_edu.ucar.opaque.size";
    private static final boolean debugCompound = false;
    private static final boolean debugDim = false;
    private static final boolean debugWrite = false;
    private boolean fill = true;
    private Nc4Chunking chunker = new Nc4ChunkingDefault();
    private final Map<EnumTypedef, Nc4reader.UserType> enumUserTypes = new HashMap<EnumTypedef, Nc4reader.UserType>();

    public Nc4writer() {
        super(NetcdfFileFormat.NETCDF4);
    }

    public Nc4writer(NetcdfFileFormat version) {
        super(version);
    }

    public void setChunker(Nc4Chunking chunker) {
        if (chunker != null) {
            this.chunker = chunker;
        }
    }

    public void openForWriting(String location, Group.Builder rootGroup, CancelTask cancelTask) throws IOException {
        throw new NotImplementedException();
    }

    public NetcdfFile getOutputFile() {
        throw new NotImplementedException();
    }

    public NetcdfFile create(String filename, Group.Builder rootGroup, int extra, long preallocateSize, boolean largeFile) throws IOException {
        if (!NetcdfClibrary.isLibraryPresent()) {
            throw new UnsupportedOperationException("Couldn't load NetCDF C library (see log for details).");
        }
        this.nc4 = NetcdfClibrary.getForeignFunctionInterface();
        this.rootGroup = rootGroup;
        log.debug("create {}", (Object)this.location);
        IntByReference oldFormat = new IntByReference();
        int ret = this.nc4.nc_set_default_format(this.defineFormat(), oldFormat);
        if (ret != 0) {
            throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
        }
        IntByReference ncidp = new IntByReference();
        ret = this.nc4.nc_create(filename, this.createMode(), ncidp);
        if (ret != 0) {
            throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
        }
        this.isClosed = false;
        this.ncid = ncidp.getValue();
        this._setFill();
        this.createGroup(new Nc4reader.Group4(this.ncid, rootGroup, null));
        this.nc4.nc_enddef(this.ncid);
        NetcdfFile.Builder ncfileb = NetcdfFile.builder().setRootGroup(rootGroup).setLocation(filename);
        this.ncfile = ncfileb.build();
        return this.ncfile;
    }

    private int createMode() {
        int ret = 0;
        switch (this.version) {
            case NETCDF4: {
                ret |= 0x1000;
                break;
            }
            case NETCDF4_CLASSIC: {
                ret |= 0x1100;
            }
        }
        return ret;
    }

    private int defineFormat() {
        switch (this.version) {
            case NETCDF4: {
                return 3;
            }
            case NETCDF4_CLASSIC: {
                return 4;
            }
            case NETCDF3: {
                return 1;
            }
            case NETCDF3_64BIT_OFFSET: {
                return 2;
            }
        }
        throw new IllegalStateException("version = " + this.version);
    }

    private void createGroup(Nc4reader.Group4 g4) throws IOException {
        this.groupBuilderHash.put(g4.g, g4.grpid);
        g4.dimHash = new HashMap<Dimension, Integer>();
        for (Attribute att : g4.g.getAttributeContainer()) {
            this.writeAttribute(g4.grpid, -1, att, null);
        }
        for (Dimension dim : g4.g.getDimensions()) {
            int dimLength = dim.isUnlimited() ? 0 : dim.getLength();
            int dimid = this.addDimension(g4.grpid, dim.getShortName(), dimLength);
            g4.dimHash.put(dim, dimid);
        }
        for (EnumTypedef en : g4.g.enumTypedefs) {
            this.createEnumType(g4, en);
        }
        for (Variable.Builder v : g4.g.vbuilders) {
            if (v.dataType != ArrayType.STRUCTURE) continue;
            this.createCompoundType(g4, (Structure.Builder)v);
        }
        for (Variable.Builder v : g4.g.vbuilders) {
            this.createVariable(g4, v);
        }
        for (Group.Builder nested : g4.g.gbuilders) {
            IntByReference grpidp = new IntByReference();
            int ret = this.nc4.nc_def_grp(g4.grpid, nested.shortName, grpidp);
            if (ret != 0) {
                throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
            }
            int nestedId = grpidp.getValue();
            this.createGroup(new Nc4reader.Group4(nestedId, nested, g4));
        }
    }

    private void createVariable(Nc4reader.Group4 g4, Variable.Builder<?> v) throws IOException {
        int varid;
        int typid;
        Nc4reader.Vinfo vinfo;
        int[] dimids = new int[v.getRank()];
        int count = 0;
        for (Dimension d : v.getDimensions()) {
            int dimid = !d.isShared() ? this.addDimension(g4.grpid, v.shortName + "_Dim" + count, d.getLength()) : this.findDimensionId(g4, d).intValue();
            dimids[count++] = dimid;
        }
        if (v instanceof Structure.Builder) {
            vinfo = (Nc4reader.Vinfo)v.spiObject;
            typid = vinfo.typeid;
        } else if (v.dataType.isEnum()) {
            EnumTypedef en = (EnumTypedef)g4.g.findEnumeration(v.getEnumTypeName()).orElseThrow(() -> new IllegalStateException("Cant find enum " + v.getEnumTypeName()));
            Nc4reader.UserType ut = this.enumUserTypes.get(en);
            if (ut == null) {
                throw new IllegalStateException("Cant find UserType for enum " + v.getEnumTypeName());
            }
            typid = ut.typeid;
            vinfo = new Nc4reader.Vinfo(g4, -1, typid);
        } else if (v.dataType == ArrayType.OPAQUE) {
            typid = this.convertDataType(v.dataType);
            if (typid < 0) {
                log.warn("Skipping Opaque Type");
                return;
            }
            vinfo = new Nc4reader.Vinfo(g4, -1, typid);
        } else {
            typid = this.convertDataType(v.dataType);
            if (typid < 0) {
                log.warn("Skipping Unknown data Type");
                return;
            }
            vinfo = new Nc4reader.Vinfo(g4, -1, typid);
        }
        IntByReference varidp = new IntByReference();
        int ret = this.nc4.nc_def_var(g4.grpid, v.shortName, new SizeT(typid), dimids.length, dimids, varidp);
        if (ret != 0) {
            throw new IOException("nc_def_var ret= " + ret + " err= '" + this.nc4.nc_strerror(ret) + "' on " + v);
        }
        vinfo.varid = varid = varidp.getValue();
        if (this.version.isNetdf4format() && v.getRank() > 0) {
            SizeT[] chunking;
            int storage;
            boolean isChunked = this.chunker.isChunked(v);
            int n = storage = isChunked ? 0 : 1;
            if (isChunked) {
                long[] lchunks = this.chunker.computeChunking(v);
                chunking = new SizeT[lchunks.length];
                for (int i = 0; i < lchunks.length; ++i) {
                    chunking[i] = new SizeT(lchunks[i]);
                }
            } else {
                chunking = new SizeT[v.getRank()];
            }
            if (isChunked) {
                int shuffle;
                ret = this.nc4.nc_def_var_chunking(g4.grpid, varid, storage, chunking);
                if (ret != 0) {
                    throw new IOException(this.nc4.nc_strerror(ret) + " nc_def_var_chunking on variable " + v.getFullName());
                }
                int deflateLevel = this.chunker.getDeflateLevel(v);
                int deflate = deflateLevel > 0 ? 1 : 0;
                int n2 = shuffle = this.chunker.isShuffle(v) ? 1 : 0;
                if (deflateLevel > 0 && (ret = this.nc4.nc_def_var_deflate(g4.grpid, varid, shuffle, deflate, deflateLevel)) != 0) {
                    throw new IOException(this.nc4.nc_strerror(ret));
                }
            }
        }
        v.setSPobject((Object)vinfo);
        if (v instanceof Structure.Builder) {
            this.createCompoundMemberAtts(g4.grpid, varid, (Structure.Builder)v);
        }
        for (Attribute att : v.getAttributeContainer()) {
            this.writeAttribute(g4.grpid, varid, att, v);
        }
    }

    private int convertDataType(ArrayType dt) {
        switch (dt) {
            case BYTE: {
                return 1;
            }
            case UBYTE: {
                return 7;
            }
            case CHAR: {
                return 2;
            }
            case DOUBLE: {
                return 6;
            }
            case FLOAT: {
                return 5;
            }
            case INT: {
                return 4;
            }
            case UINT: {
                return 9;
            }
            case LONG: {
                return 10;
            }
            case ULONG: {
                return 11;
            }
            case SHORT: {
                return 3;
            }
            case USHORT: {
                return 8;
            }
            case STRING: {
                return 12;
            }
            case ENUM1: 
            case ENUM2: 
            case ENUM4: {
                return 15;
            }
            case OPAQUE: {
                log.warn("Skipping Opaque Type");
                return -1;
            }
            case STRUCTURE: {
                return 16;
            }
        }
        throw new IllegalArgumentException("unimplemented type == " + dt);
    }

    private void createEnumType(Nc4reader.Group4 g4, EnumTypedef ent) throws IOException {
        IntByReference typeidp = new IntByReference();
        String name = ent.getShortName();
        if (!name.endsWith("_t")) {
            name = name + "_t";
        }
        DataType enumbase = ent.getBaseType();
        int basetype = 0;
        if (enumbase == DataType.ENUM1) {
            basetype = 1;
        } else if (enumbase == DataType.ENUM2) {
            basetype = 3;
        } else if (enumbase == DataType.ENUM4) {
            basetype = 4;
        }
        int ret = this.nc4.nc_def_enum(g4.grpid, basetype, name, typeidp);
        if (ret != 0) {
            throw new IOException(this.nc4.nc_strerror(ret) + " on\n" + ent);
        }
        int typeid = typeidp.getValue();
        ImmutableMap emap = ent.getMap();
        for (Map.Entry entry : emap.entrySet()) {
            IntByReference val = new IntByReference(((Integer)entry.getKey()).intValue());
            ret = this.nc4.nc_insert_enum(g4.grpid, typeid, (String)entry.getValue(), val);
            if (ret == 0) continue;
            throw new IOException(this.nc4.nc_strerror(ret) + " on\n" + (String)entry.getValue());
        }
        Nc4reader.UserType ut = new Nc4reader.UserType(g4.grpid, typeid, name, ent.getBaseType().getSize(), basetype, emap.size(), 15);
        this.userTypes.put(typeid, ut);
        this.enumUserTypes.put(ent, ut);
    }

    private void createCompoundType(Nc4reader.Group4 g4, Structure.Builder<?> s) throws IOException {
        String name;
        IntByReference typeidp = new IntByReference();
        long size = s.calcElementSize();
        int ret = this.nc4.nc_def_compound(g4.grpid, new SizeT(size), name = s.shortName + "_t", typeidp);
        if (ret != 0) {
            throw new IOException(this.nc4.nc_strerror(ret) + " on\n" + s);
        }
        int typeid = typeidp.getValue();
        ArrayList<Nc4reader.Field> flds = new ArrayList<Nc4reader.Field>();
        int fldidx = 0;
        long offset = 0L;
        for (Variable.Builder v : s.vbuilders) {
            if (v.dataType == ArrayType.STRING) continue;
            int field_typeid = this.convertDataType(v.dataType);
            ret = v.getDimensions().size() == 0 ? this.nc4.nc_insert_compound(g4.grpid, typeid, v.shortName, new SizeT(offset), field_typeid) : this.nc4.nc_insert_array_compound(g4.grpid, typeid, v.shortName, new SizeT(offset), field_typeid, v.getRank(), v.getShape());
            if (ret != 0) {
                throw new IOException(this.nc4.nc_strerror(ret) + " on\n" + s.shortName);
            }
            Nc4reader.Field fld = new Nc4reader.Field(g4.grpid, typeid, fldidx, v.shortName, (int)offset, field_typeid, v.getRank(), v.getShape());
            flds.add(fld);
            offset += (long)v.getElementSize() * v.getSize();
            ++fldidx;
        }
        s.setSPobject((Object)new Nc4reader.Vinfo(g4, -1, typeidp.getValue()));
        Nc4reader.UserType ut = new Nc4reader.UserType(g4.grpid, typeid, name, size, 0, fldidx, 16);
        this.userTypes.put(typeid, ut);
        ut.setFields(flds);
    }

    private void createCompoundMemberAtts(int grpid, int varid, Structure.Builder<?> s) throws IOException {
        int sizeAtts = 0;
        for (Variable.Builder m : s.vbuilders) {
            for (Attribute att : m.getAttributeContainer()) {
                int elemSize;
                if (att.isString()) {
                    String val = att.getStringValue();
                    elemSize = val.getBytes(StandardCharsets.UTF_8).length;
                    if (elemSize == 0) {
                        elemSize = 1;
                    }
                } else {
                    elemSize = att.getDataType().getSize() * att.getLength();
                }
                sizeAtts += elemSize;
            }
        }
        if (sizeAtts == 0) {
            return;
        }
        IntByReference typeidp = new IntByReference();
        String typeName = "_" + s.shortName + "_field_atts_t";
        int ret = this.nc4.nc_def_compound(grpid, new SizeT(sizeAtts), typeName, typeidp);
        if (ret != 0) {
            throw new IOException(this.nc4.nc_strerror(ret) + " on\n" + s);
        }
        int typeid = typeidp.getValue();
        ByteBuffer bb = ByteBuffer.allocate(sizeAtts);
        bb.order(ByteOrder.nativeOrder());
        for (Variable.Builder m : s.vbuilders) {
            for (Attribute att : m.getAttributeContainer()) {
                String val;
                int field_typeid;
                String memberName = m.shortName + ":" + att.getShortName();
                int n = field_typeid = att.isString() ? 2 : this.convertDataType(att.getArrayType());
                if (att.isString()) {
                    val = att.getStringValue();
                    int len = val.getBytes(StandardCharsets.UTF_8).length;
                    if (len == 0) {
                        len = 1;
                    }
                    ret = this.nc4.nc_insert_array_compound(grpid, typeid, memberName, new SizeT(bb.position()), field_typeid, 1, new int[]{len});
                } else {
                    ret = !att.isArray() ? this.nc4.nc_insert_compound(grpid, typeid, memberName, new SizeT(bb.position()), field_typeid) : this.nc4.nc_insert_array_compound(grpid, typeid, memberName, new SizeT(bb.position()), field_typeid, 1, new int[]{att.getLength()});
                }
                if (ret != 0) {
                    throw new IOException(this.nc4.nc_strerror(ret) + " on\n" + s.shortName);
                }
                if (att.isString()) {
                    byte[] sby;
                    val = att.getStringValue();
                    for (byte b : sby = val.getBytes(StandardCharsets.UTF_8)) {
                        bb.put(b);
                    }
                    if (sby.length != 0) continue;
                    bb.put((byte)0);
                    continue;
                }
                block14: for (int i = 0; i < att.getLength(); ++i) {
                    switch (att.getDataType()) {
                        case BYTE: {
                            bb.put(att.getNumericValue(i).byteValue());
                            continue block14;
                        }
                        case CHAR: {
                            bb.put(att.getNumericValue(i).byteValue());
                            continue block14;
                        }
                        case DOUBLE: {
                            bb.putDouble(att.getNumericValue(i).doubleValue());
                            continue block14;
                        }
                        case FLOAT: {
                            bb.putFloat(att.getNumericValue(i).floatValue());
                            continue block14;
                        }
                        case INT: {
                            bb.putInt(att.getNumericValue(i).intValue());
                            continue block14;
                        }
                        case LONG: {
                            bb.putLong(att.getNumericValue(i).longValue());
                            continue block14;
                        }
                        case SHORT: {
                            bb.putShort(att.getNumericValue(i).shortValue());
                            continue block14;
                        }
                        default: {
                            throw new IllegalStateException("Att type " + att.getDataType() + " not found");
                        }
                    }
                }
            }
        }
        String attName = "_field_atts";
        ret = this.nc4.nc_put_att(grpid, varid, attName, typeid, new SizeT(1L), bb.array());
        if (ret != 0) {
            throw new IOException(this.nc4.nc_strerror(ret) + " on\n" + s.shortName);
        }
    }

    public void flush() throws IOException {
        if (this.nc4 == null || this.ncid < 0) {
            return;
        }
        int ret = this.nc4.nc_sync(this.ncid);
        if (ret != 0) {
            throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
        }
    }

    public void setFill(boolean fill) {
        this.fill = fill;
        try {
            this._setFill();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void _setFill() throws IOException {
        IntByReference old_modep;
        if (this.nc4 == null || this.ncid < 0) {
            return;
        }
        int ret = this.nc4.nc_set_fill(this.ncid, this.fill ? 0 : 256, old_modep = new IntByReference());
        if (ret != 0) {
            throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
        }
    }

    public void updateAttribute(Variable v2, Attribute att) throws IOException {
        if (this.nc4 == null || this.ncid < 0) {
            return;
        }
        if (v2 == null) {
            this.writeAttribute(this.ncid, -1, att, null);
        } else {
            Nc4reader.Vinfo vinfo = (Nc4reader.Vinfo)v2.getSPobject();
            this.writeAttribute(vinfo.g4.grpid, vinfo.varid, att, v2.toBuilder());
        }
    }

    public void updateAttribute(Group g, Attribute att) throws IOException {
    }

    private void writeAttribute(int grpid, int varid, Attribute att, Variable.Builder<?> v) throws IOException {
        if (v != null && att.getShortName().equals("_FillValue")) {
            if (att.getLength() != 1) {
                log.warn("_FillValue length must be one on var = {}", (Object)v.getFullName());
                return;
            }
            if (att.getArrayType() != v.dataType && (att.getArrayType() != ArrayType.STRING || v.dataType != ArrayType.CHAR)) {
                log.warn("_FillValue type ({}) does not agree with variable '{}' type ({}).", new Object[]{att.getArrayType(), v.shortName, v.dataType});
                return;
            }
        }
        if (att.getShortName().equals("DIMENSION_LIST")) {
            return;
        }
        if (att.getShortName().equals("DIMENSION_SCALE")) {
            return;
        }
        if (att.getShortName().equals("DIMENSION_LABELS")) {
            return;
        }
        if (att.getShortName().equals("_ChunkSizes")) {
            return;
        }
        if (att.getShortName().equals("_Compress")) {
            return;
        }
        if (CDM.NETCDF4_SPECIAL_ATTS.contains((Object)att.getShortName())) {
            return;
        }
        int ret = 0;
        Array values = att.getValues();
        Object arrayStorage = null;
        if (values != null) {
            arrayStorage = values.getStorage();
        }
        switch (att.getDataType()) {
            case STRING: {
                if (v != null && att.getShortName().equals("_FillValue") && att.getLength() == 1 && v.dataType == ArrayType.CHAR) {
                    byte[] svalb = att.getStringValue().getBytes(StandardCharsets.UTF_8);
                    if (svalb.length == 0) {
                        svalb = new byte[]{0};
                    }
                    ret = this.nc4.nc_put_att_text(grpid, varid, att.getShortName(), new SizeT(svalb.length), svalb);
                    break;
                }
                if (!this.version.isExtendedModel()) {
                    StringBuilder text = new StringBuilder();
                    for (int i = 0; i < att.getLength(); ++i) {
                        text.append(att.getStringValue(i));
                    }
                    byte[] svalb = text.toString().getBytes(StandardCharsets.UTF_8);
                    if (svalb.length == 0) {
                        svalb = new byte[]{0};
                    }
                    ret = this.nc4.nc_put_att_text(grpid, varid, att.getShortName(), new SizeT(svalb.length), svalb);
                    break;
                }
                String[] svalues = new String[att.getLength()];
                for (int i = 0; i < att.getLength(); ++i) {
                    svalues[i] = (String)att.getValue(i);
                }
                ret = this.nc4.nc_put_att_string(grpid, varid, att.getShortName(), new SizeT(att.getLength()), svalues);
                break;
            }
            case UBYTE: {
                ret = this.nc4.nc_put_att_uchar(grpid, varid, att.getShortName(), 7, new SizeT(att.getLength()), (byte[])arrayStorage);
                break;
            }
            case BYTE: {
                ret = this.nc4.nc_put_att_schar(grpid, varid, att.getShortName(), 1, new SizeT(att.getLength()), (byte[])arrayStorage);
                break;
            }
            case CHAR: {
                ret = this.nc4.nc_put_att_text(grpid, varid, att.getShortName(), new SizeT(att.getLength()), IospHelper.convertCharToByte((char[])((char[])arrayStorage)));
                break;
            }
            case DOUBLE: {
                ret = this.nc4.nc_put_att_double(grpid, varid, att.getShortName(), 6, new SizeT(att.getLength()), (double[])arrayStorage);
                break;
            }
            case FLOAT: {
                ret = this.nc4.nc_put_att_float(grpid, varid, att.getShortName(), 5, new SizeT(att.getLength()), (float[])arrayStorage);
                break;
            }
            case UINT: {
                ret = this.nc4.nc_put_att_uint(grpid, varid, att.getShortName(), 9, new SizeT(att.getLength()), (int[])arrayStorage);
                break;
            }
            case INT: {
                ret = this.nc4.nc_put_att_int(grpid, varid, att.getShortName(), 4, new SizeT(att.getLength()), (int[])arrayStorage);
                break;
            }
            case ULONG: {
                ret = this.nc4.nc_put_att_ulonglong(grpid, varid, att.getShortName(), 11, new SizeT(att.getLength()), (long[])arrayStorage);
                break;
            }
            case LONG: {
                ret = this.nc4.nc_put_att_longlong(grpid, varid, att.getShortName(), 10, new SizeT(att.getLength()), (long[])arrayStorage);
                break;
            }
            case USHORT: {
                ret = this.nc4.nc_put_att_ushort(grpid, varid, att.getShortName(), 8, new SizeT(att.getLength()), (short[])arrayStorage);
                break;
            }
            case SHORT: {
                ret = this.nc4.nc_put_att_short(grpid, varid, att.getShortName(), 3, new SizeT(att.getLength()), (short[])arrayStorage);
            }
        }
        if (ret != 0) {
            String where = v != null ? "var " + v.getFullName() : "global or group attribute";
            throw new IOException(ret + " (" + this.nc4.nc_strerror(ret) + ") on attribute '" + att + "' on " + where);
        }
    }

    public void writeData(Variable v2, Section section, Array values) throws IOException, InvalidRangeException {
        Nc4reader.Vinfo vinfo = (Nc4reader.Vinfo)v2.getSPobject();
        if (vinfo == null) {
            log.error("vinfo null for " + v2);
            throw new IllegalStateException("vinfo null for " + v2.getFullName());
        }
        this.writeData(v2, vinfo.g4.grpid, vinfo.varid, vinfo.typeid, section, values);
    }

    private void writeData(Variable v, int grpid, int varid, int typeid, Section section, Array values) throws IOException, InvalidRangeException {
        SizeT[] origin = this.convertSizeT(section.getOrigin());
        SizeT[] shape = this.convertSizeT(section.getShape());
        SizeT[] stride = this.convertSizeT(section.getStride());
        boolean isUnsigned = this.isUnsigned(typeid);
        int sectionLen = (int)section.computeSize();
        Object data = values.get1DJavaArray(values.getDataType());
        block0 : switch (typeid) {
            case 1: 
            case 7: {
                int ret;
                byte[] valb = (byte[])data;
                assert (valb.length == sectionLen);
                int n = ret = isUnsigned ? this.nc4.nc_put_vars_uchar(grpid, varid, origin, shape, stride, valb) : this.nc4.nc_put_vars_schar(grpid, varid, origin, shape, stride, valb);
                if (ret == 0) break;
                throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
            }
            case 2: {
                char[] valc = (char[])data;
                assert (valc.length == sectionLen);
                byte[] valb = IospHelper.convertCharToByte((char[])valc);
                int ret = this.nc4.nc_put_vars_text(grpid, varid, origin, shape, stride, valb);
                if (ret == 0) break;
                throw new IOException(this.nc4.nc_strerror(ret));
            }
            case 6: {
                double[] vald = (double[])data;
                assert (vald.length == sectionLen);
                int ret = this.nc4.nc_put_vars_double(grpid, varid, origin, shape, stride, vald);
                if (ret == 0) break;
                throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
            }
            case 5: {
                float[] valf = (float[])data;
                assert (valf.length == sectionLen);
                int ret = this.nc4.nc_put_vars_float(grpid, varid, origin, shape, stride, valf);
                if (ret == 0) break;
                throw new IOException(this.nc4.nc_strerror(ret));
            }
            case 4: 
            case 9: {
                int ret;
                int[] vali = (int[])data;
                assert (vali.length == sectionLen);
                int n = ret = isUnsigned ? this.nc4.nc_put_vars_uint(grpid, varid, origin, shape, stride, vali) : this.nc4.nc_put_vars_int(grpid, varid, origin, shape, stride, vali);
                if (ret == 0) break;
                throw new IOException(this.nc4.nc_strerror(ret));
            }
            case 10: 
            case 11: {
                int ret;
                long[] vall = (long[])data;
                assert (vall.length == sectionLen);
                int n = ret = isUnsigned ? this.nc4.nc_put_vars_ulonglong(grpid, varid, origin, shape, stride, vall) : this.nc4.nc_put_vars_longlong(grpid, varid, origin, shape, stride, vall);
                if (ret == 0) break;
                throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
            }
            case 3: 
            case 8: {
                int ret;
                short[] vals = (short[])data;
                assert (vals.length == sectionLen);
                int n = ret = isUnsigned ? this.nc4.nc_put_vars_ushort(grpid, varid, origin, shape, stride, vals) : this.nc4.nc_put_vars_short(grpid, varid, origin, shape, stride, vals);
                if (ret == 0) break;
                throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
            }
            case 12: {
                String[] valss = this.convertStringData(data);
                assert (valss.length == sectionLen);
                int ret = this.nc4.nc_put_vars_string(grpid, varid, origin, shape, stride, valss);
                if (ret == 0) break;
                throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
            }
            default: {
                Nc4reader.UserType userType = (Nc4reader.UserType)this.userTypes.get(typeid);
                if (userType == null) {
                    throw new IOException("Unknown userType == " + typeid);
                }
                switch (userType.typeClass) {
                    case 15: {
                        int ret = this.writeEnumData(v, userType, grpid, varid, typeid, section, values);
                        if (ret == 0) break block0;
                        throw new IOException(this.nc4.nc_strerror(ret));
                    }
                    case 16: {
                        this.writeCompoundData((Structure)v, userType, grpid, varid, typeid, section, (ArrayStructure)values);
                        return;
                    }
                    default: {
                        throw new IOException("Unsupported writing of userType= " + userType);
                    }
                }
            }
        }
    }

    private int writeEnumData(Variable v, Nc4reader.UserType userType, int grpid, int varid, int typeid, Section section, Array values) {
        int ret;
        SizeT[] origin = this.convertSizeT(section.getOrigin());
        SizeT[] shape = this.convertSizeT(section.getShape());
        int sectionLen = (int)section.computeSize();
        assert (values.getSize() == (long)sectionLen);
        int[] secStride = section.getStride();
        boolean stride1 = this.isStride1(secStride);
        ByteBuffer bb = values.getDataAsByteBuffer(ByteOrder.nativeOrder());
        byte[] data = bb.array();
        if (stride1) {
            ret = this.nc4.nc_put_vara(grpid, varid, origin, shape, data);
        } else {
            SizeT[] stride = this.convertSizeT(secStride);
            ret = this.nc4.nc_put_vars(grpid, varid, origin, shape, stride, data);
        }
        return ret;
    }

    private void writeCompoundData(Structure s, Nc4reader.UserType userType, int grpid, int varid, int typeid, Section section, ArrayStructure values) throws IOException, InvalidRangeException {
        SizeT[] origin = this.convertSizeT(section.getOrigin());
        SizeT[] shape = this.convertSizeT(section.getShape());
        SizeT[] stride = this.convertSizeT(section.getStride());
        ArrayStructureBB valuesBB = StructureDataDeep.copyToArrayBB((Structure)s, (ArrayStructure)values, (ByteOrder)ByteOrder.nativeOrder());
        ByteBuffer bbuff = valuesBB.getByteBuffer();
        int ret = section.isStrided() ? this.nc4.nc_put_vars(grpid, varid, origin, shape, stride, bbuff.array()) : this.nc4.nc_put_vara(grpid, varid, origin, shape, bbuff.array());
        if (ret != 0) {
            throw new IOException(this.errMessage("nc_put_vars", ret, grpid, varid));
        }
    }

    public int appendStructureData(Structure s, StructureData sdata) throws IOException, InvalidRangeException {
        SizeTByReference lenp;
        Nc4reader.Vinfo vinfo = (Nc4reader.Vinfo)s.getSPobject();
        Dimension dim = s.getDimension(0);
        int dimid = vinfo.g4.dimHash.get(dim);
        int ret = this.nc4.nc_inq_dimlen(vinfo.g4.grpid, dimid, lenp = new SizeTByReference());
        if (ret != 0) {
            throw new IOException(this.errMessage("nc_inq_dimlen", ret, vinfo.g4.grpid, dimid));
        }
        SizeT[] origin = new SizeT[]{lenp.getValue()};
        SizeT[] shape = new SizeT[]{new SizeT(1L)};
        SizeT[] stride = new SizeT[]{new SizeT(1L)};
        ByteBuffer bbuff = this.makeBB(s, sdata);
        ret = this.nc4.nc_put_vars(vinfo.g4.grpid, vinfo.varid, origin, shape, stride, bbuff.array());
        if (ret != 0) {
            throw new IOException(this.errMessage("appendStructureData (nc_put_vars)", ret, vinfo.g4.grpid, vinfo.varid));
        }
        return origin[0].intValue();
    }

    private String errMessage(String what, int ret, int grpid, int varid) {
        Formatter f = new Formatter();
        f.format("%s: %d: %s grpid=%d objid=%d", what, ret, this.nc4.nc_strerror(ret), grpid, varid);
        return f.toString();
    }

    private int addDimension(int grpid, String name, int length) throws IOException {
        IntByReference dimidp = new IntByReference();
        int ret = this.nc4.nc_def_dim(grpid, name, new SizeT(length), dimidp);
        if (ret != 0) {
            throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
        }
        return dimidp.getValue();
    }

    private ByteBuffer makeBB(Structure s, StructureData sdata) {
        int size = s.getElementSize();
        ByteBuffer bb = ByteBuffer.allocate(size);
        bb.order(ByteOrder.nativeOrder());
        long offset = 0L;
        for (Variable v : s.getVariables()) {
            if (v.getDataType() == DataType.STRING) continue;
            StructureMembers.Member m = sdata.findMember(v.getShortName());
            if (m == null) {
                log.warn("WARN Nc4Iosp.makeBB() cant find {}", (Object)v.getShortName());
                bb.position((int)(offset + (long)v.getElementSize() * v.getSize()));
            } else {
                this.copy(sdata, m, bb);
            }
            offset += (long)v.getElementSize() * v.getSize();
        }
        return bb;
    }

    private void copy(StructureData sdata, StructureMembers.Member m, ByteBuffer bb) {
        block26: {
            DataType dtype;
            block25: {
                dtype = m.getDataType();
                if (!m.isScalar()) break block25;
                switch (dtype) {
                    case FLOAT: {
                        bb.putFloat(sdata.getScalarFloat(m));
                        break block26;
                    }
                    case DOUBLE: {
                        bb.putDouble(sdata.getScalarDouble(m));
                        break block26;
                    }
                    case INT: 
                    case ENUM4: {
                        bb.putInt(sdata.getScalarInt(m));
                        break block26;
                    }
                    case SHORT: 
                    case ENUM2: {
                        bb.putShort(sdata.getScalarShort(m));
                        break block26;
                    }
                    case BYTE: 
                    case ENUM1: {
                        bb.put(sdata.getScalarByte(m));
                        break block26;
                    }
                    case CHAR: {
                        bb.put((byte)sdata.getScalarChar(m));
                        break block26;
                    }
                    case LONG: {
                        bb.putLong(sdata.getScalarLong(m));
                        break block26;
                    }
                    default: {
                        throw new IllegalStateException("scalar " + dtype);
                    }
                }
            }
            int n = m.getSize();
            switch (dtype) {
                case FLOAT: {
                    float[] fdata = sdata.getJavaArrayFloat(m);
                    for (int i = 0; i < n; ++i) {
                        bb.putFloat(fdata[i]);
                    }
                    break;
                }
                case DOUBLE: {
                    double[] ddata = sdata.getJavaArrayDouble(m);
                    for (int i = 0; i < n; ++i) {
                        bb.putDouble(ddata[i]);
                    }
                    break;
                }
                case INT: 
                case ENUM4: {
                    int[] idata = sdata.getJavaArrayInt(m);
                    for (int i = 0; i < n; ++i) {
                        bb.putInt(idata[i]);
                    }
                    break;
                }
                case SHORT: 
                case ENUM2: {
                    short[] shdata = sdata.getJavaArrayShort(m);
                    for (int i = 0; i < n; ++i) {
                        bb.putShort(shdata[i]);
                    }
                    break;
                }
                case BYTE: 
                case ENUM1: {
                    byte[] bdata = sdata.getJavaArrayByte(m);
                    for (int i = 0; i < n; ++i) {
                        bb.put(bdata[i]);
                    }
                    break;
                }
                case CHAR: {
                    char[] cdata = sdata.getJavaArrayChar(m);
                    bb.put(IospHelper.convertCharToByte((char[])cdata));
                    break;
                }
                case LONG: {
                    long[] ldata = sdata.getJavaArrayLong(m);
                    for (int i = 0; i < n; ++i) {
                        bb.putLong(ldata[i]);
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("array " + dtype);
                }
                case SEQUENCE: 
            }
        }
    }

    private String[] convertStringData(Object org) throws IOException {
        if (org instanceof String[]) {
            return (String[])org;
        }
        if (org instanceof Object[]) {
            Object[] oo = (Object[])org;
            String[] result = new String[oo.length];
            int count = 0;
            for (Object s : oo) {
                result[count++] = (String)s;
            }
            return result;
        }
        throw new IOException("convertStringData failed on class = " + org.getClass().getName());
    }

    private Integer findDimensionId(Nc4reader.Group4 g4, Dimension d) {
        if (g4 == null) {
            return null;
        }
        Integer dimid = g4.dimHash.get(d);
        if (dimid == null) {
            dimid = this.findDimensionId(g4.parent, d);
        }
        return dimid;
    }

    private void updateDimensions(Group g) throws IOException {
        int[] unlimdimids;
        IntByReference nunlimdimsp;
        int grpid = (Integer)this.groupBuilderHash.get(g);
        int ret = this.nc4.nc_inq_unlimdims(grpid, nunlimdimsp = new IntByReference(), unlimdimids = new int[1024]);
        if (ret != 0) {
            throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
        }
        int ndims = nunlimdimsp.getValue();
        for (int i = 0; i < ndims; ++i) {
            byte[] name = new byte[257];
            SizeTByReference lenp = new SizeTByReference();
            ret = this.nc4.nc_inq_dim(grpid, unlimdimids[i], name, lenp);
            if (ret != 0) {
                throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
            }
            String dname = this.makeString(name);
            Dimension d = (Dimension)g.findDimension(dname).orElseThrow(() -> new IllegalStateException("Cant find dimension " + dname));
            if (!d.isUnlimited()) {
                throw new IllegalStateException("dimension " + dname + " should be unlimited");
            }
            int len = lenp.getValue().intValue();
            if (len == d.getLength()) continue;
            for (Variable var : g.getVariables()) {
                if (!this.contains((List<Dimension>)var.getDimensions(), d)) continue;
                var.resetShape();
                var.invalidateCache();
            }
        }
        for (Group child : g.getGroups()) {
            this.updateDimensions(child);
        }
    }

    private boolean contains(List<Dimension> dims, Dimension want) {
        for (Dimension have : dims) {
            if (!have.getShortName().equals(want.getShortName())) continue;
            return true;
        }
        return false;
    }

    private boolean isStride1(int[] strides) {
        if (strides == null) {
            return true;
        }
        for (int stride : strides) {
            if (stride == 1) continue;
            return false;
        }
        return true;
    }
}

