/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.impl.node;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.StateChangeEvent;
import com.sleepycat.je.rep.StateChangeListener;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.utilint.LoggerUtils;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;

public class NodeState {
    private final RepImpl repImpl;
    private StateChangeListener stateChangeListener = null;
    private StateChangeEvent stateChangeEvent = null;
    private final AtomicReference<ReplicatedEnvironment.State> currentState = new AtomicReference<ReplicatedEnvironment.State>(ReplicatedEnvironment.State.DETACHED);
    private final Logger logger;
    private final NameIdPair nameIdPair;

    public NodeState(NameIdPair nameIdPair, RepImpl repImpl) {
        this.nameIdPair = nameIdPair;
        this.repImpl = repImpl;
        this.logger = LoggerUtils.getLogger(this.getClass());
    }

    public synchronized void setChangeListener(StateChangeListener stateChangeListener) {
        this.stateChangeListener = stateChangeListener;
    }

    public synchronized StateChangeListener getChangeListener() {
        return this.stateChangeListener;
    }

    public synchronized void changeAndNotify(ReplicatedEnvironment.State state, NameIdPair masterNameId) {
        ReplicatedEnvironment.State newState = state;
        ReplicatedEnvironment.State oldState = this.currentState.getAndSet(state);
        this.stateChangeEvent = new StateChangeEvent(state, masterNameId);
        LoggerUtils.finest(this.logger, this.repImpl, "state change from " + (Object)((Object)oldState) + " to " + (Object)((Object)newState));
        if (this.stateChangeListener != null) {
            try {
                this.stateChangeListener.stateChange(this.stateChangeEvent);
            }
            catch (Exception e) {
                LoggerUtils.severe(this.logger, this.repImpl, "State Change listener exception" + e.getMessage());
                throw new EnvironmentFailureException((EnvironmentImpl)this.repImpl, EnvironmentFailureReason.LISTENER_EXCEPTION, (Throwable)e);
            }
        }
        Thread.currentThread().setName(this.currentState + " " + this.nameIdPair);
    }

    public synchronized ReplicatedEnvironment.State getRepEnvState() {
        return this.currentState.get();
    }

    public synchronized StateChangeEvent getStateChangeEvent() {
        return this.stateChangeEvent;
    }
}

