/*
 * Decompiled with CFR 0.152.
 */
package visad.data.in;

import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import visad.data.in.ValueProcessor;

public class ValueRanger
extends ValueProcessor {
    private float floatLower = Float.NEGATIVE_INFINITY;
    private float floatUpper = Float.POSITIVE_INFINITY;
    private double doubleLower = Double.NEGATIVE_INFINITY;
    private double doubleUpper = Double.POSITIVE_INFINITY;
    private static final WeakHashMap map = new WeakHashMap();
    private static final ValueRanger trivialRanger = new ValueRanger(){

        public float process(float value) {
            return value;
        }

        public double process(double value) {
            return value;
        }

        public float[] process(float[] values) {
            return values;
        }

        public double[] process(double[] values) {
            return values;
        }
    };

    protected ValueRanger() {
    }

    private ValueRanger(double lower, double upper) {
        this.doubleLower = lower == lower ? lower : Double.NEGATIVE_INFINITY;
        this.doubleUpper = upper == upper ? upper : Double.POSITIVE_INFINITY;
        this.floatLower = (float)this.doubleLower;
        this.floatUpper = (float)this.doubleUpper;
    }

    public static ValueRanger valueRanger(double lower, double upper) {
        ValueRanger ranger;
        if (!(lower == lower && lower != Double.NEGATIVE_INFINITY || upper == upper && upper != Double.POSITIVE_INFINITY)) {
            ranger = trivialRanger;
        } else {
            ranger = new ValueRanger(lower, upper);
            WeakReference ref = (WeakReference)map.get(ranger);
            if (ref == null) {
                map.put(ranger, new WeakReference<ValueRanger>(ranger));
            } else {
                ValueRanger oldRanger = (ValueRanger)ref.get();
                if (oldRanger == null) {
                    map.put(ranger, new WeakReference<ValueRanger>(ranger));
                } else {
                    ranger = oldRanger;
                }
            }
        }
        return ranger;
    }

    public double getMin() {
        return this.doubleLower;
    }

    public double getMax() {
        return this.doubleUpper;
    }

    public float process(float value) {
        return value < this.floatLower || value > this.floatUpper ? Float.NaN : value;
    }

    public double process(double value) {
        return value < this.doubleLower || value > this.doubleUpper ? Double.NaN : value;
    }

    public float[] process(float[] values) {
        for (int i = 0; i < values.length; ++i) {
            double value = values[i];
            if (!(value < (double)this.floatLower) && !(value > (double)this.floatUpper)) continue;
            values[i] = Float.NaN;
        }
        return values;
    }

    public double[] process(double[] values) {
        for (int i = 0; i < values.length; ++i) {
            double value = values[i];
            if (!(value < this.doubleLower) && !(value > this.doubleUpper)) continue;
            values[i] = Double.NaN;
        }
        return values;
    }

    public boolean equals(Object obj) {
        ValueRanger that;
        boolean equals = !this.getClass().isInstance(obj) ? false : this == (that = (ValueRanger)obj) || this.doubleLower == that.doubleLower && this.doubleUpper == that.doubleUpper;
        return equals;
    }

    public int hashCode() {
        return new Double(this.doubleLower).hashCode() ^ new Double(this.doubleUpper).hashCode();
    }
}

