/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import com.google.protobuf.ByteString;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import thredds.inventory.MCollection;
import thredds.inventory.MFile;
import ucar.coord.Coordinate;
import ucar.coord.CoordinateEns;
import ucar.coord.CoordinateRuntime;
import ucar.coord.CoordinateTime;
import ucar.coord.CoordinateTime2D;
import ucar.coord.CoordinateTimeIntv;
import ucar.coord.CoordinateVert;
import ucar.coord.SparseArray;
import ucar.nc2.constants.CDM;
import ucar.nc2.grib.collection.GcMFile;
import ucar.nc2.grib.collection.Grib2CollectionBuilder;
import ucar.nc2.grib.collection.GribCollectionBuilder;
import ucar.nc2.grib.collection.GribCollectionImmutable;
import ucar.nc2.grib.collection.GribCollectionProto;
import ucar.nc2.grib.collection.GribCollectionWriter;
import ucar.nc2.grib.grib2.Grib2Pds;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.grib.grib2.Grib2SectionBitMap;
import ucar.nc2.grib.grib2.Grib2SectionDataRepresentation;
import ucar.nc2.grib.grib2.Grib2SectionGridDefinition;
import ucar.nc2.grib.grib2.Grib2SectionIdentification;
import ucar.nc2.stream.NcStream;
import ucar.nc2.time.CalendarDate;
import ucar.unidata.io.RandomAccessFile;

class Grib2CollectionWriter
extends GribCollectionWriter {
    public static final String MAGIC_START = "Grib2Collectio2Index";
    protected static final int minVersion = 1;
    protected static final int version = 2;
    protected final MCollection dcm;
    protected final Logger logger;

    protected Grib2CollectionWriter(MCollection dcm, Logger logger) {
        this.dcm = dcm;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeIndex(String name, File idxFile, CoordinateRuntime masterRuntime, List<Group> groups, List<MFile> files, GribCollectionImmutable.Type type) throws IOException {
        Grib2Record first = null;
        boolean deleteOnClose = false;
        if (idxFile.exists()) {
            RandomAccessFile.eject(idxFile.getPath());
            if (!idxFile.delete()) {
                this.logger.error("gc2 cant delete index file {}", (Object)idxFile.getPath());
            }
        }
        this.logger.debug(" createIndex for {}", (Object)idxFile.getPath());
        try (RandomAccessFile raf = new RandomAccessFile(idxFile.getPath(), "rw");){
            Object b;
            raf.order(0);
            raf.write(MAGIC_START.getBytes(CDM.utf8Charset));
            raf.writeInt(2);
            long lenPos = raf.getFilePointer();
            raf.writeLong(0L);
            long countBytes = 0L;
            int countRecords = 0;
            HashSet<Integer> allFileSet = new HashSet<Integer>();
            for (Group g2 : groups) {
                g2.fileSet = new HashSet<Integer>();
                for (Grib2CollectionBuilder.VariableBag vb : g2.gribVars) {
                    if (first == null) {
                        first = vb.first;
                    }
                    GribCollectionProto.SparseArray vr = this.writeSparseArray(vb, g2.fileSet);
                    b = vr.toByteArray();
                    vb.pos = raf.getFilePointer();
                    vb.length = ((byte[])b).length;
                    raf.write((byte[])b);
                    countBytes += (long)((byte[])b).length;
                    countRecords += vb.coordND.getSparseArray().countNotMissing();
                }
                Iterator<Comparable<Grib2CollectionBuilder.VariableBag>> iterator = g2.fileSet.iterator();
                while (iterator.hasNext()) {
                    int index = (Integer)iterator.next();
                    allFileSet.add(index);
                }
            }
            if (this.logger.isDebugEnabled()) {
                long bytesPerRecord = countBytes / (long)(countRecords == 0 ? 1 : countRecords);
                this.logger.debug("  write RecordMaps: bytes = {} record = {} bytesPerRecord={}", countBytes, countRecords, bytesPerRecord);
            }
            if (first == null) {
                deleteOnClose = true;
                throw new IOException("GribCollection " + name + " has no records");
            }
            long pos = raf.getFilePointer();
            raf.seek(lenPos);
            raf.writeLong(countBytes);
            raf.seek(pos);
            GribCollectionProto.GribCollection.Builder indexBuilder = GribCollectionProto.GribCollection.newBuilder();
            indexBuilder.setName(name);
            indexBuilder.setTopDir(this.dcm.getRoot());
            indexBuilder.setVersion(1);
            File directory = new File(this.dcm.getRoot());
            List<GcMFile> gcmfiles = GcMFile.makeFiles(directory, files, allFileSet);
            b = gcmfiles.iterator();
            while (b.hasNext()) {
                GcMFile gcMFile = (GcMFile)b.next();
                GribCollectionProto.MFile.Builder b2 = GribCollectionProto.MFile.newBuilder();
                b2.setFilename(gcMFile.getName());
                b2.setLastModified(gcMFile.getLastModified());
                b2.setLength(gcMFile.getLength());
                b2.setIndex(gcMFile.index);
                indexBuilder.addMfiles(b2.build());
            }
            indexBuilder.setMasterRuntime(this.writeCoordProto(masterRuntime));
            for (Object e : groups) {
                Group g3 = (Group)e;
                indexBuilder.addGds(this.writeGdsProto(g3.gdss.getRawBytes(), -1));
            }
            indexBuilder.addDataset(this.writeDatasetProto(type, groups));
            Grib2SectionIdentification ids = first.getId();
            indexBuilder.setCenter(ids.getCenter_id());
            indexBuilder.setSubcenter(ids.getSubcenter_id());
            indexBuilder.setMaster(ids.getMaster_table_version());
            indexBuilder.setLocal(ids.getLocal_table_version());
            Grib2Pds grib2Pds = first.getPDS();
            indexBuilder.setGenProcessType(grib2Pds.getGenProcessType());
            indexBuilder.setGenProcessId(grib2Pds.getGenProcessId());
            indexBuilder.setBackProcessId(grib2Pds.getBackProcessId());
            GribCollectionProto.GribCollection index = indexBuilder.build();
            byte[] b3 = index.toByteArray();
            NcStream.writeVInt(raf, b3.length);
            raf.write(b3);
            this.logger.debug("  write GribCollectionIndex= {} bytes", (Object)b3.length);
        }
        finally {
            if (deleteOnClose && !idxFile.delete()) {
                this.logger.error(" gc2 cant deleteOnClose index file {}", (Object)idxFile.getPath());
            }
        }
        return true;
    }

    private GribCollectionProto.SparseArray writeSparseArray(Grib2CollectionBuilder.VariableBag vb, Set<Integer> fileSet) throws IOException {
        GribCollectionProto.SparseArray.Builder b = GribCollectionProto.SparseArray.newBuilder();
        b.setCdmHash(vb.gv.hashCode());
        SparseArray<Grib2Record> sa = vb.coordND.getSparseArray();
        for (int size : sa.getShape()) {
            b.addSize(size);
        }
        for (int track : sa.getTrack()) {
            b.addTrack(track);
        }
        Object object = sa.getContent().iterator();
        while (object.hasNext()) {
            Grib2Record gr = (Grib2Record)object.next();
            GribCollectionProto.Record.Builder br = GribCollectionProto.Record.newBuilder();
            br.setFileno(gr.getFile());
            fileSet.add(gr.getFile());
            Grib2SectionDataRepresentation drs = gr.getDataRepresentationSection();
            br.setPos(drs.getStartingPosition());
            if (gr.isBmsReplaced()) {
                Grib2SectionBitMap bms = gr.getBitmapSection();
                br.setBmsPos(bms.getStartingPosition());
            }
            br.setScanMode(gr.getScanMode());
            b.addRecords(br);
        }
        b.setNdups(sa.getNdups());
        return b.build();
    }

    private GribCollectionProto.Dataset writeDatasetProto(GribCollectionImmutable.Type type, List<Group> groups) throws IOException {
        GribCollectionProto.Dataset.Builder b = GribCollectionProto.Dataset.newBuilder();
        GribCollectionProto.Dataset.Type ptype = GribCollectionProto.Dataset.Type.valueOf(type.toString());
        b.setType(ptype);
        int count = 0;
        for (Group group : groups) {
            b.addGroups(this.writeGroupProto(group, count++));
        }
        return b.build();
    }

    protected GribCollectionProto.Group writeGroupProto(Group g2, int groupIndex) throws IOException {
        GribCollectionProto.Group.Builder b = GribCollectionProto.Group.newBuilder();
        b.setGdsIndex(groupIndex);
        b.setIsTwod(true);
        for (Grib2CollectionBuilder.VariableBag vbag : g2.gribVars) {
            b.addVariables(this.writeVariableProto(vbag));
        }
        for (Coordinate coord : g2.coords) {
            switch (coord.getType()) {
                case runtime: {
                    b.addCoords(this.writeCoordProto((CoordinateRuntime)coord));
                    break;
                }
                case time: {
                    b.addCoords(this.writeCoordProto((CoordinateTime)coord));
                    break;
                }
                case timeIntv: {
                    b.addCoords(this.writeCoordProto((CoordinateTimeIntv)coord));
                    break;
                }
                case time2D: {
                    b.addCoords(this.writeCoordProto((CoordinateTime2D)coord));
                    break;
                }
                case vert: {
                    b.addCoords(this.writeCoordProto((CoordinateVert)coord));
                    break;
                }
                case ens: {
                    b.addCoords(this.writeCoordProto((CoordinateEns)coord));
                }
            }
        }
        for (Integer aFileSet : g2.fileSet) {
            b.addFileno(aFileSet);
        }
        return b.build();
    }

    private GribCollectionProto.Variable writeVariableProto(Grib2CollectionBuilder.VariableBag vb) throws IOException {
        GribCollectionProto.Variable.Builder b = GribCollectionProto.Variable.newBuilder();
        b.setDiscipline(vb.first.getDiscipline());
        b.setPds(ByteString.copyFrom(vb.first.getPDSsection().getRawBytes()));
        b.addIds(vb.first.getId().getCenter_id());
        b.addIds(vb.first.getId().getSubcenter_id());
        b.setRecordsPos(vb.pos);
        b.setRecordsLen(vb.length);
        for (int idx : vb.coordIndex) {
            b.addCoordIdx(idx);
        }
        SparseArray<Grib2Record> sa = vb.coordND.getSparseArray();
        if (sa != null) {
            b.setNdups(sa.getNdups());
            b.setNrecords(sa.countNotMissing());
            b.setMissing(sa.countMissing());
        }
        return b.build();
    }

    public static class Group
    implements GribCollectionBuilder.Group {
        public Grib2SectionGridDefinition gdss;
        public Object gdsHashObject;
        public CalendarDate runtime;
        public List<Grib2CollectionBuilder.VariableBag> gribVars;
        public List<Coordinate> coords;
        public List<Grib2Record> records = new ArrayList<Grib2Record>();
        public Set<Integer> fileSet;
        public Set<Long> runtimes = new HashSet<Long>();

        Group(Grib2SectionGridDefinition gdss, Object gdsHashObject) {
            this.gdss = gdss;
            this.gdsHashObject = gdsHashObject;
        }

        Group(Grib2SectionGridDefinition gdss, Object gdsHashObject, CalendarDate runtime) {
            this.gdss = gdss;
            this.gdsHashObject = gdsHashObject;
            this.runtime = runtime;
        }

        @Override
        public CalendarDate getRuntime() {
            return this.runtime;
        }

        @Override
        public Set<Long> getCoordinateRuntimes() {
            return this.runtimes;
        }

        @Override
        public List<Coordinate> getCoordinates() {
            return this.coords;
        }
    }
}

