/*
 * Decompiled with CFR 0.152.
 */
package visad.browser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;

public class Divider
extends Component {
    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 2;
    private int orientation;

    public Divider() {
        this(1);
    }

    public Divider(int orientation) {
        this.orientation = orientation;
    }

    public void paint(Graphics g2) {
        if (this.orientation == 1) {
            int w = this.getSize().width;
            g2.setColor(Color.white);
            g2.drawRect(0, 0, w - 2, 6);
            g2.drawRect(2, 2, w - 4, 2);
            g2.setColor(Color.black);
            g2.drawRect(1, 1, w - 3, 3);
        } else if (this.orientation == 2) {
            int h2 = this.getSize().height;
            g2.setColor(Color.white);
            g2.drawRect(0, 0, 6, h2 - 2);
            g2.drawRect(2, 2, 2, h2 - 4);
            g2.setColor(Color.black);
            g2.drawRect(1, 1, 3, h2 - 3);
        }
    }

    public Dimension getMinimumSize() {
        if (this.orientation == 1) {
            return new Dimension(0, 6);
        }
        if (this.orientation == 2) {
            return new Dimension(6, 0);
        }
        return new Dimension(0, 0);
    }

    public Dimension getPreferredSize() {
        if (this.orientation == 1) {
            return new Dimension(0, 6);
        }
        if (this.orientation == 2) {
            return new Dimension(6, 0);
        }
        return new Dimension(0, 0);
    }

    public Dimension getMaximumSize() {
        if (this.orientation == 1) {
            return new Dimension(Integer.MAX_VALUE, 6);
        }
        if (this.orientation == 2) {
            return new Dimension(6, Integer.MAX_VALUE);
        }
        return new Dimension(0, 0);
    }
}

