/*
 * Decompiled with CFR 0.152.
 */
package visad.sounder;

import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import visad.VisADException;
import visad.matrix.JamaMatrix;
import visad.sounder.Spectrum;

public class PCA {
    JamaMatrix eigenvectors;
    JamaMatrix mean_vector;

    public PCA(JamaMatrix eigenvectors, JamaMatrix mean_vector) {
        this.eigenvectors = eigenvectors;
        this.mean_vector = mean_vector;
    }

    public Spectrum compressReconstruct(Spectrum spectrum) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        Spectrum new_spectrum = (Spectrum)spectrum.clone();
        JamaMatrix tmp = this.uncompress(this.compress(spectrum));
        new_spectrum.setSamples(tmp.getValues());
        return new_spectrum;
    }

    public JamaMatrix compress(Spectrum spectrum) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JamaMatrix data_vector = new JamaMatrix(spectrum.getValues());
        JamaMatrix tmp_vector = data_vector.minus(this.mean_vector);
        JamaMatrix trans_data_vector = this.eigenvectors.times(tmp_vector.transpose());
        return trans_data_vector;
    }

    public JamaMatrix uncompress(JamaMatrix trans_data_vector) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JamaMatrix r_data_vector = this.eigenvectors.transpose().times(trans_data_vector);
        r_data_vector = r_data_vector.plusEquals(this.mean_vector.transpose());
        return r_data_vector;
    }

    public static JamaMatrix makeCovarianceMatrix(double[][] data_vectors) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        int dim = data_vectors[0].length;
        int n_vectors = data_vectors.length;
        double[] mean_vector = new double[dim];
        for (int jj = 0; jj < dim; ++jj) {
            double sum = 0.0;
            for (int kk = 0; kk < n_vectors; ++kk) {
                sum += data_vectors[kk][jj];
            }
            mean_vector[jj] = sum / (double)n_vectors;
        }
        double[][] cv = new double[dim][dim];
        for (int jj = 0; jj < dim; ++jj) {
            for (int ii = jj; ii < dim; ++ii) {
                double sum = 0.0;
                for (int kk = 0; kk < n_vectors; ++kk) {
                    sum += (data_vectors[kk][jj] - mean_vector[jj]) * (data_vectors[kk][ii] - mean_vector[ii]);
                }
                cv[jj][ii] = sum / (double)n_vectors;
                cv[ii][jj] = cv[jj][ii];
            }
        }
        return new JamaMatrix(cv);
    }
}

