/*
 * Decompiled with CFR 0.152.
 */
package visad.browser;

public class Convert {
    private static final int RLE_ESCAPE = Integer.MIN_VALUE;
    public static final int PLACES = 3;
    public static final int ROUND_NEAREST = 1;
    public static final int ROUND_DOWN = 2;
    public static final int ROUND_UP = 3;

    public static byte[] intToBytes(int[] ints) {
        int len = ints.length;
        byte[] bytes = new byte[4 * len];
        for (int i = 0; i < len; ++i) {
            int q = ints[i];
            bytes[4 * i] = (byte)(q & 0xFF);
            bytes[4 * i + 1] = (byte)((q & 0xFF00) >> 8);
            bytes[4 * i + 2] = (byte)((q & 0xFF0000) >> 16);
            bytes[4 * i + 3] = (byte)((q & 0xFF000000) >> 24);
        }
        return bytes;
    }

    public static int[] bytesToInt(byte[] bytes) {
        int len = bytes.length / 4;
        int[] ints = new int[len];
        for (int i = 0; i < len; ++i) {
            int q3 = bytes[4 * i + 3] << 24;
            int q2 = bytes[4 * i + 2] << 16;
            int q1 = bytes[4 * i + 1] << 8;
            int q0 = bytes[4 * i];
            if (q2 < 0) {
                q2 += 0x1000000;
            }
            if (q1 < 0) {
                q1 += 65536;
            }
            if (q0 < 0) {
                q0 += 256;
            }
            ints[i] = q3 | q2 | q1 | q0;
        }
        return ints;
    }

    public static int[] encodeRLE(int[] array) {
        int len = array.length;
        int[] temp = new int[len];
        int p = 0;
        int i = 0;
        while (i < len) {
            int q = array[i];
            int count = 0;
            while (i < len && q == array[i]) {
                ++count;
                ++i;
            }
            if (count < 4) {
                for (int z = 0; z < count; ++z) {
                    temp[p++] = q;
                }
                continue;
            }
            temp[p++] = Integer.MIN_VALUE;
            temp[p++] = q;
            temp[p++] = count;
        }
        int[] encoded = new int[p];
        System.arraycopy(temp, 0, encoded, 0, p);
        return encoded;
    }

    public static int[] decodeRLE(int[] array) {
        int count = 0;
        int i = 0;
        while (i < array.length) {
            if (array[i] == Integer.MIN_VALUE) {
                count += array[i + 2];
                i += 3;
                continue;
            }
            ++count;
            ++i;
        }
        int[] decoded = new int[count];
        int p = 0;
        for (i = 0; i < array.length; ++i) {
            int q = array[i];
            if (q == Integer.MIN_VALUE) {
                int val = array[++i];
                int cnt = array[++i];
                for (int z = 0; z < cnt; ++z) {
                    decoded[p++] = val;
                }
                continue;
            }
            decoded[p++] = q;
        }
        return decoded;
    }

    public static double getDouble(String s2) {
        double d = Double.NaN;
        try {
            d = Double.valueOf(s2);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return d;
    }

    public static float getFloat(String s2) {
        float f = Float.NaN;
        if (s2 != null) {
            try {
                f = Float.valueOf(s2).floatValue();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return f;
    }

    public static boolean getBoolean(String s2) {
        if (s2 == null) {
            return false;
        }
        char c = s2.trim().charAt(0);
        return c == 'T' || c == 't';
    }

    public static int getInt(String s2) {
        int i = 0;
        if (s2 != null) {
            try {
                i = Integer.parseInt(s2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return i;
    }

    public static String shortString(double val) {
        return Convert.shortString(val, 1);
    }

    public static String shortString(double val, int mode) {
        boolean negative = val < 0.0;
        double origVal = val;
        if ((val = Math.abs(val)) < 0.001) {
            for (int i = 1; i < 30; ++i) {
                val *= 10.0;
                origVal *= 10.0;
                if (!(val >= 1.0)) continue;
                return Convert.shortString(origVal) + "E-" + i;
            }
        }
        int mult = 1;
        float round = mode == 2 ? (negative ? 1.0f : 0.0f) : (mode == 3 ? (negative ? 0.0f : 1.0f) : 0.5f);
        for (int p = 3; p > 0; --p) {
            mult *= 10;
            round /= 10.0f;
        }
        long l = (long)((val + (double)round) * (double)mult);
        long preDot = l / (long)mult;
        int postDot = (int)(l % (long)mult);
        String num = preDot <= Integer.MAX_VALUE ? Integer.toString((int)preDot) : Long.toString(preDot);
        if (postDot == 0) {
            if (negative && preDot != 0L) {
                return "-" + num;
            }
            return num;
        }
        StringBuffer buf = new StringBuffer(num.length() + 5);
        if (negative) {
            buf.append('-');
        }
        buf.append(num);
        buf.append('.');
        num = Integer.toString(postDot);
        int nlen = num.length();
        for (int p = 3; p > nlen; --p) {
            buf.append('0');
        }
        buf.append(num);
        return buf.toString();
    }
}

