/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.DataTable;
import nom.tam.util.TableException;

public class ColumnTable
implements DataTable {
    private Object[] arrays;
    private int[] sizes;
    private int nrow;
    private int chunk;
    private int rowSize;
    private char[] types;
    private Class[] bases;
    private byte[][] bytePointers;
    private short[][] shortPointers;
    private int[][] intPointers;
    private long[][] longPointers;
    private float[][] floatPointers;
    private double[][] doublePointers;
    private char[][] charPointers;
    private boolean[][] booleanPointers;

    public ColumnTable(Object[] arrays, int[] sizes) throws TableException {
        this.setup(arrays, sizes);
    }

    protected void setup(Object[] arrays, int[] sizes) throws TableException {
        this.checkArrayConsistency(arrays, sizes);
        this.getNumberOfRows();
        this.initializePointers();
    }

    public int getNrow() {
        return this.nrow;
    }

    public int getNcol() {
        return this.arrays.length;
    }

    public Object getColumn(int col) {
        return this.arrays[col];
    }

    public void setColumn(int col, Object newColumn) throws TableException {
        this.arrays[col] = newColumn;
        this.setup(this.arrays, this.sizes);
    }

    public Object getElement(int row, int col) {
        Object x = Array.newInstance(this.bases[col], this.sizes[col]);
        System.arraycopy(this.arrays[col], this.sizes[col] * row, x, 0, this.sizes[col]);
        return x;
    }

    public void setElement(int row, int col, Object x) throws TableException {
        String classname = x.getClass().getName();
        if (!classname.equals("[" + this.types[col])) {
            throw new TableException("setElement: Incompatible element type");
        }
        if (Array.getLength(x) != this.sizes[col]) {
            throw new TableException("setElement: Incompatible element size");
        }
        System.arraycopy(x, 0, this.arrays[col], this.sizes[col] * row, this.sizes[col]);
    }

    public Object getRow(int row) {
        Object[] x = new Object[this.arrays.length];
        for (int col = 0; col < this.arrays.length; ++col) {
            x[col] = this.getElement(row, col);
        }
        return x;
    }

    public void setRow(int row, Object x) throws TableException {
        if (!(x instanceof Object[])) {
            throw new TableException("setRow: Incompatible row");
        }
        for (int col = 0; col < this.arrays.length; ++col) {
            this.setElement(row, col, ((Object[])x)[col]);
        }
    }

    protected void checkArrayConsistency(Object[] arrays, int[] sizes) throws TableException {
        int i;
        if (arrays.length != sizes.length) {
            throw new TableException("readArraysAsColumns: Incompatible arrays and sizes.");
        }
        int ratio = 0;
        int rowSize = 0;
        this.types = new char[arrays.length];
        this.bases = new Class[arrays.length];
        boolean nullTable = true;
        for (i = 0; i < arrays.length; ++i) {
            if (Array.getLength(arrays[i]) <= 0) continue;
            nullTable = false;
            break;
        }
        for (i = 0; i < arrays.length; ++i) {
            String classname = arrays[i].getClass().getName();
            if (classname.charAt(0) != '[' || classname.length() != 2) {
                throw new TableException("Non-primitive array");
            }
            int thisSize = Array.getLength(arrays[i]);
            if (thisSize == 0 && sizes[i] == 0) continue;
            if (!(thisSize != 0 && sizes[i] > 0 || nullTable)) {
                throw new TableException("Invalid size for array: index=" + i);
            }
            if (thisSize % sizes[i] != 0) {
                throw new TableException("Row size does not divide array: index=" + i);
            }
            if (sizes[i] > 0) {
                int thisRatio = thisSize / sizes[i];
                if (ratio != 0 && thisRatio != ratio) {
                    throw new TableException("Different number of rows in different columns");
                }
                ratio = thisRatio;
            }
            rowSize += sizes[i] * ArrayFuncs.getBaseLength(arrays[i]);
            this.types[i] = classname.charAt(1);
            this.bases[i] = ArrayFuncs.getBaseClass(arrays[i]);
        }
        this.nrow = ratio;
        this.rowSize = rowSize;
        this.arrays = arrays;
        this.sizes = sizes;
    }

    protected void getNumberOfRows() {
        int bufSize = 65536;
        this.chunk = this.rowSize == 0 ? 0 : (this.rowSize > bufSize ? 1 : (bufSize / this.rowSize >= this.nrow ? this.nrow : bufSize / this.rowSize + 1));
    }

    protected void initializePointers() {
        int col;
        int nbyte = 0;
        int nshort = 0;
        int nint = 0;
        int nlong = 0;
        int nfloat = 0;
        int ndouble = 0;
        int nchar = 0;
        int nboolean = 0;
        block20: for (col = 0; col < this.arrays.length; ++col) {
            switch (this.types[col]) {
                case 'B': {
                    ++nbyte;
                    continue block20;
                }
                case 'S': {
                    ++nshort;
                    continue block20;
                }
                case 'I': {
                    ++nint;
                    continue block20;
                }
                case 'L': {
                    ++nlong;
                    continue block20;
                }
                case 'F': {
                    ++nfloat;
                    continue block20;
                }
                case 'D': {
                    ++ndouble;
                    continue block20;
                }
                case 'C': {
                    ++nchar;
                    continue block20;
                }
                case 'Z': {
                    ++nboolean;
                }
            }
        }
        this.bytePointers = new byte[nbyte][];
        this.shortPointers = new short[nshort][];
        this.intPointers = new int[nint][];
        this.longPointers = new long[nlong][];
        this.floatPointers = new float[nfloat][];
        this.doublePointers = new double[ndouble][];
        this.charPointers = new char[nchar][];
        this.booleanPointers = new boolean[nboolean][];
        nbyte = 0;
        nshort = 0;
        nint = 0;
        nlong = 0;
        nfloat = 0;
        ndouble = 0;
        nchar = 0;
        nboolean = 0;
        block21: for (col = 0; col < this.arrays.length; ++col) {
            switch (this.types[col]) {
                case 'B': {
                    this.bytePointers[nbyte] = (byte[])this.arrays[col];
                    ++nbyte;
                    continue block21;
                }
                case 'S': {
                    this.shortPointers[nshort] = (short[])this.arrays[col];
                    ++nshort;
                    continue block21;
                }
                case 'I': {
                    this.intPointers[nint] = (int[])this.arrays[col];
                    ++nint;
                    continue block21;
                }
                case 'L': {
                    this.longPointers[nlong] = (long[])this.arrays[col];
                    ++nlong;
                    continue block21;
                }
                case 'F': {
                    this.floatPointers[nfloat] = (float[])this.arrays[col];
                    ++nfloat;
                    continue block21;
                }
                case 'D': {
                    this.doublePointers[ndouble] = (double[])this.arrays[col];
                    ++ndouble;
                    continue block21;
                }
                case 'C': {
                    this.charPointers[nchar] = (char[])this.arrays[col];
                    ++nchar;
                    continue block21;
                }
                case 'Z': {
                    this.booleanPointers[nboolean] = (boolean[])this.arrays[col];
                    ++nboolean;
                }
            }
        }
    }

    public int read(InputStream is) throws IOException {
        int drow;
        byte[] buffer = new byte[this.chunk * this.rowSize];
        if (this.rowSize == 0) {
            return 0;
        }
        for (int currRow = 0; currRow < this.nrow; currRow += drow) {
            drow = this.chunk;
            if (currRow + drow > this.nrow) {
                drow = this.nrow - currRow;
            }
            int need = drow * this.rowSize;
            int got = 0;
            while (need > 0) {
                int len = is.read(buffer, got, need);
                if (len <= 0) {
                    throw new EOFException("EOF reached in ColumnarIO.read");
                }
                need -= len;
                got += len;
            }
            int bufOffset = 0;
            for (int row = currRow; row < currRow + drow; ++row) {
                int ibyte = 0;
                int ishort = 0;
                int iint = 0;
                int ilong = 0;
                int ichar = 0;
                int ifloat = 0;
                int idouble = 0;
                int iboolean = 0;
                block13: for (int col = 0; col < this.arrays.length; ++col) {
                    int arrOffset = this.sizes[col] * row;
                    int size = this.sizes[col];
                    switch (this.types[col]) {
                        case 'I': {
                            int i;
                            int[] ia = this.intPointers[iint];
                            ++iint;
                            for (i = arrOffset; i < arrOffset + size; ++i) {
                                ia[i] = buffer[bufOffset] << 24 | (buffer[bufOffset + 1] & 0xFF) << 16 | (buffer[bufOffset + 2] & 0xFF) << 8 | buffer[bufOffset + 3] & 0xFF;
                                bufOffset += 4;
                            }
                            continue block13;
                        }
                        case 'S': {
                            int i;
                            short[] s2 = this.shortPointers[ishort];
                            ++ishort;
                            for (i = arrOffset; i < arrOffset + size; ++i) {
                                s2[i] = (short)(buffer[bufOffset] << 8 | buffer[bufOffset + 1] & 0xFF);
                                bufOffset += 2;
                            }
                            continue block13;
                        }
                        case 'B': {
                            int i;
                            byte[] b = this.bytePointers[ibyte];
                            ++ibyte;
                            for (i = arrOffset; i < arrOffset + size; ++i) {
                                b[i] = buffer[bufOffset];
                                ++bufOffset;
                            }
                            continue block13;
                        }
                        case 'F': {
                            int tmp;
                            int i;
                            float[] f = this.floatPointers[ifloat];
                            ++ifloat;
                            for (i = arrOffset; i < arrOffset + size; ++i) {
                                tmp = buffer[bufOffset] << 24 | (buffer[bufOffset + 1] & 0xFF) << 16 | (buffer[bufOffset + 2] & 0xFF) << 8 | buffer[bufOffset + 3] & 0xFF;
                                f[i] = Float.intBitsToFloat(tmp);
                                bufOffset += 4;
                            }
                            continue block13;
                        }
                        case 'D': {
                            int i2;
                            int i1;
                            int i;
                            double[] d = this.doublePointers[idouble];
                            ++idouble;
                            for (i = arrOffset; i < arrOffset + size; ++i) {
                                i1 = buffer[bufOffset] << 24 | (buffer[bufOffset + 1] & 0xFF) << 16 | (buffer[bufOffset + 2] & 0xFF) << 8 | buffer[bufOffset + 3] & 0xFF;
                                i2 = buffer[bufOffset += 4] << 24 | (buffer[bufOffset + 1] & 0xFF) << 16 | (buffer[bufOffset + 2] & 0xFF) << 8 | buffer[bufOffset + 3] & 0xFF;
                                bufOffset += 4;
                                d[i] = Double.longBitsToDouble((long)i1 << 32 | (long)i2 & 0xFFFFFFFFL);
                            }
                            continue block13;
                        }
                        case 'C': {
                            int tmp;
                            int i;
                            char[] c = this.charPointers[ichar];
                            ++ichar;
                            for (i = arrOffset; i < arrOffset + size; ++i) {
                                tmp = buffer[bufOffset] << 8 | buffer[bufOffset + 1] & 0xFF;
                                c[i] = (char)tmp;
                                bufOffset += 2;
                            }
                            continue block13;
                        }
                        case 'L': {
                            int i2;
                            int i1;
                            int i;
                            long[] l = this.longPointers[ilong];
                            ++ilong;
                            for (i = arrOffset; i < arrOffset + size; ++i) {
                                i1 = buffer[bufOffset] << 24 | (buffer[bufOffset + 1] & 0xFF) << 16 | (buffer[bufOffset + 2] & 0xFF) << 8 | buffer[bufOffset + 3] & 0xFF;
                                i2 = buffer[bufOffset += 4] << 24 | (buffer[bufOffset + 1] & 0xFF) << 16 | (buffer[bufOffset + 2] & 0xFF) << 8 | buffer[bufOffset + 3] & 0xFF;
                                bufOffset += 4;
                                l[i] = (long)i1 << 32 | (long)i2 & 0xFFFFFFFFL;
                            }
                            continue block13;
                        }
                        case 'Z': {
                            int i;
                            boolean[] bool = this.booleanPointers[iboolean];
                            ++iboolean;
                            for (i = arrOffset; i < arrOffset + size; ++i) {
                                bool[i] = buffer[bufOffset] == 1;
                                ++bufOffset;
                            }
                            continue block13;
                        }
                    }
                }
            }
        }
        return this.rowSize * this.nrow;
    }

    public int write(OutputStream os) throws IOException {
        int drow;
        byte[] buffer = new byte[this.chunk * this.rowSize];
        if (this.rowSize == 0) {
            return 0;
        }
        for (int currRow = 0; currRow < this.nrow; currRow += drow) {
            drow = this.chunk;
            if (currRow + drow > this.nrow) {
                drow = this.nrow - currRow;
            }
            int bufOffset = 0;
            for (int row = currRow; row < currRow + drow; ++row) {
                int ibyte = 0;
                int ishort = 0;
                int iint = 0;
                int ilong = 0;
                int ichar = 0;
                int ifloat = 0;
                int idouble = 0;
                int iboolean = 0;
                block12: for (int col = 0; col < this.arrays.length; ++col) {
                    int arrOffset = this.sizes[col] * row;
                    int size = this.sizes[col];
                    switch (this.types[col]) {
                        case 'I': {
                            int i;
                            int[] ia = this.intPointers[iint];
                            ++iint;
                            for (i = arrOffset; i < arrOffset + size; ++i) {
                                buffer[bufOffset] = (byte)(ia[i] >>> 24);
                                buffer[bufOffset + 1] = (byte)(ia[i] >>> 16);
                                buffer[bufOffset + 2] = (byte)(ia[i] >>> 8);
                                buffer[bufOffset + 3] = (byte)ia[i];
                                bufOffset += 4;
                            }
                            continue block12;
                        }
                        case 'S': {
                            int i;
                            short[] s2 = this.shortPointers[ishort];
                            ++ishort;
                            for (i = arrOffset; i < arrOffset + size; ++i) {
                                buffer[bufOffset] = (byte)(s2[i] >>> 8);
                                buffer[bufOffset + 1] = (byte)s2[i];
                                bufOffset += 2;
                            }
                            continue block12;
                        }
                        case 'B': {
                            byte[] b = this.bytePointers[ibyte];
                            ++ibyte;
                            System.arraycopy(b, arrOffset, buffer, bufOffset, size);
                            bufOffset += size;
                            continue block12;
                        }
                        case 'F': {
                            int i;
                            float[] f = this.floatPointers[ifloat];
                            ++ifloat;
                            for (i = arrOffset; i < arrOffset + size; ++i) {
                                int tmp = Float.floatToIntBits(f[i]);
                                buffer[bufOffset] = (byte)(tmp >>> 24);
                                buffer[bufOffset + 1] = (byte)(tmp >>> 16);
                                buffer[bufOffset + 2] = (byte)(tmp >>> 8);
                                buffer[bufOffset + 3] = (byte)tmp;
                                bufOffset += 4;
                            }
                            continue block12;
                        }
                        case 'D': {
                            int i2;
                            int i1;
                            int i;
                            double[] d = this.doublePointers[idouble];
                            ++idouble;
                            for (i = arrOffset; i < arrOffset + size; ++i) {
                                long lng = Double.doubleToLongBits(d[i]);
                                i1 = (int)(lng >>> 32);
                                i2 = (int)lng;
                                buffer[bufOffset] = (byte)(i1 >>> 24);
                                buffer[bufOffset + 1] = (byte)(i1 >>> 16);
                                buffer[bufOffset + 2] = (byte)(i1 >>> 8);
                                buffer[bufOffset + 3] = (byte)i1;
                                buffer[bufOffset += 4] = (byte)(i2 >>> 24);
                                buffer[bufOffset + 1] = (byte)(i2 >>> 16);
                                buffer[bufOffset + 2] = (byte)(i2 >>> 8);
                                buffer[bufOffset + 3] = (byte)i2;
                                bufOffset += 4;
                            }
                            continue block12;
                        }
                        case 'C': {
                            int i;
                            char[] c = this.charPointers[ichar];
                            ++ichar;
                            for (i = arrOffset; i < arrOffset + size; ++i) {
                                buffer[bufOffset] = (byte)(c[i] >>> 8);
                                buffer[bufOffset + 1] = (byte)c[i];
                                bufOffset += 2;
                            }
                            continue block12;
                        }
                        case 'L': {
                            int i2;
                            int i1;
                            int i;
                            long[] l = this.longPointers[ilong];
                            ++ilong;
                            for (i = arrOffset; i < arrOffset + size; ++i) {
                                i1 = (int)(l[i] >>> 32);
                                i2 = (int)l[i];
                                buffer[bufOffset] = (byte)(i1 >>> 24);
                                buffer[bufOffset + 1] = (byte)(i1 >>> 16);
                                buffer[bufOffset + 2] = (byte)(i1 >>> 8);
                                buffer[bufOffset + 3] = (byte)i1;
                                buffer[bufOffset += 4] = (byte)(i2 >>> 24);
                                buffer[bufOffset + 1] = (byte)(i2 >>> 16);
                                buffer[bufOffset + 2] = (byte)(i2 >>> 8);
                                buffer[bufOffset + 3] = (byte)i2;
                                bufOffset += 4;
                            }
                            continue block12;
                        }
                        case 'Z': {
                            int i;
                            boolean[] bool = this.booleanPointers[iboolean];
                            ++iboolean;
                            for (i = arrOffset; i < arrOffset + size; ++i) {
                                buffer[bufOffset] = bool[i] ? (byte)1 : 0;
                                ++bufOffset;
                            }
                            continue block12;
                        }
                    }
                }
            }
            os.write(buffer, 0, this.rowSize * drow);
        }
        return this.rowSize * this.nrow;
    }

    public Class[] getBases() {
        return this.bases;
    }

    public char[] getTypes() {
        return this.types;
    }
}

