/*
 * Decompiled with CFR 0.152.
 */
package visad.bom;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.CellImpl;
import visad.CoordinateSystem;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayException;
import visad.DisplayRealType;
import visad.DisplayTupleType;
import visad.Integer1DSet;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.ShapeControl;
import visad.VisADException;
import visad.VisADLineArray;
import visad.java3d.DirectManipulationRendererJ3D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.TwoDDisplayRendererJ3D;

public class TrackManipulation {
    private DisplayImplJ3D display;
    private DataReference track1_ref;
    private DataReference track2_ref;
    private DataReference track3_ref;
    private RealTupleType latlonshape = null;
    private ScalarMap latmap = null;
    private ScalarMap lonmap = null;
    private CoordinateSystem coord = null;
    private int latindex = -1;
    private int lonindex = -1;
    private int otherindex = -1;
    private float othervalue = 0.0f;
    private ScalarMap shapemap = null;
    private ShapeControl shapecontrol = null;
    private float x_size;
    private float y_size;
    private float angle;
    private static int NE = 32;
    private float[] x_ellipse = new float[NE + 1];
    private float[] y_ellipse = new float[NE + 1];
    private static final int NUM = 4096;

    public TrackManipulation(float lat1, float lon1, float lat2, float lon2, DisplayImplJ3D d, float xs, float ys, float ang) throws VisADException, RemoteException {
        RealTupleType latlon = new RealTupleType(RealType.Latitude, RealType.Longitude);
        RealTuple track1 = new RealTuple(latlon, new double[]{lat1, lon1});
        RealTuple track2 = new RealTuple(latlon, new double[]{lat2, lon2});
        RealType shape = RealType.getRealType("shape");
        this.latlonshape = new RealTupleType(RealType.Latitude, RealType.Longitude, shape);
        RealTuple track3 = new RealTuple(this.latlonshape, new double[]{lat1, lon1, 0.0});
        this.track1_ref = new DataReferenceImpl("track1_ref");
        this.track2_ref = new DataReferenceImpl("track2_ref");
        this.track3_ref = new DataReferenceImpl("track3_ref");
        this.track1_ref.setData(track1);
        this.track2_ref.setData(track2);
        this.track3_ref.setData(track3);
        this.display = d;
        this.x_size = Math.abs(xs);
        this.y_size = Math.abs(ys);
        this.angle = ang;
        float sa = (float)Math.sin((double)ang * (Math.PI / 180));
        float ca = (float)Math.cos((double)ang * (Math.PI / 180));
        for (int i = 0; i < NE + 1; ++i) {
            double b = Math.PI * 2 * (double)i / (double)NE;
            float xe = (float)((double)this.x_size * Math.cos(b));
            float ye = (float)((double)this.y_size * Math.sin(b));
            this.x_ellipse[i] = ca * xe + sa * ye;
            this.y_ellipse[i] = ca * ye - sa * xe;
        }
        Vector scalar_map_vector = this.display.getMapVector();
        Enumeration en = scalar_map_vector.elements();
        while (en.hasMoreElements()) {
            ScalarMap map = (ScalarMap)en.nextElement();
            if (RealType.Latitude.equals(map.getScalar())) {
                this.latmap = map;
                continue;
            }
            if (!RealType.Longitude.equals(map.getScalar())) continue;
            this.lonmap = map;
        }
        if (this.latmap == null || this.lonmap == null) {
            throw new DisplayException("Latitude and Longitude must be mapped in display");
        }
        DisplayRealType latreal = this.latmap.getDisplayScalar();
        DisplayRealType lonreal = this.lonmap.getDisplayScalar();
        DisplayTupleType lattuple = latreal.getTuple();
        DisplayTupleType lontuple = lonreal.getTuple();
        if (lattuple == null || !lattuple.equals(lontuple)) {
            throw new DisplayException("Latitude and Longitude must be mapped to spatial in display(1)");
        }
        this.latindex = latreal.getTupleIndex();
        this.lonindex = lonreal.getTupleIndex();
        this.otherindex = 3 - (this.latindex + this.lonindex);
        DisplayRealType othertype = (DisplayRealType)lattuple.getComponent(this.otherindex);
        this.othervalue = (float)othertype.getDefaultValue();
        this.coord = lattuple.getCoordinateSystem();
        if (!(lattuple.equals(Display.DisplaySpatialCartesianTuple) || this.coord != null && this.coord.getReference().equals(Display.DisplaySpatialCartesianTuple))) {
            throw new DisplayException("Latitude and Longitude must be mapped to spatial in display(2)");
        }
        this.shapemap = new ScalarMap(shape, Display.Shape);
        this.display.addMap(this.shapemap);
        this.shapecontrol = (ShapeControl)this.shapemap.getControl();
        this.shapecontrol.setShapeSet(new Integer1DSet(1));
        this.display.addReferences((DataRenderer)new DirectManipulationRendererJ3D(), this.track1_ref);
        this.display.addReferences((DataRenderer)new DirectManipulationRendererJ3D(), this.track2_ref);
        this.display.addReference(this.track3_ref);
        TrackGetter tracker = new TrackGetter();
        tracker.addReference(this.track1_ref);
        tracker.addReference(this.track2_ref);
    }

    private float getStep(float x, float y) {
        double dist = 2.0 * (double)(this.x_size + this.y_size);
        float step = -1.0f;
        for (int i = 0; i < NE + 1; ++i) {
            double d = Math.abs(x * this.y_ellipse[i] - y * this.x_ellipse[i]);
            if (!(d < dist)) continue;
            dist = d;
            step = (float)Math.sqrt(this.x_ellipse[i] * this.x_ellipse[i] + this.y_ellipse[i] * this.y_ellipse[i]);
        }
        return step;
    }

    private VisADLineArray makeTrack(float[][] values) {
        int i;
        float sscale = 0.112500004f;
        float x = 0.0f;
        float y = 0.0f;
        float z = values[2][0];
        float x5 = values[0][1] - values[0][0];
        float y5 = values[1][1] - values[1][0];
        float xdir = x5 - x;
        float ydir = y5 - y;
        float dist = (float)Math.sqrt(xdir * xdir + ydir * ydir);
        float x0 = xdir / dist;
        float y0 = ydir / dist;
        int nv = 0;
        float[] vx = new float[4096];
        float[] vy = new float[4096];
        float[] vz = new float[4096];
        int lenv = vx.length;
        vx[nv] = x;
        vy[nv] = y;
        vz[nv] = z;
        vx[++nv] = x5;
        vy[nv] = y5;
        vz[nv] = z;
        ++nv;
        float xd = sscale * x0;
        float yd = sscale * y0;
        float x3 = x5 - 0.3f * (xd - yd);
        float y3 = y5 - 0.3f * (yd + xd);
        float x4 = x5 - 0.3f * (xd + yd);
        float y4 = y5 - 0.3f * (yd - xd);
        vx[nv] = x5;
        vy[nv] = y5;
        vz[nv] = z;
        vx[++nv] = x3;
        vy[nv] = y3;
        vz[nv] = z;
        vx[++nv] = x5;
        vy[nv] = y5;
        vz[nv] = z;
        vx[++nv] = x4;
        vy[nv] = y4;
        vz[nv] = z;
        ++nv;
        float step = this.getStep(xdir, ydir);
        int nsteps = (int)(dist / step);
        if (nsteps < 1) {
            nsteps = 1;
        }
        int lim = (vx.length - nv) / (2 * NE);
        if (nsteps < 1) {
            nsteps = 1;
        }
        if (nsteps > lim) {
            nsteps = lim;
        }
        float xstep = xdir / (float)nsteps;
        float ystep = ydir / (float)nsteps;
        boolean[] outside = new boolean[NE + 1];
        for (int i2 = 0; i2 < NE + 1; ++i2) {
            float xs = this.x_ellipse[i2] + xstep;
            float ys = this.y_ellipse[i2] + ystep;
            float radius = this.getStep(xs, ys);
            float len = (float)Math.sqrt(xs * xs + ys * ys);
            outside[i2] = len > radius;
        }
        float[] xe = new float[2 * NE];
        float[] ye = new float[2 * NE];
        int ne = 0;
        for (int i3 = 0; i3 < NE; ++i3) {
            if (!outside[i3] || !outside[i3 + 1]) continue;
            xe[ne] = this.x_ellipse[i3];
            ye[ne] = this.y_ellipse[i3];
            xe[++ne] = this.x_ellipse[i3 + 1];
            ye[ne] = this.y_ellipse[i3 + 1];
            ++ne;
        }
        float xcenter = x;
        float ycenter = y;
        for (i = 0; i < NE; ++i) {
            vx[nv] = this.x_ellipse[i];
            vy[nv] = this.y_ellipse[i];
            vz[nv] = z;
            vx[++nv] = this.x_ellipse[i + 1];
            vy[nv] = this.y_ellipse[i + 1];
            vz[nv] = z;
            ++nv;
        }
        for (i = 0; i < nsteps; ++i) {
            xcenter += xstep;
            ycenter += ystep;
            for (int j = 0; j < ne; ++j) {
                vx[nv] = xcenter + xe[j];
                vy[nv] = ycenter + ye[j];
                vz[nv] = z;
                ++nv;
            }
        }
        VisADLineArray array = new VisADLineArray();
        array.vertexCount = nv;
        float[] coordinates = new float[3 * nv];
        int m3 = 0;
        for (int i4 = 0; i4 < nv; ++i4) {
            coordinates[m3++] = vx[i4];
            coordinates[m3++] = vy[i4];
            coordinates[m3++] = vz[i4];
        }
        array.coordinates = coordinates;
        return array;
    }

    public static void main(String[] args) throws VisADException, RemoteException {
        float[] fargs = new float[]{0.2f, 0.1f, 0.0f};
        for (int i = 0; i < args.length; ++i) {
            try {
                fargs[i] = Float.parseFloat(args[i]);
                continue;
            }
            catch (NumberFormatException exc) {
                // empty catch block
            }
        }
        DisplayImplJ3D display = new DisplayImplJ3D("display1", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
        ScalarMap lonmap = new ScalarMap(RealType.Longitude, Display.XAxis);
        display.addMap(lonmap);
        lonmap.setRange(-10.0, 10.0);
        ScalarMap latmap = new ScalarMap(RealType.Latitude, Display.YAxis);
        display.addMap(latmap);
        latmap.setRange(-10.0, 10.0);
        TrackManipulation track = new TrackManipulation(0.0f, 0.0f, 3.0f, 3.0f, display, fargs[0], fargs[1], fargs[2]);
        JFrame frame = new JFrame("test TrackManipulation");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setAlignmentY(0.0f);
        panel.setAlignmentX(0.0f);
        frame.getContentPane().add(panel);
        panel.add(display.getComponent());
        frame.setSize(500, 500);
        frame.setVisible(true);
    }

    class TrackGetter
    extends CellImpl {
        public void doAction() throws VisADException, RemoteException {
            float[] latvalues = new float[2];
            float[] lonvalues = new float[2];
            RealTuple tuple1 = (RealTuple)TrackManipulation.this.track1_ref.getData();
            latvalues[0] = (float)((Real)tuple1.getComponent(0)).getValue(RealType.Latitude.getDefaultUnit());
            lonvalues[0] = (float)((Real)tuple1.getComponent(1)).getValue(RealType.Longitude.getDefaultUnit());
            float lat0 = latvalues[0];
            float lon0 = lonvalues[0];
            RealTuple tuple2 = (RealTuple)TrackManipulation.this.track2_ref.getData();
            latvalues[1] = (float)((Real)tuple2.getComponent(0)).getValue(RealType.Latitude.getDefaultUnit());
            lonvalues[1] = (float)((Real)tuple2.getComponent(1)).getValue(RealType.Longitude.getDefaultUnit());
            latvalues = TrackManipulation.this.latmap.scaleValues(latvalues);
            lonvalues = TrackManipulation.this.lonmap.scaleValues(lonvalues);
            float[][] values = new float[3][2];
            for (int k = 0; k < 2; ++k) {
                values[((TrackManipulation)TrackManipulation.this).latindex][k] = latvalues[k];
                values[((TrackManipulation)TrackManipulation.this).lonindex][k] = lonvalues[k];
                values[((TrackManipulation)TrackManipulation.this).otherindex][k] = TrackManipulation.this.othervalue;
            }
            if (TrackManipulation.this.coord != null) {
                values = TrackManipulation.this.coord.toReference(values);
            }
            TrackManipulation.this.display.disableAction();
            RealTuple track3 = new RealTuple(TrackManipulation.this.latlonshape, new double[]{lat0, lon0, 0.0});
            TrackManipulation.this.track3_ref.setData(track3);
            VisADLineArray shape = TrackManipulation.this.makeTrack(values);
            TrackManipulation.this.shapecontrol.setShape(0, shape);
            TrackManipulation.this.display.enableAction();
        }
    }
}

