/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.LogTools;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;

public class DeltavisionReader
extends FormatReader {
    private static final short LITTLE_ENDIAN = -16224;
    private static final int HEADER_LENGTH = 1024;
    private int extSize;
    private int bytesPerPixel;
    protected int wSize;
    protected int zSize;
    protected int tSize;
    protected int numIntsPerSection;
    protected int numFloatsPerSection;
    protected DVExtHdrFields[][][] extHdrFields = null;

    public DeltavisionReader() {
        super("Deltavision", new String[]{"dv", "r3d", "r3d_d3d"});
    }

    public boolean isThisType(byte[] block) {
        return false;
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length);
        long offset = 1024 + this.extSize;
        long bytes = this.core.sizeX[0] * this.core.sizeY[0] * this.bytesPerPixel;
        this.in.seek(offset + bytes * (long)no);
        this.in.read(buf);
        return buf;
    }

    protected void initFile(String id) throws FormatException, IOException {
        String imageSequence;
        String imageType;
        String pixel;
        if (debug) {
            this.debug("DeltavisionReader.initFile(" + id + ")");
        }
        super.initFile(id);
        this.in = new RandomAccessStream(id);
        this.status("Reading header");
        this.in.seek(96L);
        this.in.order(true);
        this.core.littleEndian[0] = this.in.readShort() == -16224;
        this.in.order(this.core.littleEndian[0]);
        this.in.seek(8L);
        this.core.imageCount[0] = this.in.readInt();
        this.in.seek(92L);
        this.extSize = this.in.readInt();
        this.in.seek(0L);
        this.core.sizeX[0] = this.in.readInt();
        this.core.sizeY[0] = this.in.readInt();
        Integer xSize = new Integer(this.core.sizeX[0]);
        Integer ySize = new Integer(this.core.sizeY[0]);
        this.addMeta("ImageWidth", xSize);
        this.addMeta("ImageHeight", ySize);
        this.addMeta("NumberOfImages", new Integer(this.in.readInt()));
        int filePixelType = this.in.readInt();
        switch (filePixelType) {
            case 0: {
                pixel = "8 bit unsigned integer";
                this.core.pixelType[0] = 1;
                this.bytesPerPixel = 1;
                break;
            }
            case 1: {
                pixel = "16 bit signed integer";
                this.core.pixelType[0] = 3;
                this.bytesPerPixel = 2;
                break;
            }
            case 2: {
                pixel = "32 bit floating point";
                this.core.pixelType[0] = 6;
                this.bytesPerPixel = 4;
                break;
            }
            case 3: {
                pixel = "32 bit complex";
                this.core.pixelType[0] = 5;
                this.bytesPerPixel = 4;
                break;
            }
            case 4: {
                pixel = "64 bit complex";
                this.core.pixelType[0] = 6;
                this.bytesPerPixel = 8;
                break;
            }
            case 6: {
                pixel = "16 bit unsigned integer";
                this.core.pixelType[0] = 3;
                this.bytesPerPixel = 2;
                break;
            }
            default: {
                pixel = "unknown";
                this.core.pixelType[0] = 1;
                this.bytesPerPixel = 1;
            }
        }
        this.addMeta("PixelType", pixel);
        this.addMeta("Sub-image starting point (X)", new Integer(this.in.readInt()));
        this.addMeta("Sub-image starting point (Y)", new Integer(this.in.readInt()));
        this.addMeta("Sub-image starting point (Z)", new Integer(this.in.readInt()));
        this.addMeta("Pixel sampling size (X)", new Integer(this.in.readInt()));
        this.addMeta("Pixel sampling size (Y)", new Integer(this.in.readInt()));
        this.addMeta("Pixel sampling size (Z)", new Integer(this.in.readInt()));
        float pixX = this.in.readFloat();
        float pixY = this.in.readFloat();
        float pixZ = this.in.readFloat();
        this.addMeta("X element length (in um)", new Float(pixX));
        this.addMeta("Y element length (in um)", new Float(pixY));
        this.addMeta("Z element length (in um)", new Float(pixZ));
        this.addMeta("X axis angle", new Float(this.in.readFloat()));
        this.addMeta("Y axis angle", new Float(this.in.readFloat()));
        this.addMeta("Z axis angle", new Float(this.in.readFloat()));
        this.addMeta("Column axis sequence", new Integer(this.in.readInt()));
        this.addMeta("Row axis sequence", new Integer(this.in.readInt()));
        this.addMeta("Section axis sequence", new Integer(this.in.readInt()));
        Float wave1Min = new Float(this.in.readFloat());
        this.addMeta("Wavelength 1 min. intensity", wave1Min);
        Float wave1Max = new Float(this.in.readFloat());
        this.addMeta("Wavelength 1 max. intensity", wave1Max);
        this.addMeta("Wavelength 1 mean intensity", new Float(this.in.readFloat()));
        this.addMeta("Space group number", new Integer(this.in.readInt()));
        this.in.seek(132L);
        this.addMeta("Number of Sub-resolution sets", new Integer(this.in.readShort()));
        this.addMeta("Z axis reduction quotient", new Integer(this.in.readShort()));
        Float wave2Min = new Float(this.in.readFloat());
        this.addMeta("Wavelength 2 min. intensity", wave2Min);
        Float wave2Max = new Float(this.in.readFloat());
        this.addMeta("Wavelength 2 max. intensity", wave2Max);
        Float wave3Min = new Float(this.in.readFloat());
        this.addMeta("Wavelength 3 min. intensity", wave3Min);
        Float wave3Max = new Float(this.in.readFloat());
        this.addMeta("Wavelength 3 max. intensity", wave3Max);
        Float wave4Min = new Float(this.in.readFloat());
        this.addMeta("Wavelength 4 min. intensity", wave4Min);
        Float wave4Max = new Float(this.in.readFloat());
        this.addMeta("Wavelength 4 max. intensity", wave4Max);
        short type = this.in.readShort();
        switch (type) {
            case 0: {
                imageType = "normal";
                break;
            }
            case 1: {
                imageType = "Tilt-series";
                break;
            }
            case 2: {
                imageType = "Stereo tilt-series";
                break;
            }
            case 3: {
                imageType = "Averaged images";
                break;
            }
            case 4: {
                imageType = "Averaged stereo pairs";
                break;
            }
            default: {
                imageType = "unknown";
            }
        }
        this.addMeta("Image Type", imageType);
        this.addMeta("Lens ID Number", new Integer(this.in.readShort()));
        this.in.seek(172L);
        Float wave5Min = new Float(this.in.readFloat());
        this.addMeta("Wavelength 5 min. intensity", wave5Min);
        Float wave5Max = new Float(this.in.readFloat());
        this.addMeta("Wavelength 5 max. intensity", wave5Max);
        this.core.sizeT[0] = this.in.readShort();
        this.addMeta("Number of timepoints", new Integer(this.core.sizeT[0]));
        short sequence = this.in.readShort();
        switch (sequence) {
            case 0: {
                imageSequence = "ZTW";
                this.core.currentOrder[0] = "XYZTC";
                break;
            }
            case 1: {
                imageSequence = "WZT";
                this.core.currentOrder[0] = "XYCZT";
                break;
            }
            case 2: {
                imageSequence = "ZWT";
                this.core.currentOrder[0] = "XYZCT";
                break;
            }
            case 65536: {
                imageSequence = "WZT";
                this.core.currentOrder[0] = "XYCZT";
                break;
            }
            default: {
                imageSequence = "unknown";
                this.core.currentOrder[0] = "XYZTC";
            }
        }
        this.addMeta("Image sequence", imageSequence);
        this.addMeta("X axis tilt angle", new Float(this.in.readFloat()));
        this.addMeta("Y axis tilt angle", new Float(this.in.readFloat()));
        this.addMeta("Z axis tilt angle", new Float(this.in.readFloat()));
        this.core.sizeC[0] = this.in.readShort();
        this.addMeta("Number of wavelengths", new Integer(this.core.sizeC[0]));
        this.core.sizeZ[0] = this.core.imageCount[0] / (this.core.sizeC[0] * this.core.sizeT[0]);
        this.addMeta("Number of focal planes", new Integer(this.core.sizeZ[0]));
        this.core.rgb[0] = false;
        this.core.interleaved[0] = false;
        this.core.metadataComplete[0] = true;
        this.core.indexed[0] = false;
        this.core.falseColor[0] = false;
        short[] waves = new short[5];
        for (int i = 0; i < waves.length; ++i) {
            waves[i] = this.in.readShort();
        }
        this.addMeta("Wavelength 1 (in nm)", new Integer(waves[0]));
        this.addMeta("Wavelength 2 (in nm)", new Integer(waves[1]));
        this.addMeta("Wavelength 3 (in nm)", new Integer(waves[2]));
        this.addMeta("Wavelength 4 (in nm)", new Integer(waves[3]));
        this.addMeta("Wavelength 5 (in nm)", new Integer(waves[4]));
        this.addMeta("X origin (in um)", new Float(this.in.readFloat()));
        this.addMeta("Y origin (in um)", new Float(this.in.readFloat()));
        this.addMeta("Z origin (in um)", new Float(this.in.readFloat()));
        MetadataStore store = this.getMetadataStore();
        this.in.seek(224L);
        String title = null;
        for (int i = 1; i <= 10; ++i) {
            title = this.in.readString(80).replaceAll("\u0000", "");
            this.addMeta("Title " + i, title);
        }
        this.status("Reading extended header");
        this.in.seek(128L);
        this.numIntsPerSection = this.in.readShort();
        this.numFloatsPerSection = this.in.readShort();
        this.setOffsetInfo(sequence, this.core.sizeZ[0], this.core.sizeC[0], this.core.sizeT[0]);
        this.extHdrFields = new DVExtHdrFields[this.core.sizeZ[0]][this.core.sizeC[0]][this.core.sizeT[0]];
        FormatTools.populatePixels(store, this);
        store.setDimensions(new Float(pixX), new Float(pixY), new Float(pixZ), null, null, null);
        if (title == null) {
            title = "";
        }
        title = title.length() == 0 ? null : title;
        store.setImage(id, null, title, null);
        for (int z = 0; z < this.core.sizeZ[0]; ++z) {
            for (int t = 0; t < this.core.sizeT[0]; ++t) {
                for (int w = 0; w < this.core.sizeC[0]; ++w) {
                    this.in.seek(1024L);
                    this.extHdrFields[z][w][t] = new DVExtHdrFields(this.getTotalOffset(z, w, t), this.numIntsPerSection, this.in, this.core.littleEndian[0]);
                    store.setPlaneInfo(z, w, t, new Float(this.extHdrFields[z][w][t].getTimeStampSeconds()), new Float(this.extHdrFields[z][w][t].getExpTime()), null);
                }
            }
        }
        this.status("Populating metadata");
        for (int w = 0; w < this.core.sizeC[0]; ++w) {
            store.setLogicalChannel(w, null, null, null, null, null, null, null, null, null, null, null, null, "Monochrome", "Wide-field", null, null, null, null, null, new Integer(waves[w]), new Integer((int)this.extHdrFields[0][w][0].getExFilter()), null, new Float(this.extHdrFields[0][w][0].getNdFilter()), null);
        }
        store.setStageLabel("ome", new Float(this.extHdrFields[0][0][0].getStageXCoord()), new Float(this.extHdrFields[0][0][0].getStageYCoord()), new Float(this.extHdrFields[0][0][0].getStageZCoord()), null);
        if (this.core.sizeC[0] > 0) {
            store.setChannelGlobalMinMax(0, new Double(wave1Min.floatValue()), new Double(wave1Max.floatValue()), null);
        }
        if (this.core.sizeC[0] > 1) {
            store.setChannelGlobalMinMax(1, new Double(wave2Min.floatValue()), new Double(wave2Max.floatValue()), null);
        }
        if (this.core.sizeC[0] > 2) {
            store.setChannelGlobalMinMax(2, new Double(wave3Min.floatValue()), new Double(wave3Max.floatValue()), null);
        }
        if (this.core.sizeC[0] > 3) {
            store.setChannelGlobalMinMax(3, new Double(wave4Min.floatValue()), new Double(wave4Max.floatValue()), null);
        }
        if (this.core.sizeC[0] > 4) {
            store.setChannelGlobalMinMax(4, new Double(wave5Min.floatValue()), new Double(wave5Max.floatValue()), null);
        }
    }

    private void setOffsetInfo(int imgSequence, int numZSections, int numWaves, int numTimes) {
        int smallOffset = (this.numIntsPerSection + this.numFloatsPerSection) * 4;
        switch (imgSequence) {
            case 0: {
                this.zSize = smallOffset;
                this.tSize = this.zSize * numZSections;
                this.wSize = this.tSize * numTimes;
                break;
            }
            case 1: {
                this.wSize = smallOffset;
                this.zSize = this.wSize * numWaves;
                this.tSize = this.zSize * numZSections;
                break;
            }
            case 2: {
                this.zSize = smallOffset;
                this.wSize = this.zSize * numZSections;
                this.tSize = this.wSize * numWaves;
            }
        }
    }

    public int getTotalOffset(int currentZ, int currentW, int currentT) {
        return this.zSize * currentZ + this.wSize * currentW + this.tSize * currentT;
    }

    public int getPlaneNumber(int currentZ, int currentW, int currentT) {
        int smallOffset = (this.numIntsPerSection + this.numFloatsPerSection) * 4;
        return this.getTotalOffset(currentZ, currentW, currentT) / smallOffset;
    }

    private class DVExtHdrFields {
        private int offsetWithInts;
        private float oDFilter;
        private float photosensorReading;
        private float timeStampSeconds;
        private float stageXCoord;
        private float stageYCoord;
        private float stageZCoord;
        private float minInten;
        private float maxInten;
        private float meanInten;
        private float expTime;
        private float ndFilter;
        private float exFilter;
        private float emFilter;
        private float exWavelen;
        private float emWavelen;
        private float intenScaling;
        private float energyConvFactor;

        public String toString() {
            String s2 = new String();
            s2 = s2 + "photosensorReading: " + this.photosensorReading + "\n";
            s2 = s2 + "timeStampSeconds: " + this.timeStampSeconds + "\n";
            s2 = s2 + "stageXCoord: " + this.stageXCoord + "\n";
            s2 = s2 + "stageYCoord: " + this.stageYCoord + "\n";
            s2 = s2 + "stageZCoord: " + this.stageZCoord + "\n";
            s2 = s2 + "minInten: " + this.minInten + "\n";
            s2 = s2 + "maxInten: " + this.maxInten + "\n";
            s2 = s2 + "meanInten: " + this.meanInten + "\n";
            s2 = s2 + "expTime: " + this.expTime + "\n";
            s2 = s2 + "ndFilter: " + this.ndFilter + "\n";
            s2 = s2 + "exFilter: " + this.exFilter + "\n";
            s2 = s2 + "emFilter: " + this.emFilter + "\n";
            s2 = s2 + "exWavelen: " + this.exWavelen + "\n";
            s2 = s2 + "emWavelen: " + this.emWavelen + "\n";
            s2 = s2 + "intenScaling: " + this.intenScaling + "\n";
            s2 = s2 + "energyConvFactor: " + this.energyConvFactor + "\n";
            return s2;
        }

        protected DVExtHdrFields(int startingOffset, int numIntsPerSection, RandomAccessStream in, boolean little) {
            try {
                long fp = in.getFilePointer();
                this.offsetWithInts = startingOffset + numIntsPerSection * 4;
                in.skipBytes(this.offsetWithInts + 36);
                this.oDFilter = in.readFloat();
                in.seek(fp + (long)this.offsetWithInts);
                this.photosensorReading = in.readFloat();
                this.timeStampSeconds = in.readFloat();
                this.stageXCoord = in.readFloat();
                this.stageYCoord = in.readFloat();
                this.stageZCoord = in.readFloat();
                this.minInten = in.readFloat();
                this.maxInten = in.readFloat();
                this.meanInten = in.readFloat();
                this.expTime = in.readFloat();
                this.ndFilter = (float)Math.pow(10.0, -this.oDFilter);
                in.skipBytes(4);
                this.exFilter = in.readFloat();
                this.emFilter = in.readFloat();
                this.exWavelen = in.readFloat();
                this.emWavelen = in.readFloat();
                this.intenScaling = in.readFloat();
                this.energyConvFactor = in.readFloat();
            }
            catch (IOException e) {
                LogTools.trace(e);
            }
        }

        public float getPhotosensorReading() {
            return this.photosensorReading;
        }

        public float getTimeStampSeconds() {
            return this.timeStampSeconds;
        }

        public float getStageXCoord() {
            return this.stageXCoord;
        }

        public float getStageYCoord() {
            return this.stageYCoord;
        }

        public float getStageZCoord() {
            return this.stageZCoord;
        }

        public float getMinInten() {
            return this.minInten;
        }

        public float getMaxInten() {
            return this.maxInten;
        }

        public float getMeanInten() {
            return this.meanInten;
        }

        public float getExpTime() {
            return this.expTime;
        }

        public float getNdFilter() {
            return this.ndFilter;
        }

        public float getExFilter() {
            return this.exFilter;
        }

        public float getEmFilter() {
            return this.emFilter;
        }

        public float getExWavelen() {
            return this.exWavelen;
        }

        public float getEmWavelen() {
            return this.emWavelen;
        }

        public float getIntenScaling() {
            return this.intenScaling;
        }
    }
}

