/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.Structure;
import ucar.nc2.ft.point.StructureDataIteratorLinked;

public class StructureDataIteratorIndexed
implements StructureDataIterator {
    private static Logger log = LoggerFactory.getLogger(StructureDataIteratorLinked.class);
    private Structure s;
    private List<Integer> index;
    private Iterator<Integer> indexIter;
    private int currRecord;

    public StructureDataIteratorIndexed(Structure s2, List<Integer> index) throws IOException {
        this.s = s2;
        this.index = index;
        this.reset();
    }

    @Override
    public StructureData next() throws IOException {
        StructureData sdata;
        this.currRecord = this.indexIter.next();
        try {
            sdata = this.s.readStructure(this.currRecord);
        }
        catch (InvalidRangeException e) {
            log.error("StructureDataIteratorIndexed.nextStructureData recno=" + this.currRecord, e);
            throw new IOException(e.getMessage());
        }
        return sdata;
    }

    @Override
    public boolean hasNext() throws IOException {
        return this.indexIter.hasNext();
    }

    @Override
    public StructureDataIterator reset() {
        this.indexIter = this.index.iterator();
        return this;
    }

    @Override
    public void setBufferSize(int bytes) {
    }

    @Override
    public int getCurrentRecno() {
        return this.currRecord;
    }

    @Override
    public void finish() {
    }
}

