/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.utilint.LongAvg;
import com.sleepycat.je.utilint.MapStat;
import com.sleepycat.je.utilint.Stat;
import com.sleepycat.je.utilint.StatDefinition;
import com.sleepycat.je.utilint.StatGroup;
import java.util.Iterator;
import java.util.Map;

public class LongAvgMapStat
extends MapStat<Long, LongAvg> {
    private static final long serialVersionUID = 1L;

    public LongAvgMapStat(StatGroup group, StatDefinition definition) {
        super(group, definition);
        if (definition.getType() != StatDefinition.StatType.INCREMENTAL) {
            throw new IllegalArgumentException("The stat type must be INCREMENTAL, found: " + (Object)((Object)definition.getType()));
        }
    }

    private LongAvgMapStat(LongAvgMapStat other) {
        super(other);
    }

    public synchronized LongAvg createStat(String key) {
        assert (key != null);
        LongAvg stat = new LongAvg();
        this.statMap.put(key, stat);
        return stat;
    }

    @Override
    public LongAvgMapStat copy() {
        return new LongAvgMapStat(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LongAvgMapStat computeInterval(Stat<String> base) {
        LongAvgMapStat result;
        if (!(base instanceof LongAvgMapStat)) {
            throw new IllegalArgumentException("Other stat must be a LongAvgMapStat, found: " + base);
        }
        LongAvgMapStat other = (LongAvgMapStat)base.copy();
        LongAvgMapStat longAvgMapStat = result = this.copy();
        synchronized (longAvgMapStat) {
            LongAvgMapStat longAvgMapStat2 = other;
            synchronized (longAvgMapStat2) {
                Iterator i = result.statMap.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry e = i.next();
                    String key = (String)e.getKey();
                    LongAvg stat = (LongAvg)e.getValue();
                    LongAvg otherStat = (LongAvg)other.statMap.get(key);
                    if (otherStat != null) {
                        stat.updateInterval(otherStat);
                        continue;
                    }
                    i.remove();
                }
            }
        }
        return result;
    }

    @Override
    public synchronized void negate() {
        for (LongAvg avg : this.statMap.values()) {
            avg.negate();
        }
    }
}

