/*
 * Decompiled with CFR 0.152.
 */
package visad.test;

import com.sun.j3d.utils.behaviors.vp.OrbitBehavior;
import com.sun.j3d.utils.behaviors.vp.ViewPlatformBehavior;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Group;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Node;
import javax.media.j3d.PointAttributes;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.QuadArray;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Switch;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import javax.media.j3d.TextureAttributes;
import javax.swing.JFrame;
import javax.vecmath.Point3d;
import visad.util.Util;

public class J3DTextureTest
extends Canvas3D {
    public static final float BACK2D = -0.01f;
    private BranchGroup scene;
    private Switch swit;

    public J3DTextureTest(int size) throws IOException {
        super(SimpleUniverse.getPreferredConfiguration());
        this.createSceneGraph(size);
        SimpleUniverse uverse = new SimpleUniverse((Canvas3D)this);
        ViewingPlatform vp = uverse.getViewingPlatform();
        vp.setNominalViewingTransform();
        OrbitBehavior orbit = new OrbitBehavior(uverse.getCanvas());
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 1.0);
        orbit.setSchedulingBounds((Bounds)bounds);
        vp.setViewPlatformBehavior((ViewPlatformBehavior)orbit);
        uverse.addBranchGraph(this.scene);
        Timer timer = new Timer();
        timer.scheduleAtFixedRate(new TimerTask(){
            int i = 0;

            public void run() {
                int idx;
                if ((idx = this.i++ % 3) < 2) {
                    J3DTextureTest.this.swit.setWhichChild(idx);
                    System.err.println("Switched to child " + idx);
                } else {
                    J3DTextureTest.this.swit.setWhichChild(-1);
                    System.err.println("Switched to NONE");
                }
            }
        }, 0L, 2000L);
    }

    private void setGeometryCapabilities(GeometryArray array) {
        array.setCapability(2);
        array.setCapability(0);
        array.setCapability(8);
        array.setCapability(17);
        array.setCapability(4);
        array.setCapability(6);
    }

    private Appearance makeAppearance(Geometry geometry) {
        Appearance appearance = new Appearance();
        appearance.setCapability(8);
        appearance.setCapability(16);
        appearance.setCapability(0);
        appearance.setCapability(18);
        appearance.setCapability(14);
        appearance.setCapability(12);
        appearance.setCapability(4);
        appearance.setCapability(6);
        appearance.setCapability(2);
        appearance.setCapability(10);
        LineAttributes line = new LineAttributes();
        line.setCapability(4);
        line.setCapability(2);
        line.setCapability(0);
        int pattern = 0;
        line.setLinePattern(pattern);
        appearance.setLineAttributes(line);
        PointAttributes point = new PointAttributes();
        point.setCapability(2);
        point.setCapability(0);
        appearance.setPointAttributes(point);
        PolygonAttributes polygon = new PolygonAttributes();
        polygon.setCapability(0);
        polygon.setCapability(2);
        polygon.setCapability(6);
        polygon.setCapability(4);
        polygon.setCullFace(0);
        appearance.setPolygonAttributes(polygon);
        RenderingAttributes rendering = new RenderingAttributes();
        rendering.setCapability(2);
        rendering.setCapability(0);
        rendering.setCapability(4);
        rendering.setDepthBufferEnable(true);
        appearance.setRenderingAttributes(rendering);
        return appearance;
    }

    private void createSceneGraph(int size) throws IOException {
        this.scene = new BranchGroup();
        this.scene.setCapability(13);
        this.swit = new Switch();
        this.swit.setCapability(17);
        this.swit.setCapability(18);
        this.swit.setCapability(17);
        this.swit.setCapability(12);
        this.swit.setCapability(13);
        this.swit.setCapability(13);
        this.textureToGroup((Group)this.swit, this.makeGeometryArray(), this.makeImage(255, 0, 0, 255, size, size));
        this.textureToGroup((Group)this.swit, this.makeGeometryArray(), this.makeImage(0, 0, 255, 255, size, size));
        this.scene.addChild((Node)this.swit);
        this.scene.compile();
        Util.printSceneGraph((Node)this.scene);
    }

    private GeometryArray makeGeometryArray() {
        float width = 0.5f;
        float height = 0.5f;
        float[] grid = new float[]{-width, -height, 0.0f, width, -height, 0.0f, width, height, 0.0f, -width, height, 0.0f};
        float[] texCoord = new float[]{-width, -height, width, -height, width, height, -width, height};
        QuadArray array = new QuadArray(4, 161);
        this.setGeometryCapabilities((GeometryArray)array);
        array.setCoordRefFloat(grid);
        array.setTexCoordRefFloat(0, texCoord);
        return array;
    }

    private BufferedImage makeImage(int r, int b, int g2, int a, int width, int height) {
        System.err.println(String.format("Image color: RGBA(%s,%s,%s,%s)", r, g2, b, a));
        BufferedImage image = new BufferedImage(width, height, 6);
        int pxl = 0;
        pxl = -16777216;
        pxl += r << 16;
        pxl += g2 << 8;
        pxl += b;
        int[] pxls = new int[image.getWidth() * image.getHeight()];
        for (int i = 0; i < pxls.length; ++i) {
            pxls[i] = pxl;
        }
        image.setRGB(0, 0, image.getWidth(), image.getHeight(), pxls, 0, width);
        return image;
    }

    public void textureToGroup(Group group, GeometryArray geometry, BufferedImage image) {
        Appearance appearance = this.makeAppearance((Geometry)geometry);
        TextureAttributes texture_attributes = new TextureAttributes();
        texture_attributes.setTextureMode(5);
        texture_attributes.setPerspectiveCorrectionMode(1);
        appearance.setTextureAttributes(texture_attributes);
        Texture2D texture = new Texture2D(1, 6, image.getWidth(), image.getHeight());
        System.err.println(String.format("Image width:%s height:%s", image.getWidth(), image.getHeight()));
        System.err.println(String.format("Texture width:%s height:%s", texture.getWidth(), texture.getHeight()));
        System.err.println();
        texture.setCapability(4);
        ImageComponent2D image2d = new ImageComponent2D(2, image);
        image2d.setCapability(2);
        texture.setImage(0, (ImageComponent)image2d);
        texture.setMinFilter(2);
        texture.setMagFilter(2);
        texture.setEnable(true);
        Shape3D shape = new Shape3D((Geometry)geometry, appearance);
        shape.setCapability(12);
        shape.setCapability(14);
        appearance.setTexture((Texture)texture);
        appearance.setCapability(2);
        BranchGroup branch = new BranchGroup();
        branch.setCapability(17);
        branch.setCapability(12);
        branch.addChild((Node)shape);
        if (group.numChildren() > 0) {
            group.insertChild((Node)branch, 0);
        } else {
            group.addChild((Node)branch);
        }
    }

    public static void main(String[] args) throws IOException {
        int size = 0;
        try {
            size = Integer.parseInt(args[0]);
        }
        catch (Exception e) {
            System.err.println("You must provide an image size");
            System.exit(1);
        }
        JFrame frame = new JFrame("Texture Test Canvas");
        frame.setDefaultCloseOperation(3);
        frame.setLayout(new BorderLayout());
        J3DTextureTest canvas = new J3DTextureTest(size);
        Util.printJ3DProperties(canvas);
        frame.add((Component)((Object)canvas));
        frame.setSize(800, 600);
        frame.setVisible(true);
    }
}

