/*
 * Decompiled with CFR 0.152.
 */
package opendap.util;

import java.util.Enumeration;
import opendap.dap.BaseType;
import opendap.dap.DArray;
import opendap.dap.DArrayDimension;
import opendap.dap.DByte;
import opendap.dap.DDS;
import opendap.dap.DFloat32;
import opendap.dap.DFloat64;
import opendap.dap.DGrid;
import opendap.dap.DInt16;
import opendap.dap.DInt32;
import opendap.dap.DSequence;
import opendap.dap.DString;
import opendap.dap.DStructure;
import opendap.dap.DUInt16;
import opendap.dap.DUInt32;
import opendap.dap.DURL;
import opendap.dap.NoSuchVariableException;

public class dasTools {
    public static boolean nameInKillFile(String name) {
        return false;
    }

    public static boolean nameInDDS(String name, DDS dds) {
        boolean found = true;
        try {
            dds.getVariable(name);
        }
        catch (NoSuchVariableException e) {
            found = false;
        }
        return found;
    }

    public static boolean nameIsGlobal(String name) {
        String lcName = name.toLowerCase();
        boolean global = false;
        if (lcName.indexOf("global") >= 0) {
            global = true;
        }
        if (lcName.indexOf("dods") >= 0) {
            global = true;
        }
        return global;
    }

    public static String fancyTypeName(BaseType bt) {
        if (bt instanceof DByte) {
            return "8 bit Byte";
        }
        if (bt instanceof DUInt16) {
            return "16 bit Unsigned Integer";
        }
        if (bt instanceof DInt16) {
            return "16 bit Integer";
        }
        if (bt instanceof DUInt32) {
            return "32 bit Unsigned Integer";
        }
        if (bt instanceof DInt32) {
            return "32 bit Integer";
        }
        if (bt instanceof DFloat32) {
            return "32 bit Real";
        }
        if (bt instanceof DFloat64) {
            return "64 bit Real";
        }
        if (bt instanceof DURL) {
            return "URL";
        }
        if (bt instanceof DString) {
            return "String";
        }
        if (bt instanceof DArray) {
            DArray a = (DArray)bt;
            StringBuilder type = new StringBuilder();
            type.append("Array of ");
            type.append(dasTools.fancyTypeName(a.getPrimitiveVector().getTemplate()));
            type.append("s ");
            Enumeration e = a.getDimensions();
            while (e.hasMoreElements()) {
                DArrayDimension dad = (DArrayDimension)e.nextElement();
                type.append("[");
                type.append(dad.getEncodedName());
                type.append(" = 0..");
                type.append(dad.getSize() - 1);
                type.append("]");
            }
            type.append("\n");
            return type.toString();
        }
        if (bt instanceof DStructure) {
            return "Structure";
        }
        if (bt instanceof DSequence) {
            return "Sequence";
        }
        if (bt instanceof DGrid) {
            return "Grid";
        }
        return "UNKNOWN";
    }
}

