/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import loci.formats.CoreMetadata;
import loci.formats.DataTools;
import loci.formats.FilePattern;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.Location;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;
import loci.formats.TiffTools;
import loci.formats.in.TiffReader;

public class LeicaReader
extends FormatReader {
    private static final int LEICA_MAGIC_TAG = 33923;
    protected Hashtable[] ifds;
    protected Hashtable[] headerIFDs;
    protected TiffReader[][] tiff;
    protected Vector[] files;
    private int numSeries;
    private String leiFilename;
    private int bpp;
    private Vector seriesNames;

    public LeicaReader() {
        super("Leica", new String[]{"lei", "tif", "tiff"});
    }

    public boolean isThisType(byte[] block) {
        if (block.length < 4) {
            return false;
        }
        if (block.length < 8) {
            return block[0] == 73 && block[1] == 73 && block[2] == 73 && block[3] == 73 || block[0] == 77 && block[1] == 77 && block[2] == 77 && block[3] == 77;
        }
        int ifdlocation = DataTools.bytesToInt(block, 4, true);
        if (ifdlocation < 0 || ifdlocation + 1 > block.length) {
            return false;
        }
        int ifdnumber = DataTools.bytesToInt(block, ifdlocation, 2, true);
        for (int i = 0; i < ifdnumber; ++i) {
            if (ifdlocation + 3 + i * 12 > block.length) {
                return false;
            }
            int ifdtag = DataTools.bytesToInt(block, ifdlocation + 2 + i * 12, 2, true);
            if (ifdtag != 33923) continue;
            return true;
        }
        return false;
    }

    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        this.tiff[0][0].setId((String)this.files[0].get(0));
        return this.tiff[0][0].get8BitLookupTable();
    }

    public short[][] get16BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        this.tiff[0][0].setId((String)this.files[0].get(0));
        return this.tiff[0][0].get16BitLookupTable();
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return id.toLowerCase().endsWith(".lei") ? 0 : 1;
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        this.tiff[this.series][no].setId((String)this.files[this.series].get(no));
        return this.tiff[this.series][no].openBytes(0, buf);
    }

    public String[] getUsedFiles() {
        FormatTools.assertId(this.currentId, true, 1);
        Vector<String> v = new Vector<String>();
        v.add(this.leiFilename);
        for (int i = 0; i < this.files.length; ++i) {
            for (int j = 0; j < this.files[i].size(); ++j) {
                v.add((String)this.files[i].get(j));
            }
        }
        return v.toArray(new String[0]);
    }

    public void close(boolean fileOnly) throws IOException {
        if (fileOnly) {
            if (this.in != null) {
                this.in.close();
            }
            if (this.tiff != null) {
                for (int i = 0; i < this.tiff.length; ++i) {
                    if (this.tiff[i] == null) continue;
                    for (int j = 0; j < this.tiff[i].length; ++j) {
                        if (this.tiff[i][j] == null) continue;
                        this.tiff[i][j].close(fileOnly);
                    }
                }
            }
        } else {
            this.close();
        }
    }

    public boolean isThisType(String name, boolean open) {
        block13: {
            String lname = name.toLowerCase();
            if (lname.endsWith(".lei")) {
                return true;
            }
            if (!lname.endsWith(".tif") && !lname.endsWith(".tiff")) {
                return false;
            }
            if (!open) {
                return true;
            }
            if (!this.isGroupFiles()) {
                return false;
            }
            Location file = new Location(name);
            if (!file.exists()) {
                return false;
            }
            long len = file.length();
            if (len < 4L) {
                return false;
            }
            try {
                int ndx;
                RandomAccessStream ras = new RandomAccessStream(name);
                Hashtable ifd = TiffTools.getFirstIFD(ras);
                ras.close();
                if (ifd == null) {
                    return false;
                }
                String descr = (String)ifd.get(new Integer(270));
                int n = ndx = descr == null ? -1 : descr.indexOf("Series Name");
                if (ndx == -1) {
                    return false;
                }
                File f = new File(name).getAbsoluteFile();
                String[] listing = null;
                listing = f.exists() ? f.getParentFile().list() : Location.getIdMap().keySet().toArray(new String[0]);
                for (int i = 0; i < listing.length; ++i) {
                    if (!listing[i].toLowerCase().endsWith(".lei")) continue;
                    return true;
                }
                return false;
            }
            catch (IOException exc) {
                if (debug) {
                    this.trace(exc);
                }
            }
            catch (ClassCastException exc) {
                if (!debug) break block13;
                this.trace(exc);
            }
        }
        return false;
    }

    public void close() throws IOException {
        super.close();
        this.leiFilename = null;
        this.files = null;
        if (this.tiff != null) {
            for (int i = 0; i < this.tiff.length; ++i) {
                if (this.tiff[i] == null) continue;
                for (int j = 0; j < this.tiff[i].length; ++j) {
                    if (this.tiff[i][j] == null) continue;
                    this.tiff[i][j].close();
                }
            }
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (debug) {
            this.debug("LeicaReader.initFile(" + id + ")");
        }
        String idLow = id.toLowerCase();
        this.close();
        if (idLow.endsWith("tif") || idLow.endsWith("tiff")) {
            String lei;
            if (this.ifds == null) {
                super.initFile(id);
            }
            this.in = new RandomAccessStream(id);
            if (this.in.readShort() == 18761) {
                this.in.order(true);
            }
            this.in.seek(0L);
            this.status("Finding companion file name");
            this.ifds = TiffTools.getIFDs(this.in);
            if (this.ifds == null) {
                throw new FormatException("No IFDs found");
            }
            String descr = (String)TiffTools.getIFDValue(this.ifds[0], 270);
            int ndx = descr.indexOf("Series Name");
            if (ndx == -1) {
                throw new FormatException("LEI file not found");
            }
            int newLineNdx = (lei = descr.substring(descr.indexOf("=", ndx) + 1)).indexOf("\n");
            lei = lei.substring(0, newLineNdx == -1 ? lei.length() : newLineNdx);
            lei = lei.trim();
            String dir = id.substring(0, id.lastIndexOf("/") + 1);
            lei = dir + lei;
            while (descr.indexOf("[") != -1) {
                String first = descr.substring(0, descr.indexOf("["));
                String last = descr.substring(descr.indexOf("\n", descr.indexOf("[")));
                descr = first + last;
            }
            int eqIndex = descr.indexOf("=");
            while (eqIndex != -1) {
                String key = descr.substring(0, eqIndex);
                newLineNdx = descr.indexOf("\n", eqIndex);
                if (newLineNdx == -1) {
                    newLineNdx = descr.length();
                }
                String value = descr.substring(eqIndex + 1, newLineNdx);
                this.addMeta(key.trim(), value.trim());
                newLineNdx = descr.indexOf("\n", eqIndex);
                if (newLineNdx == -1) {
                    newLineNdx = descr.length();
                }
                descr = descr.substring(newLineNdx);
                eqIndex = descr.indexOf("=");
            }
            Location l = new Location(lei);
            if (l.getAbsoluteFile().exists()) {
                this.initFile(lei);
            } else {
                l = l.getAbsoluteFile().getParentFile();
                String[] list = l.list();
                for (int i = 0; i < list.length; ++i) {
                    if (!list[i].toLowerCase().endsWith("lei")) continue;
                    this.initFile(list[i]);
                    return;
                }
            }
        } else {
            int i;
            super.initFile(id);
            this.leiFilename = id;
            this.in = new RandomAccessStream(id);
            this.seriesNames = new Vector();
            byte[] fourBytes = new byte[4];
            this.in.read(fourBytes);
            this.core.littleEndian[0] = fourBytes[0] == 73 && fourBytes[1] == 73 && fourBytes[2] == 73 && fourBytes[3] == 73;
            this.in.order(this.core.littleEndian[0]);
            this.status("Reading metadata blocks");
            this.in.skipBytes(8);
            int addr = this.in.readInt();
            Vector v = new Vector();
            while (addr != 0) {
                ++this.numSeries;
                Hashtable<Integer, byte[]> ifd = new Hashtable<Integer, byte[]>();
                v.add(ifd);
                this.in.seek(addr + 4);
                int tag = this.in.readInt();
                while (tag != 0) {
                    int offset = this.in.readInt();
                    long pos = this.in.getFilePointer();
                    this.in.seek(offset + 12);
                    int size = this.in.readInt();
                    byte[] data = new byte[size];
                    this.in.read(data);
                    ifd.put(new Integer(tag), data);
                    this.in.seek(pos);
                    tag = this.in.readInt();
                }
                addr = this.in.readInt();
            }
            if (v.size() < this.numSeries) {
                this.numSeries = v.size();
            }
            this.core = new CoreMetadata(this.numSeries);
            this.headerIFDs = new Hashtable[this.numSeries];
            this.files = new Vector[this.numSeries];
            v.copyInto(this.headerIFDs);
            int nameLength = 0;
            int maxPlanes = 0;
            this.status("Parsing metadata blocks");
            this.core.littleEndian[0] = !this.core.littleEndian[0];
            for (i = 0; i < this.headerIFDs.length; ++i) {
                if (this.headerIFDs[i].get(new Integer(10)) != null) {
                    byte[] temp = (byte[])this.headerIFDs[i].get(new Integer(10));
                    nameLength = DataTools.bytesToInt(temp, 8, 4, this.core.littleEndian[0]);
                }
                Vector<String> f = new Vector<String>();
                byte[] tempData = (byte[])this.headerIFDs[i].get(new Integer(15));
                int tempImages = DataTools.bytesToInt(tempData, 0, 4, this.core.littleEndian[0]);
                File dirFile = new File(id).getAbsoluteFile();
                Object[] listing = null;
                String dirPrefix = "";
                if (dirFile.exists()) {
                    listing = dirFile.getParentFile().list();
                    dirPrefix = dirFile.getParent();
                } else {
                    listing = Location.getIdMap().keySet().toArray(new String[0]);
                }
                Vector<String> list = new Vector<String>();
                for (int k = 0; k < listing.length; ++k) {
                    if (!listing[k].toLowerCase().endsWith(".tif") && !listing[k].toLowerCase().endsWith(".tiff")) continue;
                    list.add(listing[k]);
                }
                listing = list.toArray(new String[0]);
                boolean tiffsExist = true;
                String prefix = "";
                for (int j = 0; j < tempImages; ++j) {
                    prefix = DataTools.stripString(new String(tempData, 20 + 2 * (j * nameLength), 2 * nameLength));
                    f.add(dirPrefix + File.separator + prefix);
                    Location test = new Location((String)f.get(f.size() - 1));
                    if (tiffsExist) {
                        tiffsExist = test.exists();
                    }
                    int firstUnderscore = prefix.indexOf("_") + 1;
                    int secondUnderscore = prefix.indexOf("_", firstUnderscore);
                    String name = null;
                    if (firstUnderscore < 0 || secondUnderscore < 0) {
                        name = prefix;
                    } else {
                        String s2 = prefix.substring(firstUnderscore, secondUnderscore);
                        if (this.seriesNames.contains(s2)) {
                            int suffix = 2;
                            do {
                                name = s2 + "-" + suffix;
                                ++suffix;
                            } while (this.seriesNames.contains(name));
                        } else {
                            name = s2;
                        }
                    }
                    this.seriesNames.add(name);
                }
                if (!tiffsExist) {
                    this.status("Handling renamed TIFF files");
                    Hashtable<Object, String> leiMapping = new Hashtable<Object, String>();
                    int numLeis = 0;
                    for (int j = 0; j < listing.length; ++j) {
                        RandomAccessStream ras = new RandomAccessStream(new Location(dirPrefix, listing[j]).getAbsolutePath());
                        Hashtable ifd = TiffTools.getFirstIFD(ras);
                        ras.close();
                        String descr = (String)ifd.get(new Integer(270));
                        int ndx = descr.indexOf("=", descr.indexOf("Series Name"));
                        String leiFile = descr.substring(ndx + 1, descr.indexOf("\n", ndx));
                        leiFile = leiFile.trim();
                        if (!leiMapping.contains(leiFile)) {
                            ++numLeis;
                        }
                        leiMapping.put(listing[j], leiFile);
                    }
                    f.clear();
                    String[] keys = leiMapping.keySet().toArray(new String[0]);
                    for (int j = 0; j < keys.length; ++j) {
                        String lei = (String)leiMapping.get(keys[j]);
                        if (!DataTools.samePrefix(lei, prefix)) continue;
                        f.add(keys[j]);
                    }
                    String[] usedFiles = null;
                    for (int j = 0; j < f.size(); ++j) {
                        if (usedFiles != null) {
                            for (int k = 0; k < usedFiles.length; ++k) {
                                if (!usedFiles[k].equals((String)f.get(j)) && !this.usedFile((String)f.get(j))) continue;
                                k = 0;
                                ++j;
                            }
                        }
                        if (j >= f.size()) break;
                        FilePattern fp = new FilePattern(new Location((String)f.get(j)));
                        if (fp != null) {
                            usedFiles = fp.getFiles();
                        }
                        if (usedFiles == null || usedFiles.length != tempImages) continue;
                        this.files[i] = new Vector();
                        for (int k = 0; k < usedFiles.length; ++k) {
                            this.files[i].add(new Location(usedFiles[k]).getAbsolutePath());
                        }
                        break;
                    }
                    if (this.files[i] == null || this.files[i].size() == 0) {
                        this.files[i] = new Vector();
                        Hashtable<String, Object> h2 = new Hashtable<String, Object>();
                        for (int j = 0; j < listing.length; ++j) {
                            RandomAccessStream ras = new RandomAccessStream(new Location(dirPrefix, (String)listing[j]).getAbsolutePath());
                            Hashtable fd = TiffTools.getFirstIFD(ras);
                            String stamp = (String)TiffTools.getIFDValue(fd, 306);
                            if (h2.size() == tempImages) {
                                Object[] ks = h2.keySet().toArray(new String[0]);
                                Arrays.sort(ks);
                                for (int k = 0; k < ks.length; ++k) {
                                    this.files[i].add(new Location(dirPrefix, (String)h2.get(ks[k])).getAbsolutePath());
                                }
                                h2.clear();
                                break;
                            }
                            if (!h2.contains(stamp)) {
                                h2.put(stamp, listing[j]);
                            } else {
                                h2.clear();
                                h2.put(stamp, listing[j]);
                            }
                            ras.close();
                        }
                        if (h2.size() == tempImages) {
                            Object[] ks = h2.keySet().toArray(new String[0]);
                            Arrays.sort(ks);
                            for (int k = 0; k < ks.length; ++k) {
                                this.files[i].add(new Location(dirPrefix, (String)h2.get(ks[k])).getAbsolutePath());
                            }
                        }
                    }
                    if (this.files[i] == null || this.files[i].size() == 0) {
                        int j;
                        if (debug) {
                            this.debug("File ordering is not obvious.");
                        }
                        this.files[i] = new Vector();
                        Arrays.sort(listing);
                        int ndx = 0;
                        for (j = 0; j < i; ++j) {
                            ndx += this.files[j].size();
                        }
                        for (j = ndx; j < ndx + tempImages; ++j) {
                            this.files[i].add(new Location(dirPrefix, (String)listing[j]).getAbsolutePath());
                        }
                    }
                } else {
                    this.files[i] = f;
                }
                this.core.imageCount[i] = this.files[i].size();
                if (this.core.imageCount[i] <= maxPlanes) continue;
                maxPlanes = this.core.imageCount[i];
            }
            this.tiff = new TiffReader[this.numSeries][maxPlanes];
            for (i = 0; i < this.tiff.length; ++i) {
                for (int j = 0; j < this.tiff[i].length; ++j) {
                    this.tiff[i][j] = new TiffReader();
                    if (j <= 0) continue;
                    this.tiff[i][j].setMetadataCollected(false);
                }
            }
            this.status("Populating metadata");
            this.initMetadata();
        }
    }

    protected void initMetadata() throws FormatException, IOException {
        int i;
        if (this.headerIFDs == null) {
            this.headerIFDs = this.ifds;
        }
        for (int i2 = 0; i2 < this.headerIFDs.length; ++i2) {
            int v;
            int j;
            byte[] temp = (byte[])this.headerIFDs[i2].get(new Integer(10));
            if (temp != null) {
                this.addMeta("Version", new Integer(DataTools.bytesToInt(temp, 0, 4, this.core.littleEndian[0])));
                this.addMeta("Number of Series", new Integer(DataTools.bytesToInt(temp, 4, 4, this.core.littleEndian[0])));
                this.addMeta("Length of filename", new Integer(DataTools.bytesToInt(temp, 8, 4, this.core.littleEndian[0])));
                Integer fileExtLen = new Integer(DataTools.bytesToInt(temp, 12, 4, this.core.littleEndian[0]));
                this.addMeta("Length of file extension", fileExtLen);
                this.addMeta("Image file extension", DataTools.stripString(new String(temp, 16, (int)fileExtLen)));
            }
            if ((temp = (byte[])this.headerIFDs[i2].get(new Integer(15))) != null) {
                this.core.sizeZ[i2] = DataTools.bytesToInt(temp, 0, 4, this.core.littleEndian[0]);
                this.core.sizeX[i2] = DataTools.bytesToInt(temp, 4, 4, this.core.littleEndian[0]);
                this.core.sizeY[i2] = DataTools.bytesToInt(temp, 8, 4, this.core.littleEndian[0]);
                this.addMeta("Number of images", new Integer(this.core.sizeZ[i2]));
                this.addMeta("Image width", new Integer(this.core.sizeX[i2]));
                this.addMeta("Image height", new Integer(this.core.sizeY[i2]));
                this.addMeta("Bits per Sample", new Integer(DataTools.bytesToInt(temp, 12, 4, this.core.littleEndian[0])));
                this.addMeta("Samples per pixel", new Integer(DataTools.bytesToInt(temp, 16, 4, this.core.littleEndian[0])));
            }
            if ((temp = (byte[])this.headerIFDs[i2].get(new Integer(20))) != null) {
                int pt = 0;
                this.addMeta("Voxel Version", new Integer(DataTools.bytesToInt(temp, 0, 4, this.core.littleEndian[0])));
                int voxelType = DataTools.bytesToInt(temp, 4, 4, this.core.littleEndian[0]);
                String type = "";
                switch (voxelType) {
                    case 0: {
                        type = "undefined";
                        break;
                    }
                    case 10: {
                        type = "gray normal";
                        break;
                    }
                    case 20: {
                        type = "RGB";
                    }
                }
                this.addMeta("VoxelType", type);
                this.bpp = DataTools.bytesToInt(temp, 8, 4, this.core.littleEndian[0]);
                this.addMeta("Bytes per pixel", new Integer(this.bpp));
                this.addMeta("Real world resolution", new Integer(DataTools.bytesToInt(temp, 12, 4, this.core.littleEndian[0])));
                int length = DataTools.bytesToInt(temp, 16, 4, this.core.littleEndian[0]);
                this.addMeta("Maximum voxel intensity", DataTools.stripString(new String(temp, 20, length)));
                pt = 20 + length;
                this.addMeta("Minimum voxel intensity", DataTools.stripString(new String(temp, pt += 4, length)));
                pt += length;
                length = DataTools.bytesToInt(temp, pt, 4, this.core.littleEndian[0]);
                pt += 4 + length + 4;
                length = DataTools.bytesToInt(temp, pt, 4, this.core.littleEndian[0]);
                for (j = 0; j < length; ++j) {
                    int dimId = DataTools.bytesToInt(temp, pt, 4, this.core.littleEndian[0]);
                    String dimType = "";
                    switch (dimId) {
                        case 0: {
                            dimType = "undefined";
                            break;
                        }
                        case 120: {
                            dimType = "x";
                            break;
                        }
                        case 121: {
                            dimType = "y";
                            break;
                        }
                        case 122: {
                            dimType = "z";
                            break;
                        }
                        case 116: {
                            dimType = "t";
                            break;
                        }
                        case 6815843: {
                            dimType = "channel";
                            break;
                        }
                        case 6357100: {
                            dimType = "wave length";
                            break;
                        }
                        case 7602290: {
                            dimType = "rotation";
                            break;
                        }
                        case 0x770078: {
                            dimType = "x-wide for the motorized xy-stage";
                            break;
                        }
                        case 0x770079: {
                            dimType = "y-wide for the motorized xy-stage";
                            break;
                        }
                        case 0x77007A: {
                            dimType = "z-wide for the z-stage-drive";
                            break;
                        }
                        case 4259957: {
                            dimType = "user1 - unspecified";
                            break;
                        }
                        case 4325493: {
                            dimType = "user2 - unspecified";
                            break;
                        }
                        case 4391029: {
                            dimType = "user3 - unspecified";
                            break;
                        }
                        case 6357095: {
                            dimType = "graylevel";
                            break;
                        }
                        case 6422631: {
                            dimType = "graylevel1";
                            break;
                        }
                        case 6488167: {
                            dimType = "graylevel2";
                            break;
                        }
                        case 6553703: {
                            dimType = "graylevel3";
                            break;
                        }
                        case 7864398: {
                            dimType = "logical x";
                            break;
                        }
                        case 7929934: {
                            dimType = "logical y";
                            break;
                        }
                        case 7995470: {
                            dimType = "logical z";
                            break;
                        }
                        case 7602254: {
                            dimType = "logical t";
                            break;
                        }
                        case 7077966: {
                            dimType = "logical lambda";
                            break;
                        }
                        case 7471182: {
                            dimType = "logical rotation";
                            break;
                        }
                        case 5767246: {
                            dimType = "logical x-wide";
                            break;
                        }
                        case 5832782: {
                            dimType = "logical y-wide";
                            break;
                        }
                        case 5898318: {
                            dimType = "logical z-wide";
                        }
                    }
                    this.addMeta("Dim" + j + " type", dimType);
                    this.addMeta("Dim" + j + " size", new Integer(DataTools.bytesToInt(temp, pt += 4, 4, this.core.littleEndian[0])));
                    int dist = DataTools.bytesToInt(temp, pt += 4, 4, this.core.littleEndian[0]);
                    this.addMeta("Dim" + j + " distance between sub-dimensions", new Integer(dist));
                    int len = DataTools.bytesToInt(temp, pt += 4, 4, this.core.littleEndian[0]);
                    this.addMeta("Dim" + j + " physical length", DataTools.stripString(new String(temp, pt += 4, len)));
                    pt += len;
                    len = DataTools.bytesToInt(temp, pt, 4, this.core.littleEndian[0]);
                    this.addMeta("Dim" + j + " physical origin", DataTools.stripString(new String(temp, pt += 4, len)));
                    pt += len;
                    len = DataTools.bytesToInt(temp, pt, 4, this.core.littleEndian[0]);
                    this.addMeta("Dim" + j + " name", DataTools.stripString(new String(temp, pt += 4, len)));
                    pt += len;
                    len = DataTools.bytesToInt(temp, pt, 4, this.core.littleEndian[0]);
                    this.addMeta("Dim" + j + " description", DataTools.stripString(new String(temp, pt += 4, len)));
                }
            }
            if ((temp = (byte[])this.headerIFDs[i2].get(new Integer(30))) != null) {
                // empty if block
            }
            if ((temp = (byte[])this.headerIFDs[i2].get(new Integer(40))) != null) {
                int nDims = DataTools.bytesToInt(temp, 0, 4, this.core.littleEndian[0]);
                this.addMeta("Number of time-stamped dimensions", new Integer(nDims));
                this.addMeta("Time-stamped dimension", new Integer(DataTools.bytesToInt(temp, 4, 4, this.core.littleEndian[0])));
                int pt = 8;
                for (int j2 = 0; j2 < nDims; ++j2) {
                    v = DataTools.bytesToInt(temp, pt, 4, this.core.littleEndian[0]);
                    this.addMeta("Dimension " + j2 + " ID", new Integer(v));
                    v = DataTools.bytesToInt(temp, pt += 4, 4, this.core.littleEndian[0]);
                    this.addMeta("Dimension " + j2 + " size", new Integer(v));
                    v = DataTools.bytesToInt(temp, pt += 4, 4, this.core.littleEndian[0]);
                    this.addMeta("Dimension " + j2 + " distance between dimensions", new Integer(v));
                    pt += 4;
                }
                int numStamps = DataTools.bytesToInt(temp, pt, 4, this.core.littleEndian[0]);
                pt += 4;
                this.addMeta("Number of time-stamps", new Integer(numStamps));
                for (int j3 = 0; j3 < numStamps; ++j3) {
                    this.addMeta("Timestamp " + j3, DataTools.stripString(new String(temp, pt, 64)));
                    pt += 64;
                }
                int numTMs = DataTools.bytesToInt(temp, pt, 4, this.core.littleEndian[0]);
                pt += 4;
                this.addMeta("Number of time-markers", new Integer(numTMs));
                for (j = 0; j < numTMs; ++j) {
                    int numDims = DataTools.bytesToInt(temp, pt, 4, this.core.littleEndian[0]);
                    pt += 4;
                    for (int k = 0; k < numDims; ++k) {
                        int v2 = DataTools.bytesToInt(temp, pt, 4, this.core.littleEndian[0]);
                        this.addMeta("Time-marker " + j + " Dimension " + k + " coordinate", new Integer(v2));
                        pt += 4;
                    }
                    this.addMeta("Time-marker " + j, DataTools.stripString(new String(temp, pt, 64)));
                    pt += 64;
                }
            }
            if ((temp = (byte[])this.headerIFDs[i2].get(new Integer(50))) != null) {
                // empty if block
            }
            if ((temp = (byte[])this.headerIFDs[i2].get(new Integer(60))) != null) {
                int pt = 8;
                int len = DataTools.bytesToInt(temp, pt, 4, this.core.littleEndian[0]);
                this.addMeta("Image Description", DataTools.stripString(new String(temp, pt += 4, 2 * len)));
                pt += 2 * len;
                len = DataTools.bytesToInt(temp, pt, 4, this.core.littleEndian[0]);
                this.addMeta("Main file extension", DataTools.stripString(new String(temp, pt += 4, 2 * len)));
                pt += 2 * len;
                len = DataTools.bytesToInt(temp, pt, 4, this.core.littleEndian[0]);
                this.addMeta("Single image format identifier", DataTools.stripString(new String(temp, pt += 4, 2 * len)));
                pt += 2 * len;
                len = DataTools.bytesToInt(temp, pt, 4, this.core.littleEndian[0]);
                this.addMeta("Single image extension", DataTools.stripString(new String(temp, pt += 4, 2 * len)));
            }
            if ((temp = (byte[])this.headerIFDs[i2].get(new Integer(70))) == null) continue;
            int pt = 0;
            int nChannels = DataTools.bytesToInt(temp, pt, 4, this.core.littleEndian[0]);
            this.addMeta("Number of LUT channels", new Integer(nChannels));
            this.addMeta("ID of colored dimension", new Integer(DataTools.bytesToInt(temp, pt += 4, 4, this.core.littleEndian[0])));
            pt += 4;
            if (nChannels > 4) {
                nChannels = 3;
            }
            this.core.sizeC[i2] = nChannels;
            for (int j4 = 0; j4 < nChannels; ++j4) {
                v = DataTools.bytesToInt(temp, pt, 4, this.core.littleEndian[0]);
                this.addMeta("LUT Channel " + j4 + " version", new Integer(v));
                int invert = DataTools.bytesToInt(temp, pt += 4, 1, this.core.littleEndian[0]);
                boolean inverted = invert == 1;
                this.addMeta("LUT Channel " + j4 + " inverted?", new Boolean(inverted).toString());
                int length = DataTools.bytesToInt(temp, ++pt, 4, this.core.littleEndian[0]);
                this.addMeta("LUT Channel " + j4 + " description", DataTools.stripString(new String(temp, pt += 4, length)));
                pt += length;
                length = DataTools.bytesToInt(temp, pt, 4, this.core.littleEndian[0]);
                this.addMeta("LUT Channel " + j4 + " filename", DataTools.stripString(new String(temp, pt += 4, length)));
                pt += length;
                length = DataTools.bytesToInt(temp, pt, 4, this.core.littleEndian[0]);
                String name = DataTools.stripString(new String(temp, pt += 4, length));
                this.addMeta("LUT Channel " + j4 + " name", name);
                pt += length;
                pt += 8;
            }
        }
        Arrays.fill(this.core.orderCertain, true);
        if (this.core.sizeC != null) {
            int oldSeries = this.getSeries();
            for (int i3 = 0; i3 < this.core.sizeC.length; ++i3) {
                this.setSeries(i3);
                int n = i3;
                this.core.sizeZ[n] = this.core.sizeZ[n] / this.core.sizeC[i3];
            }
            this.setSeries(oldSeries);
        }
        Integer v = (Integer)this.getMeta("Real world resolution");
        MetadataStore store = this.getMetadataStore();
        byte[] f = new byte[4];
        for (i = 0; i < this.numSeries; ++i) {
            this.core.orderCertain[i] = true;
            this.core.interleaved[i] = true;
            this.in.seek(0L);
            this.in.read(f);
            boolean bl = this.core.littleEndian[i] = f[0] == 73 && f[1] == 73 && f[2] == 73 && f[3] == 73;
            if (this.core.sizeC[i] == 0) {
                this.core.sizeC[i] = 1;
            }
            int n = i;
            this.core.sizeT[n] = this.core.sizeT[n] + 1;
            String string = this.core.currentOrder[i] = this.core.sizeC[i] == 1 ? "XYZTC" : "XYCZT";
            if (this.core.sizeZ[i] == 0) {
                this.core.sizeZ[i] = 1;
            }
            switch (this.bpp) {
                case 1: {
                    this.core.pixelType[i] = 1;
                    break;
                }
                case 2: {
                    this.core.pixelType[i] = 3;
                    break;
                }
                case 3: {
                    this.core.pixelType[i] = 1;
                    break;
                }
                case 4: {
                    this.core.pixelType[i] = 4;
                    break;
                }
                case 6: {
                    this.core.pixelType[i] = 2;
                    break;
                }
                case 8: {
                    this.core.pixelType[i] = 7;
                }
            }
            this.core.rgb[i] = this.core.imageCount[i] != this.core.sizeC[i] * this.core.sizeZ[i] * this.core.sizeT[i];
            Integer ii = new Integer(i);
            this.core.rgb[i] = false;
            this.core.indexed[i] = true;
            this.core.falseColor[i] = true;
            this.core.metadataComplete[i] = true;
            String timestamp = (String)this.getMeta("Timestamp " + (i + 1));
            String description = (String)this.getMeta("Image Description");
            if (timestamp != null) {
                SimpleDateFormat parse = new SimpleDateFormat("yyyy:MM:dd,HH:mm:ss:SSS");
                Date date = parse.parse(timestamp, new ParsePosition(0));
                SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                timestamp = fmt.format(date);
            }
            store.setImage((String)this.seriesNames.get(i), timestamp, description, ii);
        }
        FormatTools.populatePixels(store, this);
        for (i = 0; i < this.core.sizeC.length; ++i) {
            for (int j = 0; j < this.core.sizeC[i]; ++j) {
                store.setLogicalChannel(j, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, new Integer(i));
            }
        }
    }

    private boolean usedFile(String s2) {
        if (this.files == null) {
            return false;
        }
        for (int i = 0; i < this.files.length; ++i) {
            if (this.files[i] == null) continue;
            for (int j = 0; j < this.files[i].size(); ++j) {
                if (!((String)this.files[i].get(j)).endsWith(s2)) continue;
                return true;
            }
        }
        return false;
    }
}

