/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.utilint;

import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.rep.RepInternal;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.ReplicationConfig;
import com.sleepycat.je.utilint.CmdUtil;
import java.io.File;

public class DbRepRunAction {
    private static final String USAGE = "usage: " + CmdUtil.getJavaCommand(DbRepRunAction.class) + "\n" + "       -h <dir> # environment home directory\n" + "       -group <name> # groupName\n" + "       -name <name> # nodeName\n" + "       -host <host> # nodeHost\n";
    private File envHome;
    private String nodeName;
    private String nodeHost;
    private String groupName;

    public static void main(String[] argv) {
        DbRepRunAction runAction = new DbRepRunAction();
        runAction.parseArgs(argv);
        try {
            runAction.run();
            System.exit(0);
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }

    private void parseArgs(String[] argv) {
        int argc = 0;
        int nArgs = argv.length;
        if (nArgs < 4) {
            this.printUsage(null);
            System.exit(0);
        }
        while (argc < nArgs) {
            String thisArg;
            if ((thisArg = argv[argc++]).equals("-h")) {
                if (argc < nArgs) {
                    this.envHome = new File(argv[argc++]);
                    continue;
                }
                this.printUsage("-h requires an argument");
                continue;
            }
            if (thisArg.equals("-name")) {
                if (argc < nArgs) {
                    this.nodeName = argv[argc++];
                    continue;
                }
                this.printUsage("-name requires an argument");
                continue;
            }
            if (thisArg.equals("-host")) {
                if (argc < nArgs) {
                    this.nodeHost = argv[argc++];
                    continue;
                }
                this.printUsage("-host requires an argument");
                continue;
            }
            if (thisArg.equals("-group")) {
                if (argc < nArgs) {
                    this.groupName = argv[argc++];
                    continue;
                }
                this.printUsage("-group requires an argument");
                continue;
            }
            this.printUsage(thisArg + " is not a valid argument");
        }
    }

    private void run() {
        ReplicatedEnvironment repEnv = this.recover();
        repEnv.close();
    }

    private ReplicatedEnvironment recover() {
        ReplicationConfig repConfig = new ReplicationConfig();
        repConfig.setNodeName(this.nodeName);
        repConfig.setGroupName(this.groupName);
        repConfig.setNodeHostPort(this.nodeHost);
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setTransactional(true);
        return RepInternal.createDetachedEnv(this.envHome, repConfig, envConfig);
    }

    private void printUsage(String msg) {
        if (msg != null) {
            System.out.println(msg);
        }
        System.out.println(USAGE);
        System.exit(-1);
    }
}

