/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;

public class PropUtil {
    public static int durationToMillis(long val, TimeUnit unit) {
        if (val == 0L) {
            return 0;
        }
        if (unit == null) {
            throw new IllegalArgumentException("Duration TimeUnit argument may not be null if interval is non-zero");
        }
        if (val < 0L) {
            throw new IllegalArgumentException("Duration argument may not be negative: " + val);
        }
        long newVal = unit.toMillis(val);
        if (newVal == 0L) {
            return 1;
        }
        if (newVal > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Duration argument may not be greater than Integer.MAX_VALUE milliseconds: " + newVal);
        }
        return (int)newVal;
    }

    public static long millisToDuration(int val, TimeUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("TimeUnit argument may not be null");
        }
        return unit.convert(val, TimeUnit.MILLISECONDS);
    }

    public static int parseDuration(String property) {
        long millis;
        long time;
        StringTokenizer tokens = new StringTokenizer(property.toUpperCase(), " \t");
        if (!tokens.hasMoreTokens()) {
            throw new IllegalArgumentException("Duration argument is empty");
        }
        try {
            time = Long.parseLong(tokens.nextToken());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Duration argument does not start with a long integer: " + property);
        }
        if (tokens.hasMoreTokens()) {
            String unitName = tokens.nextToken();
            if (tokens.hasMoreTokens()) {
                throw new IllegalArgumentException("Duration argument has extra characters after unit: " + property);
            }
            try {
                TimeUnit unit = TimeUnit.valueOf(unitName);
                millis = TimeUnit.MILLISECONDS.convert(time, unit);
            }
            catch (IllegalArgumentException e) {
                try {
                    IEEETimeUnit unit = IEEETimeUnit.valueOf(unitName);
                    millis = unit.toMillis(time);
                }
                catch (IllegalArgumentException e2) {
                    throw new IllegalArgumentException("Duration argument has unknown unit name: " + property);
                }
            }
        } else {
            millis = TimeUnit.MILLISECONDS.convert(time, TimeUnit.MICROSECONDS);
        }
        if (time > 0L && millis == 0L) {
            return 1;
        }
        if (millis > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Duration argument may not be greater than Integer.MAX_VALUE milliseconds: " + property);
        }
        return (int)millis;
    }

    public static String formatDuration(long time, TimeUnit unit) {
        return String.valueOf(time) + ' ' + unit.name();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum IEEETimeUnit {
        NS{

            long toMillis(long val) {
                return millisUnit.convert(val, TimeUnit.NANOSECONDS);
            }
        }
        ,
        US{

            long toMillis(long val) {
                return millisUnit.convert(val, TimeUnit.MICROSECONDS);
            }
        }
        ,
        MS{

            long toMillis(long val) {
                return millisUnit.convert(val, TimeUnit.MILLISECONDS);
            }
        }
        ,
        S{

            long toMillis(long val) {
                return millisUnit.convert(val, TimeUnit.SECONDS);
            }
        }
        ,
        MIN{

            long toMillis(long val) {
                return val * 60000L;
            }
        }
        ,
        H{

            long toMillis(long val) {
                return val * 3600000L;
            }
        };

        private static final TimeUnit millisUnit;

        abstract long toMillis(long var1);

        static {
            millisUnit = TimeUnit.MILLISECONDS;
        }
    }
}

