/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.ArraySequence;
import ucar.ma2.ArrayStructure;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataA;
import ucar.ma2.StructureMembers;
import ucar.nc2.constants.CDM;
import ucar.nc2.util.Indent;

public class ArrayStructureBB
extends ArrayStructure {
    protected ByteBuffer bbuffer;
    protected int bb_offset = 0;
    private List<Object> heap;

    public static int setOffsets(StructureMembers members) {
        int offset = 0;
        for (StructureMembers.Member m3 : members.getMembers()) {
            m3.setDataParam(offset);
            offset += m3.getSizeBytes();
            if (m3.getStructureMembers() == null) continue;
            ArrayStructureBB.setOffsets(m3.getStructureMembers());
        }
        members.setStructureSize(offset);
        return offset;
    }

    public static int showOffsets(StructureMembers members, Indent indent, Formatter f) {
        int offset = 0;
        for (StructureMembers.Member m3 : members.getMembers()) {
            f.format("%s%s offset=%d (%d %s = %d bytes)%n", new Object[]{indent, m3.getName(), m3.getDataParam(), m3.getSize(), m3.getDataType(), m3.getSizeBytes()});
            if (m3.getStructureMembers() == null) continue;
            indent.incr();
            StructureMembers nested = m3.getStructureMembers();
            f.format("%n%s%s == %d bytes%n", indent, nested.getName(), nested.getStructureSize());
            ArrayStructureBB.showOffsets(nested, indent, f);
            indent.decr();
        }
        return offset;
    }

    public ArrayStructureBB(StructureMembers members, int[] shape) {
        super(members, shape);
        this.bbuffer = ByteBuffer.allocate(this.nelems * this.getStructureSize());
        this.bbuffer.order(ByteOrder.BIG_ENDIAN);
    }

    public ArrayStructureBB(StructureMembers members, int[] shape, ByteBuffer bbuffer, int offset) {
        super(members, shape);
        this.bbuffer = bbuffer;
        this.bb_offset = offset;
    }

    @Override
    protected StructureData makeStructureData(ArrayStructure as, int index) {
        return new StructureDataA(as, index);
    }

    public ByteBuffer getByteBuffer() {
        return this.bbuffer;
    }

    @Override
    public double getScalarDouble(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType() != DataType.DOUBLE) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be double");
        }
        if (m3.getDataArray() != null) {
            return super.getScalarDouble(recnum, m3);
        }
        int offset = this.calcOffsetSetOrder(recnum, m3);
        return this.bbuffer.getDouble(offset);
    }

    @Override
    public double[] getJavaArrayDouble(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType() != DataType.DOUBLE) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be double");
        }
        if (m3.getDataArray() != null) {
            return super.getJavaArrayDouble(recnum, m3);
        }
        int offset = this.calcOffsetSetOrder(recnum, m3);
        int count = m3.getSize();
        double[] pa = new double[count];
        for (int i = 0; i < count; ++i) {
            pa[i] = this.bbuffer.getDouble(offset + i * 8);
        }
        return pa;
    }

    @Override
    protected void copyDoubles(int recnum, StructureMembers.Member m3, IndexIterator result) {
        int offset = this.calcOffsetSetOrder(recnum, m3);
        int count = m3.getSize();
        for (int i = 0; i < count; ++i) {
            result.setDoubleNext(this.bbuffer.getDouble(offset + i * 8));
        }
    }

    @Override
    public float getScalarFloat(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType() != DataType.FLOAT) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be float");
        }
        if (m3.getDataArray() != null) {
            return super.getScalarFloat(recnum, m3);
        }
        int offset = this.calcOffsetSetOrder(recnum, m3);
        return this.bbuffer.getFloat(offset);
    }

    @Override
    public Array getArray(int recnum, StructureMembers.Member m3) {
        if (m3.isVariableLength()) {
            int offset = this.calcOffsetSetOrder(recnum, m3);
            int heapIndex = this.bbuffer.getInt(offset);
            return (Array)this.heap.get(heapIndex);
        }
        return super.getArray(recnum, m3);
    }

    @Override
    public float[] getJavaArrayFloat(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType() != DataType.FLOAT) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be float");
        }
        if (m3.getDataArray() != null) {
            return super.getJavaArrayFloat(recnum, m3);
        }
        int offset = this.calcOffsetSetOrder(recnum, m3);
        int count = m3.getSize();
        float[] pa = new float[count];
        for (int i = 0; i < count; ++i) {
            pa[i] = this.bbuffer.getFloat(offset + i * 4);
        }
        return pa;
    }

    @Override
    protected void copyFloats(int recnum, StructureMembers.Member m3, IndexIterator result) {
        int offset = this.calcOffsetSetOrder(recnum, m3);
        int count = m3.getSize();
        for (int i = 0; i < count; ++i) {
            result.setFloatNext(this.bbuffer.getFloat(offset + i * 4));
        }
    }

    @Override
    public byte getScalarByte(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType().getPrimitiveClassType() != Byte.TYPE) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be byte");
        }
        if (m3.getDataArray() != null) {
            return super.getScalarByte(recnum, m3);
        }
        int offset = this.calcOffsetSetOrder(recnum, m3);
        return this.bbuffer.get(offset);
    }

    @Override
    public byte[] getJavaArrayByte(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType().getPrimitiveClassType() != Byte.TYPE) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be byte");
        }
        if (m3.getDataArray() != null) {
            return super.getJavaArrayByte(recnum, m3);
        }
        int offset = this.calcOffsetSetOrder(recnum, m3);
        int count = m3.getSize();
        byte[] pa = new byte[count];
        for (int i = 0; i < count; ++i) {
            pa[i] = this.bbuffer.get(offset + i);
        }
        return pa;
    }

    @Override
    protected void copyBytes(int recnum, StructureMembers.Member m3, IndexIterator result) {
        int offset = this.calcOffsetSetOrder(recnum, m3);
        int count = m3.getSize();
        for (int i = 0; i < count; ++i) {
            result.setByteNext(this.bbuffer.get(offset + i));
        }
    }

    @Override
    public short getScalarShort(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType().getPrimitiveClassType() != Short.TYPE) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be short");
        }
        if (m3.getDataArray() != null) {
            return super.getScalarShort(recnum, m3);
        }
        int offset = this.calcOffsetSetOrder(recnum, m3);
        return this.bbuffer.getShort(offset);
    }

    @Override
    public short[] getJavaArrayShort(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType().getPrimitiveClassType() != Short.TYPE) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be short");
        }
        if (m3.getDataArray() != null) {
            return super.getJavaArrayShort(recnum, m3);
        }
        int offset = this.calcOffsetSetOrder(recnum, m3);
        int count = m3.getSize();
        short[] pa = new short[count];
        for (int i = 0; i < count; ++i) {
            pa[i] = this.bbuffer.getShort(offset + i * 2);
        }
        return pa;
    }

    @Override
    protected void copyShorts(int recnum, StructureMembers.Member m3, IndexIterator result) {
        int offset = this.calcOffsetSetOrder(recnum, m3);
        int count = m3.getSize();
        for (int i = 0; i < count; ++i) {
            result.setShortNext(this.bbuffer.getShort(offset + i * 2));
        }
    }

    @Override
    public int getScalarInt(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType().getPrimitiveClassType() != Integer.TYPE) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be int");
        }
        if (m3.getDataArray() != null) {
            return super.getScalarInt(recnum, m3);
        }
        int offset = this.calcOffsetSetOrder(recnum, m3);
        return this.bbuffer.getInt(offset);
    }

    @Override
    public int[] getJavaArrayInt(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType().getPrimitiveClassType() != Integer.TYPE) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be int");
        }
        if (m3.getDataArray() != null) {
            return super.getJavaArrayInt(recnum, m3);
        }
        int offset = this.calcOffsetSetOrder(recnum, m3);
        int count = m3.getSize();
        int[] pa = new int[count];
        for (int i = 0; i < count; ++i) {
            pa[i] = this.bbuffer.getInt(offset + i * 4);
        }
        return pa;
    }

    @Override
    protected void copyInts(int recnum, StructureMembers.Member m3, IndexIterator result) {
        int offset = this.calcOffsetSetOrder(recnum, m3);
        int count = m3.getSize();
        for (int i = 0; i < count; ++i) {
            result.setIntNext(this.bbuffer.getInt(offset + i * 4));
        }
    }

    @Override
    public long getScalarLong(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType().getPrimitiveClassType() != Long.TYPE) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be long");
        }
        if (m3.getDataArray() != null) {
            return super.getScalarLong(recnum, m3);
        }
        int offset = this.calcOffsetSetOrder(recnum, m3);
        return this.bbuffer.getLong(offset);
    }

    @Override
    public long[] getJavaArrayLong(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType().getPrimitiveClassType() != Long.TYPE) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be long");
        }
        if (m3.getDataArray() != null) {
            return super.getJavaArrayLong(recnum, m3);
        }
        int offset = this.calcOffsetSetOrder(recnum, m3);
        int count = m3.getSize();
        long[] pa = new long[count];
        for (int i = 0; i < count; ++i) {
            pa[i] = this.bbuffer.getLong(offset + i * 8);
        }
        return pa;
    }

    @Override
    protected void copyLongs(int recnum, StructureMembers.Member m3, IndexIterator result) {
        int offset = this.calcOffsetSetOrder(recnum, m3);
        int count = m3.getSize();
        for (int i = 0; i < count; ++i) {
            result.setLongNext(this.bbuffer.getLong(offset + i * 8));
        }
    }

    @Override
    public char getScalarChar(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType() != DataType.CHAR) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be char");
        }
        if (m3.getDataArray() != null) {
            return super.getScalarChar(recnum, m3);
        }
        int offset = this.calcOffsetSetOrder(recnum, m3);
        return (char)this.bbuffer.get(offset);
    }

    @Override
    public char[] getJavaArrayChar(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType() != DataType.CHAR) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be char");
        }
        if (m3.getDataArray() != null) {
            return super.getJavaArrayChar(recnum, m3);
        }
        int offset = this.calcOffsetSetOrder(recnum, m3);
        int count = m3.getSize();
        char[] pa = new char[count];
        for (int i = 0; i < count; ++i) {
            pa[i] = (char)this.bbuffer.get(offset + i);
        }
        return pa;
    }

    @Override
    protected void copyChars(int recnum, StructureMembers.Member m3, IndexIterator result) {
        int offset = this.calcOffsetSetOrder(recnum, m3);
        int count = m3.getSize();
        for (int i = 0; i < count; ++i) {
            result.setByteNext(this.bbuffer.get(offset + i));
        }
    }

    @Override
    public String getScalarString(int recnum, StructureMembers.Member m3) {
        if (m3.getDataArray() != null) {
            return super.getScalarString(recnum, m3);
        }
        if (m3.getDataType() == DataType.STRING) {
            int offset = this.calcOffsetSetOrder(recnum, m3);
            int index = this.bbuffer.getInt(offset);
            Object data = this.heap.get(index);
            if (data instanceof String) {
                return (String)data;
            }
            return ((String[])data)[0];
        }
        if (m3.getDataType() == DataType.CHAR) {
            int i;
            int offset = this.calcOffsetSetOrder(recnum, m3);
            int count = m3.getSize();
            byte[] pa = new byte[count];
            for (i = 0; i < count; ++i) {
                pa[i] = this.bbuffer.get(offset + i);
                if (0 == pa[i]) break;
            }
            return new String(pa, 0, i, CDM.utf8Charset);
        }
        throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be String or char");
    }

    @Override
    public String[] getJavaArrayString(int recnum, StructureMembers.Member m3) {
        if (m3.getDataArray() != null) {
            return super.getJavaArrayString(recnum, m3);
        }
        if (m3.getDataType() == DataType.STRING) {
            int offset = this.calcOffsetSetOrder(recnum, m3);
            int heapIndex = this.bbuffer.getInt(offset);
            Object ho = this.heap.get(heapIndex);
            if (ho instanceof String[]) {
                return (String[])ho;
            }
            if (ho instanceof String) {
                String[] result = new String[]{(String)ho};
                return result;
            }
            throw new IllegalArgumentException("Expected a String, but found an object of type  " + ho.getClass().getName() + ", on heap for  member " + m3.getName());
        }
        if (m3.getDataType() == DataType.CHAR) {
            int[] shape = m3.getShape();
            int rank = shape.length;
            if (rank < 2) {
                String[] result = new String[]{this.getScalarString(recnum, m3)};
                return result;
            }
            int strlen = shape[rank - 1];
            int n = m3.getSize() / strlen;
            int offset = this.calcOffsetSetOrder(recnum, m3);
            String[] result = new String[n];
            for (int i = 0; i < n; ++i) {
                byte[] bytes = new byte[strlen];
                for (int j = 0; j < bytes.length; ++j) {
                    bytes[j] = this.bbuffer.get(offset + i * strlen + j);
                }
                result[i] = new String(bytes, CDM.utf8Charset);
            }
            return result;
        }
        throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be char");
    }

    @Override
    protected void copyObjects(int recnum, StructureMembers.Member m3, IndexIterator result) {
        int offset = this.calcOffsetSetOrder(recnum, m3);
        int count = m3.getSize();
        int index = this.bbuffer.getInt(offset);
        String[] data = (String[])this.heap.get(index);
        for (int i = 0; i < count; ++i) {
            result.setObjectNext(data[i]);
        }
    }

    @Override
    public StructureData getScalarStructure(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType() != DataType.STRUCTURE) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be Structure");
        }
        if (m3.getDataArray() != null) {
            return super.getScalarStructure(recnum, m3);
        }
        int offset = this.calcOffsetSetOrder(recnum, m3);
        ArrayStructureBB subset = new ArrayStructureBB(m3.getStructureMembers(), new int[]{1}, this.bbuffer, offset);
        return new StructureDataA(subset, 0);
    }

    @Override
    public ArrayStructure getArrayStructure(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType() != DataType.STRUCTURE) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be Structure");
        }
        if (m3.getDataArray() != null) {
            return super.getArrayStructure(recnum, m3);
        }
        int offset = this.calcOffsetSetOrder(recnum, m3);
        ArrayStructureBB result = new ArrayStructureBB(m3.getStructureMembers(), m3.getShape(), this.bbuffer, offset);
        result.heap = this.heap;
        return result;
    }

    @Override
    public ArraySequence getArraySequence(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType() != DataType.SEQUENCE) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be Sequence");
        }
        int offset = this.calcOffsetSetOrder(recnum, m3);
        int index = this.bbuffer.getInt(offset);
        if (this.heap == null) {
            System.out.println("ArrayStructureBB null heap");
            return null;
        }
        Object ho = this.heap.get(index);
        if (ho instanceof ArraySequence) {
            return (ArraySequence)this.heap.get(index);
        }
        return null;
    }

    protected int calcOffsetSetOrder(int recnum, StructureMembers.Member m3) {
        if (null != m3.getDataObject()) {
            this.bbuffer.order((ByteOrder)m3.getDataObject());
        }
        return this.bb_offset + recnum * this.getStructureSize() + m3.getDataParam();
    }

    public int addObjectToHeap(Object s2) {
        if (null == this.heap) {
            this.heap = new ArrayList<Object>();
        }
        this.heap.add(s2);
        return this.heap.size() - 1;
    }

    public void addObjectToHeap(int recnum, StructureMembers.Member m3, Object s2) {
        if (null == this.heap) {
            this.heap = new ArrayList<Object>();
        }
        this.heap.add(s2);
        int index = this.heap.size() - 1;
        this.bbuffer.putInt(this.calcOffsetSetOrder(recnum, m3), index);
    }

    public List<Object> getHeap() {
        return this.heap;
    }

    @Override
    public void showInternal(Formatter f, Indent indent) {
        super.showInternal(f, indent);
        f.format("%sByteBuffer = %s (hash=0x%x)%n", indent, this.bbuffer, this.bbuffer.hashCode());
        if (null != this.heap) {
            f.format("%s  Heap Objects%n", indent);
            for (int i = 0; i < this.heap.size(); ++i) {
                Object o = this.heap.get(i);
                f.format("%s   %d class=%s hash=0x%x = %s%n", indent, i, o.getClass().getName(), o.hashCode(), o);
                if (!(o instanceof ArrayStructure)) continue;
                ((ArrayStructure)o).showInternal(f, indent.incr());
                indent.decr();
            }
            f.format("%n", new Object[0]);
        }
    }

    public static void main(String[] argv) {
        byte[] ba = new byte[20];
        for (int i = 0; i < ba.length; ++i) {
            ba[i] = (byte)i;
        }
        ByteBuffer bbw = ByteBuffer.wrap(ba, 5, 15);
        bbw.get(0);
        System.out.println(" bbw(0)=" + bbw.get(0) + " i would expect = 5");
        bbw.position(5);
        System.out.println(" bbw(0)=" + bbw.get(0) + " i would expect = 4");
    }
}

