/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib1.tables;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.concurrent.Immutable;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.constants.CDM;
import ucar.nc2.grib.GribResourceReader;
import ucar.nc2.grib.grib1.Grib1Parameter;
import ucar.nc2.grib.grib1.Grib1Record;
import ucar.nc2.grib.grib1.Grib1SectionProductDefinition;
import ucar.nc2.grib.grib1.tables.Grib1ParamTableReader;

@Immutable
public class Grib1ParamTables {
    private static final Logger logger = LoggerFactory.getLogger(Grib1ParamTables.class);
    private static final Object lock = new Object();
    private static int standardTablesStart = 0;
    private static Lookup standardLookup;
    private static Grib1ParamTableReader defaultTable;
    private static boolean strict;
    private static final Map<String, Grib1ParamTableReader> localTableHash;
    private final Lookup lookup;
    private final Grib1ParamTableReader override;

    public static boolean isStrict() {
        return strict;
    }

    public static void setStrict(boolean strict) {
        Grib1ParamTables.strict = strict;
    }

    public static Grib1ParamTableReader getDefaultTable() {
        return defaultTable;
    }

    public static int makeKey(int center, int subcenter, int version) {
        if (center < 0) {
            center = 255;
        }
        if (subcenter < 0) {
            subcenter = 255;
        }
        if (version < 0) {
            version = 255;
        }
        return center * 1000 * 1000 + subcenter * 1000 + version;
    }

    public static Grib1ParamTables factory(String paramTablePath, String lookupTablePath) throws IOException {
        Grib1ParamTableReader table;
        if (paramTablePath == null && lookupTablePath == null) {
            return new Grib1ParamTables();
        }
        Lookup lookup = null;
        Grib1ParamTableReader override = null;
        if (paramTablePath != null && (table = localTableHash.get(paramTablePath)) == null) {
            table = new Grib1ParamTableReader(paramTablePath);
            localTableHash.put(paramTablePath, table);
            override = table;
        }
        if (lookupTablePath != null && !(lookup = new Lookup()).readLookupTable(lookupTablePath)) {
            throw new FileNotFoundException("cant read lookup table=" + lookupTablePath);
        }
        return new Grib1ParamTables(lookup, override);
    }

    public static Grib1ParamTables factory(Element paramTableElem) throws IOException {
        if (paramTableElem == null) {
            return new Grib1ParamTables();
        }
        return new Grib1ParamTables(null, new Grib1ParamTableReader(paramTableElem));
    }

    public Grib1ParamTables() {
        this.lookup = null;
        this.override = null;
    }

    public Grib1ParamTables(Lookup lookup, Grib1ParamTableReader override) {
        this.lookup = lookup;
        this.override = override;
    }

    public Grib1Parameter getParameter(Grib1Record record) {
        Grib1SectionProductDefinition pds = record.getPDSsection();
        return this.getParameter(pds.getCenter(), pds.getSubCenter(), pds.getTableVersion(), pds.getParameterNumber());
    }

    public Grib1Parameter getParameter(int center, int subcenter, int tableVersion, int param_number) {
        Grib1Parameter param = null;
        if (this.override != null) {
            param = this.override.getParameter(param_number);
        }
        if (param == null && this.lookup != null) {
            param = this.lookup.getParameter(center, subcenter, tableVersion, param_number);
        }
        if (param == null) {
            param = standardLookup.getParameter(center, subcenter, tableVersion, param_number);
        }
        return param;
    }

    public Grib1ParamTableReader getParameterTable(int center, int subcenter, int tableVersion) {
        Grib1ParamTableReader result = null;
        if (this.lookup != null) {
            result = this.lookup.getParameterTable(center, subcenter, tableVersion);
        }
        if (result == null) {
            result = standardLookup.getParameterTable(center, subcenter, tableVersion);
        }
        return result;
    }

    public static List<Grib1ParamTableReader> getStandardParameterTables() {
        return Grib1ParamTables.standardLookup.tables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addParameterTableLookup(String lookupFilename) throws IOException {
        Lookup lookup = new Lookup();
        if (!lookup.readLookupTable(lookupFilename)) {
            return false;
        }
        Object object = lock;
        synchronized (object) {
            Grib1ParamTables.standardLookup.tables.addAll(standardTablesStart, lookup.tables);
            standardTablesStart += lookup.tables.size();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addParameterTable(int center, int subcenter, int tableVersion, String tableFilename) {
        Grib1ParamTableReader table = new Grib1ParamTableReader(center, subcenter, tableVersion, tableFilename);
        Object object = lock;
        synchronized (object) {
            Grib1ParamTables.standardLookup.tables.add(standardTablesStart, table);
            ++standardTablesStart;
        }
    }

    static {
        try {
            standardLookup = new Lookup();
            standardLookup.readLookupTable("resources/grib1/lookupTables.txt");
            standardLookup.readLookupTable("resources/grib1/ecmwfGribApi/lookupTables.txt");
            standardLookup.readLookupTable("resources/grib1/ecmwf/lookupTables.txt");
            standardLookup.readLookupTable("resources/grib1/ncl/lookupTables.txt");
            standardLookup.readLookupTable("resources/grib1/dss/lookupTables.txt");
            standardLookup.readLookupTable("resources/grib1/wrf/lookupTables.txt");
            Grib1ParamTables.standardLookup.tables = new CopyOnWriteArrayList<Grib1ParamTableReader>(Grib1ParamTables.standardLookup.tables);
            defaultTable = standardLookup.getParameterTable(0, -1, -1);
        }
        catch (Throwable t) {
            logger.warn("Grib1ParamTables init failed: ", t);
        }
        strict = false;
        localTableHash = new ConcurrentHashMap<String, Grib1ParamTableReader>();
    }

    public static class Lookup {
        List<Grib1ParamTableReader> tables = new ArrayList<Grib1ParamTableReader>();
        Map<Integer, Grib1ParamTableReader> tableMap = new ConcurrentHashMap<Integer, Grib1ParamTableReader>();

        public boolean readLookupTable(String resourceName) throws IOException {
            try (InputStream inputStream = GribResourceReader.getInputStream(resourceName);){
                if (inputStream == null) {
                    logger.warn("Could not open table file:" + resourceName);
                    boolean bl = false;
                    return bl;
                }
                boolean bl = this.readLookupTable(inputStream, resourceName);
                return bl;
            }
        }

        private boolean readLookupTable(InputStream is, String lookupFile) throws IOException {
            String line;
            if (is == null) {
                return false;
            }
            File parent = new File(lookupFile).getParentFile();
            InputStreamReader isr = new InputStreamReader(is, CDM.utf8Charset);
            BufferedReader br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                String path;
                if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                String[] tableDefArr = line.split(":");
                int center = Integer.parseInt(tableDefArr[0].trim());
                int subcenter = Integer.parseInt(tableDefArr[1].trim());
                int version = Integer.parseInt(tableDefArr[2].trim());
                String filename = tableDefArr[3].trim();
                if (filename.startsWith("/") || filename.startsWith("\\") || filename.startsWith("file:") || filename.startsWith("http://")) {
                    path = filename;
                } else {
                    File tableFile = new File(parent, filename);
                    path = tableFile.getPath();
                }
                Grib1ParamTableReader table = new Grib1ParamTableReader(center, subcenter, version, path);
                this.tables.add(table);
            }
            return true;
        }

        public Grib1Parameter getParameter(int center, int subcenter, int tableVersion, int param_number) {
            if (strict && param_number < 128 && tableVersion < 128) {
                return defaultTable.getParameter(param_number);
            }
            Grib1ParamTableReader pt = this.getParameterTable(center, subcenter, tableVersion);
            Grib1Parameter param = null;
            if (pt != null) {
                param = pt.getParameter(param_number);
            }
            if (!strict && param == null) {
                param = defaultTable.getParameter(param_number);
            }
            return param;
        }

        public Grib1ParamTableReader getParameterTable(int center, int subcenter, int tableVersion) {
            int key = Grib1ParamTables.makeKey(center, subcenter, tableVersion);
            Grib1ParamTableReader table = this.tableMap.get(key);
            if (table != null) {
                return table;
            }
            table = this.findParameterTableExact(center, subcenter, tableVersion);
            if (table == null) {
                table = this.findParameterTable(center, subcenter, tableVersion);
            }
            if (table == null) {
                if (strict || defaultTable == null) {
                    logger.warn("Could not find a table for GRIB file with center: " + center + " subCenter: " + subcenter + " version: " + tableVersion);
                    throw new UnsupportedOperationException("Could not find a table for GRIB file with center: " + center + " subCenter: " + subcenter + " version: " + tableVersion);
                }
                return defaultTable;
            }
            this.tableMap.put(key, table);
            return table;
        }

        private Grib1ParamTableReader findParameterTableExact(int center, int subcenter, int version) {
            List<Grib1ParamTableReader> localCopy = this.tables;
            for (Grib1ParamTableReader table : localCopy) {
                if (center != table.getCenter_id() || subcenter != table.getSubcenter_id() || version != table.getVersion() || table.getParameters() == null) continue;
                for (Grib1ParamTableReader table2 : localCopy) {
                    if (!table2.getPath().equals(table.getPath())) continue;
                    table2.setParameters(table.getParameters());
                }
                return table;
            }
            return null;
        }

        private Grib1ParamTableReader findParameterTable(int center, int subcenter, int version) {
            List<Grib1ParamTableReader> localCopy = this.tables;
            for (Grib1ParamTableReader table : localCopy) {
                if (center != table.getCenter_id() || table.getSubcenter_id() != -1 && subcenter != table.getSubcenter_id() || table.getVersion() != -1 && version != table.getVersion() || table.getParameters() == null) continue;
                for (Grib1ParamTableReader table2 : localCopy) {
                    if (!table2.getPath().equals(table.getPath())) continue;
                    table2.setParameters(table.getParameters());
                }
                return table;
            }
            return null;
        }
    }
}

