/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep;

import com.sleepycat.je.ReplicaConsistencyPolicy;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.RepConfigProxy;
import com.sleepycat.je.rep.NodeType;
import com.sleepycat.je.rep.ReplicationMutableConfig;
import com.sleepycat.je.rep.impl.RepParams;
import com.sleepycat.je.rep.utilint.HostPortPair;
import com.sleepycat.je.rep.utilint.RepUtils;
import java.net.InetSocketAddress;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicationConfig
extends ReplicationMutableConfig
implements RepConfigProxy {
    public static final String GROUP_NAME = "je.rep.groupName";
    public static final String NODE_NAME = "je.rep.nodeName";
    public static final String NODE_TYPE = "je.rep.nodeType";
    public static final String HELPER_HOSTS = "je.rep.helperHosts";
    public static final String DEFAULT_PORT = "je.rep.defaultPort";
    public static final String NODE_HOST_PORT = "je.rep.nodeHostPort";
    public static final String CONSISTENCY_POLICY = "je.rep.consistencyPolicy";
    public static final String REP_STREAM_TIMEOUT = "je.rep.repStreamTimeout";
    public static final String REPLAY_TXN_LOCK_TIMEOUT = "je.rep.replayTxnLockTimeout";
    public static final String ENV_CONSISTENCY_TIMEOUT = "je.rep.envConsistencyTimeout";
    public static final String REPLICA_ACK_TIMEOUT = "je.rep.replicaAckTimeout";
    public static final String INSUFFICIENT_REPLICAS_TIMEOUT = "je.rep.insufficientReplicasTimeout";
    public static final String MAX_MESSAGE_SIZE = "je.rep.maxMessageSize";
    public static final String MAX_CLOCK_DELTA = "je.rep.maxClockDelta";
    public static final String ELECTIONS_PRIMARY_RETRIES = "je.rep.electionsPrimaryRetries";
    public static final String TXN_ROLLBACK_LIMIT = "je.rep.txnRollbackLimit";
    public static final ReplicationConfig DEFAULT = new ReplicationConfig();
    private boolean allowConvert = false;

    public ReplicationConfig() {
    }

    public ReplicationConfig(String groupName, String nodeName, String hostPort) {
        this.setGroupName(groupName);
        this.setNodeName(nodeName);
        this.setNodeHostPort(hostPort);
    }

    public ReplicationConfig(Properties properties) throws IllegalArgumentException {
        super(properties, true);
    }

    ReplicationConfig(Properties properties, boolean validateParams) throws IllegalArgumentException {
        super(properties, validateParams);
    }

    public String getGroupName() {
        return DbConfigManager.getVal(this.props, RepParams.GROUP_NAME);
    }

    public ReplicationConfig setGroupName(String groupName) throws IllegalArgumentException {
        DbConfigManager.setVal(this.props, RepParams.GROUP_NAME, groupName, this.validateParams);
        return this;
    }

    boolean getAllowConvert() {
        return this.allowConvert;
    }

    void setAllowConvert(boolean allowConvert) {
        this.allowConvert = allowConvert;
    }

    public String getNodeName() {
        return DbConfigManager.getVal(this.props, RepParams.NODE_NAME);
    }

    public ReplicationConfig setNodeName(String nodeName) throws IllegalArgumentException {
        DbConfigManager.setVal(this.props, RepParams.NODE_NAME, nodeName, this.validateParams);
        return this;
    }

    public NodeType getNodeType() {
        return RepParams.NODE_TYPE.getEnumerator(DbConfigManager.getVal(this.props, RepParams.NODE_TYPE));
    }

    public ReplicationConfig setNodeType(NodeType nodeType) {
        DbConfigManager.setVal(this.props, RepParams.NODE_TYPE, nodeType.name(), this.validateParams);
        return this;
    }

    public String getNodeHostPort() {
        return DbConfigManager.getVal(this.props, RepParams.NODE_HOST_PORT);
    }

    public ReplicationConfig setNodeHostPort(String hostPort) {
        DbConfigManager.setVal(this.props, RepParams.NODE_HOST_PORT, hostPort, this.validateParams);
        return this;
    }

    public long getReplicaAckTimeout(TimeUnit unit) {
        return DbConfigManager.getDurationVal(this.props, RepParams.REPLICA_ACK_TIMEOUT, unit);
    }

    public ReplicationConfig setReplicaAckTimeout(long replicaCommitTimeout, TimeUnit unit) {
        DbConfigManager.setDurationVal(this.props, RepParams.REPLICA_ACK_TIMEOUT, replicaCommitTimeout, unit, this.validateParams);
        return this;
    }

    public long getMaxClockDelta(TimeUnit unit) {
        return DbConfigManager.getDurationVal(this.props, RepParams.MAX_CLOCK_DELTA, unit);
    }

    public ReplicationConfig setMaxClockDelta(long maxClockDelta, TimeUnit unit) throws IllegalArgumentException {
        DbConfigManager.setDurationVal(this.props, RepParams.MAX_CLOCK_DELTA, maxClockDelta, unit, this.validateParams);
        return this;
    }

    public String getHelperHosts() {
        return DbConfigManager.getVal(this.props, RepParams.HELPER_HOSTS);
    }

    public ReplicationConfig setHelperHosts(String hostsAndPorts) {
        DbConfigManager.setVal(this.props, RepParams.HELPER_HOSTS, hostsAndPorts, this.validateParams);
        return this;
    }

    public ReplicationConfig setConsistencyPolicy(ReplicaConsistencyPolicy policy) {
        DbConfigManager.setVal(this.props, RepParams.CONSISTENCY_POLICY, RepUtils.getPropertyString(policy), this.validateParams);
        return this;
    }

    @Override
    public ReplicaConsistencyPolicy getConsistencyPolicy() {
        String propertyValue = DbConfigManager.getVal(this.props, RepParams.CONSISTENCY_POLICY);
        return RepUtils.getReplicaConsistencyPolicy(propertyValue);
    }

    @Override
    public ReplicationConfig setConfigParam(String paramName, String value) throws IllegalArgumentException {
        DbConfigManager.setConfigParam(this.props, paramName, value, false, this.validateParams, true, true);
        return this;
    }

    @Override
    public ReplicationConfig clone() {
        try {
            return (ReplicationConfig)super.clone();
        }
        catch (CloneNotSupportedException willNeverOccur) {
            return null;
        }
    }

    public Set<InetSocketAddress> getHelperSockets() {
        return HostPortPair.getSockets(this.getHelperHosts());
    }

    public InetSocketAddress getNodeSocketAddress() {
        return new InetSocketAddress(this.getNodeHostname(), this.getNodePort());
    }

    public String getNodeHostname() {
        String hostAndPort = DbConfigManager.getVal(this.props, RepParams.NODE_HOST_PORT);
        int colonToken = hostAndPort.indexOf(":");
        return colonToken >= 0 ? hostAndPort.substring(0, colonToken) : hostAndPort;
    }

    public int getNodePort() {
        String hostAndPort = DbConfigManager.getVal(this.props, RepParams.NODE_HOST_PORT);
        int colonToken = hostAndPort.indexOf(":");
        String portString = colonToken >= 0 ? hostAndPort.substring(colonToken + 1) : DbConfigManager.getVal(this.props, RepParams.DEFAULT_PORT);
        return Integer.parseInt(portString);
    }

    public void verify() throws IllegalArgumentException {
        if (this.getGroupName() == null || "".equals(this.getGroupName())) {
            throw new IllegalArgumentException("Missing group name");
        }
        if (this.getNodeName() == null || "".equals(this.getNodeName())) {
            throw new IllegalArgumentException("Missing node name");
        }
        if (this.getNodeHostPort() == null || "".equals(this.getNodeHostPort())) {
            throw new IllegalArgumentException("Missing node host");
        }
    }
}

