/*
 * Decompiled with CFR 0.152.
 */
package visad.sounder;

import java.rmi.RemoteException;
import java.util.Vector;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayImpl;
import visad.DisplayRealType;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded1DSet;
import visad.MathType;
import visad.RealType;
import visad.ScalarMap;
import visad.ScalarType;
import visad.SetException;
import visad.Unit;
import visad.VisADException;
import visad.data.netcdf.StandardQuantityDB;
import visad.data.netcdf.units.DefaultUnitsDB;
import visad.data.netcdf.units.UnitsDB;
import visad.java3d.DirectManipulationRendererJ3D;

public class Spectrum
extends FlatField {
    private static UnitsDB udb;
    private static StandardQuantityDB qdb;
    private static RealType Wavelength;
    private static RealType Radiance;
    private static FunctionType spectrumType;
    private Vector spectrumDisplay_s = new Vector();
    DataReferenceImpl spectrum_ref;
    Unit domain_unit;
    Unit range_unit;

    public Spectrum(float[] wavelength_domain, Unit domain_unit, float[] radiance_range, Unit range_unit) throws VisADException, RemoteException {
        super(spectrumType, Spectrum.makeSet(wavelength_domain));
        int length = this.getLength();
        if (radiance_range == null) {
            radiance_range = new float[length];
            for (int i = 0; i < length; ++i) {
                radiance_range[i] = Float.NaN;
            }
        } else if (radiance_range.length != length) {
            throw new VisADException("radiance_range should have same length as wavelenghts");
        }
        this.setSamples(new float[][]{radiance_range});
        this.domain_unit = domain_unit;
        this.range_unit = range_unit;
        this.spectrum_ref = new DataReferenceImpl("Spectrum reference");
        this.spectrum_ref.setData(this);
    }

    private static Gridded1DSet makeSet(float[] wavelength_domain) throws VisADException {
        if (wavelength_domain == null) {
            throw new SetException("wavelengths cannot be null");
        }
        return new Gridded1DSet((MathType)Wavelength, (float[][])new float[][]{wavelength_domain}, wavelength_domain.length, null, new Unit[]{udb.get("Radiance")}, null);
    }

    public void addToDisplay(DisplayImpl display) throws VisADException, RemoteException {
        this.addToDisplay(display, null);
    }

    public void addToDisplayWithDirectManipulation(DisplayImpl display) throws VisADException, RemoteException {
        this.addToDisplay(display, new DirectManipulationRendererJ3D());
    }

    private void addToDisplay(DisplayImpl display, DataRenderer renderer) throws VisADException, RemoteException {
        if (this.spectrumDisplay_s.contains(display)) {
            return;
        }
        this.spectrumDisplay_s.add(display);
        Vector mapVector = display.getMapVector();
        boolean radianceToYAxis = false;
        boolean wavelengthToXAxis = false;
        for (int kk = 0; kk < mapVector.size(); ++kk) {
            ScalarMap smap = (ScalarMap)mapVector.elementAt(kk);
            ScalarType s_type = smap.getScalar();
            DisplayRealType d_type = smap.getDisplayScalar();
            if (Radiance.equals(smap) && d_type.equals(Display.YAxis)) {
                radianceToYAxis = true;
            }
            if (!Wavelength.equals(smap) || !d_type.equals(Display.XAxis)) continue;
            wavelengthToXAxis = true;
        }
        if (radianceToYAxis && wavelengthToXAxis) {
            display.removeAllReferences();
            display.addReferences(renderer, this.spectrum_ref);
        } else {
            display.removeAllReferences();
            display.clearMaps();
            display.addMap(new ScalarMap(Radiance, Display.YAxis));
            display.addMap(new ScalarMap(Wavelength, Display.XAxis));
            display.addReferences(renderer, this.spectrum_ref);
        }
    }

    public void remove() throws VisADException, RemoteException {
        for (int kk = 0; kk < this.spectrumDisplay_s.size(); ++kk) {
            DisplayImpl display = (DisplayImpl)this.spectrumDisplay_s.elementAt(kk);
            display.removeReference(this.spectrum_ref);
        }
        this.spectrumDisplay_s.removeAllElements();
    }

    public boolean restore() {
        return false;
    }

    public static void main(String[] args) {
    }

    static {
        try {
            udb = DefaultUnitsDB.instance();
            qdb = StandardQuantityDB.instance();
            Wavelength = qdb.get("Wavelength");
            Radiance = qdb.get("Radiance");
            spectrumType = new FunctionType(Wavelength, Radiance);
        }
        catch (VisADException e) {
            e.printStackTrace();
        }
    }
}

