/*
 * Decompiled with CFR 0.152.
 */
package thredds.client.catalog.tools;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterDescription;
import com.beust.jcommander.ParameterException;
import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Formatter;
import java.util.List;
import java.util.Random;
import thredds.client.catalog.Access;
import thredds.client.catalog.Catalog;
import thredds.client.catalog.CatalogRef;
import thredds.client.catalog.Dataset;
import thredds.client.catalog.Service;
import thredds.client.catalog.ServiceType;
import thredds.client.catalog.builder.CatalogBuilder;
import thredds.client.catalog.tools.DataFactory;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.NCdumpW;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft2.coverage.Coverage;
import ucar.nc2.ft2.coverage.CoverageCollection;
import ucar.nc2.ft2.coverage.FeatureDatasetCoverage;
import ucar.nc2.ft2.coverage.GeoReferencedArray;
import ucar.nc2.ft2.coverage.SubsetParams;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.Indent;
import ucar.nc2.util.Misc;

public class CatalogCrawler {
    private final Type type;
    private final int max;
    private final Filter filter;
    private final Listener listen;
    private final CancelTask task;
    private final PrintWriter out;
    private final Object context;
    private Random random;
    private int countCatrefs = 0;
    private int numReadFailures = 0;

    public CatalogCrawler(Type type, int max, Filter filter, Listener listen, CancelTask task, PrintWriter out, Object context) {
        this.type = type == null ? Type.all : type;
        this.max = max;
        this.filter = filter;
        this.listen = listen;
        this.task = task;
        this.out = out;
        this.context = context;
        if (type == Type.random_direct || type == Type.random_direct_middle || type == Type.random_direct_max) {
            this.random = new Random(System.currentTimeMillis());
        }
    }

    public int crawl(String catUrl) throws IOException {
        boolean isValid;
        CatalogBuilder catFactory = new CatalogBuilder();
        Catalog cat = catFactory.buildFromLocation(catUrl, null);
        boolean bl = isValid = !catFactory.hasFatalError();
        if (this.out != null) {
            this.out.println("Catalog <" + catUrl + "> " + (isValid ? "read ok" : "is not valid"));
            if (!isValid) {
                this.out.println(" validation output=\n" + catFactory.getErrorMessage());
            }
        }
        this.countCatrefs = 0;
        if (isValid) {
            return this.crawl(cat);
        }
        System.err.printf("%s%n", catFactory.getErrorMessage());
        return 0;
    }

    public int crawl(Catalog cat) throws IOException {
        this.countCatrefs = 0;
        this.crawl(cat, 0, new Indent(2));
        return 1 + this.countCatrefs;
    }

    private int crawl(Catalog cat, int level, Indent indent) throws IOException {
        for (Dataset ds : cat.getDatasetsLocal()) {
            this.crawlDataset(ds, level, indent);
            if (this.task == null || !this.task.isCancel()) continue;
            break;
        }
        return 1 + this.countCatrefs;
    }

    private void crawlDataset(Dataset ds, int level, Indent indent) throws IOException {
        if (this.filter != null && this.filter.skipAll(ds)) {
            return;
        }
        if (ds instanceof CatalogRef) {
            CatalogRef catref = (CatalogRef)ds;
            if (this.filter != null && this.filter.skipCatref(catref, level + 1)) {
                return;
            }
            if (this.out != null) {
                this.out.printf("%n%sCatalogRef %s (%s)%n", indent, catref.getURI(), ds.getName());
            }
            ++this.countCatrefs;
            Catalog cat = this.readCatref(catref, this.out, indent);
            if (cat == null) {
                ++this.numReadFailures;
                return;
            }
            this.crawl(cat, level + 1, indent.incr());
            indent.decr();
            return;
        }
        if (this.filter != null && this.filter.skipAll(ds)) {
            return;
        }
        if (level == 0 && (this.type == Type.all || ds.hasAccess())) {
            this.listen.getDataset(ds, this.context);
        }
        if (this.type == Type.all) {
            for (Dataset dds : ds.getDatasetsLocal()) {
                if (!(dds instanceof CatalogRef)) {
                    this.listen.getDataset(dds, this.context);
                }
                this.crawlDataset(dds, level, indent.incr());
                indent.decr();
                if (this.task == null || !this.task.isCancel()) continue;
                break;
            }
        } else {
            List<Dataset> dlist = ds.getDatasetsLocal();
            ArrayList<Dataset> leaves = new ArrayList<Dataset>();
            for (Dataset dds : dlist) {
                if (!dds.hasAccess()) continue;
                leaves.add(dds);
            }
            if (leaves.size() > 0) {
                if (this.type == Type.first_direct) {
                    Dataset dds = (Dataset)leaves.get(0);
                    this.listen.getDataset(dds, this.context);
                } else if (this.type == Type.random_direct) {
                    this.listen.getDataset(this.chooseRandom(leaves), this.context);
                } else if (this.type == Type.random_direct_middle) {
                    this.listen.getDataset(this.chooseRandomNotFirstOrLast(leaves), this.context);
                } else {
                    for (Dataset dds : leaves) {
                        this.listen.getDataset(dds, this.context);
                        if (this.task == null || !this.task.isCancel()) continue;
                        break;
                    }
                }
            }
            for (Dataset dds : ds.getDatasetsLocal()) {
                if (!dds.hasNestedDatasets() && !(dds instanceof CatalogRef)) continue;
                this.crawlDataset(dds, level, indent.incr());
                indent.decr();
                if (this.task == null || !this.task.isCancel()) continue;
                break;
            }
        }
    }

    private Catalog readCatref(CatalogRef catref, PrintWriter out, Indent indent) {
        CatalogBuilder builder = new CatalogBuilder();
        try {
            Catalog cat = builder.buildFromCatref(catref);
            if (builder.hasFatalError() || cat == null) {
                if (out != null) {
                    out.printf("%sError reading catref %s err=%s%n", indent, catref.getName(), builder.getErrorMessage());
                }
                return null;
            }
            return cat;
        }
        catch (IOException e) {
            if (out != null) {
                out.printf("%sError reading catref %s err=%s%n", indent, catref.getName(), e.getMessage());
            }
            return null;
        }
    }

    private Dataset chooseRandom(List datasets) {
        int index = this.random.nextInt(datasets.size());
        return (Dataset)datasets.get(index);
    }

    private Dataset chooseRandomNotFirstOrLast(List datasets) {
        int index = this.random.nextInt(datasets.size());
        if (index == 0 && datasets.size() > 1) {
            ++index;
        } else if (index == datasets.size() - 1 && datasets.size() > 1) {
            --index;
        }
        return (Dataset)datasets.get(index);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("filter", this.filter).add("max", this.max).add("type", (Object)this.type).add("listen", this.listen).add("random", this.random).add("countCatrefs", this.countCatrefs).toString();
    }

    public int getNumReadFailures() {
        return this.numReadFailures;
    }

    public static void main(String[] args) throws Exception {
        String progName = CatalogCrawler.class.getName();
        long start = System.currentTimeMillis();
        final Counter c = new Counter();
        try {
            final CommandLine cmdLine = new CommandLine(progName, args);
            if (cmdLine.help) {
                cmdLine.printUsage();
                return;
            }
            System.out.printf("%s %n   %s%n", progName, cmdLine);
            final PrintWriter pw = new PrintWriter(System.out, true);
            FilterDatasetScan filter = new FilterDatasetScan(pw, cmdLine.skipDatasetScan, cmdLine.catrefLevel);
            final CancelTask task = null;
            CatalogCrawler crawler = new CatalogCrawler(cmdLine.type, -1, filter, new Listener(){

                @Override
                public void getDataset(Dataset dd, Object context) {
                    Service s;
                    ++c.datasets;
                    if (cmdLine.showNames) {
                        s = dd.getServiceDefault();
                        String sname = s == null ? "none" : s.getName();
                        pw.format("  Dataset '%s' service=%s%n", dd.getName(), sname);
                    }
                    if (cmdLine.openDataset && dd.hasAccess()) {
                        Access cdmremote;
                        s = dd.getServiceDefault();
                        if (s == null || s.getServiceTypeName().equalsIgnoreCase(ServiceType.HTTPServer.name())) {
                            return;
                        }
                        DataFactory fac = new DataFactory();
                        try (DataFactory.Result result = fac.openFeatureDataset(dd, task);){
                            if (result.fatalError) {
                                pw.format("  Dataset fatalError=%s%n", result.errLog);
                                ++c.failFc;
                            } else {
                                pw.format("  Dataset '%s' opened as type=%s%n", new Object[]{dd.getName(), result.featureDataset.getFeatureType()});
                                ++c.openFc;
                                if (cmdLine.readRandom && result.featureDataset instanceof FeatureDatasetCoverage) {
                                    CatalogCrawler.readRandom((FeatureDatasetCoverage)result.featureDataset, pw);
                                }
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace(pw);
                            ++c.failException;
                        }
                        catch (InvalidRangeException e) {
                            e.printStackTrace();
                            ++c.failException;
                        }
                        Access opendap = dd.getAccess(ServiceType.OPENDAP);
                        if (opendap != null) {
                            if (CatalogCrawler.readAccess(opendap, fac, pw)) {
                                ++c.openOdap;
                            } else {
                                ++c.failOdap;
                            }
                        }
                        if ((cdmremote = dd.getAccess(ServiceType.CdmRemote)) != null) {
                            if (CatalogCrawler.readAccess(cdmremote, fac, pw)) {
                                ++c.openCdmr;
                            } else {
                                ++c.failCdmr;
                            }
                        }
                    }
                }
            }, task, pw, null);
            int count = 0;
            pw.flush();
            long took = System.currentTimeMillis() - start;
            System.out.printf("%nthat took %d msecs%n", took);
            System.out.printf("count catalogs = %d%n", count += crawler.crawl(cmdLine.topCatalog));
            System.out.printf("count catrefs  = %d%n", filter.countCatrefs);
            System.out.printf("count skipped  = %d%n", filter.countSkip);
            System.out.printf("count filterCalls = %d%n%n", filter.count);
            System.out.printf("             count datasets = %d%n", c.datasets);
            System.out.printf("count open featureCollection = %d%n", c.openFc);
            System.out.printf("count fail featureCollection = %d%n", c.failFc);
            System.out.printf("         count failException = %d%n", c.failException);
            System.out.printf("          count open Opendap = %d%n", c.openOdap);
            System.out.printf("          count fail Opendap = %d%n", c.failOdap);
            System.out.printf("             count open Cdmr = %d%n", c.openCdmr);
            System.out.printf("             count fail Cdmr = %d%n", c.failCdmr);
        }
        catch (ParameterException e) {
            System.err.println(e.getMessage());
            System.err.printf("Try \"%s --help\" for more information.%n", progName);
        }
    }

    private static boolean readRandom(FeatureDatasetCoverage covDataset, PrintWriter pw) throws IOException, InvalidRangeException {
        CoverageCollection cc = covDataset.getCoverageCollections().get(0);
        int ncov = cc.getCoverageCount();
        Random r = new Random(System.currentTimeMillis());
        int randomIdx = r.nextInt(ncov);
        int count = 0;
        Coverage randomCov = null;
        for (Coverage c : cc.getCoverages()) {
            if (count == randomIdx) {
                randomCov = c;
                break;
            }
            ++count;
        }
        if (randomCov == null) {
            pw.format("Bad random coverage", new Object[0]);
            return false;
        }
        SubsetParams subset = new SubsetParams().setTimePresent();
        GeoReferencedArray geo = randomCov.readData(subset);
        Array data = geo.getData();
        System.out.printf(" read data from %s shape = %s%n", randomCov.getName(), Misc.showInts(data.getShape()));
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean readAccess(Access access, DataFactory fac, PrintWriter pw) {
        Formatter log = new Formatter();
        try (NetcdfDataset ncd = fac.openDataset(access, false, null, log);){
            if (ncd == null) {
                pw.format("  Dataset opendap fatalError=%s%n", log);
                boolean bl2 = false;
                return bl2;
            }
            pw.format("  Dataset '%s' opened as %s%n", access.getDataset().getName(), access.getService());
            boolean bl = CatalogCrawler.readRandom(ncd, pw);
            return bl;
        }
        catch (IOException | InvalidRangeException e) {
            e.printStackTrace(pw);
            return false;
        }
    }

    private static boolean readRandom(NetcdfDataset ncd, PrintWriter pw) throws IOException, InvalidRangeException {
        int ncov = ncd.getVariables().size();
        Random r = new Random(System.currentTimeMillis());
        int randomIdx = r.nextInt(ncov);
        Variable randomVariable = ncd.getVariables().get(randomIdx);
        int[] shape = randomVariable.getShape();
        int[] origin = new int[shape.length];
        int[] size = new int[shape.length];
        for (int i = 0; i < shape.length; ++i) {
            origin[i] = r.nextInt(shape[i]);
            size[i] = 1;
        }
        Array data = randomVariable.read(origin, size);
        pw.format(" read data from %s origin = %s return = %s%n", randomVariable.getNameAndDimensions(), Misc.showInts(origin), NCdumpW.toString(data));
        return true;
    }

    private static class Counter {
        int datasets = 0;
        int openFc = 0;
        int failFc = 0;
        int failException = 0;
        int openOdap = 0;
        int failOdap = 0;
        int openCdmr = 0;
        int failCdmr = 0;

        private Counter() {
        }
    }

    private static class CommandLine {
        @Parameter(names={"-cat", "--catalog"}, description="Top catalog URL", required=true)
        public String topCatalog;
        @Parameter(names={"-t", "--type"}, description="type of crawl. Allowed values=[all, all_direct, first_direct, random_direct, random_direct_middle, random_direct_max]")
        public Type type = Type.all;
        @Parameter(names={"-sh", "--showNames"}, description="show dataset names ")
        public boolean showNames = false;
        @Parameter(names={"-o", "--openDataset"}, description="try to open the dataset ")
        public boolean openDataset = false;
        @Parameter(names={"-r", "--readRandom"}, description="read some random data")
        public boolean readRandom = false;
        @Parameter(names={"-skipScans", "--skipScans"}, description="skip DatasetScans ")
        public boolean skipDatasetScan = true;
        @Parameter(names={"-catrefLevel", "--catrefLevel"}, description="skip Catalog References > nested level")
        public int catrefLevel = 0;
        @Parameter(names={"-h", "--help"}, description="Display this help and exit", help=true)
        public boolean help = false;
        private final JCommander jc;

        public CommandLine(String progName, String[] args) throws ParameterException {
            this.jc = new JCommander((Object)this, args);
            this.jc.setProgramName(progName);
            this.jc.setParameterDescriptionComparator(new ParameterDescriptionComparator());
        }

        public void printUsage() {
            this.jc.usage();
        }

        public String toString() {
            return "topCatalog='" + this.topCatalog + '\'' + "\n   type=" + (Object)((Object)this.type) + ", showNames=" + this.showNames + ", skipDatasetScan=" + this.skipDatasetScan + ", catrefLevel=" + this.catrefLevel + ", openDataset=" + this.openDataset;
        }

        private static class ParameterDescriptionComparator
        implements Comparator<ParameterDescription> {
            private final List<String> orderedParamNames = Arrays.asList("--catalog", "--type", "--openDataset", "--skipScans", "--readRandom", "--catrefLevel", "--showNames", "--help");

            private ParameterDescriptionComparator() {
            }

            @Override
            public int compare(ParameterDescription p0, ParameterDescription p1) {
                int index0 = this.orderedParamNames.indexOf(p0.getLongestName());
                int index1 = this.orderedParamNames.indexOf(p1.getLongestName());
                assert (index0 >= 0) : "Unexpected parameter name: " + p0.getLongestName();
                assert (index1 >= 0) : "Unexpected parameter name: " + p1.getLongestName();
                return Integer.compare(index0, index1);
            }
        }
    }

    private static class FilterDatasetScan
    implements Filter {
        PrintWriter out;
        boolean skipDatasetScan;
        int catrefLevel;
        int count = 0;
        int countSkip = 0;
        int countCatrefs = 0;

        private FilterDatasetScan(PrintWriter pw, boolean skipDatasetScan, int catrefLevel) {
            this.out = pw;
            this.skipDatasetScan = skipDatasetScan;
            this.catrefLevel = catrefLevel;
        }

        @Override
        public boolean skipAll(Dataset ds) {
            boolean skip;
            boolean bl = skip = this.skipDatasetScan && ds instanceof CatalogRef && ds.findProperty("DatasetScan") != null;
            if (skip) {
                ++this.countSkip;
                this.out.printf("  skip DatasetScan %s%n", ds.getName());
            }
            ++this.count;
            return skip;
        }

        @Override
        public boolean skipCatref(CatalogRef dd, int level) {
            ++this.countCatrefs;
            if (this.catrefLevel <= 0) {
                return false;
            }
            return level > this.catrefLevel;
        }
    }

    public static enum Type {
        all,
        all_direct,
        first_direct,
        random_direct,
        random_direct_middle,
        random_direct_max;

    }

    public static interface Filter {
        public boolean skipAll(Dataset var1);

        public boolean skipCatref(CatalogRef var1, int var2);
    }

    public static interface Listener {
        public void getDataset(Dataset var1, Object var2);
    }
}

