/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Objects;
import ucar.ma2.Array;
import ucar.ma2.ArrayObject;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.IsMissingEvaluator;
import ucar.nc2.util.Misc;

public class MAMath {
    public static Array add(Array a, Array b) throws IllegalArgumentException {
        Array result = Array.factory(a.getDataType(), a.getShape());
        if (a.getElementType() != Double.TYPE) {
            throw new UnsupportedOperationException();
        }
        MAMath.addDouble(result, a, b);
        return result;
    }

    public static void addDouble(Array result, Array a, Array b) throws IllegalArgumentException {
        if (!MAMath.conformable(result, a) || !MAMath.conformable(a, b)) {
            throw new IllegalArgumentException();
        }
        IndexIterator iterR = result.getIndexIterator();
        IndexIterator iterA = a.getIndexIterator();
        IndexIterator iterB = b.getIndexIterator();
        while (iterA.hasNext()) {
            iterR.setDoubleNext(iterA.getDoubleNext() + iterB.getDoubleNext());
        }
    }

    public static boolean conformable(Array a, Array b) {
        return MAMath.conformable(a.getShape(), b.getShape());
    }

    public static boolean conformable(int[] shapeA, int[] shapeB) {
        if (MAMath.reducedRank(shapeA) != MAMath.reducedRank(shapeB)) {
            return false;
        }
        int rankB = shapeB.length;
        int dimB = 0;
        for (int aShapeA : shapeA) {
            if (aShapeA == 1) continue;
            while (dimB < rankB && shapeB[dimB] == 1) {
                ++dimB;
            }
            if (aShapeA != shapeB[dimB]) {
                return false;
            }
            ++dimB;
        }
        return true;
    }

    public static Array convertUnsigned(Array unsigned) {
        if (unsigned.getElementType().equals(Byte.TYPE)) {
            Array result = Array.factory(DataType.SHORT, unsigned.getShape());
            IndexIterator ii = result.getIndexIterator();
            unsigned.resetLocalIterator();
            while (unsigned.hasNext()) {
                ii.setShortNext(DataType.widenNumber(unsigned.nextByte()).shortValue());
            }
            return result;
        }
        if (unsigned.getElementType().equals(Short.TYPE)) {
            Array result = Array.factory(DataType.INT, unsigned.getShape());
            IndexIterator ii = result.getIndexIterator();
            unsigned.resetLocalIterator();
            while (unsigned.hasNext()) {
                ii.setIntNext(DataType.widenNumber(unsigned.nextShort()).intValue());
            }
            return result;
        }
        if (unsigned.getElementType().equals(Integer.TYPE)) {
            Array result = Array.factory(DataType.LONG, unsigned.getShape());
            IndexIterator ii = result.getIndexIterator();
            unsigned.resetLocalIterator();
            while (unsigned.hasNext()) {
                ii.setLongNext(DataType.widenNumber(unsigned.nextInt()).longValue());
            }
            return result;
        }
        if (unsigned.getElementType().equals(Long.TYPE)) {
            ArrayObject result = ArrayObject.factory(DataType.OBJECT, BigInteger.class, false, Index.factory(unsigned.getShape()));
            IndexIterator ii = result.getIndexIterator();
            unsigned.resetLocalIterator();
            while (unsigned.hasNext()) {
                ii.setObjectNext(DataType.widenNumber(unsigned.nextLong()));
            }
            return result;
        }
        throw new IllegalArgumentException("Cant convertUnsigned type= " + unsigned.getElementType());
    }

    public static Array convert(Array org, DataType wantType) {
        if (org == null) {
            return null;
        }
        Class wantClass = wantType.getPrimitiveClassType();
        if (org.getElementType().equals(wantClass)) {
            return org;
        }
        Array result = Array.factory(wantType, org.getShape());
        MAMath.copy(wantType, org.getIndexIterator(), result.getIndexIterator());
        return result;
    }

    public static void copy(DataType dataType, IndexIterator from, IndexIterator to) throws IllegalArgumentException {
        if (dataType == DataType.DOUBLE) {
            while (from.hasNext()) {
                to.setDoubleNext(from.getDoubleNext());
            }
        } else if (dataType == DataType.FLOAT) {
            while (from.hasNext()) {
                to.setFloatNext(from.getFloatNext());
            }
        } else if (dataType.getPrimitiveClassType() == Long.TYPE) {
            while (from.hasNext()) {
                to.setLongNext(from.getLongNext());
            }
        } else if (dataType.getPrimitiveClassType() == Integer.TYPE) {
            while (from.hasNext()) {
                to.setIntNext(from.getIntNext());
            }
        } else if (dataType.getPrimitiveClassType() == Short.TYPE) {
            while (from.hasNext()) {
                to.setShortNext(from.getShortNext());
            }
        } else if (dataType == DataType.CHAR) {
            while (from.hasNext()) {
                to.setCharNext(from.getCharNext());
            }
        } else if (dataType.getPrimitiveClassType() == Byte.TYPE) {
            while (from.hasNext()) {
                to.setByteNext(from.getByteNext());
            }
        } else if (dataType == DataType.BOOLEAN) {
            while (from.hasNext()) {
                to.setBooleanNext(from.getBooleanNext());
            }
        } else {
            while (from.hasNext()) {
                to.setObjectNext(from.getObjectNext());
            }
        }
    }

    public static void copy(Array result, Array a) throws IllegalArgumentException {
        Class classType = a.getElementType();
        if (classType == Double.TYPE) {
            MAMath.copyDouble(result, a);
        } else if (classType == Float.TYPE) {
            MAMath.copyFloat(result, a);
        } else if (classType == Long.TYPE) {
            MAMath.copyLong(result, a);
        } else if (classType == Integer.TYPE) {
            MAMath.copyInt(result, a);
        } else if (classType == Short.TYPE) {
            MAMath.copyShort(result, a);
        } else if (classType == Character.TYPE) {
            MAMath.copyChar(result, a);
        } else if (classType == Byte.TYPE) {
            MAMath.copyByte(result, a);
        } else if (classType == Boolean.TYPE) {
            MAMath.copyBoolean(result, a);
        } else {
            MAMath.copyObject(result, a);
        }
    }

    public static void copyDouble(Array result, Array a) throws IllegalArgumentException {
        if (!MAMath.conformable(a, result)) {
            throw new IllegalArgumentException("copy arrays are not conformable");
        }
        IndexIterator iterA = a.getIndexIterator();
        IndexIterator iterR = result.getIndexIterator();
        while (iterA.hasNext()) {
            iterR.setDoubleNext(iterA.getDoubleNext());
        }
    }

    public static void copyFloat(Array result, Array a) throws IllegalArgumentException {
        if (!MAMath.conformable(a, result)) {
            throw new IllegalArgumentException("copy arrays are not conformable");
        }
        IndexIterator iterA = a.getIndexIterator();
        IndexIterator iterR = result.getIndexIterator();
        while (iterA.hasNext()) {
            iterR.setFloatNext(iterA.getFloatNext());
        }
    }

    public static void copyLong(Array result, Array a) throws IllegalArgumentException {
        if (!MAMath.conformable(a, result)) {
            throw new IllegalArgumentException("copy arrays are not conformable");
        }
        IndexIterator iterA = a.getIndexIterator();
        IndexIterator iterR = result.getIndexIterator();
        while (iterA.hasNext()) {
            iterR.setLongNext(iterA.getLongNext());
        }
    }

    public static void copyInt(Array result, Array a) throws IllegalArgumentException {
        if (!MAMath.conformable(a, result)) {
            throw new IllegalArgumentException("copy arrays are not conformable");
        }
        IndexIterator iterA = a.getIndexIterator();
        IndexIterator iterR = result.getIndexIterator();
        while (iterA.hasNext()) {
            iterR.setIntNext(iterA.getIntNext());
        }
    }

    public static void copyShort(Array result, Array a) throws IllegalArgumentException {
        if (!MAMath.conformable(a, result)) {
            throw new IllegalArgumentException("copy arrays are not conformable");
        }
        IndexIterator iterA = a.getIndexIterator();
        IndexIterator iterR = result.getIndexIterator();
        while (iterA.hasNext()) {
            iterR.setShortNext(iterA.getShortNext());
        }
    }

    public static void copyChar(Array result, Array a) throws IllegalArgumentException {
        if (!MAMath.conformable(a, result)) {
            throw new IllegalArgumentException("copy arrays are not conformable");
        }
        IndexIterator iterA = a.getIndexIterator();
        IndexIterator iterR = result.getIndexIterator();
        while (iterA.hasNext()) {
            iterR.setCharNext(iterA.getCharNext());
        }
    }

    public static void copyByte(Array result, Array a) throws IllegalArgumentException {
        if (!MAMath.conformable(a, result)) {
            throw new IllegalArgumentException("copy arrays are not conformable");
        }
        IndexIterator iterA = a.getIndexIterator();
        IndexIterator iterR = result.getIndexIterator();
        while (iterA.hasNext()) {
            iterR.setByteNext(iterA.getByteNext());
        }
    }

    public static void copyBoolean(Array result, Array a) throws IllegalArgumentException {
        if (!MAMath.conformable(a, result)) {
            throw new IllegalArgumentException("copy arrays are not conformable");
        }
        IndexIterator iterA = a.getIndexIterator();
        IndexIterator iterR = result.getIndexIterator();
        while (iterA.hasNext()) {
            iterR.setBooleanNext(iterA.getBooleanNext());
        }
    }

    public static void copyObject(Array result, Array a) throws IllegalArgumentException {
        if (!MAMath.conformable(a, result)) {
            throw new IllegalArgumentException("copy arrays are not conformable");
        }
        IndexIterator iterA = a.getIndexIterator();
        IndexIterator iterR = result.getIndexIterator();
        while (iterA.hasNext()) {
            iterR.setObjectNext(iterA.getObjectNext());
        }
    }

    public static int reducedRank(int[] shape) {
        int rank = 0;
        for (int aShape : shape) {
            if (aShape <= 1) continue;
            ++rank;
        }
        return rank;
    }

    public static double getMinimum(Array a) {
        IndexIterator iter = a.getIndexIterator();
        double min = Double.MAX_VALUE;
        while (iter.hasNext()) {
            double val = iter.getDoubleNext();
            if (Double.isNaN(val) || !(val < min)) continue;
            min = val;
        }
        return min;
    }

    public static double getMaximum(Array a) {
        IndexIterator iter = a.getIndexIterator();
        double max = -1.7976931348623157E308;
        while (iter.hasNext()) {
            double val = iter.getDoubleNext();
            if (Double.isNaN(val) || !(val > max)) continue;
            max = val;
        }
        return max;
    }

    public static MinMax getMinMax(Array a) {
        IndexIterator iter = a.getIndexIterator();
        double max = -1.7976931348623157E308;
        double min = Double.MAX_VALUE;
        while (iter.hasNext()) {
            double val = iter.getDoubleNext();
            if (Double.isNaN(val)) continue;
            if (val > max) {
                max = val;
            }
            if (!(val < min)) continue;
            min = val;
        }
        return new MinMax(min, max);
    }

    public static MinMax getMinMaxSkipMissingData(Array a, IsMissingEvaluator eval) {
        if (eval == null || !eval.hasMissing()) {
            return MAMath.getMinMax(a);
        }
        IndexIterator iter = a.getIndexIterator();
        double max = -1.7976931348623157E308;
        double min = Double.MAX_VALUE;
        while (iter.hasNext()) {
            double val = iter.getDoubleNext();
            if (eval.isMissing(val)) continue;
            if (val > max) {
                max = val;
            }
            if (!(val < min)) continue;
            min = val;
        }
        return new MinMax(min, max);
    }

    public static double getMinimumSkipMissingData(Array a, double missingValue) {
        IndexIterator iter = a.getIndexIterator();
        double min = Double.MAX_VALUE;
        while (iter.hasNext()) {
            double val = iter.getDoubleNext();
            if (val == missingValue || !(val < min)) continue;
            min = val;
        }
        return min;
    }

    public static double getMaximumSkipMissingData(Array a, double missingValue) {
        IndexIterator iter = a.getIndexIterator();
        double max = -1.7976931348623157E308;
        while (iter.hasNext()) {
            double val = iter.getDoubleNext();
            if (val == missingValue || !(val > max)) continue;
            max = val;
        }
        return max;
    }

    public static MinMax getMinMaxSkipMissingData(Array a, double missingValue) {
        IndexIterator iter = a.getIndexIterator();
        double max = -1.7976931348623157E308;
        double min = Double.MAX_VALUE;
        while (iter.hasNext()) {
            double val = iter.getDoubleNext();
            if (val == missingValue) continue;
            if (val > max) {
                max = val;
            }
            if (!(val < min)) continue;
            min = val;
        }
        return new MinMax(min, max);
    }

    public static void setDouble(Array result, double val) {
        IndexIterator iter = result.getIndexIterator();
        while (iter.hasNext()) {
            iter.setDoubleNext(val);
        }
    }

    public static double sumDouble(Array a) {
        double sum = 0.0;
        IndexIterator iterA = a.getIndexIterator();
        while (iterA.hasNext()) {
            sum += iterA.getDoubleNext();
        }
        return sum;
    }

    public static double sumDoubleSkipMissingData(Array a, double missingValue) {
        double sum = 0.0;
        IndexIterator iterA = a.getIndexIterator();
        while (iterA.hasNext()) {
            double val = iterA.getDoubleNext();
            if (val == missingValue || Double.isNaN(val)) continue;
            sum += val;
        }
        return sum;
    }

    public static ScaleOffset calcScaleOffsetSkipMissingData(Array a, double missingValue, int nbits) {
        MinMax minmax = MAMath.getMinMaxSkipMissingData(a, missingValue);
        if (a.isUnsigned()) {
            long size = (1L << nbits) - 1L;
            double offset = minmax.min;
            double scale = (minmax.max - minmax.min) / (double)size;
            return new ScaleOffset(scale, offset);
        }
        long size = (1L << nbits) - 2L;
        double offset = (minmax.max + minmax.min) / 2.0;
        double scale = (minmax.max - minmax.min) / (double)size;
        return new ScaleOffset(scale, offset);
    }

    public static Array convert2packed(Array unpacked, double missingValue, int nbits, DataType packedType) {
        ScaleOffset scaleOffset = MAMath.calcScaleOffsetSkipMissingData(unpacked, missingValue, nbits);
        Array result = Array.factory(packedType, unpacked.getShape());
        IndexIterator riter = result.getIndexIterator();
        while (unpacked.hasNext()) {
            double uv = unpacked.nextDouble();
            double pv = (uv - scaleOffset.offset) / scaleOffset.scale;
            riter.setDoubleNext(pv);
        }
        return result;
    }

    public static Array convert2Unpacked(Array packed, ScaleOffset scaleOffset) {
        Array result = Array.factory(DataType.DOUBLE, packed.getShape());
        IndexIterator riter = result.getIndexIterator();
        while (packed.hasNext()) {
            riter.setDoubleNext(packed.nextDouble() * scaleOffset.scale + scaleOffset.offset);
        }
        return result;
    }

    public static boolean nearlyEquals(Array data1, Array data2) {
        if (data1 == data2) {
            return true;
        }
        if (data1 == null || data2 == null) {
            return false;
        }
        if (data1.getSize() != data2.getSize()) {
            return false;
        }
        if (data1.isUnsigned() != data2.isUnsigned()) {
            return false;
        }
        DataType dt = DataType.getType(data1);
        IndexIterator iter1 = data1.getIndexIterator();
        IndexIterator iter2 = data2.getIndexIterator();
        if (dt == DataType.DOUBLE) {
            while (iter1.hasNext() && iter2.hasNext()) {
                double v2;
                double v1 = iter1.getDoubleNext();
                if (Misc.nearlyEquals(v1, v2 = iter2.getDoubleNext(), 1.0E-8)) continue;
                return false;
            }
        } else if (dt == DataType.FLOAT) {
            while (iter1.hasNext() && iter2.hasNext()) {
                float v2;
                float v1 = iter1.getFloatNext();
                if (Misc.nearlyEquals((double)v1, (double)(v2 = iter2.getFloatNext()), 1.0E-8)) continue;
                return false;
            }
        } else if (dt.getPrimitiveClassType() == Integer.TYPE) {
            while (iter1.hasNext() && iter2.hasNext()) {
                int v2;
                int v1 = iter1.getIntNext();
                if (v1 == (v2 = iter2.getIntNext())) continue;
                return false;
            }
        } else if (dt.getPrimitiveClassType() == Byte.TYPE) {
            while (iter1.hasNext() && iter2.hasNext()) {
                short v2;
                short v1 = iter1.getShortNext();
                if (v1 == (v2 = iter2.getShortNext())) continue;
                return false;
            }
        } else if (dt.getPrimitiveClassType() == Short.TYPE) {
            while (iter1.hasNext() && iter2.hasNext()) {
                byte v2;
                byte v1 = iter1.getByteNext();
                if (v1 == (v2 = iter2.getByteNext())) continue;
                return false;
            }
        } else if (dt.getPrimitiveClassType() == Long.TYPE) {
            while (iter1.hasNext() && iter2.hasNext()) {
                long v2;
                long v1 = iter1.getLongNext();
                if (v1 == (v2 = iter2.getLongNext())) continue;
                return false;
            }
        } else {
            while (iter1.hasNext() && iter2.hasNext()) {
                if (Objects.equals(iter1.next(), iter2.next())) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean equals(Array array1, Array array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        if (array1.getDataType() != array2.getDataType()) {
            return false;
        }
        if (!Arrays.equals(array1.getShape(), array2.getShape())) {
            return false;
        }
        IndexIterator iter1 = array1.getIndexIterator();
        IndexIterator iter2 = array2.getIndexIterator();
        while (iter1.hasNext() && iter2.hasNext()) {
            if (!Objects.equals(iter1.next(), iter2.next())) {
                return false;
            }
            if (Arrays.equals(iter1.getCurrentCounter(), iter2.getCurrentCounter())) continue;
            return false;
        }
        assert (!iter1.hasNext() && !iter2.hasNext());
        return true;
    }

    public static int hashCode(Array array) {
        if (array == null) {
            return 0;
        }
        int hash = 3;
        hash = 29 * hash + array.getDataType().hashCode();
        hash = 29 * hash + Arrays.hashCode(array.getShape());
        IndexIterator iter = array.getIndexIterator();
        while (iter.hasNext()) {
            hash = 29 * hash + iter.next().hashCode();
            hash = 29 * hash + Arrays.hashCode(iter.getCurrentCounter());
        }
        return hash;
    }

    public static class ScaleOffset {
        public double scale;
        public double offset;

        public ScaleOffset(double scale, double offset) {
            this.scale = scale;
            this.offset = offset;
        }
    }

    public static class MinMax {
        public double min;
        public double max;

        public MinMax(double min, double max) {
            this.min = min;
            this.max = max;
        }

        public String toString() {
            return "MinMax{min=" + this.min + ", max=" + this.max + '}';
        }
    }
}

