/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.coverage;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CollectionUpdateType;
import ucar.coord.Coordinate;
import ucar.coord.CoordinateEns;
import ucar.coord.CoordinateRuntime;
import ucar.coord.CoordinateTime;
import ucar.coord.CoordinateTime2D;
import ucar.coord.CoordinateTimeAbstract;
import ucar.coord.CoordinateTimeIntv;
import ucar.coord.CoordinateVert;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.RangeIterator;
import ucar.ma2.SectionIterable;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainerHelper;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft2.coverage.CoordAxisReader;
import ucar.nc2.ft2.coverage.CoordsSet;
import ucar.nc2.ft2.coverage.Coverage;
import ucar.nc2.ft2.coverage.CoverageCollection;
import ucar.nc2.ft2.coverage.CoverageCoordAxis;
import ucar.nc2.ft2.coverage.CoverageCoordAxis1D;
import ucar.nc2.ft2.coverage.CoverageCoordAxisBuilder;
import ucar.nc2.ft2.coverage.CoverageCoordSys;
import ucar.nc2.ft2.coverage.CoverageReader;
import ucar.nc2.ft2.coverage.CoverageTransform;
import ucar.nc2.ft2.coverage.FeatureDatasetCoverage;
import ucar.nc2.ft2.coverage.GeoReferencedArray;
import ucar.nc2.ft2.coverage.LatLonAxis2D;
import ucar.nc2.ft2.coverage.SubsetParams;
import ucar.nc2.ft2.coverage.TimeAxis2DFmrc;
import ucar.nc2.ft2.coverage.TimeOffsetAxis;
import ucar.nc2.grib.EnsCoord;
import ucar.nc2.grib.GdsHorizCoordSys;
import ucar.nc2.grib.TimeCoord;
import ucar.nc2.grib.VertCoord;
import ucar.nc2.grib.collection.GribCdmIndex;
import ucar.nc2.grib.collection.GribCollectionImmutable;
import ucar.nc2.grib.collection.GribDataReader;
import ucar.nc2.grib.grib2.Grib2Utils;
import ucar.nc2.time.Calendar;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.time.CalendarPeriod;
import ucar.nc2.units.SimpleUnit;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.Parameter;

@Immutable
public class GribCoverageDataset
implements CoverageReader,
CoordAxisReader {
    private static final Logger logger = LoggerFactory.getLogger(GribCoverageDataset.class);
    private final GribCollectionImmutable gribCollection;
    private final GribCollectionImmutable.Dataset ds;
    private final GribCollectionImmutable.GroupGC group;
    private final FeatureType coverageType;
    private final boolean isGrib1;
    private final boolean isLatLon;
    private final boolean isCurvilinearOrthogonal;
    CalendarDateRange dateRange;

    public static ucar.nc2.util.Optional<FeatureDatasetCoverage> open(String endpoint) throws IOException {
        GribCollectionImmutable gc;
        if (endpoint.startsWith("file:")) {
            endpoint = endpoint.substring("file:".length());
        }
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(endpoint, "r");
            gc = GribCdmIndex.openGribCollectionFromRaf(raf, new FeatureCollectionConfig(), CollectionUpdateType.nocheck, logger);
            if (gc == null) {
                raf.close();
                return ucar.nc2.util.Optional.empty("Not a GRIB file");
            }
        }
        catch (IOException ioe) {
            if (raf != null) {
                raf.close();
            }
            throw ioe;
        }
        try {
            ArrayList<CoverageCollection> datasets = new ArrayList<CoverageCollection>();
            for (GribCollectionImmutable.Dataset ds : gc.getDatasets()) {
                for (GribCollectionImmutable.GroupGC group : ds.getGroups()) {
                    GribCoverageDataset gribCov = new GribCoverageDataset(gc, ds, group);
                    datasets.add(gribCov.createCoverageCollection());
                }
            }
            FeatureDatasetCoverage result = new FeatureDatasetCoverage(endpoint, gc.getGlobalAttributes(), gc, datasets);
            return ucar.nc2.util.Optional.of(result);
        }
        catch (Throwable t) {
            logger.error("GribCoverageDataset.open failed", t);
            return ucar.nc2.util.Optional.empty(t.getMessage());
        }
    }

    public GribCoverageDataset(GribCollectionImmutable gribCollection, GribCollectionImmutable.Dataset ds, GribCollectionImmutable.GroupGC group) {
        FeatureType ct;
        this.gribCollection = gribCollection;
        this.ds = ds != null ? ds : gribCollection.getDataset(0);
        this.group = group != null ? group : this.ds.getGroup(0);
        this.isGrib1 = gribCollection.isGrib1;
        GdsHorizCoordSys hcs = this.group.getGdsHorizCoordSys();
        this.isLatLon = hcs.isLatLon();
        this.isCurvilinearOrthogonal = !this.isGrib1 && Grib2Utils.isCurvilinearOrthogonal(hcs.template, gribCollection.getCenter());
        switch (this.ds.getType()) {
            case MRC: 
            case TwoD: {
                ct = FeatureType.FMRC;
                break;
            }
            default: {
                ct = FeatureType.GRID;
            }
        }
        if (this.isCurvilinearOrthogonal) {
            ct = FeatureType.CURVILINEAR;
        }
        this.coverageType = ct;
    }

    @Override
    public void close() throws IOException {
        this.gribCollection.close();
    }

    @Override
    public String getLocation() {
        return this.gribCollection.getLocation() + "#" + this.group.getId();
    }

    public CoverageCollection createCoverageCollection() {
        String name = this.gribCollection.getName() + "#" + (Object)((Object)this.ds.getType());
        if (this.ds.getGroupsSize() > 1) {
            name = name + "-" + this.group.getId();
        }
        AttributeContainerHelper gatts = this.gribCollection.getGlobalAttributes();
        ArrayList<CoverageTransform> transforms = new ArrayList<CoverageTransform>();
        if (!this.isLatLon) {
            AttributeContainerHelper projAtts = new AttributeContainerHelper(this.group.horizCoordSys.getId());
            for (Parameter p : this.group.getGdsHorizCoordSys().proj.getProjectionParameters()) {
                projAtts.addAttribute(new Attribute(p));
            }
            CoverageTransform projTransform = new CoverageTransform(this.group.horizCoordSys.getId(), projAtts, true);
            transforms.add(projTransform);
        }
        ArrayList<GribCollectionImmutable.VariableIndex> vars = new ArrayList<GribCollectionImmutable.VariableIndex>(this.group.getVariables());
        ArrayList<CoverageCoordAxis> axes = new ArrayList<CoverageCoordAxis>();
        if (this.isCurvilinearOrthogonal) {
            axes.addAll(this.makeHorizCoordinates2D(vars));
        } else {
            axes.addAll(this.makeHorizCoordinates());
        }
        HashMap<Coordinate, List<CoverageCoordAxis>> coord2axisMap = new HashMap<Coordinate, List<CoverageCoordAxis>>();
        for (Coordinate axis : this.group.getCoordinates()) {
            switch (axis.getType()) {
                case runtime: {
                    break;
                }
                case time2D: {
                    coord2axisMap.put(axis, this.makeTime2DCoordinates((CoordinateTime2D)axis));
                    break;
                }
                case time: 
                case timeIntv: {
                    coord2axisMap.put(axis, this.makeTimeCoordinates((CoordinateTimeAbstract)axis));
                    break;
                }
                case vert: {
                    CoverageCoordAxis covAxisVert = this.makeCoordAxis((CoordinateVert)axis);
                    coord2axisMap.put(axis, Lists.newArrayList(covAxisVert));
                    break;
                }
                case ens: {
                    CoverageCoordAxis covAxisEns = this.makeCoordAxis((CoordinateEns)axis);
                    coord2axisMap.put(axis, Lists.newArrayList(covAxisEns));
                }
            }
        }
        for (Object coord : coord2axisMap.keySet()) {
            for (CoverageCoordAxis covCoord : (List)coord2axisMap.get(coord)) {
                if (this.alreadyHave(axes, covCoord.getName())) continue;
                axes.add(covCoord);
            }
        }
        HashMap<String, CoverageCoordSys> coordSysSet = new HashMap<String, CoverageCoordSys>();
        for (GribCollectionImmutable.VariableIndex v : vars) {
            CoverageCoordSys sys = this.makeCoordSys(v, transforms, coord2axisMap);
            coordSysSet.put(sys.getName(), sys);
        }
        ArrayList<CoverageCoordSys> coordSys = new ArrayList<CoverageCoordSys>(coordSysSet.values());
        ArrayList<Coverage> pgrids = new ArrayList<Coverage>();
        for (GribCollectionImmutable.VariableIndex v : vars) {
            pgrids.add(this.makeCoverage(v, coord2axisMap));
        }
        return new CoverageCollection(name, this.coverageType, gatts, null, null, this.getCalendarDateRange(), coordSys, transforms, axes, pgrids, this);
    }

    private void trackDateRange(CalendarDateRange cdr) {
        this.dateRange = this.dateRange == null ? cdr : this.dateRange.extend(cdr);
    }

    CalendarDateRange getCalendarDateRange() {
        return this.dateRange;
    }

    private List<CoverageCoordAxis> makeHorizCoordinates() {
        GdsHorizCoordSys hcs = this.group.getGdsHorizCoordSys();
        ArrayList<CoverageCoordAxis> result = new ArrayList<CoverageCoordAxis>(2);
        if (this.isLatLon) {
            AttributeContainerHelper atts = new AttributeContainerHelper("latitude");
            atts.addAttribute(new Attribute("units", "degrees_north"));
            double[] values = null;
            CoverageCoordAxis.Spacing spacing = CoverageCoordAxis.Spacing.regularPoint;
            Array glats = hcs.getGaussianLats();
            if (glats != null) {
                spacing = CoverageCoordAxis.Spacing.irregularPoint;
                values = (double[])glats.get1DJavaArray(DataType.DOUBLE);
                atts.addAttribute(new Attribute("gaussian_lats", "true"));
            }
            result.add(new CoverageCoordAxis1D(new CoverageCoordAxisBuilder("latitude", "degrees_north", null, DataType.FLOAT, AxisType.Lat, atts, CoverageCoordAxis.DependenceType.independent, null, spacing, hcs.ny, hcs.getStartY(), hcs.getEndY(), hcs.dy, values, this)));
            atts = new AttributeContainerHelper("longitude");
            atts.addAttribute(new Attribute("units", "degrees_east"));
            result.add(new CoverageCoordAxis1D(new CoverageCoordAxisBuilder("longitude", "degrees_east", null, DataType.FLOAT, AxisType.Lon, atts, CoverageCoordAxis.DependenceType.independent, null, CoverageCoordAxis.Spacing.regularPoint, hcs.nx, hcs.getStartX(), hcs.getEndX(), hcs.dx, null, this)));
        } else {
            AttributeContainerHelper atts = new AttributeContainerHelper("y");
            atts.addAttribute(new Attribute("units", "km"));
            result.add(new CoverageCoordAxis1D(new CoverageCoordAxisBuilder("y", "km", "projection_y_coordinate", DataType.FLOAT, AxisType.GeoY, atts, CoverageCoordAxis.DependenceType.independent, null, CoverageCoordAxis.Spacing.regularPoint, hcs.ny, hcs.getStartY(), hcs.getEndY(), hcs.dy, null, this)));
            atts = new AttributeContainerHelper("x");
            atts.addAttribute(new Attribute("units", "km"));
            result.add(new CoverageCoordAxis1D(new CoverageCoordAxisBuilder("x", "km", "projection_x_coordinate", DataType.FLOAT, AxisType.GeoX, atts, CoverageCoordAxis.DependenceType.independent, null, CoverageCoordAxis.Spacing.regularPoint, hcs.nx, hcs.getStartX(), hcs.getEndX(), hcs.dx, null, this)));
        }
        return result;
    }

    private List<CoverageCoordAxis> makeHorizCoordinates2D(List<GribCollectionImmutable.VariableIndex> vars) {
        GdsHorizCoordSys hcs = this.group.getGdsHorizCoordSys();
        ArrayList<GribCollectionImmutable.VariableIndex> remove = new ArrayList<GribCollectionImmutable.VariableIndex>();
        ArrayList<CoverageCoordAxis> result = new ArrayList<CoverageCoordAxis>();
        for (GribCollectionImmutable.VariableIndex vindex : vars) {
            CoverageCoordAxisBuilder builder;
            Grib2Utils.LatLon2DCoord ll2d = Grib2Utils.getLatLon2DcoordType(vindex.getDiscipline(), vindex.getCategory(), vindex.getParameter());
            if (ll2d == null) continue;
            AxisType axisType = ll2d.getAxisType();
            String name = ll2d.toString();
            AttributeContainerHelper atts = new AttributeContainerHelper(name);
            atts.addAttribute(new Attribute("_CoordinateStagger", "Curvilinear_Orthogonal"));
            atts.addAttribute(new Attribute("stagger_type", ll2d.toString()));
            int[] shape = new int[]{hcs.ny, hcs.nx};
            int npts = hcs.ny * hcs.nx;
            if (axisType == AxisType.Lat) {
                atts.addAttribute(new Attribute("units", "degrees_north"));
                builder = new CoverageCoordAxisBuilder(name, "degrees_north", vindex.makeVariableDescription(), DataType.FLOAT, AxisType.Lat, atts, CoverageCoordAxis.DependenceType.twoD, null, CoverageCoordAxis.Spacing.irregularPoint, npts, 0.0, 0.0, 0.0, null, this);
            } else {
                atts.addAttribute(new Attribute("units", "degrees_east"));
                builder = new CoverageCoordAxisBuilder(name, "degrees_east", vindex.makeVariableDescription(), DataType.FLOAT, AxisType.Lon, atts, CoverageCoordAxis.DependenceType.twoD, null, CoverageCoordAxis.Spacing.irregularPoint, npts, 0.0, 0.0, 0.0, null, this);
            }
            builder.shape = shape;
            builder.userObject = vindex;
            result.add(new LatLonAxis2D(builder));
            remove.add(vindex);
        }
        for (GribCollectionImmutable.VariableIndex vindex : remove) {
            vars.remove(vindex);
        }
        return result;
    }

    private List<CoverageCoordAxis> makeTime2DCoordinates(CoordinateTime2D time2D) {
        CoverageCoordAxis covTime;
        this.trackDateRange(time2D.makeCalendarDateRange(null));
        ArrayList<CoverageCoordAxis> result = new ArrayList<CoverageCoordAxis>();
        if (this.ds.getType() == GribCollectionImmutable.Type.SRC) {
            covTime = this.makeUniqueTimeAxis(time2D);
            CoordinateRuntime rt = time2D.getRuntimeCoordinate();
            result.add(this.makeRuntimeCoord(rt));
        } else if (this.ds.getType().isUniqueTime()) {
            covTime = this.makeUniqueTimeAxis(time2D);
            result.add(this.makeRuntimeAuxCoord(time2D, covTime.getNcoords()));
        } else if (time2D.isOrthogonal()) {
            covTime = this.makeTimeOffsetAxis(time2D);
            CoordinateRuntime rt = time2D.getRuntimeCoordinate();
            result.add(this.makeRuntimeCoord(rt));
        } else if (time2D.isRegular()) {
            covTime = this.makeFmrcRegTimeAxis(time2D);
            CoordinateRuntime rt = time2D.getRuntimeCoordinate();
            result.add(this.makeRuntimeCoord(rt));
        } else {
            throw new IllegalStateException("Time2D with type= " + (Object)((Object)this.ds.getType()));
        }
        result.add(covTime);
        return result;
    }

    private boolean alreadyHave(List<CoverageCoordAxis> list, String name) {
        for (CoverageCoordAxis coord : list) {
            if (!coord.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private CoverageCoordAxis1D makeUniqueTimeAxis(CoordinateTime2D time2D) {
        int runIdx;
        int count;
        double[] values;
        int nruns = time2D.getNruns();
        int ntimes = 0;
        for (int run = 0; run < time2D.getNruns(); ++run) {
            CoordinateTimeAbstract timeCoord = time2D.getTimeCoordinate(run);
            ntimes += timeCoord.getSize();
        }
        CalendarPeriod timeUnit = time2D.getTimeUnit();
        if (time2D.isTimeInterval()) {
            values = new double[2 * ntimes];
            count = 0;
            for (runIdx = 0; runIdx < nruns; ++runIdx) {
                CoordinateTimeIntv timeIntv = (CoordinateTimeIntv)time2D.getTimeCoordinate(runIdx);
                for (TimeCoord.Tinv tinv : timeIntv.getTimeIntervals()) {
                    values[count++] = timeUnit.getValue() * tinv.getBounds1() + time2D.getOffset(runIdx);
                    values[count++] = timeUnit.getValue() * tinv.getBounds2() + time2D.getOffset(runIdx);
                }
            }
        } else {
            values = new double[ntimes];
            count = 0;
            for (runIdx = 0; runIdx < nruns; ++runIdx) {
                CoordinateTime coordTime = (CoordinateTime)time2D.getTimeCoordinate(runIdx);
                for (int val : coordTime.getOffsetSorted()) {
                    double b1 = timeUnit.getValue() * val + time2D.getOffset(runIdx);
                    values[count++] = b1;
                }
            }
        }
        AttributeContainerHelper atts = new AttributeContainerHelper(time2D.getName());
        atts.addAttribute(new Attribute("units", time2D.getUnit()));
        atts.addAttribute(new Attribute("standard_name", "time"));
        atts.addAttribute(new Attribute("long_name", "time"));
        atts.addAttribute(new Attribute("udunits", time2D.getTimeUdUnit()));
        atts.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Time.toString()));
        CoverageCoordAxisBuilder builder = new CoverageCoordAxisBuilder(time2D.getName(), time2D.getTimeUdUnit(), "time", DataType.DOUBLE, AxisType.Time, atts, CoverageCoordAxis.DependenceType.independent, null, null, ntimes, 0.0, 0.0, 0.0, values, this);
        builder.setSpacingFromValues(time2D.isTimeInterval());
        return new CoverageCoordAxis1D(builder);
    }

    private TimeAxis2DFmrc makeFmrcRegTimeAxis(CoordinateTime2D time2D) {
        CoordinateRuntime runtime = time2D.getRuntimeCoordinate();
        String dependsOn = runtime.getName();
        int nruns = time2D.getNruns();
        int ntimes = time2D.getNtimes();
        int nvalues = time2D.isTimeInterval() ? nruns * ntimes * 2 : nruns * ntimes;
        double[] values = new double[nvalues];
        for (int runIdx = 0; runIdx < nruns; ++runIdx) {
            int timeIdx;
            int n;
            int runOffset = time2D.getOffset(runIdx);
            CoordinateTimeAbstract time = time2D.getTimeCoordinate(runIdx);
            if (time2D.isTimeInterval()) {
                CoordinateTimeIntv coordIntv = (CoordinateTimeIntv)time;
                n = coordIntv.getSize();
                for (timeIdx = 0; timeIdx < n; ++timeIdx) {
                    TimeCoord.Tinv tinv = (TimeCoord.Tinv)coordIntv.getValue(timeIdx);
                    values[runIdx * ntimes + timeIdx] = tinv.getBounds1() + runOffset;
                    values[runIdx * ntimes + timeIdx + 1] = tinv.getBounds2() + runOffset;
                }
                continue;
            }
            CoordinateTime coord = (CoordinateTime)time;
            n = coord.getSize();
            for (timeIdx = 0; timeIdx < n; ++timeIdx) {
                Integer offset = (Integer)coord.getValue(timeIdx);
                values[runIdx * ntimes + timeIdx] = offset + runOffset;
            }
        }
        AttributeContainerHelper atts = new AttributeContainerHelper(time2D.getName());
        atts.addAttribute(new Attribute("units", time2D.getUnit()));
        atts.addAttribute(new Attribute("standard_name", "forecast_period"));
        atts.addAttribute(new Attribute("long_name", "time offset from runtime"));
        atts.addAttribute(new Attribute("udunits", time2D.getTimeUdUnit()));
        atts.addAttribute(new Attribute("_CoordinateAxisType", AxisType.TimeOffset.toString()));
        CoverageCoordAxisBuilder builder = new CoverageCoordAxisBuilder(time2D.getName(), time2D.getUnit(), "time offset from runtime", DataType.DOUBLE, AxisType.TimeOffset, atts, CoverageCoordAxis.DependenceType.fmrcReg, dependsOn, null, nruns * ntimes, 0.0, 0.0, 0.0, values, this);
        builder.setSpacingFromValues(time2D.isTimeInterval());
        return new TimeAxis2DFmrc(builder);
    }

    private TimeOffsetAxis makeTimeOffsetAxis(CoordinateTime2D time2D) {
        int count;
        double[] values;
        List<? extends Object> offsets = time2D.getOffsetsSorted();
        int n = offsets.size();
        if (time2D.isTimeInterval()) {
            values = new double[2 * n];
            count = 0;
            for (Object object : offsets) {
                TimeCoord.Tinv tinv = (TimeCoord.Tinv)object;
                values[count++] = tinv.getBounds1();
                values[count++] = tinv.getBounds2();
            }
        } else {
            values = new double[n];
            count = 0;
            for (Object object : offsets) {
                Integer off = (Integer)object;
                values[count++] = off.intValue();
            }
        }
        AttributeContainerHelper atts = new AttributeContainerHelper(time2D.getName());
        atts.addAttribute(new Attribute("units", time2D.getUnit()));
        atts.addAttribute(new Attribute("standard_name", "forecast_period"));
        atts.addAttribute(new Attribute("long_name", "time offset from runtime"));
        atts.addAttribute(new Attribute("udunits", time2D.getTimeUdUnit()));
        atts.addAttribute(new Attribute("_CoordinateAxisType", AxisType.TimeOffset.toString()));
        CoverageCoordAxisBuilder builder = new CoverageCoordAxisBuilder(time2D.getName(), time2D.getUnit(), "time offset from runtime", DataType.DOUBLE, AxisType.TimeOffset, atts, CoverageCoordAxis.DependenceType.independent, null, null, n, 0.0, 0.0, 0.0, values, this);
        builder.setSpacingFromValues(time2D.isTimeInterval());
        return new TimeOffsetAxis(builder);
    }

    private List<CoverageCoordAxis> makeTimeCoordinates(CoordinateTimeAbstract time) {
        ArrayList<CoverageCoordAxis> result = new ArrayList<CoverageCoordAxis>();
        if (time instanceof CoordinateTime) {
            result.add(this.makeCoordAxis((CoordinateTime)time));
        } else if (time instanceof CoordinateTimeIntv) {
            result.add(this.makeCoordAxis((CoordinateTimeIntv)time));
        }
        CoverageCoordAxis runAux = this.makeRuntimeAuxCoord(time);
        if (runAux != null) {
            result.add(runAux);
        }
        return result;
    }

    private CoverageCoordAxis1D makeRuntimeCoord(CoordinateRuntime runtime) {
        String units = runtime.getPeriodName() + " since " + this.gribCollection.getMasterFirstDate().toString();
        List<Double> offsets = runtime.getOffsetsInTimeUnits();
        int n = offsets.size();
        boolean isScalar = n == 1;
        CoverageCoordAxis.DependenceType dependence = isScalar ? CoverageCoordAxis.DependenceType.scalar : CoverageCoordAxis.DependenceType.independent;
        double[] values = new double[n];
        int count = 0;
        for (Double offset : runtime.getOffsetsInTimeUnits()) {
            values[count++] = offset;
        }
        AttributeContainerHelper atts = new AttributeContainerHelper(runtime.getName());
        atts.addAttribute(new Attribute("units", units));
        atts.addAttribute(new Attribute("standard_name", "forecast_reference_time"));
        atts.addAttribute(new Attribute("long_name", "GRIB reference time"));
        atts.addAttribute(new Attribute("calendar", Calendar.proleptic_gregorian.toString()));
        CoverageCoordAxisBuilder builder = new CoverageCoordAxisBuilder(runtime.getName(), units, "GRIB reference time", DataType.DOUBLE, AxisType.RunTime, atts, dependence, null, null, n, 0.0, 0.0, 0.0, values, this);
        builder.setSpacingFromValues(false);
        return new CoverageCoordAxis1D(builder);
    }

    private CoverageCoordAxis makeRuntimeAuxCoord(CoordinateTime2D time2D, int ntimes) {
        CoordinateRuntime runtimeU = time2D.getRuntimeCoordinate();
        List<Double> runOffsets = runtimeU.getOffsetsInTimeUnits();
        double[] values = new double[ntimes];
        int count = 0;
        for (int run = 0; run < time2D.getNruns(); ++run) {
            CoordinateTimeAbstract timeCoord = time2D.getTimeCoordinate(run);
            for (int time = 0; time < timeCoord.getNCoords(); ++time) {
                values[count++] = runOffsets.get(run);
            }
        }
        boolean isScalar = time2D.getNruns() == 1;
        CoverageCoordAxis.DependenceType dependence = isScalar ? CoverageCoordAxis.DependenceType.scalar : CoverageCoordAxis.DependenceType.dependent;
        String refName = "ref" + time2D.getName();
        AttributeContainerHelper atts = new AttributeContainerHelper(time2D.getName());
        atts.addAttribute(new Attribute("units", time2D.getTimeUdUnit()));
        atts.addAttribute(new Attribute("standard_name", "forecast_reference_time"));
        atts.addAttribute(new Attribute("long_name", "GRIB reference time"));
        atts.addAttribute(new Attribute("calendar", Calendar.proleptic_gregorian.toString()));
        CoverageCoordAxisBuilder builder = new CoverageCoordAxisBuilder(refName, time2D.getTimeUdUnit(), "GRIB reference time", DataType.DOUBLE, AxisType.RunTime, atts, dependence, time2D.getName(), null, ntimes, 0.0, 0.0, 0.0, values, this);
        builder.setSpacingFromValues(false);
        return new CoverageCoordAxis1D(builder);
    }

    private CoverageCoordAxis makeRuntimeAuxCoord(CoordinateTimeAbstract time) {
        if (time.getTime2runtime() == null) {
            return null;
        }
        String refName = "ref" + time.getName();
        int length = time.getSize();
        double[] data = new double[length];
        for (int i = 0; i < length; ++i) {
            data[i] = Double.NaN;
        }
        int count = 0;
        CoordinateRuntime master = this.gribCollection.getMasterRuntime();
        List<Double> masterOffsets = master.getOffsetsInTimeUnits();
        for (int masterIdx : time.getTime2runtime()) {
            data[count++] = masterOffsets.get(masterIdx - 1);
        }
        AttributeContainerHelper atts = new AttributeContainerHelper(time.getName());
        atts.addAttribute(new Attribute("units", time.getTimeUdUnit()));
        atts.addAttribute(new Attribute("standard_name", "forecast_reference_time"));
        atts.addAttribute(new Attribute("long_name", "GRIB reference time"));
        atts.addAttribute(new Attribute("calendar", Calendar.proleptic_gregorian.toString()));
        CoverageCoordAxisBuilder builder = new CoverageCoordAxisBuilder(refName, master.getUnit(), "GRIB reference time", DataType.DOUBLE, AxisType.RunTime, atts, CoverageCoordAxis.DependenceType.dependent, time.getName(), null, length, 0.0, 0.0, 0.0, data, this);
        builder.setSpacingFromValues(false);
        return new CoverageCoordAxis1D(builder);
    }

    private CoverageCoordAxis makeCoordAxis(CoordinateTime time) {
        this.trackDateRange(time.makeCalendarDateRange(null));
        List<Integer> offsets = time.getOffsetSorted();
        int n = offsets.size();
        double[] values = new double[n];
        int count = 0;
        for (int offset : offsets) {
            values[count++] = offset;
        }
        AttributeContainerHelper atts = new AttributeContainerHelper(time.getName());
        atts.addAttribute(new Attribute("units", time.getUnit()));
        atts.addAttribute(new Attribute("standard_name", "time"));
        atts.addAttribute(new Attribute("long_name", "GRIB forecast or observation time"));
        atts.addAttribute(new Attribute("calendar", Calendar.proleptic_gregorian.toString()));
        CoverageCoordAxisBuilder builder = new CoverageCoordAxisBuilder(time.getName(), time.getTimeUdUnit(), "GRIB forecast or observation time", DataType.DOUBLE, AxisType.Time, atts, CoverageCoordAxis.DependenceType.independent, null, null, n, 0.0, 0.0, 0.0, values, this);
        builder.setSpacingFromValues(false);
        return new CoverageCoordAxis1D(builder);
    }

    private CoverageCoordAxis makeCoordAxis(CoordinateTimeIntv time) {
        this.trackDateRange(time.makeCalendarDateRange(null));
        List<TimeCoord.Tinv> offsets = time.getTimeIntervals();
        int n = offsets.size();
        double[] values = new double[2 * n];
        int count = 0;
        for (TimeCoord.Tinv offset : offsets) {
            values[count++] = offset.getBounds1();
            values[count++] = offset.getBounds2();
        }
        AttributeContainerHelper atts = new AttributeContainerHelper(time.getName());
        atts.addAttribute(new Attribute("units", time.getUnit()));
        atts.addAttribute(new Attribute("standard_name", "time"));
        atts.addAttribute(new Attribute("long_name", "GRIB forecast or observation time"));
        atts.addAttribute(new Attribute("calendar", Calendar.proleptic_gregorian.toString()));
        CoverageCoordAxisBuilder builder = new CoverageCoordAxisBuilder(time.getName(), time.getTimeUdUnit(), "GRIB forecast or observation time", DataType.DOUBLE, AxisType.Time, atts, CoverageCoordAxis.DependenceType.independent, null, null, n, 0.0, 0.0, 0.0, values, this);
        builder.setSpacingFromValues(true);
        return new CoverageCoordAxis1D(builder);
    }

    private CoverageCoordAxis makeCoordAxis(CoordinateVert vertCoord) {
        double[] values;
        List<VertCoord.Level> levels = vertCoord.getLevelSorted();
        int n = vertCoord.getSize();
        if (vertCoord.isLayer()) {
            int count = 0;
            values = new double[2 * n];
            for (int i = 0; i < n; ++i) {
                values[count++] = levels.get(i).getValue1();
                values[count++] = levels.get(i).getValue2();
            }
        } else {
            values = new double[n];
            for (int i = 0; i < n; ++i) {
                values[i] = levels.get(i).getValue1();
            }
        }
        AttributeContainerHelper atts = new AttributeContainerHelper(vertCoord.getName());
        String units = vertCoord.getUnit();
        atts.addAttribute(new Attribute("units", units));
        AxisType axisType = AxisType.GeoZ;
        if (SimpleUnit.isCompatible("mbar", units)) {
            axisType = AxisType.Pressure;
        } else if (SimpleUnit.isCompatible("m", units)) {
            axisType = AxisType.Height;
        }
        String desc = vertCoord.getVertUnit().getDesc();
        if (desc != null) {
            atts.addAttribute(new Attribute("long_name", desc));
        }
        atts.addAttribute(new Attribute("positive", vertCoord.isPositiveUp() ? "up" : "down"));
        CoverageCoordAxisBuilder builder = new CoverageCoordAxisBuilder(vertCoord.getName(), vertCoord.getUnit(), null, DataType.DOUBLE, axisType, atts, CoverageCoordAxis.DependenceType.independent, null, null, n, 0.0, 0.0, 0.0, values, this);
        builder.setSpacingFromValues(vertCoord.isLayer());
        return new CoverageCoordAxis1D(builder);
    }

    private CoverageCoordAxis makeCoordAxis(CoordinateEns ensCoord) {
        int n = ensCoord.getSize();
        double[] values = new double[n];
        for (int i = 0; i < n; ++i) {
            values[i] = ((EnsCoord.Coord)ensCoord.getValue(i)).getEnsMember();
        }
        AttributeContainerHelper atts = new AttributeContainerHelper(ensCoord.getName());
        String units = ensCoord.getUnit();
        atts.addAttribute(new Attribute("units", units));
        CoverageCoordAxisBuilder builder = new CoverageCoordAxisBuilder(ensCoord.getName(), units, null, DataType.DOUBLE, AxisType.Ensemble, atts, CoverageCoordAxis.DependenceType.independent, null, null, ensCoord.getSize(), 0.0, 0.0, 0.0, values, this);
        builder.setSpacingFromValues(false);
        return new CoverageCoordAxis1D(builder);
    }

    private CoverageCoordSys makeCoordSys(GribCollectionImmutable.VariableIndex gribVar, List<CoverageTransform> transforms, Map<Coordinate, List<CoverageCoordAxis>> coord2axisMap) {
        List<String> axisNames = this.makeAxisNameList(gribVar, coord2axisMap);
        List<String> transformNames = transforms.stream().map(CoverageTransform::getName).collect(Collectors.toList());
        return new CoverageCoordSys(null, axisNames, transformNames, this.coverageType);
    }

    private List<String> makeAxisNameList(GribCollectionImmutable.VariableIndex gribVar, Map<Coordinate, List<CoverageCoordAxis>> coord2axisMap) {
        ArrayList<NameAndType> names = new ArrayList<NameAndType>();
        for (Coordinate axis : gribVar.getCoordinates()) {
            List<CoverageCoordAxis> coordList = coord2axisMap.get(axis);
            if (coordList == null) continue;
            for (CoverageCoordAxis coord : coordList) {
                names.add(new NameAndType(coord.getName(), coord.getAxisType()));
            }
        }
        Collections.sort(names, (o1, o2) -> o1.type.axisOrder() - o2.type.axisOrder());
        List<String> axisNames = names.stream().map(o -> o.name).collect(Collectors.toList());
        if (this.isCurvilinearOrthogonal) {
            Grib2Utils.LatLonCoordType type = Grib2Utils.getLatLon2DcoordType(gribVar.makeVariableDescription());
            if (type != null) {
                switch (type) {
                    case U: {
                        axisNames.add(Grib2Utils.LatLon2DCoord.U_Latitude.toString());
                        axisNames.add(Grib2Utils.LatLon2DCoord.U_Longitude.toString());
                        break;
                    }
                    case V: {
                        axisNames.add(Grib2Utils.LatLon2DCoord.V_Latitude.toString());
                        axisNames.add(Grib2Utils.LatLon2DCoord.V_Longitude.toString());
                        break;
                    }
                    case P: {
                        axisNames.add(Grib2Utils.LatLon2DCoord.P_Latitude.toString());
                        axisNames.add(Grib2Utils.LatLon2DCoord.P_Longitude.toString());
                    }
                }
            }
        } else if (this.isLatLon) {
            axisNames.add("latitude");
            axisNames.add("longitude");
        } else {
            axisNames.add("y");
            axisNames.add("x");
        }
        return axisNames;
    }

    private Coverage makeCoverage(GribCollectionImmutable.VariableIndex gribVar, Map<Coordinate, List<CoverageCoordAxis>> coord2axisMap) {
        AttributeContainerHelper atts = new AttributeContainerHelper(gribVar.makeVariableName());
        atts.addAttribute(new Attribute("long_name", gribVar.makeVariableDescription()));
        atts.addAttribute(new Attribute("units", gribVar.makeVariableUnits()));
        this.gribCollection.addVariableAttributes(atts, gribVar);
        String coordSysName = CoverageCoordSys.makeCoordSysName(this.makeAxisNameList(gribVar, coord2axisMap));
        return new Coverage(gribVar.makeVariableName(), DataType.FLOAT, atts.getAttributes(), coordSysName, gribVar.makeVariableUnits(), gribVar.makeVariableDescription(), this, gribVar);
    }

    @Override
    public double[] readCoordValues(CoverageCoordAxis coordAxis) throws IOException {
        if (coordAxis instanceof LatLonAxis2D) {
            return this.readLatLonAxis2DCoordValues((LatLonAxis2D)coordAxis);
        }
        Optional<Coordinate> opt = this.group.findCoordinate(coordAxis.getName());
        if (!opt.isPresent()) {
            throw new IllegalStateException();
        }
        Coordinate coord = opt.get();
        if (coord instanceof CoordinateTime) {
            List<Integer> offsets = ((CoordinateTime)coord).getOffsetSorted();
            double[] values = new double[offsets.size()];
            int count = 0;
            for (int val : offsets) {
                values[count++] = val;
            }
            return values;
        }
        if (coord instanceof CoordinateTimeIntv) {
            double[] values;
            List<TimeCoord.Tinv> intv = ((CoordinateTimeIntv)coord).getTimeIntervals();
            if (coordAxis.getSpacing() == CoverageCoordAxis.Spacing.discontiguousInterval) {
                values = new double[2 * intv.size()];
                int count = 0;
                for (TimeCoord.Tinv val : intv) {
                    values[count++] = val.getBounds1();
                    values[count++] = val.getBounds2();
                }
            } else {
                values = new double[intv.size() + 1];
                int count = 0;
                for (TimeCoord.Tinv val : intv) {
                    values[count++] = val.getBounds1();
                    values[count] = val.getBounds2();
                }
            }
            return values;
        }
        if (coord instanceof CoordinateRuntime) {
            List<Double> offsets = ((CoordinateRuntime)coord).getOffsetsInTimeUnits();
            double[] values = new double[offsets.size()];
            int count = 0;
            for (double val : offsets) {
                values[count++] = val;
            }
            return values;
        }
        throw new IllegalStateException();
    }

    public double[] readLatLonAxis2DCoordValues(LatLonAxis2D coordAxis) throws IOException {
        Array data;
        GribCollectionImmutable.VariableIndex vindex = (GribCollectionImmutable.VariableIndex)coordAxis.getUserObject();
        int[] shape = coordAxis.getShape();
        ArrayList<RangeIterator> ranges = new ArrayList<RangeIterator>();
        ArrayList<Integer> fullShape = new ArrayList<Integer>();
        for (Coordinate coord : vindex.getCoordinates()) {
            ranges.add(new Range(1));
            fullShape.add(coord.getNCoords());
        }
        ranges.add(new Range(shape[0]));
        fullShape.add(shape[0]);
        ranges.add(new Range(shape[1]));
        fullShape.add(shape[1]);
        SectionIterable siter = new SectionIterable(ranges, fullShape);
        GribDataReader dataReader = GribDataReader.factory(this.gribCollection, vindex);
        try {
            data = dataReader.readData(siter);
        }
        catch (InvalidRangeException e) {
            throw new RuntimeException(e);
        }
        return (double[])data.get1DJavaArray(DataType.DOUBLE);
    }

    @Override
    public GeoReferencedArray readData(Coverage coverage, SubsetParams params, boolean canonicalOrder) throws IOException, InvalidRangeException {
        GribCollectionImmutable.VariableIndex vindex = (GribCollectionImmutable.VariableIndex)coverage.getUserObject();
        CoverageCoordSys orgCoordSys = coverage.getCoordSys();
        ucar.nc2.util.Optional<CoverageCoordSys> opt = orgCoordSys.subset(params, false, true);
        if (!opt.isPresent()) {
            throw new InvalidRangeException(opt.getErrorMessage());
        }
        CoverageCoordSys subsetCoordSys = opt.get();
        ArrayList<CoverageCoordAxis> coordsSetAxes = new ArrayList<CoverageCoordAxis>();
        block6: for (Coordinate gribCoord : vindex.getCoordinates()) {
            switch (gribCoord.getType()) {
                case runtime: {
                    CoverageCoordAxis runAxis = subsetCoordSys.getAxis(AxisType.RunTime);
                    coordsSetAxes.addAll(this.axisAndDependents(runAxis, subsetCoordSys));
                    break;
                }
                case time2D: {
                    CoverageCoordAxis toAxis;
                    if (this.ds.getType().isTwoD()) {
                        toAxis = subsetCoordSys.getAxis(AxisType.TimeOffset);
                        if (toAxis == null) continue block6;
                        coordsSetAxes.addAll(this.axisAndDependents(toAxis, subsetCoordSys));
                        break;
                    }
                    toAxis = subsetCoordSys.getAxis(AxisType.Time);
                    if (toAxis == null) continue block6;
                    coordsSetAxes.addAll(this.axisAndDependents(toAxis, subsetCoordSys));
                    break;
                }
                case vert: {
                    CoverageCoordAxis1D vertAxis = (CoverageCoordAxis1D)subsetCoordSys.getZAxis();
                    coordsSetAxes.add(vertAxis);
                    break;
                }
                case time: 
                case timeIntv: 
                case ens: {
                    CoverageCoordAxis axis = subsetCoordSys.getAxis(gribCoord.getType().axisType);
                    coordsSetAxes.addAll(this.axisAndDependents(axis, subsetCoordSys));
                }
            }
        }
        ArrayList<CoverageCoordAxis> geoArrayAxes = new ArrayList<CoverageCoordAxis>(coordsSetAxes);
        geoArrayAxes.add(subsetCoordSys.getYAxis());
        geoArrayAxes.add(subsetCoordSys.getXAxis());
        List<RangeIterator> yxRange = subsetCoordSys.getHorizCoordSys().getRanges();
        CoordsSet coordIter = CoordsSet.factory(subsetCoordSys.isConstantForecast(), coordsSetAxes);
        GribDataReader dataReader = GribDataReader.factory(this.gribCollection, vindex);
        Array data = dataReader.readData2(coordIter, yxRange.get(0), yxRange.get(1));
        return new GeoReferencedArray(coverage.getName(), coverage.getDataType(), data, subsetCoordSys);
    }

    private List<CoverageCoordAxis> axisAndDependents(CoverageCoordAxis axis, CoverageCoordSys csys) {
        ArrayList<CoverageCoordAxis> result = new ArrayList<CoverageCoordAxis>();
        if (axis.getDependenceType() != CoverageCoordAxis.DependenceType.dependent) {
            result.add(axis);
        }
        for (CoverageCoordAxis dependent : csys.getDependentAxes(axis)) {
            result.add(dependent);
        }
        return result;
    }

    private class NameAndType {
        String name;
        AxisType type;

        public NameAndType(String name, AxisType type) {
            this.name = name;
            this.type = type;
        }
    }
}

