/*
 * Decompiled with CFR 0.152.
 */
package visad.gifts;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.rmi.RemoteException;
import java.util.StringTokenizer;
import java.util.Vector;
import visad.DataImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Integer1DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.VisADException;

public class TextForm {
    boolean eastLongitudePositive = true;
    String longitudeName = null;
    String latitudeName = null;

    public TextForm() {
        this(true, "Longitude", "Latitude");
    }

    public TextForm(String lon_name, String lat_name) {
        this(true, lon_name, lat_name);
    }

    public TextForm(boolean elp, String lon_name, String lat_name) {
        this.eastLongitudePositive = elp;
        this.longitudeName = lon_name;
        this.latitudeName = lat_name;
    }

    public DataImpl open(String file_path) throws VisADException, RemoteException {
        DataImpl data = null;
        try {
            data = this.getFileData(file_path);
        }
        catch (FileNotFoundException e1) {
            System.out.println(e1.getMessage());
        }
        catch (IOException e2) {
            System.out.println(e2.getMessage());
        }
        if (!this.eastLongitudePositive) {
            return this.switchLongitudeSign(data);
        }
        return data;
    }

    private DataImpl getFileData(String file_path) throws VisADException, RemoteException, FileNotFoundException, IOException {
        Object data = null;
        MathType type = null;
        String line = null;
        Vector<String> lines = new Vector<String>();
        String header = null;
        boolean n_lines = false;
        FileReader reader = new FileReader(file_path);
        LineNumberReader line_reader = new LineNumberReader(reader);
        header = line_reader.readLine();
        lines.addElement(header);
        String line_1 = line_reader.readLine();
        lines.addElement(line_1);
        int[][] indexes = new int[1][];
        type = this.getFileType(header, line_1, indexes);
        int tup_dim = ((RealTupleType)((FunctionType)type).getRange()).getDimension();
        while ((line = line_reader.readLine()) != null) {
            lines.addElement(line);
        }
        int n_samples = lines.size() - 1;
        float[][] values = new float[tup_dim][n_samples];
        for (int ii = 0; ii < n_samples; ++ii) {
            StringTokenizer tokens = new StringTokenizer((String)lines.elementAt(ii + 1));
            int cnt = 0;
            while (tokens.hasMoreElements()) {
                String token = tokens.nextToken();
                for (int jj = 0; jj < tup_dim; ++jj) {
                    if (cnt != indexes[0][jj]) continue;
                    values[jj][ii] = Float.valueOf(token).floatValue();
                }
                ++cnt;
            }
        }
        Integer1DSet domainSet = new Integer1DSet((MathType)((FunctionType)type).getDomain(), n_samples);
        FlatField f_field = new FlatField((FunctionType)type, domainSet);
        f_field.setSamples(values);
        return f_field;
    }

    private MathType getFileType(String header, String line_1, int[][] indexes) throws VisADException, RemoteException {
        StringTokenizer tokens = new StringTokenizer(header);
        StringTokenizer values = new StringTokenizer(line_1);
        Vector<String> names = new Vector<String>();
        Vector<RealType> types = new Vector<RealType>();
        Vector comps = new Vector();
        while (tokens.hasMoreElements()) {
            String token = tokens.nextToken();
            names.addElement(token);
        }
        int tup_dim = names.size();
        indexes[0] = new int[tup_dim];
        int cnt_num = 0;
        RealType r_type = null;
        for (int ii = 0; ii < tup_dim; ++ii) {
            try {
                Float.valueOf(values.nextToken());
                String name = (String)names.elementAt(ii);
                r_type = name.equals(this.longitudeName) ? RealType.Longitude : (name.equals(this.latitudeName) ? RealType.Latitude : RealType.getRealType(name));
                types.addElement(r_type);
                indexes[0][cnt_num++] = ii;
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        RealType[] r_types = new RealType[types.size()];
        for (int ii = 0; ii < r_types.length; ++ii) {
            r_types[ii] = (RealType)types.elementAt(ii);
        }
        RealTupleType range = new RealTupleType(r_types);
        RealType domain = RealType.getRealType("index");
        FunctionType type = new FunctionType(domain, range);
        return type;
    }

    private DataImpl switchLongitudeSign(DataImpl data) throws VisADException, RemoteException {
        int idx = ((RealTupleType)((FunctionType)data.getType()).getRange()).getIndex("Longitude");
        double[][] values = ((FlatField)data).getValues();
        for (int ii = 0; ii < values[idx].length; ++ii) {
            values[idx][ii] = -1.0 * values[idx][ii];
        }
        ((FlatField)data).setSamples(values);
        return data;
    }
}

