/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.FilenameMangler;
import HTTPClient.HttpHeaderElement;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.Util;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.BitSet;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class Codecs {
    private static BitSet BoundChar;
    private static BitSet EBCDICUnsafeChar;
    private static byte[] Base64EncMap;
    private static byte[] Base64DecMap;
    private static char[] UUEncMap;
    private static byte[] UUDecMap;
    private static final String ContDisp = "\r\nContent-Disposition: form-data; name=\"";
    private static final String FileName = "\"; filename=\"";
    private static final String ContType = "\r\nContent-Type: ";
    private static final String Boundary = "\r\n----------ieoau._._+2_8_GoodLuck8.3-dskdfJwSJKl234324jfLdsjfdAuaoei-----";
    private static NVPair[] dummy;

    private Codecs() {
    }

    public static final String base64Encode(String str) {
        if (str == null) {
            return null;
        }
        try {
            return new String(Codecs.base64Encode(str.getBytes("8859_1")), "8859_1");
        }
        catch (UnsupportedEncodingException uee) {
            throw new Error(uee.toString());
        }
    }

    public static final byte[] base64Encode(byte[] data) {
        int sidx;
        if (data == null) {
            return null;
        }
        byte[] dest = new byte[(data.length + 2) / 3 * 4];
        int didx = 0;
        for (sidx = 0; sidx < data.length - 2; sidx += 3) {
            dest[didx++] = Base64EncMap[data[sidx] >>> 2 & 0x3F];
            dest[didx++] = Base64EncMap[data[sidx + 1] >>> 4 & 0xF | data[sidx] << 4 & 0x3F];
            dest[didx++] = Base64EncMap[data[sidx + 2] >>> 6 & 3 | data[sidx + 1] << 2 & 0x3F];
            dest[didx++] = Base64EncMap[data[sidx + 2] & 0x3F];
        }
        if (sidx < data.length) {
            dest[didx++] = Base64EncMap[data[sidx] >>> 2 & 0x3F];
            if (sidx < data.length - 1) {
                dest[didx++] = Base64EncMap[data[sidx + 1] >>> 4 & 0xF | data[sidx] << 4 & 0x3F];
                dest[didx++] = Base64EncMap[data[sidx + 1] << 2 & 0x3F];
            } else {
                dest[didx++] = Base64EncMap[data[sidx] << 4 & 0x3F];
            }
        }
        while (didx < dest.length) {
            dest[didx] = 61;
            ++didx;
        }
        return dest;
    }

    public static final String base64Decode(String str) {
        if (str == null) {
            return null;
        }
        try {
            return new String(Codecs.base64Decode(str.getBytes("8859_1")), "8859_1");
        }
        catch (UnsupportedEncodingException uee) {
            throw new Error(uee.toString());
        }
    }

    public static final byte[] base64Decode(byte[] data) {
        int didx;
        if (data == null) {
            return null;
        }
        int tail = data.length;
        while (data[tail - 1] == 61) {
            --tail;
        }
        byte[] dest = new byte[tail - data.length / 4];
        for (int idx = 0; idx < data.length; ++idx) {
            data[idx] = Base64DecMap[data[idx]];
        }
        int sidx = 0;
        for (didx = 0; didx < dest.length - 2; didx += 3) {
            dest[didx] = (byte)(data[sidx] << 2 & 0xFF | data[sidx + 1] >>> 4 & 3);
            dest[didx + 1] = (byte)(data[sidx + 1] << 4 & 0xFF | data[sidx + 2] >>> 2 & 0xF);
            dest[didx + 2] = (byte)(data[sidx + 2] << 6 & 0xFF | data[sidx + 3] & 0x3F);
            sidx += 4;
        }
        if (didx < dest.length) {
            dest[didx] = (byte)(data[sidx] << 2 & 0xFF | data[sidx + 1] >>> 4 & 3);
        }
        if (++didx < dest.length) {
            dest[didx] = (byte)(data[sidx + 1] << 4 & 0xFF | data[sidx + 2] >>> 2 & 0xF);
        }
        return dest;
    }

    public static final char[] uuencode(byte[] data) {
        int idx;
        if (data == null) {
            return null;
        }
        if (data.length == 0) {
            return new char[0];
        }
        int line_len = 45;
        char[] nl = System.getProperty("line.separator", "\n").toCharArray();
        char[] dest = new char[(data.length + 2) / 3 * 4 + (data.length + line_len - 1) / line_len * (nl.length + 1)];
        int sidx = 0;
        int didx = 0;
        while (sidx + line_len < data.length) {
            dest[didx++] = UUEncMap[line_len];
            int end = sidx + line_len;
            while (sidx < end) {
                dest[didx++] = UUEncMap[data[sidx] >>> 2 & 0x3F];
                dest[didx++] = UUEncMap[data[sidx + 1] >>> 4 & 0xF | data[sidx] << 4 & 0x3F];
                dest[didx++] = UUEncMap[data[sidx + 2] >>> 6 & 3 | data[sidx + 1] << 2 & 0x3F];
                dest[didx++] = UUEncMap[data[sidx + 2] & 0x3F];
                sidx += 3;
            }
            for (idx = 0; idx < nl.length; ++idx) {
                dest[didx++] = nl[idx];
            }
        }
        dest[didx++] = UUEncMap[data.length - sidx];
        while (sidx + 2 < data.length) {
            dest[didx++] = UUEncMap[data[sidx] >>> 2 & 0x3F];
            dest[didx++] = UUEncMap[data[sidx + 1] >>> 4 & 0xF | data[sidx] << 4 & 0x3F];
            dest[didx++] = UUEncMap[data[sidx + 2] >>> 6 & 3 | data[sidx + 1] << 2 & 0x3F];
            dest[didx++] = UUEncMap[data[sidx + 2] & 0x3F];
            sidx += 3;
        }
        if (sidx < data.length - 1) {
            dest[didx++] = UUEncMap[data[sidx] >>> 2 & 0x3F];
            dest[didx++] = UUEncMap[data[sidx + 1] >>> 4 & 0xF | data[sidx] << 4 & 0x3F];
            dest[didx++] = UUEncMap[data[sidx + 1] << 2 & 0x3F];
            dest[didx++] = UUEncMap[0];
        } else if (sidx < data.length) {
            dest[didx++] = UUEncMap[data[sidx] >>> 2 & 0x3F];
            dest[didx++] = UUEncMap[data[sidx] << 4 & 0x3F];
            dest[didx++] = UUEncMap[0];
            dest[didx++] = UUEncMap[0];
        }
        for (idx = 0; idx < nl.length; ++idx) {
            dest[didx++] = nl[idx];
        }
        if (didx != dest.length) {
            throw new Error("Calculated " + dest.length + " chars but wrote " + didx + " chars!");
        }
        return dest;
    }

    private static final byte[] uudecode(BufferedReader rdr) throws ParseException, IOException {
        String line;
        while ((line = rdr.readLine()) != null && !line.startsWith("begin ")) {
        }
        if (line == null) {
            throw new ParseException("'begin' line not found");
        }
        StringTokenizer tok = new StringTokenizer(line);
        tok.nextToken();
        try {
            int file_mode = Integer.parseInt(tok.nextToken(), 8);
        }
        catch (Exception e) {
            throw new ParseException("Invalid mode on line: " + line);
        }
        try {
            String file_name = tok.nextToken();
        }
        catch (NoSuchElementException e) {
            throw new ParseException("No file name found on line: " + line);
        }
        byte[] body = new byte[1000];
        int off = 0;
        while ((line = rdr.readLine()) != null && !line.equals("end")) {
            byte[] tmp = Codecs.uudecode(line.toCharArray());
            if (off + tmp.length > body.length) {
                body = Util.resizeArray(body, off + 1000);
            }
            System.arraycopy(tmp, 0, body, off, tmp.length);
            off += tmp.length;
        }
        if (line == null) {
            throw new ParseException("'end' line not found");
        }
        return Util.resizeArray(body, off);
    }

    public static final byte[] uudecode(char[] data) {
        if (data == null) {
            return null;
        }
        byte[] dest = new byte[data.length / 4 * 3];
        int sidx = 0;
        int didx = 0;
        while (sidx < data.length) {
            byte B;
            byte A2;
            byte len = UUDecMap[data[sidx++]];
            int end = didx + len;
            while (didx < end - 2) {
                A2 = UUDecMap[data[sidx]];
                B = UUDecMap[data[sidx + 1]];
                byte C2 = UUDecMap[data[sidx + 2]];
                byte D = UUDecMap[data[sidx + 3]];
                dest[didx++] = (byte)(A2 << 2 & 0xFF | B >>> 4 & 3);
                dest[didx++] = (byte)(B << 4 & 0xFF | C2 >>> 2 & 0xF);
                dest[didx++] = (byte)(C2 << 6 & 0xFF | D & 0x3F);
                sidx += 4;
            }
            if (didx < end) {
                A2 = UUDecMap[data[sidx]];
                B = UUDecMap[data[sidx + 1]];
                dest[didx++] = (byte)(A2 << 2 & 0xFF | B >>> 4 & 3);
            }
            if (didx < end) {
                byte B2 = UUDecMap[data[sidx + 1]];
                byte C3 = UUDecMap[data[sidx + 2]];
                dest[didx++] = (byte)(B2 << 4 & 0xFF | C3 >>> 2 & 0xF);
            }
            while (sidx < data.length && data[sidx] != '\n' && data[sidx] != '\r') {
                ++sidx;
            }
            while (sidx < data.length && (data[sidx] == '\n' || data[sidx] == '\r')) {
                ++sidx;
            }
        }
        return Util.resizeArray(dest, didx);
    }

    public static final String quotedPrintableEncode(String str) {
        if (str == null) {
            return null;
        }
        char[] map = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] nl = System.getProperty("line.separator", "\n").toCharArray();
        char[] res = new char[(int)((double)str.length() * 1.5)];
        char[] src = str.toCharArray();
        int cnt = 0;
        int didx = 1;
        boolean last = false;
        int slen = str.length();
        for (int sidx = 0; sidx < slen; ++sidx) {
            char ch = src[sidx];
            if (ch == nl[0] && Codecs.match(src, sidx, nl)) {
                if (res[didx - 1] == ' ') {
                    res[didx - 1] = 61;
                    res[didx++] = 50;
                    res[didx++] = 48;
                } else if (res[didx - 1] == '\t') {
                    res[didx - 1] = 61;
                    res[didx++] = 48;
                    res[didx++] = 57;
                }
                res[didx++] = 13;
                res[didx++] = 10;
                sidx += nl.length - 1;
                cnt = didx;
            } else if (ch > '~' || ch < ' ' && ch != '\t' || ch == '=' || EBCDICUnsafeChar.get(ch)) {
                res[didx++] = 61;
                res[didx++] = map[(ch & 0xF0) >>> 4];
                res[didx++] = map[ch & 0xF];
            } else {
                res[didx++] = ch;
            }
            if (didx > cnt + 70) {
                res[didx++] = 61;
                res[didx++] = 13;
                res[didx++] = 10;
                cnt = didx;
            }
            if (didx <= res.length - 5) continue;
            res = Util.resizeArray(res, res.length + 500);
        }
        return String.valueOf(res, 1, didx - 1);
    }

    private static final boolean match(char[] str, int start, char[] arr) {
        if (str.length < start + arr.length) {
            return false;
        }
        for (int idx = 1; idx < arr.length; ++idx) {
            if (str[start + idx] == arr[idx]) continue;
            return false;
        }
        return true;
    }

    public static final String quotedPrintableDecode(String str) throws ParseException {
        if (str == null) {
            return null;
        }
        char[] res = new char[(int)((double)str.length() * 1.1)];
        char[] src = str.toCharArray();
        char[] nl = System.getProperty("line.separator", "\n").toCharArray();
        int last = 0;
        int didx = 0;
        int slen = str.length();
        int sidx = 0;
        while (sidx < slen) {
            char ch;
            if ((ch = src[sidx++]) == '=') {
                if (sidx >= slen - 1) {
                    throw new ParseException("Premature end of input detected");
                }
                if (src[sidx] == '\n' || src[sidx] == '\r') {
                    if (src[++sidx - 1] == '\r' && src[sidx] == '\n') {
                        ++sidx;
                    }
                } else {
                    int lo;
                    int hi = Character.digit(src[sidx], 16);
                    if ((hi | (lo = Character.digit(src[sidx + 1], 16))) < 0) {
                        throw new ParseException(new String(src, sidx - 1, 3) + " is an invalid code");
                    }
                    char repl = (char)(hi << 4 | lo);
                    sidx += 2;
                    res[didx++] = repl;
                }
                last = didx;
            } else if (ch == '\n' || ch == '\r') {
                if (ch == '\r' && sidx < slen && src[sidx] == '\n') {
                    ++sidx;
                }
                for (int idx = 0; idx < nl.length; ++idx) {
                    res[last++] = nl[idx];
                }
                didx = last;
            } else {
                res[didx++] = ch;
                if (ch != ' ' && ch != '\t') {
                    last = didx;
                }
            }
            if (didx <= res.length - nl.length - 2) continue;
            res = Util.resizeArray(res, res.length + 500);
        }
        return new String(res, 0, didx);
    }

    public static final String URLEncode(String str) {
        if (str == null) {
            return null;
        }
        return URLEncoder.encode(str);
    }

    public static final String URLDecode(String str) throws ParseException {
        if (str == null) {
            return null;
        }
        char[] res = new char[str.length()];
        int didx = 0;
        for (int sidx = 0; sidx < str.length(); ++sidx) {
            char ch = str.charAt(sidx);
            if (ch == '+') {
                res[didx++] = 32;
                continue;
            }
            if (ch == '%') {
                try {
                    res[didx++] = (char)Integer.parseInt(str.substring(sidx + 1, sidx + 3), 16);
                    sidx += 2;
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new ParseException(str.substring(sidx, sidx + 3) + " is an invalid code");
                }
            }
            res[didx++] = ch;
        }
        return String.valueOf(res, 0, didx);
    }

    public static final NVPair[] mpFormDataDecode(byte[] data, String cont_type, String dir) throws IOException, ParseException {
        return Codecs.mpFormDataDecode(data, cont_type, dir, null);
    }

    public static final NVPair[] mpFormDataDecode(byte[] data, String cont_type, String dir, FilenameMangler mangler) throws IOException, ParseException {
        String bndstr = Util.getParameter("boundary", cont_type);
        if (bndstr == null) {
            throw new ParseException("'boundary' parameter not found in Content-type: " + cont_type);
        }
        byte[] srtbndry = ("--" + bndstr + "\r\n").getBytes("8859_1");
        byte[] boundary = ("\r\n--" + bndstr + "\r\n").getBytes("8859_1");
        byte[] endbndry = ("\r\n--" + bndstr + "--").getBytes("8859_1");
        int[] bs = Util.compile_search(srtbndry);
        int[] bc = Util.compile_search(boundary);
        int[] be = Util.compile_search(endbndry);
        int start = Util.findStr(srtbndry, bs, data, 0, data.length);
        if (start == -1) {
            throw new ParseException("Starting boundary not found: " + new String(srtbndry, "8859_1"));
        }
        start += srtbndry.length;
        NVPair[] res = new NVPair[10];
        boolean done = false;
        int idx = 0;
        while (!done) {
            String value;
            int next;
            int end = Util.findStr(boundary, bc, data, start, data.length);
            if (end == -1) {
                end = Util.findStr(endbndry, be, data, start, data.length);
                if (end == -1) {
                    throw new ParseException("Ending boundary not found: " + new String(endbndry, "8859_1"));
                }
                done = true;
            }
            String name = null;
            String filename = null;
            String cont_disp = null;
            while ((next = Codecs.findEOL(data, start) + 2) - 2 > start) {
                byte ch;
                String hdr = new String(data, start, next - 2 - start, "8859_1");
                start = next;
                while (next < data.length - 1 && ((ch = data[next]) == 32 || ch == 9)) {
                    next = Codecs.findEOL(data, start) + 2;
                    hdr = hdr + new String(data, start, next - 2 - start, "8859_1");
                    start = next;
                }
                if (!hdr.regionMatches(true, 0, "Content-Disposition", 0, 19)) continue;
                Vector pcd = Util.parseHeader(hdr.substring(hdr.indexOf(58) + 1));
                HttpHeaderElement elem = Util.getElement(pcd, "form-data");
                if (elem == null) {
                    throw new ParseException("Expected 'Content-Disposition: form-data' in line: " + hdr);
                }
                NVPair[] params = elem.getParams();
                filename = null;
                name = null;
                for (int pidx = 0; pidx < params.length; ++pidx) {
                    if (params[pidx].getName().equalsIgnoreCase("name")) {
                        name = params[pidx].getValue();
                    }
                    if (!params[pidx].getName().equalsIgnoreCase("filename")) continue;
                    filename = params[pidx].getValue();
                }
                if (name == null) {
                    throw new ParseException("'name' parameter not found in header: " + hdr);
                }
                cont_disp = hdr;
            }
            if ((start += 2) > end) {
                throw new ParseException("End of header not found at offset " + end);
            }
            if (cont_disp == null) {
                throw new ParseException("Missing 'Content-Disposition' header at offset " + start);
            }
            if (filename != null) {
                if (mangler != null) {
                    filename = mangler.mangleFilename(filename, name);
                }
                if (filename != null && filename.length() > 0) {
                    File file = new File(dir, filename);
                    FileOutputStream out = new FileOutputStream(file);
                    out.write(data, start, end - start);
                    out.close();
                }
                value = filename;
            } else {
                value = new String(data, start, end - start, "8859_1");
            }
            if (idx >= res.length) {
                res = Util.resizeArray(res, idx + 10);
            }
            res[idx] = new NVPair(name, value);
            start = end + boundary.length;
            ++idx;
        }
        return Util.resizeArray(res, idx);
    }

    private static final int findEOL(byte[] arr, int off) {
        while (off < arr.length - 1 && (arr[off++] != 13 || arr[off] != 10)) {
        }
        return off - 1;
    }

    public static final byte[] mpFormDataEncode(NVPair[] opts, NVPair[] files, NVPair[] ct_hdr) throws IOException {
        return Codecs.mpFormDataEncode(opts, files, ct_hdr, null);
    }

    public static final byte[] mpFormDataEncode(NVPair[] opts, NVPair[] files, NVPair[] ct_hdr, FilenameMangler mangler) throws IOException {
        int idx;
        byte[] boundary = Boundary.getBytes("8859_1");
        byte[] cont_disp = ContDisp.getBytes("8859_1");
        byte[] cont_type = ContType.getBytes("8859_1");
        byte[] filename = FileName.getBytes("8859_1");
        int len = 0;
        int hdr_len = boundary.length + cont_disp.length + 1 + 2 + 2;
        if (opts == null) {
            opts = dummy;
        }
        if (files == null) {
            files = dummy;
        }
        for (idx = 0; idx < opts.length; ++idx) {
            if (opts[idx] == null) continue;
            len += hdr_len + opts[idx].getName().length() + opts[idx].getValue().length();
        }
        for (idx = 0; idx < files.length; ++idx) {
            if (files[idx] == null) continue;
            File file = new File(files[idx].getValue());
            String fname = file.getName();
            if (mangler != null) {
                fname = mangler.mangleFilename(fname, files[idx].getName());
            }
            if (fname == null) continue;
            len += hdr_len + files[idx].getName().length() + filename.length;
            len = (int)((long)len + ((long)fname.length() + file.length()));
            String ct = CT.getContentType(file.getName());
            if (ct == null) continue;
            len += cont_type.length + ct.length();
        }
        if (len == 0) {
            ct_hdr[0] = new NVPair("Content-Type", "application/octet-stream");
            return new byte[0];
        }
        len -= 2;
        byte[] res = new byte[len += boundary.length + 2 + 2];
        int pos = 0;
        block2: for (int new_c = 0x30303030; new_c != 0x7A7A7A7A; ++new_c) {
            int idx2;
            pos = 0;
            while (!BoundChar.get(new_c & 0xFF)) {
                ++new_c;
            }
            while (!BoundChar.get(new_c >> 8 & 0xFF)) {
                new_c += 256;
            }
            while (!BoundChar.get(new_c >> 16 & 0xFF)) {
                new_c += 65536;
            }
            while (!BoundChar.get(new_c >> 24 & 0xFF)) {
                new_c += 0x1000000;
            }
            boundary[40] = (byte)(new_c & 0xFF);
            boundary[42] = (byte)(new_c >> 8 & 0xFF);
            boundary[44] = (byte)(new_c >> 16 & 0xFF);
            boundary[46] = (byte)(new_c >> 24 & 0xFF);
            int off = 2;
            int[] bnd_cmp = Util.compile_search(boundary);
            for (idx2 = 0; idx2 < opts.length; ++idx2) {
                if (opts[idx2] == null) continue;
                System.arraycopy(boundary, off, res, pos, boundary.length - off);
                off = 0;
                int start = pos += boundary.length - off;
                System.arraycopy(cont_disp, 0, res, pos, cont_disp.length);
                int nlen = opts[idx2].getName().length();
                System.arraycopy(opts[idx2].getName().getBytes("8859_1"), 0, res, pos += cont_disp.length, nlen);
                pos += nlen;
                res[pos++] = 34;
                res[pos++] = 13;
                res[pos++] = 10;
                res[pos++] = 13;
                res[pos++] = 10;
                int vlen = opts[idx2].getValue().length();
                System.arraycopy(opts[idx2].getValue().getBytes("8859_1"), 0, res, pos, vlen);
                if ((pos += vlen) - start >= boundary.length && Util.findStr(boundary, bnd_cmp, res, start, pos) != -1) continue block2;
            }
            for (idx2 = 0; idx2 < files.length; ++idx2) {
                if (files[idx2] == null) continue;
                File file = new File(files[idx2].getValue());
                String fname = file.getName();
                if (mangler != null) {
                    fname = mangler.mangleFilename(fname, files[idx2].getName());
                }
                if (fname == null) continue;
                System.arraycopy(boundary, off, res, pos, boundary.length - off);
                off = 0;
                int start = pos += boundary.length - off;
                System.arraycopy(cont_disp, 0, res, pos, cont_disp.length);
                int nlen = files[idx2].getName().length();
                System.arraycopy(files[idx2].getName().getBytes("8859_1"), 0, res, pos += cont_disp.length, nlen);
                System.arraycopy(filename, 0, res, pos += nlen, filename.length);
                nlen = fname.length();
                System.arraycopy(fname.getBytes("8859_1"), 0, res, pos += filename.length, nlen);
                pos += nlen;
                res[pos++] = 34;
                String ct = CT.getContentType(file.getName());
                if (ct != null) {
                    System.arraycopy(cont_type, 0, res, pos, cont_type.length);
                    System.arraycopy(ct.getBytes("8859_1"), 0, res, pos += cont_type.length, ct.length());
                    pos += ct.length();
                }
                res[pos++] = 13;
                res[pos++] = 10;
                res[pos++] = 13;
                res[pos++] = 10;
                nlen = (int)file.length();
                FileInputStream fin = new FileInputStream(file);
                while (nlen > 0) {
                    int got = fin.read(res, pos, nlen);
                    nlen -= got;
                    pos += got;
                }
                fin.close();
                if (pos - start >= boundary.length && Util.findStr(boundary, bnd_cmp, res, start, pos) != -1) continue block2;
            }
        }
        System.arraycopy(boundary, 0, res, pos, boundary.length);
        pos += boundary.length;
        res[pos++] = 45;
        res[pos++] = 45;
        res[pos++] = 13;
        res[pos++] = 10;
        if (pos != len) {
            throw new Error("Calculated " + len + " bytes but wrote " + pos + " bytes!");
        }
        ct_hdr[0] = new NVPair("Content-Type", "multipart/form-data; boundary=" + new String(boundary, 4, boundary.length - 4, "8859_1"));
        return res;
    }

    public static final String nv2query(NVPair[] pairs) {
        if (pairs == null) {
            return null;
        }
        StringBuffer qbuf = new StringBuffer();
        for (int idx = 0; idx < pairs.length; ++idx) {
            if (pairs[idx] == null) continue;
            qbuf.append(Codecs.URLEncode(pairs[idx].getName()) + "=" + Codecs.URLEncode(pairs[idx].getValue()) + "&");
        }
        if (qbuf.length() > 0) {
            qbuf.setLength(qbuf.length() - 1);
        }
        return qbuf.toString();
    }

    public static final NVPair[] query2nv(String query) throws ParseException {
        if (query == null) {
            return null;
        }
        int idx = -1;
        int cnt = 1;
        while ((idx = query.indexOf(38, idx + 1)) != -1) {
            ++cnt;
        }
        NVPair[] pairs = new NVPair[cnt];
        idx = 0;
        for (cnt = 0; cnt < pairs.length; ++cnt) {
            int eq = query.indexOf(61, idx);
            int end = query.indexOf(38, idx);
            if (end == -1) {
                end = query.length();
            }
            if (eq == -1 || eq >= end) {
                throw new ParseException("'=' missing in " + query.substring(idx, end));
            }
            pairs[cnt] = new NVPair(Codecs.URLDecode(query.substring(idx, eq)), Codecs.URLDecode(query.substring(eq + 1, end)));
            idx = end + 1;
        }
        return pairs;
    }

    public static final byte[] chunkedEncode(byte[] data, NVPair[] ftrs, boolean last) {
        return Codecs.chunkedEncode(data, 0, data == null ? 0 : data.length, ftrs, last);
    }

    public static final byte[] chunkedEncode(byte[] data, int off, int len, NVPair[] ftrs, boolean last) {
        if (data == null) {
            data = new byte[]{};
            len = 0;
        }
        if (last && ftrs == null) {
            ftrs = new NVPair[]{};
        }
        String hex_len = Integer.toString(len, 16);
        int res_len = 0;
        if (len > 0) {
            res_len += hex_len.length() + 2 + len + 2;
        }
        if (last) {
            res_len += 3;
            for (int idx = 0; idx < ftrs.length; ++idx) {
                res_len += ftrs[idx].getName().length() + 2 + ftrs[idx].getValue().length() + 2;
            }
            res_len += 2;
        }
        byte[] res = new byte[res_len];
        int r_off = 0;
        if (len > 0) {
            int hlen = hex_len.length();
            try {
                System.arraycopy(hex_len.getBytes("8859_1"), 0, res, r_off, hlen);
            }
            catch (UnsupportedEncodingException uee) {
                throw new Error(uee.toString());
            }
            r_off += hlen;
            res[r_off++] = 13;
            res[r_off++] = 10;
            System.arraycopy(data, off, res, r_off, len);
            r_off += len;
            res[r_off++] = 13;
            res[r_off++] = 10;
        }
        if (last) {
            res[r_off++] = 48;
            res[r_off++] = 13;
            res[r_off++] = 10;
            for (int idx = 0; idx < ftrs.length; ++idx) {
                int nlen = ftrs[idx].getName().length();
                try {
                    System.arraycopy(ftrs[idx].getName().getBytes("8859_1"), 0, res, r_off, nlen);
                }
                catch (UnsupportedEncodingException uee) {
                    throw new Error(uee.toString());
                }
                r_off += nlen;
                res[r_off++] = 58;
                res[r_off++] = 32;
                int vlen = ftrs[idx].getValue().length();
                try {
                    System.arraycopy(ftrs[idx].getValue().getBytes("8859_1"), 0, res, r_off, vlen);
                }
                catch (UnsupportedEncodingException uee) {
                    throw new Error(uee.toString());
                }
                r_off += vlen;
                res[r_off++] = 13;
                res[r_off++] = 10;
            }
            res[r_off++] = 13;
            res[r_off++] = 10;
        }
        if (r_off != res.length) {
            throw new Error("Calculated " + res.length + " bytes but wrote " + r_off + " bytes!");
        }
        return res;
    }

    public static final Object chunkedDecode(InputStream input) throws ParseException, IOException {
        String line;
        long clen = Codecs.getChunkLength(input);
        if (clen > Integer.MAX_VALUE) {
            throw new ParseException("Can't deal with chunk lengths greater Integer.MAX_VALUE: " + clen + " > " + Integer.MAX_VALUE);
        }
        if (clen > 0L) {
            int off;
            byte[] res = new byte[(int)clen];
            int len = 0;
            for (off = 0; len != -1 && off < res.length; off += len) {
                len = input.read(res, off, res.length - off);
            }
            if (len == -1) {
                throw new ParseException("Premature EOF while reading chunk;Expected: " + res.length + " Bytes, " + "Received: " + (off + 1) + " Bytes");
            }
            input.read();
            input.read();
            return res;
        }
        NVPair[] res = new NVPair[]{};
        BufferedReader reader = new BufferedReader(new InputStreamReader(input, "8859_1"));
        while ((line = reader.readLine()) != null && line.length() > 0) {
            int colon = line.indexOf(58);
            if (colon == -1) {
                throw new ParseException("Error in Footer format: no ':' found in '" + line + "'");
            }
            res = Util.resizeArray(res, res.length + 1);
            res[res.length - 1] = new NVPair(line.substring(0, colon).trim(), line.substring(colon + 1).trim());
        }
        return res;
    }

    static final long getChunkLength(InputStream input) throws ParseException, IOException {
        int ch;
        byte[] hex_len = new byte[16];
        int off = 0;
        while ((ch = input.read()) > 0 && (ch == 32 || ch == 9)) {
        }
        if (ch < 0) {
            throw new EOFException("Premature EOF while reading chunk length");
        }
        hex_len[off++] = (byte)ch;
        while ((ch = input.read()) > 0 && ch != 13 && ch != 10 && ch != 32 && ch != 9 && ch != 59 && off < hex_len.length) {
            hex_len[off++] = (byte)ch;
        }
        while ((ch == 32 || ch == 9) && (ch = input.read()) > 0) {
        }
        if (ch == 59) {
            while ((ch = input.read()) > 0 && ch != 13 && ch != 10) {
            }
        }
        if (ch < 0) {
            throw new EOFException("Premature EOF while reading chunk length");
        }
        if (ch != 10 && (ch != 13 || input.read() != 10)) {
            throw new ParseException("Didn't find valid chunk length: " + new String(hex_len, 0, off, "8859_1"));
        }
        try {
            return Long.parseLong(new String(hex_len, 0, off, "8859_1").trim(), 16);
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("Didn't find valid chunk length: " + new String(hex_len, 0, off, "8859_1"));
        }
    }

    static {
        int idx;
        int ch;
        BoundChar = new BitSet(256);
        for (ch = 48; ch <= 57; ++ch) {
            BoundChar.set(ch);
        }
        for (ch = 65; ch <= 90; ++ch) {
            BoundChar.set(ch);
        }
        for (ch = 97; ch <= 122; ++ch) {
            BoundChar.set(ch);
        }
        BoundChar.set(43);
        BoundChar.set(95);
        BoundChar.set(45);
        BoundChar.set(46);
        EBCDICUnsafeChar = new BitSet(256);
        EBCDICUnsafeChar.set(33);
        EBCDICUnsafeChar.set(34);
        EBCDICUnsafeChar.set(35);
        EBCDICUnsafeChar.set(36);
        EBCDICUnsafeChar.set(64);
        EBCDICUnsafeChar.set(91);
        EBCDICUnsafeChar.set(92);
        EBCDICUnsafeChar.set(93);
        EBCDICUnsafeChar.set(94);
        EBCDICUnsafeChar.set(96);
        EBCDICUnsafeChar.set(123);
        EBCDICUnsafeChar.set(124);
        EBCDICUnsafeChar.set(125);
        EBCDICUnsafeChar.set(126);
        byte[] map = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
        Base64EncMap = map;
        Base64DecMap = new byte[128];
        for (idx = 0; idx < Base64EncMap.length; ++idx) {
            Codecs.Base64DecMap[Codecs.Base64EncMap[idx]] = (byte)idx;
        }
        UUEncMap = new char[64];
        for (idx = 0; idx < UUEncMap.length; ++idx) {
            Codecs.UUEncMap[idx] = (char)(idx + 32);
        }
        UUDecMap = new byte[128];
        for (idx = 0; idx < UUEncMap.length; ++idx) {
            Codecs.UUDecMap[Codecs.UUEncMap[idx]] = (byte)idx;
        }
        dummy = new NVPair[0];
    }

    private static class CT
    extends URLConnection {
        protected static final String getContentType(String fname) {
            return CT.guessContentTypeFromName(fname);
        }

        private CT() {
            super(null);
        }

        public void connect() {
        }
    }
}

