/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.formats.DataTools;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;

public class IPLabReader
extends FormatReader {
    private int bps;
    private int dataSize;

    public IPLabReader() {
        super("IPLab", "ipl");
    }

    public boolean isThisType(byte[] block) {
        if (block.length < 12) {
            return false;
        }
        String s2 = new String(block, 0, 4);
        boolean big = s2.equals("iiii");
        boolean little = s2.equals("mmmm");
        if (!big && !little) {
            return false;
        }
        int size = DataTools.bytesToInt(block, 4, 4, little);
        if (size != 4) {
            return false;
        }
        int version = DataTools.bytesToInt(block, 8, 4, little);
        return version >= 4110;
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length);
        int numPixels = this.core.sizeX[0] * this.core.sizeY[0] * this.core.sizeC[0] * this.bps;
        this.in.seek(numPixels * (no / this.core.sizeC[0]) + 44);
        this.in.read(buf);
        return buf;
    }

    protected void initFile(String id) throws FormatException, IOException {
        String ptype;
        if (debug) {
            this.debug("IPLabReader.initFile(" + id + ")");
        }
        super.initFile(id);
        this.in = new RandomAccessStream(id);
        this.status("Populating metadata");
        this.core.littleEndian[0] = this.in.readString(4).equals("iiii");
        this.in.order(this.core.littleEndian[0]);
        this.in.skipBytes(12);
        this.dataSize = this.in.readInt() - 28;
        this.core.sizeX[0] = this.in.readInt();
        this.core.sizeY[0] = this.in.readInt();
        this.core.sizeC[0] = this.in.readInt();
        this.core.sizeZ[0] = this.in.readInt();
        this.core.sizeT[0] = this.in.readInt();
        int filePixelType = this.in.readInt();
        this.core.imageCount[0] = this.core.sizeZ[0] * this.core.sizeT[0];
        this.addMeta("Width", new Long(this.core.sizeX[0]));
        this.addMeta("Height", new Long(this.core.sizeY[0]));
        this.addMeta("Channels", new Long(this.core.sizeC[0]));
        this.addMeta("ZDepth", new Long(this.core.sizeZ[0]));
        this.addMeta("TDepth", new Long(this.core.sizeT[0]));
        this.bps = 1;
        switch (filePixelType) {
            case 0: {
                ptype = "8 bit unsigned";
                this.core.pixelType[0] = 1;
                this.bps = 1;
                break;
            }
            case 1: {
                ptype = "16 bit signed short";
                this.core.pixelType[0] = 3;
                this.bps = 2;
                break;
            }
            case 2: {
                ptype = "16 bit unsigned short";
                this.core.pixelType[0] = 3;
                this.bps = 2;
                break;
            }
            case 3: {
                ptype = "32 bit signed long";
                this.core.pixelType[0] = 5;
                this.bps = 4;
                break;
            }
            case 4: {
                ptype = "32 bit single-precision float";
                this.core.pixelType[0] = 6;
                this.bps = 4;
                break;
            }
            case 5: {
                ptype = "Color24";
                this.core.pixelType[0] = 5;
                this.bps = 1;
                break;
            }
            case 6: {
                ptype = "Color48";
                this.core.pixelType[0] = 3;
                this.bps = 2;
                break;
            }
            case 10: {
                ptype = "64 bit double-precision float";
                this.core.pixelType[0] = 7;
                this.bps = 8;
                break;
            }
            default: {
                ptype = "reserved";
            }
        }
        this.addMeta("PixelType", ptype);
        this.in.skipBytes(this.dataSize);
        this.core.currentOrder[0] = "XY";
        this.core.currentOrder[0] = this.core.sizeC[0] > 1 ? this.core.currentOrder[0] + "CZT" : this.core.currentOrder[0] + "ZTC";
        this.core.rgb[0] = this.core.sizeC[0] > 1;
        this.core.interleaved[0] = false;
        this.core.indexed[0] = false;
        this.core.falseColor[0] = false;
        this.core.metadataComplete[0] = true;
        MetadataStore store = this.getMetadataStore();
        store.setImage(this.currentId, null, null, null);
        FormatTools.populatePixels(store, this);
        for (int i = 0; i < this.core.sizeC[0]; ++i) {
            store.setLogicalChannel(i, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        }
        this.status("Reading tags");
        String tag = this.in.readString(4);
        while (!tag.equals("fini") && this.in.getFilePointer() < this.in.length() - 4L) {
            if (tag.equals("clut")) {
                int size = this.in.readInt();
                if (size == 8) {
                    this.in.skipBytes(4);
                    int type = this.in.readInt();
                    String[] types = new String[]{"monochrome", "reverse monochrome", "BGR", "classify", "rainbow", "red", "green", "blue", "cyan", "magenta", "yellow", "saturated pixels"};
                    String clutType = type >= 0 && type < types.length ? types[type] : "unknown";
                    this.addMeta("LUT type", clutType);
                } else {
                    this.in.skipBytes(772);
                }
            } else if (tag.equals("norm")) {
                int size = this.in.readInt();
                if (size != 44 * this.core.sizeC[0]) {
                    throw new FormatException("Bad normalization settings");
                }
                String[] types = new String[]{"user", "plane", "sequence", "saturated plane", "saturated sequence", "ROI"};
                for (int i = 0; i < this.core.sizeC[0]; ++i) {
                    int source = this.in.readInt();
                    String sourceType = source >= 0 && source < types.length ? types[source] : "user";
                    this.addMeta("NormalizationSource" + i, sourceType);
                    double min2 = this.in.readDouble();
                    double max = this.in.readDouble();
                    double gamma = this.in.readDouble();
                    double black = this.in.readDouble();
                    double white = this.in.readDouble();
                    this.addMeta("NormalizationMin" + i, new Double(min2));
                    this.addMeta("NormalizationMax" + i, new Double(max));
                    this.addMeta("NormalizationGamma" + i, new Double(gamma));
                    this.addMeta("NormalizationBlack" + i, new Double(black));
                    this.addMeta("NormalizationWhite" + i, new Double(white));
                    store = this.getMetadataStore();
                    store.setChannelGlobalMinMax(i, new Double(min2), new Double(max), null);
                    store.setDisplayChannel(new Integer(this.core.sizeC[0]), new Double(black), new Double(white), new Float(gamma), null);
                }
            } else if (tag.equals("head")) {
                int size = this.in.readInt();
                for (int i = 0; i < size / 22; ++i) {
                    short num = this.in.readShort();
                    this.addMeta("Header" + num, this.in.readString(20));
                }
            } else if (tag.equals("mmrc")) {
                this.in.skipBytes(this.in.readInt());
            } else if (tag.equals("roi ")) {
                this.in.skipBytes(8);
                int roiLeft = this.in.readInt();
                int roiTop = this.in.readInt();
                int roiRight = this.in.readInt();
                int roiBottom = this.in.readInt();
                int numRoiPts = this.in.readInt();
                Integer x0 = new Integer(roiLeft);
                Integer x1 = new Integer(roiRight);
                Integer y0 = new Integer(roiBottom);
                Integer y1 = new Integer(roiTop);
                store.setDisplayROI(x0, y0, null, x1, y1, null, null, null, null, null);
                this.in.skipBytes(8 * numRoiPts);
            } else if (tag.equals("mask")) {
                this.in.skipBytes(this.in.readInt());
            } else if (tag.equals("unit")) {
                this.in.skipBytes(4);
                for (int i = 0; i < 4; ++i) {
                    int xResStyle = this.in.readInt();
                    int unitsPerPixel = this.in.readInt();
                    int xUnitName = this.in.readInt();
                    this.addMeta("ResolutionStyle" + i, new Long(xResStyle));
                    this.addMeta("UnitsPerPixel" + i, new Long(unitsPerPixel));
                    if (i == 0) {
                        Float pixelSize = new Float(1.0f / (float)unitsPerPixel);
                        store.setDimensions(pixelSize, pixelSize, null, null, null, null);
                    }
                    this.addMeta("UnitName" + i, new Long(xUnitName));
                }
            } else if (tag.equals("view")) {
                this.in.skipBytes(4);
            } else if (tag.equals("plot")) {
                this.in.skipBytes(2512);
            } else if (tag.equals("notes")) {
                this.in.skipBytes(4);
                String descriptor = this.in.readString(64);
                String notes = this.in.readString(512);
                this.addMeta("Descriptor", descriptor);
                this.addMeta("Notes", notes);
                store.setImage(this.currentId, null, notes, null);
            }
            tag = this.in.getFilePointer() + 4L <= this.in.length() ? this.in.readString(4) : "fini";
            if (this.in.getFilePointer() < this.in.length() || tag.equals("fini")) continue;
            tag = "fini";
        }
    }
}

