/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureCollectionIterator;
import ucar.nc2.ft.StationTimeSeriesFeature;
import ucar.nc2.ft.StationTimeSeriesFeatureCollection;
import ucar.nc2.ft.point.CollectionInfo;
import ucar.nc2.ft.point.CollectionIteratorAdapter;
import ucar.nc2.ft.point.DsgCollectionImpl;
import ucar.nc2.ft.point.PointFeatureCCImpl;
import ucar.nc2.ft.point.StationFeature;
import ucar.nc2.ft.point.StationFeatureHas;
import ucar.nc2.ft.point.StationHelper;
import ucar.nc2.ft.point.StationTimeSeriesCollectionFlattened;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.time.CalendarDateUnit;
import ucar.nc2.util.IOIterator;
import ucar.unidata.geoloc.LatLonRect;

public abstract class StationTimeSeriesCollectionImpl
extends PointFeatureCCImpl
implements StationTimeSeriesFeatureCollection {
    private volatile StationHelper stationHelper;
    protected PointFeatureCollectionIterator localIterator;

    public StationTimeSeriesCollectionImpl(String name, CalendarDateUnit timeUnit, String altUnits) {
        super(name, timeUnit, altUnits, FeatureType.STATION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StationHelper getStationHelper() {
        if (this.stationHelper == null) {
            StationTimeSeriesCollectionImpl stationTimeSeriesCollectionImpl = this;
            synchronized (stationTimeSeriesCollectionImpl) {
                if (this.stationHelper == null) {
                    try {
                        this.stationHelper = this.createStationHelper();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        assert (this.stationHelper != null) : "stationHelper is null for StationTimeSeriesCollectionImpl" + this.getName();
        return this.stationHelper;
    }

    protected abstract StationHelper createStationHelper() throws IOException;

    @Override
    public LatLonRect getBoundingBox() {
        return this.getStationHelper().getBoundingBox();
    }

    @Override
    public List<StationFeature> getStationFeatures() throws IOException {
        return this.getStationHelper().getStationFeatures();
    }

    @Override
    public List<StationFeature> getStationFeatures(List<String> stnNames) {
        return this.getStationHelper().getStationFeaturesFromNames(stnNames);
    }

    @Override
    public List<StationFeature> getStationFeatures(LatLonRect boundingBox) throws IOException {
        return this.getStationHelper().getStationFeatures(boundingBox);
    }

    @Override
    public StationFeature findStationFeature(String name) {
        return this.getStationHelper().getStation(name);
    }

    @Override
    public StationTimeSeriesFeature getStationTimeSeriesFeature(StationFeature s2) {
        return (StationTimeSeriesFeature)s2;
    }

    @Override
    public StationTimeSeriesFeatureCollection subset(LatLonRect boundingBox) throws IOException {
        return this.subset(this.getStationFeatures(boundingBox));
    }

    @Override
    public StationTimeSeriesFeatureCollection subset(LatLonRect boundingBox, CalendarDateRange dateRange) throws IOException {
        return this.subset(this.getStationFeatures(boundingBox), dateRange);
    }

    @Override
    public StationTimeSeriesFeatureCollection subset(List<StationFeature> stations) throws IOException {
        return new StationSubset(this, stations);
    }

    @Override
    public StationTimeSeriesFeatureCollection subset(List<StationFeature> stnsWanted, CalendarDateRange dateRange) throws IOException {
        if (dateRange == null) {
            return this.subset(stnsWanted);
        }
        ArrayList<StationFeature> subsetStations = new ArrayList<StationFeature>();
        for (StationFeature sf : stnsWanted) {
            StationTimeSeriesFeature stsf = (StationTimeSeriesFeature)sf;
            StationTimeSeriesFeature subset = stsf.subset(dateRange);
            subsetStations.add(subset);
        }
        return new StationSubset(this, subsetStations);
    }

    @Override
    public StationTimeSeriesFeatureCollection subsetFeatures(List<StationFeature> stationsFeatures) throws IOException {
        return new StationSubset(this, stationsFeatures);
    }

    @Override
    public PointFeatureCollection flatten(List<String> stationNames, CalendarDateRange dateRange, List<VariableSimpleIF> varList) throws IOException {
        if (stationNames == null || stationNames.size() == 0) {
            return new StationTimeSeriesCollectionFlattened(this, dateRange);
        }
        List<StationFeature> subsetStations = this.getStationHelper().getStationFeaturesFromNames(stationNames);
        return new StationTimeSeriesCollectionFlattened(new StationSubset(this, subsetStations), dateRange);
    }

    @Override
    public PointFeatureCollection flatten(LatLonRect boundingBox, CalendarDateRange dateRange) throws IOException {
        if (boundingBox == null) {
            return new StationTimeSeriesCollectionFlattened(this, dateRange);
        }
        List<StationFeature> subsetStations = this.getStationHelper().getStationFeatures(boundingBox);
        return new StationTimeSeriesCollectionFlattened(new StationSubset(this, subsetStations), dateRange);
    }

    @Override
    public StationFeature getStationFeature(PointFeature flatPointFeature) throws IOException {
        if (flatPointFeature instanceof StationFeatureHas) {
            return ((StationFeatureHas)((Object)flatPointFeature)).getStationFeature();
        }
        return null;
    }

    @Override
    public Iterator<StationTimeSeriesFeature> iterator() {
        try {
            PointFeatureCollectionIterator pfIterator = this.getPointFeatureCollectionIterator();
            return new CollectionIteratorAdapter<StationTimeSeriesFeature>(pfIterator);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public IOIterator<PointFeatureCollection> getCollectionIterator() throws IOException {
        return new StationIterator();
    }

    @Override
    public PointFeatureCollectionIterator getPointFeatureCollectionIterator() throws IOException {
        return new StationIterator();
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.localIterator == null) {
            this.resetIteration();
        }
        return this.localIterator.hasNext();
    }

    @Override
    public void finish() {
        if (this.localIterator != null) {
            this.localIterator.close();
        }
    }

    @Override
    public StationTimeSeriesFeature next() throws IOException {
        return (StationTimeSeriesFeature)this.localIterator.next();
    }

    @Override
    public void resetIteration() throws IOException {
        this.localIterator = this.getPointFeatureCollectionIterator();
    }

    private class StationIterator
    implements PointFeatureCollectionIterator,
    IOIterator<PointFeatureCollection> {
        Iterator<StationFeature> stationIter;
        DsgCollectionImpl prev;
        CollectionInfo calcInfo;

        public StationIterator() {
            this.stationIter = StationTimeSeriesCollectionImpl.this.getStationHelper().getStationFeatures().iterator();
            CollectionInfo info = StationTimeSeriesCollectionImpl.this.getInfo();
            if (!info.isComplete()) {
                this.calcInfo = info;
            }
        }

        @Override
        public boolean hasNext() throws IOException {
            boolean more;
            if (this.prev != null && this.calcInfo != null) {
                this.calcInfo.extend(this.prev.getInfo());
            }
            if (!(more = this.stationIter.hasNext()) && this.calcInfo != null) {
                this.calcInfo.setComplete();
            }
            return more;
        }

        @Override
        public PointFeatureCollection next() throws IOException {
            PointFeatureCollection result = (PointFeatureCollection)((Object)this.stationIter.next());
            this.prev = (DsgCollectionImpl)((Object)result);
            return result;
        }
    }

    private static class StationSubset
    extends StationTimeSeriesCollectionImpl {
        private final List<StationFeature> stations;

        StationSubset(StationTimeSeriesCollectionImpl from, List<StationFeature> stations) {
            super(from.getName(), from.getTimeUnit(), from.getAltUnits());
            this.stations = stations;
        }

        @Override
        protected StationHelper createStationHelper() throws IOException {
            StationHelper stationHelper = new StationHelper();
            stationHelper.setStations(this.stations);
            return stationHelper;
        }

        @Override
        public List<StationFeature> getStationFeatures() throws IOException {
            return this.getStationHelper().getStationFeatures();
        }
    }
}

