/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.util.Vector;
import visad.DelaunayCustom;
import visad.TextControl;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADLineArray;
import visad.VisADTriangleArray;
import visad.browser.Convert;
import visad.util.HersheyFont;

public class PlotText {
    static final double XMIN = -1.0;
    static final double YMIN = -1.0;
    static final double ZMIN = -1.0;
    static final double WIDTH = 0.8;
    static double[] bx = new double[]{0.07, 0.0, 0.0};
    static double[] ux = new double[]{0.0, 0.07, 0.07};
    static double[] by = new double[]{0.0, 0.07, 0.0};
    static double[] uy = new double[]{-0.07, 0.0, -0.07};
    static double[] bz = new double[]{0.0, 0.0, -0.07};
    static double[] uz = new double[]{0.07, 0.07, 0.0};
    static float[][] charCodes = new float[][]{{100.0f, 0.0f}, {101.0f, 8.0f, 1.0f, 3.0f, 3.0f, 3.0f, 3.0f, 8.0f, 1.0f, 8.0f, 101.0f, 1.0f, 1.0f, 0.0f, 3.0f, 0.0f, 3.0f, 1.0f, 1.0f, 1.0f}, {101.0f, 8.0f, 0.0f, 5.0f, 104.0f, 8.0f, 3.0f, 5.0f}, {101.5f, 8.0f, 1.5f, 0.0f, 103.5f, 8.0f, 3.5f, 0.0f, 100.0f, 5.0f, 5.0f, 5.0f, 100.0f, 3.0f, 5.0f, 3.0f}, {101.5f, 8.0f, 1.5f, 0.0f, 102.5f, 8.0f, 2.5f, 0.0f, 104.0f, 5.5f, 3.0f, 7.0f, 1.0f, 7.0f, 0.0f, 5.5f, 0.0f, 4.5f, 4.0f, 3.5f, 4.0f, 2.5f, 3.0f, 1.0f, 1.0f, 1.0f, 0.0f, 2.5f}, {100.0f, 8.0f, 0.0f, 7.0f, 1.0f, 7.0f, 1.0f, 8.0f, 0.0f, 8.0f, 105.0f, 8.0f, 0.0f, 0.0f, 104.0f, 1.0f, 4.0f, 0.0f, 5.0f, 0.0f, 5.0f, 1.0f, 4.0f, 1.0f}, {105.0f, 0.0f, 0.0f, 5.0f, 0.0f, 7.0f, 1.0f, 8.0f, 3.0f, 8.0f, 4.0f, 7.0f, 4.0f, 5.0f, 0.0f, 3.0f, 0.0f, 1.0f, 1.0f, 0.0f, 3.0f, 0.0f, 5.0f, 3.0f, 5.0f, 4.0f}, {101.0f, 8.0f, 0.0f, 5.0f}, {104.0f, 8.0f, 2.0f, 6.0f, 2.0f, 2.0f, 4.0f, 0.0f}, {101.0f, 8.0f, 3.0f, 6.0f, 3.0f, 2.0f, 1.0f, 0.0f}, {100.0f, 7.0f, 5.0f, 1.0f, 102.5f, 7.0f, 2.5f, 1.0f, 100.0f, 1.0f, 5.0f, 7.0f, 105.0f, 4.0f, 0.0f, 4.0f}, {102.5f, 7.0f, 2.5f, 1.0f, 100.0f, 4.0f, 5.0f, 4.0f}, {103.0f, 0.0f, 2.0f, 0.0f, 2.0f, 1.0f, 3.0f, 1.0f, 3.0f, 0.0f, 2.1f, -2.0f}, {100.0f, 4.0f, 5.0f, 4.0f}, {102.0f, 0.0f, 3.0f, 0.0f, 3.0f, 1.0f, 2.0f, 1.0f, 2.0f, 0.0f}, {100.0f, 0.0f, 5.0f, 8.0f}, {102.0f, 8.0f, 0.0f, 6.0f, 0.0f, 2.0f, 2.0f, 0.0f, 3.0f, 0.0f, 5.0f, 2.0f, 5.0f, 6.0f, 3.0f, 8.0f, 2.0f, 8.0f}, {101.0f, 7.0f, 2.5f, 8.0f, 2.5f, 0.0f, 1.0f, 0.0f, 4.0f, 0.0f}, {100.0f, 7.0f, 1.0f, 8.0f, 4.0f, 8.0f, 5.0f, 7.0f, 5.0f, 5.0f, 0.0f, 0.0f, 5.0f, 0.0f}, {100.0f, 7.0f, 1.0f, 8.0f, 4.0f, 8.0f, 5.0f, 7.0f, 5.0f, 5.0f, 4.0f, 4.0f, 3.0f, 4.0f, 4.0f, 4.0f, 5.0f, 3.0f, 5.0f, 1.0f, 4.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f}, {103.0f, 8.0f, 0.0f, 4.0f, 5.0f, 4.0f, 5.0f, 8.0f, 5.0f, 0.0f}, {100.0f, 1.0f, 1.0f, 0.0f, 4.0f, 0.0f, 5.0f, 1.0f, 5.0f, 4.0f, 4.0f, 5.0f, 0.0f, 5.0f, 0.0f, 8.0f, 5.0f, 8.0f}, {105.0f, 7.0f, 4.0f, 8.0f, 1.0f, 8.0f, 0.0f, 7.0f, 0.0f, 1.0f, 1.0f, 0.0f, 4.0f, 0.0f, 5.0f, 1.0f, 5.0f, 3.0f, 4.0f, 4.0f, 0.0f, 4.0f}, {100.0f, 8.0f, 5.0f, 8.0f, 3.0f, 0.0f}, {101.0f, 8.0f, 0.0f, 7.0f, 0.0f, 5.0f, 1.0f, 4.0f, 4.0f, 4.0f, 5.0f, 5.0f, 5.0f, 7.0f, 4.0f, 8.0f, 1.0f, 8.0f, 101.0f, 4.0f, 0.0f, 3.0f, 0.0f, 1.0f, 1.0f, 0.0f, 4.0f, 0.0f, 5.0f, 1.0f, 5.0f, 3.0f, 4.0f, 4.0f}, {101.0f, 0.0f, 1.0f, 0.0f, 4.0f, 0.0f, 5.0f, 1.0f, 5.0f, 7.0f, 4.0f, 8.0f, 1.0f, 8.0f, 0.0f, 7.0f, 0.0f, 5.0f, 1.0f, 4.0f, 5.0f, 4.0f}, {102.0f, 7.0f, 2.0f, 5.0f, 3.0f, 5.0f, 3.0f, 7.0f, 2.0f, 7.0f, 102.0f, 3.0f, 2.0f, 1.0f, 3.0f, 1.0f, 3.0f, 3.0f, 2.0f, 3.0f}, {100.0f, 7.0f, 0.0f, 5.0f, 1.0f, 5.0f, 1.0f, 7.0f, 0.0f, 7.0f, 100.0f, 0.0f, 1.0f, 1.0f, 1.0f, 3.0f, 0.0f, 3.0f, 0.0f, 1.0f, 1.0f, 1.0f}, {105.0f, 7.0f, 0.0f, 4.0f, 5.0f, 1.0f}, {100.0f, 5.0f, 5.0f, 5.0f, 100.0f, 3.0f, 5.0f, 3.0f}, {100.0f, 7.0f, 5.0f, 4.0f, 0.0f, 1.0f}, {100.0f, 7.0f, 1.0f, 8.0f, 4.0f, 8.0f, 5.0f, 7.0f, 5.0f, 5.0f, 4.0f, 4.0f, 2.5f, 4.0f, 2.5f, 2.0f, 102.5f, 1.0f, 2.5f, 0.0f}, {104.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 7.0f, 1.0f, 8.0f, 4.0f, 8.0f, 5.0f, 7.0f, 5.0f, 3.0f, 4.0f, 1.5f, 3.0f, 2.0f, 1.5f, 4.0f, 1.5f, 5.0f, 2.5f, 6.0f, 4.0f, 5.0f, 3.0f, 2.0f}, {100.0f, 0.0f, 0.0f, 7.0f, 1.0f, 8.0f, 4.0f, 8.0f, 5.0f, 7.0f, 5.0f, 0.0f, 5.0f, 4.0f, 0.0f, 4.0f}, {100.0f, 8.0f, 0.0f, 0.0f, 4.0f, 0.0f, 5.0f, 1.0f, 5.0f, 3.0f, 4.0f, 4.0f, 5.0f, 5.0f, 5.0f, 7.0f, 4.0f, 8.0f, 0.0f, 8.0f, 0.0f, 4.0f, 4.0f, 4.0f}, {105.0f, 7.0f, 4.0f, 8.0f, 1.0f, 8.0f, 0.0f, 7.0f, 0.0f, 1.0f, 1.0f, 0.0f, 4.0f, 0.0f, 5.0f, 1.0f}, {100.0f, 8.0f, 0.0f, 0.0f, 4.0f, 0.0f, 5.0f, 1.0f, 5.0f, 7.0f, 4.0f, 8.0f, 0.0f, 8.0f}, {105.0f, 8.0f, 0.0f, 8.0f, 0.0f, 4.0f, 3.0f, 4.0f, 0.0f, 4.0f, 0.0f, 0.0f, 5.0f, 0.0f}, {105.0f, 8.0f, 0.0f, 8.0f, 0.0f, 4.0f, 3.0f, 4.0f, 0.0f, 4.0f, 0.0f, 0.0f}, {105.0f, 7.0f, 4.0f, 8.0f, 1.0f, 8.0f, 0.0f, 7.0f, 0.0f, 1.0f, 1.0f, 0.0f, 4.0f, 0.0f, 5.0f, 1.0f, 5.0f, 4.0f, 3.0f, 4.0f}, {100.0f, 8.0f, 0.0f, 0.0f, 0.0f, 4.0f, 5.0f, 4.0f, 5.0f, 8.0f, 5.0f, 0.0f}, {100.0f, 8.0f, 5.0f, 8.0f, 2.5f, 8.0f, 2.5f, 0.0f, 0.0f, 0.0f, 5.0f, 0.0f}, {105.0f, 8.0f, 5.0f, 1.0f, 4.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 3.0f}, {100.0f, 8.0f, 0.0f, 0.0f, 0.0f, 4.0f, 5.0f, 8.0f, 0.0f, 4.0f, 5.0f, 0.0f}, {100.0f, 8.0f, 0.0f, 0.0f, 5.0f, 0.0f}, {100.0f, 0.0f, 0.0f, 8.0f, 2.5f, 4.0f, 5.0f, 8.0f, 5.0f, 0.0f}, {100.0f, 0.0f, 0.0f, 8.0f, 5.0f, 0.0f, 5.0f, 8.0f}, {101.0f, 8.0f, 0.0f, 7.0f, 0.0f, 1.0f, 1.0f, 0.0f, 4.0f, 0.0f, 5.0f, 1.0f, 5.0f, 7.0f, 4.0f, 8.0f, 1.0f, 8.0f}, {100.0f, 0.0f, 0.0f, 8.0f, 4.0f, 8.0f, 5.0f, 7.0f, 5.0f, 5.0f, 4.0f, 4.0f, 0.0f, 4.0f}, {101.0f, 8.0f, 0.0f, 7.0f, 0.0f, 1.0f, 1.0f, 0.0f, 4.0f, 0.0f, 5.0f, 1.0f, 5.0f, 7.0f, 4.0f, 8.0f, 1.0f, 8.0f, 103.0f, 3.0f, 5.0f, 0.0f}, {100.0f, 0.0f, 0.0f, 8.0f, 4.0f, 8.0f, 5.0f, 7.0f, 5.0f, 5.0f, 4.0f, 4.0f, 0.0f, 4.0f, 3.0f, 4.0f, 5.0f, 0.0f}, {105.0f, 7.0f, 4.0f, 8.0f, 1.0f, 8.0f, 0.0f, 7.0f, 0.0f, 5.0f, 1.0f, 4.0f, 4.0f, 4.0f, 5.0f, 3.0f, 5.0f, 1.0f, 4.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f}, {100.0f, 8.0f, 5.0f, 8.0f, 2.5f, 8.0f, 2.5f, 0.0f}, {100.0f, 8.0f, 0.0f, 1.0f, 1.0f, 0.0f, 4.0f, 0.0f, 5.0f, 1.0f, 5.0f, 8.0f}, {100.0f, 8.0f, 2.5f, 0.0f, 5.0f, 8.0f}, {100.0f, 8.0f, 0.0f, 0.0f, 2.5f, 4.0f, 5.0f, 0.0f, 5.0f, 8.0f}, {100.0f, 8.0f, 5.0f, 0.0f, 100.0f, 0.0f, 5.0f, 8.0f}, {100.0f, 8.0f, 2.5f, 4.0f, 5.0f, 8.0f, 2.5f, 4.0f, 2.5f, 0.0f}, {100.0f, 8.0f, 5.0f, 8.0f, 0.0f, 0.0f, 5.0f, 0.0f}, {104.0f, 8.0f, 2.0f, 8.0f, 2.0f, 0.0f, 4.0f, 0.0f}, {100.0f, 8.0f, 5.0f, 0.0f}, {101.0f, 8.0f, 3.0f, 8.0f, 3.0f, 0.0f, 1.0f, 0.0f}, {102.0f, 6.0f, 3.0f, 8.0f, 4.0f, 6.0f}, {100.0f, -2.0f, 5.0f, -2.0f}, {102.0f, 8.0f, 4.0f, 6.0f}, {104.0f, 5.0f, 4.0f, 1.0f, 3.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 4.0f, 1.0f, 5.0f, 3.0f, 5.0f, 4.0f, 4.0f, 4.0f, 1.0f, 5.0f, 0.0f}, {100.0f, 8.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 4.0f, 0.0f, 5.0f, 1.0f, 5.0f, 4.0f, 4.0f, 5.0f, 3.0f, 5.0f, 0.0f, 3.0f}, {105.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 4.0f, 1.0f, 5.0f, 4.0f, 5.0f, 5.0f, 4.0f}, {105.0f, 3.0f, 3.0f, 5.0f, 1.0f, 5.0f, 0.0f, 4.0f, 0.0f, 1.0f, 1.0f, 0.0f, 4.0f, 0.0f, 5.0f, 1.0f, 5.0f, 0.0f, 5.0f, 8.0f}, {105.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 4.0f, 1.0f, 5.0f, 4.0f, 5.0f, 5.0f, 4.0f, 4.0f, 3.0f, 0.0f, 3.0f}, {103.0f, 0.0f, 3.0f, 7.0f, 4.0f, 8.0f, 5.0f, 8.0f, 5.0f, 7.0f, 101.0f, 4.0f, 4.0f, 4.0f}, {105.0f, 5.0f, 5.0f, -3.0f, 4.0f, -4.0f, 1.0f, -4.0f, 105.0f, 1.0f, 4.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 4.0f, 1.0f, 5.0f, 3.0f, 5.0f, 5.0f, 3.0f}, {100.0f, 8.0f, 0.0f, 0.0f, 0.0f, 3.0f, 3.0f, 5.0f, 4.0f, 5.0f, 5.0f, 4.0f, 5.0f, 0.0f}, {103.0f, 4.0f, 3.0f, 0.0f, 4.0f, 0.0f, 1.0f, 0.0f, 103.0f, 6.5f, 3.0f, 5.5f}, {104.0f, 4.0f, 4.0f, -3.0f, 3.0f, -4.0f, 1.0f, -4.0f, 0.0f, -3.0f, 0.0f, -1.0f, 1.0f, 0.0f, 104.0f, 6.5f, 4.0f, 5.5f}, {101.0f, 8.0f, 1.0f, 0.0f, 101.0f, 3.0f, 5.0f, 5.0f, 101.0f, 3.0f, 5.0f, 0.0f}, {102.0f, 8.0f, 3.0f, 8.0f, 3.0f, 0.0f}, {100.0f, 0.0f, 0.0f, 5.0f, 0.0f, 4.0f, 1.0f, 5.0f, 4.0f, 5.0f, 5.0f, 4.0f, 5.0f, 0.0f, 102.5f, 5.0f, 2.5f, 2.0f}, {100.0f, 0.0f, 0.0f, 5.0f, 0.0f, 4.0f, 1.0f, 5.0f, 4.0f, 5.0f, 5.0f, 3.0f, 5.0f, 0.0f}, {101.0f, 0.0f, 0.0f, 1.0f, 0.0f, 4.0f, 1.0f, 5.0f, 4.0f, 5.0f, 5.0f, 4.0f, 5.0f, 1.0f, 4.0f, 0.0f, 1.0f, 0.0f}, {100.0f, -4.0f, 0.0f, 1.0f, 1.0f, 0.0f, 4.0f, 0.0f, 5.0f, 1.0f, 5.0f, 4.0f, 4.0f, 5.0f, 3.0f, 5.0f, 0.0f, 3.0f, 0.0f, 1.0f, 0.0f, 5.0f}, {105.0f, -4.0f, 5.0f, 1.0f, 4.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 4.0f, 1.0f, 5.0f, 3.0f, 5.0f, 5.0f, 3.0f, 5.0f, 1.0f, 5.0f, 5.0f}, {100.0f, 5.0f, 0.0f, 0.0f, 0.0f, 3.0f, 3.0f, 5.0f, 4.0f, 5.0f, 5.0f, 4.0f}, {105.0f, 4.0f, 3.0f, 5.0f, 2.0f, 5.0f, 0.0f, 4.0f, 0.0f, 3.0f, 5.0f, 2.0f, 5.0f, 1.0f, 3.0f, 0.0f, 2.0f, 0.0f, 0.0f, 1.0f}, {102.5f, 8.0f, 2.5f, 0.0f, 100.5f, 5.0f, 4.5f, 5.0f}, {100.0f, 5.0f, 0.0f, 1.0f, 1.0f, 0.0f, 3.0f, 0.0f, 5.0f, 3.0f, 5.0f, 5.0f, 5.0f, 0.0f}, {100.0f, 5.0f, 0.0f, 3.0f, 2.5f, 0.0f, 5.0f, 3.0f, 5.0f, 5.0f}, {100.0f, 5.0f, 0.0f, 0.0f, 2.5f, 3.0f, 5.0f, 0.0f, 5.0f, 5.0f}, {100.0f, 5.0f, 5.0f, 0.0f, 105.0f, 5.0f, 0.0f, 0.0f}, {100.0f, 5.0f, 0.0f, 3.0f, 3.0f, 0.0f, 5.0f, 3.0f, 5.0f, 5.0f, 5.0f, -3.0f, 3.0f, -4.0f}, {100.0f, 5.0f, 5.0f, 5.0f, 0.0f, 0.0f, 5.0f, 0.0f}, {104.0f, 8.0f, 3.0f, 8.0f, 2.0f, 4.5f, 1.0f, 4.5f, 2.0f, 4.5f, 3.0f, 0.0f, 4.0f, 0.0f}, {103.5f, 8.0f, 3.5f, 0.0f}, {102.0f, 8.0f, 3.0f, 8.0f, 4.0f, 4.5f, 5.0f, 4.5f, 4.0f, 4.5f, 3.0f, 0.0f, 2.0f, 0.0f}, {100.0f, 4.0f, 1.0f, 5.0f, 3.0f, 4.0f, 4.0f, 5.0f}, {100.0f, 0.0f}};

    public static VisADLineArray render_label(int axis, double pos, String str, int line, long c) {
        double XMIN = -1.0;
        double YMIN = -1.0;
        double ZMIN = -1.0;
        double[] bx = new double[]{0.07, 0.0, 0.0};
        double[] ux = new double[]{0.0, 0.07, 0.07};
        double[] by = new double[]{0.0, 0.07, 0.0};
        double[] uy = new double[]{-0.07, 0.0, -0.07};
        double[] bz = new double[]{0.0, 0.0, -0.07};
        double[] uz = new double[]{0.07, 0.07, 0.0};
        double[] base = null;
        double[] up = null;
        double[] start = new double[3];
        if (axis == 0) {
            base = bx;
            up = ux;
            start[0] = pos;
            start[1] = YMIN * (1.1 + 0.07 * (double)line);
            start[2] = ZMIN * (1.1 + 0.07 * (double)line);
        } else if (axis == 1) {
            base = by;
            up = uy;
            start[0] = XMIN * (1.1 + 0.07 * (double)line);
            start[1] = pos;
            start[2] = ZMIN * (1.1 + 0.07 * (double)line);
        } else if (axis == 2) {
            base = bz;
            up = uz;
            start[0] = XMIN * (1.1 + 0.07 * (double)line);
            start[1] = YMIN * (1.1 + 0.07 * (double)line);
            start[2] = pos;
        }
        return PlotText.render_label(str, start, base, up, TextControl.Justification.CENTER, TextControl.Justification.BOTTOM, 0.0, 1.0, null);
    }

    public static VisADLineArray render_label(String str, double[] start, double[] base, double[] up, boolean center) {
        return PlotText.render_label(str, start, base, up, center ? TextControl.Justification.CENTER : TextControl.Justification.LEFT, TextControl.Justification.BOTTOM, 0.0, 1.0, null);
    }

    public static VisADLineArray render_label(String str, double[] start, double[] base, double[] up, TextControl.Justification justification, TextControl.Justification verticalJustification) {
        return PlotText.render_label(str, start, base, up, justification, verticalJustification, 0.0, 1.0, null);
    }

    public static VisADLineArray render_label(String str, double[] start, double[] base, double[] up, TextControl.Justification justification) {
        return PlotText.render_label(str, start, base, up, justification, TextControl.Justification.BOTTOM, 0.0, 1.0, null);
    }

    public static VisADLineArray render_label(String str, double[] start, double[] base, double[] up, TextControl.Justification justification, double characRotation) {
        return PlotText.render_label(str, start, base, up, justification, TextControl.Justification.BOTTOM, characRotation, 1.0, null);
    }

    public static VisADLineArray render_label(String str, double[] start, double[] base, double[] up, TextControl.Justification justification, TextControl.Justification verticalJustification, double characRotation, double scale, double[] offsets) {
        int i;
        if (offsets == null) {
            offsets = new double[]{0.0, 0.0, 0.0};
        }
        if (scale <= 0.0) {
            scale = 1.0;
        }
        double[] start_off = new double[]{start[0] + offsets[0], start[1] + offsets[1], start[2] + offsets[2]};
        double[] base_scaled = new double[]{base[0] * scale, base[1] * scale, base[2] * scale};
        double[] up_scaled = new double[]{up[0] * scale, up[1] * scale, up[2] * scale};
        double startx = 0.0;
        double starty = 0.0;
        double startz = 0.0;
        double cx = start_off[0];
        double cy = start_off[1];
        double cz = start_off[2];
        int len = str.length();
        float[] plot = new float[120 * len];
        int plot_index = 0;
        double angle = Math.toRadians(-characRotation);
        float angle2 = (float)(angle + 1.5707963267948966);
        for (i = 0; i < len; ++i) {
            double y;
            double x;
            int j;
            char cur_char = str.charAt(i);
            int k = str.charAt(i) - 32;
            if (k < 0 || k > 127) continue;
            int verts = charCodes[k].length / 2;
            int plot_index_begin = plot_index;
            float maxX = 0.0f;
            float maxY = 0.0f;
            float minY = 10.0f;
            int temp_index = 0;
            for (j = 0; j < verts && verts != 1; ++j) {
                double w;
                boolean dup_point = true;
                if (j == verts - 1) {
                    dup_point = false;
                }
                if ((w = (double)charCodes[k][temp_index] * 0.1) > 9.0) {
                    if (j != 0) {
                        plot_index -= 3;
                    }
                    w -= 10.0;
                    dup_point = false;
                }
                double h2 = (double)charCodes[k][++temp_index] * 0.1;
                ++temp_index;
                if (w > (double)maxX) {
                    maxX = (float)w;
                }
                if (h2 > (double)maxY) {
                    maxY = (float)h2;
                }
                if (h2 < (double)minY) {
                    minY = (float)h2;
                }
                x = (float)(w * Math.cos(angle) - h2 * Math.sin(angle));
                y = (float)(w * Math.sin(angle) + h2 * Math.cos(angle));
                float px = (float)(cx + x * base_scaled[0] + y * up_scaled[0]);
                float py = (float)(cy + x * base_scaled[1] + y * up_scaled[1]);
                float pz = (float)(cz + x * base_scaled[2] + y * up_scaled[2]);
                plot[plot_index] = px;
                plot[plot_index + 1] = py;
                plot[plot_index + 2] = pz;
                if (dup_point) {
                    plot[plot_index + 3] = plot[plot_index];
                    plot[plot_index + 4] = plot[plot_index + 1];
                    plot[plot_index + 5] = plot[plot_index + 2];
                    plot_index += 3;
                }
                plot_index += 3;
            }
            if (minY > maxY) {
                minY = maxY;
            }
            x = maxX;
            y = (float)((double)(maxY - minY) + 0.1);
            float x_plus = (float)(x * Math.abs(Math.cos(angle)) + y * Math.abs(Math.cos(angle2)));
            float cur_x_off = 0.0f;
            if (Math.cos(angle) < 0.0) {
                cur_x_off = (float)(x * Math.abs(Math.cos(angle)));
            }
            if (Math.cos(angle2) < 0.0) {
                cur_x_off += (float)(((double)maxY + 0.05) * Math.abs(Math.cos(angle2)));
            } else if (minY < 0.0f) {
                cur_x_off += (float)(((double)(-minY) + 0.05) * Math.abs(Math.cos(angle2)));
            }
            for (j = plot_index_begin; j < plot_index; j += 6) {
                int n = j;
                plot[n] = (float)((double)plot[n] + (double)cur_x_off * base_scaled[0]);
                int n2 = j + 1;
                plot[n2] = (float)((double)plot[n2] + (double)cur_x_off * base_scaled[1]);
                int n3 = j + 2;
                plot[n3] = (float)((double)plot[n3] + (double)cur_x_off * base_scaled[2]);
                int n4 = j + 3;
                plot[n4] = (float)((double)plot[n4] + (double)cur_x_off * base_scaled[0]);
                int n5 = j + 4;
                plot[n5] = (float)((double)plot[n5] + (double)cur_x_off * base_scaled[1]);
                int n6 = j + 5;
                plot[n6] = (float)((double)plot[n6] + (double)cur_x_off * base_scaled[2]);
            }
            double width = Math.max(0.8, (double)x_plus + 0.3);
            cx += (double)((float)(width * base_scaled[0]));
            cy += (double)((float)(width * base_scaled[1]));
            cz += (double)((float)(width * base_scaled[2]));
        }
        if (plot_index <= 0) {
            return null;
        }
        float cxoff = 0.0f;
        float cyoff = 0.0f;
        float czoff = 0.0f;
        if (justification == TextControl.Justification.CENTER) {
            cxoff = (float)((cx - start_off[0]) / 2.0);
            cyoff = (float)((cy - start_off[1]) / 2.0);
            czoff = (float)((cz - start_off[2]) / 2.0);
        } else if (justification == TextControl.Justification.RIGHT) {
            cxoff = (float)(cx - start_off[0]);
            cyoff = (float)(cy - start_off[1]);
            czoff = (float)(cz - start_off[2]);
        }
        if (verticalJustification == TextControl.Justification.TOP) {
            double height = 0.8;
            cxoff = (float)((double)cxoff + 0.8 * up_scaled[0]);
            cyoff = (float)((double)cyoff + 0.8 * up_scaled[1]);
            czoff = (float)((double)czoff + 0.8 * up_scaled[2]);
        } else if (verticalJustification == TextControl.Justification.CENTER) {
            double height = 0.8;
            cxoff = (float)((double)cxoff + 0.8 * up_scaled[0] / 2.0);
            cyoff = (float)((double)cyoff + 0.8 * up_scaled[1] / 2.0);
            czoff = (float)((double)czoff + 0.8 * up_scaled[2] / 2.0);
        }
        if (cxoff != 0.0f || cyoff != 0.0f || czoff != 0.0f) {
            for (i = 0; i < plot_index; i += 3) {
                plot[i] = plot[i] - cxoff;
                plot[i + 1] = plot[i + 1] - cyoff;
                plot[i + 2] = plot[i + 2] - czoff;
            }
        }
        VisADLineArray array = new VisADLineArray();
        float[] coordinates = new float[plot_index];
        System.arraycopy(plot, 0, coordinates, 0, plot_index);
        array.coordinates = coordinates;
        array.vertexCount = plot_index / 3;
        return array;
    }

    public static String shortString(double val) {
        return Convert.shortString(val);
    }

    public static VisADLineArray render_font(String str, HersheyFont font, double[] start, double[] base, double[] up, boolean center) {
        return PlotText.render_font(str, font, start, base, up, center ? TextControl.Justification.CENTER : TextControl.Justification.LEFT, TextControl.Justification.BOTTOM, 0.0, 1.0, null);
    }

    public static VisADLineArray render_font(String str, HersheyFont font, double[] start, double[] base, double[] up, TextControl.Justification justification) {
        return PlotText.render_font(str, font, start, base, up, justification, TextControl.Justification.BOTTOM, 0.0, 1.0, null);
    }

    public static VisADLineArray render_font(String str, HersheyFont font, double[] start, double[] base, double[] up, TextControl.Justification justification, double characRotation) {
        return PlotText.render_font(str, font, start, base, up, justification, TextControl.Justification.BOTTOM, characRotation, 1.0, null);
    }

    public static VisADLineArray render_font(String str, HersheyFont font, double[] start, double[] base, double[] up, TextControl.Justification justification, TextControl.Justification verticalJustification) {
        return PlotText.render_font(str, font, start, base, up, justification, verticalJustification, 0.0, 1.0, null);
    }

    public static VisADLineArray render_font(String str, HersheyFont font, double[] start, double[] base, double[] up, TextControl.Justification justification, TextControl.Justification verticalJustification, double characRotation, double scale, double[] offsets) {
        if (offsets == null) {
            offsets = new double[]{0.0, 0.0, 0.0};
        }
        double[] start_off = new double[]{start[0] + offsets[0], start[1] + offsets[1], start[2] + offsets[2]};
        if (scale <= 0.0) {
            scale = 1.0;
        }
        double[] base_scaled = new double[]{base[0] * scale, base[1] * scale, base[2] * scale};
        double[] up_scaled = new double[]{up[0] * scale, up[1] * scale, up[2] * scale};
        int maxChars = font.getCharactersInSet();
        double width = 0.0;
        double startx = 0.0;
        double starty = 0.0;
        double startz = 0.0;
        double cx = start_off[0];
        double cy = start_off[1];
        double cz = start_off[2];
        int len = str.length();
        boolean isFixed = font.getFixedWidth();
        int maxSeg = font.getMaxPoints();
        float[] plot = new float[maxSeg * 6 * len];
        int plot_index = 0;
        int[] charMinX = font.getCharacterMinX();
        int[] charMaxX = font.getCharacterMaxX();
        int charMinY = font.getCharacterSetMinY();
        int charMaxY = font.getCharacterSetMaxY();
        int charSetMinX = font.getCharacterSetMinX();
        int charSetMaxX = font.getCharacterSetMaxX();
        boolean isCursive = font.getIsCursive();
        float oldpx = 0.0f;
        float oldpy = 0.0f;
        float oldpz = 0.0f;
        double angle = Math.toRadians(-characRotation);
        float angle2 = (float)(angle + 1.5707963267948966);
        for (int i = 0; i < len; ++i) {
            float y;
            float x;
            char cur_char = str.charAt(i);
            int k = str.charAt(i) - 32;
            if (k < 0 || k > maxChars) continue;
            char[][] charVector = font.getCharacterVector(k);
            int verts = font.getNumberOfPoints(k);
            if (i > 0) {
                width = 0.08;
                if (isCursive) {
                    width = -0.08;
                }
                cx += width * base_scaled[0];
                cy += width * base_scaled[1];
                cz += width * base_scaled[2];
            }
            int plot_index_begin = plot_index;
            boolean skip = true;
            float maxX = 0.0f;
            float maxY = 0.0f;
            float minY = charMaxY;
            for (int j = 1; j < verts; ++j) {
                if (charVector[0][j] == ' ') {
                    skip = true;
                    continue;
                }
                float w = isFixed ? (float)(charVector[0][j] - charMinX[k]) / (float)(charSetMaxX - charSetMinX) : (float)(charVector[0][j] - charMinX[k]) / (float)(charMaxX[k] - charMinX[k]);
                float h2 = (float)(charMaxY - charVector[1][j]) / (float)(charMaxY - charMinY);
                if (w > maxX) {
                    maxX = w;
                }
                if (h2 > maxY) {
                    maxY = h2;
                }
                if (h2 < minY) {
                    minY = h2;
                }
                x = (float)((double)w * Math.cos(angle) - (double)h2 * Math.sin(angle));
                y = (float)((double)w * Math.sin(angle) + (double)h2 * Math.cos(angle));
                float px = (float)(cx + (double)x * base_scaled[0] + (double)y * up_scaled[0]);
                float py = (float)(cy + (double)x * base_scaled[1] + (double)y * up_scaled[1]);
                float pz = (float)(cz + (double)x * base_scaled[2] + (double)y * up_scaled[2]);
                if (!skip) {
                    plot[plot_index] = oldpx;
                    plot[plot_index + 1] = oldpy;
                    plot[plot_index + 2] = oldpz;
                    plot[plot_index + 3] = px;
                    plot[plot_index + 4] = py;
                    plot[plot_index + 5] = pz;
                    plot_index += 6;
                }
                skip = false;
                oldpx = px;
                oldpy = py;
                oldpz = pz;
            }
            if (verts == 1) {
                maxX = 0.5f;
            }
            if (minY > maxY) {
                minY = maxY;
            }
            x = maxX;
            y = (float)Math.max((double)(maxY - minY) + 0.3, 0.5);
            float x_plus = (float)((double)x * Math.abs(Math.cos(angle)) + (double)y * Math.abs(Math.cos(angle2)));
            float cur_x_off = 0.0f;
            if (Math.cos(angle) < 0.0) {
                cur_x_off = (float)((double)x * Math.abs(Math.cos(angle)));
            }
            if (Math.cos(angle2) < 0.0) {
                cur_x_off += (float)((double)y * Math.abs(Math.cos(angle2)));
            }
            float y1 = (float)(((double)minY + 0.3) / 2.0 - (double)minY);
            cur_x_off += (float)((double)y1 * Math.cos(angle2));
            for (int j = plot_index_begin; j < plot_index; j += 6) {
                int n = j;
                plot[n] = (float)((double)plot[n] + (double)cur_x_off * base_scaled[0]);
                int n2 = j + 1;
                plot[n2] = (float)((double)plot[n2] + (double)cur_x_off * base_scaled[1]);
                int n3 = j + 2;
                plot[n3] = (float)((double)plot[n3] + (double)cur_x_off * base_scaled[2]);
                int n4 = j + 3;
                plot[n4] = (float)((double)plot[n4] + (double)cur_x_off * base_scaled[0]);
                int n5 = j + 4;
                plot[n5] = (float)((double)plot[n5] + (double)cur_x_off * base_scaled[1]);
                int n6 = j + 5;
                plot[n6] = (float)((double)plot[n6] + (double)cur_x_off * base_scaled[2]);
            }
            cx += (width += (double)x_plus) * base_scaled[0];
            cy += width * base_scaled[1];
            cz += width * base_scaled[2];
        }
        if (plot_index <= 0) {
            return null;
        }
        float cxoff = 0.0f;
        float cyoff = 0.0f;
        float czoff = 0.0f;
        if (justification == TextControl.Justification.CENTER) {
            cxoff = (float)((cx - start_off[0]) / 2.0);
            cyoff = (float)((cy - start_off[1]) / 2.0);
            czoff = (float)((cz - start_off[2]) / 2.0);
        } else if (justification == TextControl.Justification.RIGHT) {
            cxoff = (float)(cx - start_off[0]);
            cyoff = (float)(cy - start_off[1]);
            czoff = (float)(cz - start_off[2]);
        }
        if (verticalJustification == TextControl.Justification.TOP) {
            double height = 0.8;
            cxoff = (float)((double)cxoff + 0.8 * up_scaled[0]);
            cyoff = (float)((double)cyoff + 0.8 * up_scaled[1]);
            czoff = (float)((double)czoff + 0.8 * up_scaled[2]);
        } else if (verticalJustification == TextControl.Justification.CENTER) {
            double height = 0.8;
            cxoff = (float)((double)cxoff + 0.8 * up_scaled[0] / 2.0);
            cyoff = (float)((double)cyoff + 0.8 * up_scaled[1] / 2.0);
            czoff = (float)((double)czoff + 0.8 * up_scaled[2] / 2.0);
        }
        if (cxoff != 0.0f || cyoff != 0.0f || czoff != 0.0f) {
            for (int i = 0; i < plot_index; i += 3) {
                plot[i] = plot[i] - cxoff;
                plot[i + 1] = plot[i + 1] - cyoff;
                plot[i + 2] = plot[i + 2] - czoff;
            }
        }
        VisADLineArray array = new VisADLineArray();
        float[] coordinates = new float[plot_index];
        System.arraycopy(plot, 0, coordinates, 0, plot_index);
        array.coordinates = coordinates;
        array.vertexCount = plot_index / 3;
        return array;
    }

    public static VisADTriangleArray render_font(String str, Font font, double[] start, double[] base, double[] up, boolean center) {
        return PlotText.render_font(str, font, start, base, up, center ? TextControl.Justification.CENTER : TextControl.Justification.LEFT, TextControl.Justification.BOTTOM, 0.0, 1.0, null);
    }

    public static VisADTriangleArray render_font(String str, Font font, double[] start, double[] base, double[] up, TextControl.Justification justification) {
        return PlotText.render_font(str, font, start, base, up, justification, TextControl.Justification.BOTTOM, 0.0, 1.0, null);
    }

    public static VisADTriangleArray render_font(String str, Font font, double[] start, double[] base, double[] up, TextControl.Justification justification, double characRotation) {
        return PlotText.render_font(str, font, start, base, up, justification, TextControl.Justification.BOTTOM, characRotation, 1.0, null);
    }

    public static VisADTriangleArray render_font(String str, Font font, double[] start, double[] base, double[] up, TextControl.Justification justification, TextControl.Justification verticalJustification) {
        return PlotText.render_font(str, font, start, base, up, justification, verticalJustification, 0.0, 1.0, null);
    }

    public static VisADTriangleArray render_font(String str, Font font, double[] start, double[] base, double[] up, TextControl.Justification justification, TextControl.Justification verticalJustification, double characRotation, double scale, double[] offsets) {
        VisADTriangleArray array = null;
        if (offsets == null) {
            offsets = new double[]{0.0, 0.0, 0.0};
        }
        double[] start_off = new double[]{start[0] + offsets[0], start[1] + offsets[1], start[2] + offsets[2]};
        if (scale < 0.0) {
            scale = 1.0;
        }
        float fsize = font.getSize();
        float fsize_inv = (float)(scale / (double)fsize);
        int str_len = str.length();
        AffineTransform at = null;
        boolean isAntiAliased = false;
        boolean usesFractionalMetrics = false;
        FontRenderContext frc = new FontRenderContext(at, isAntiAliased, usesFractionalMetrics);
        GlyphVector gv = font.createGlyphVector(frc, "M");
        float maxW = (float)((double)fsize_inv * gv.getGlyphMetrics(0).getBounds2D().getWidth());
        double flatness = 0.05;
        Vector<Object> big_vector = new Vector<Object>();
        int big_len = 1000;
        float[][] big_samples = new float[2][big_len];
        float[] seg = new float[6];
        float x_offset = 0.0f;
        for (int str_index = 0; str_index < str_len; ++str_index) {
            char[] chars = new char[]{str.charAt(str_index)};
            gv = font.createGlyphVector(frc, chars);
            int ng = gv.getNumGlyphs();
            if (ng == 0) continue;
            int path_count = 0;
            Vector<float[][]> samples_vector = new Vector<float[][]>();
            float angle = (float)Math.toRadians(-characRotation);
            float angle2 = (float)((double)angle + 1.5707963267948966);
            float x = fsize_inv * gv.getGlyphMetrics(0).getAdvance();
            float y = (float)((double)fsize_inv * gv.getGlyphMetrics(0).getBounds2D().getHeight() + 0.2);
            float x_plus = (float)((double)x * Math.abs(Math.cos(angle)) + (double)y * Math.abs(Math.cos(angle2)));
            float y1 = (float)((double)fsize_inv * (gv.getGlyphMetrics(0).getBounds2D().getY() * -1.0) + 0.2);
            float cur_x_off = 0.0f;
            if (Math.cos(angle) < 0.0) {
                cur_x_off = (float)((double)x * Math.abs(Math.cos(angle)));
            }
            cur_x_off = Math.cos(angle2) < 0.0 ? (cur_x_off += (float)((double)y1 * Math.abs(Math.cos(angle2)))) : (cur_x_off += (float)((double)(y - y1) * Math.abs(Math.cos(angle2))));
            float w = (float)((double)fsize_inv * gv.getGlyphMetrics(0).getBounds2D().getWidth());
            float x_start = (float)((double)fsize_inv * gv.getGlyphMetrics(0).getBounds2D().getX());
            float space = (float)((double)(maxW - w) / 2.0);
            float cur_y_off = (float)((double)(space - x_start) * Math.cos(angle2));
            for (int ig = 0; ig < ng; ++ig) {
                Shape sh = null;
                if (characRotation != 0.0) {
                    Shape sh0 = gv.getGlyphOutline(ig);
                    angle = (float)Math.toRadians(characRotation);
                    AffineTransform at2 = AffineTransform.getRotateInstance(angle);
                    sh = at2.createTransformedShape(sh0);
                } else {
                    sh = gv.getGlyphOutline(ig);
                }
                PathIterator pi = sh.getPathIterator(at, flatness);
                int k = 0;
                while (!pi.isDone()) {
                    int segType = pi.currentSegment(seg);
                    switch (segType) {
                        case 0: {
                            float[][] samples;
                            if (k > 0) {
                                samples = new float[2][k];
                                System.arraycopy(big_samples[0], 0, samples[0], 0, k);
                                System.arraycopy(big_samples[1], 0, samples[1], 0, k);
                                samples_vector.addElement(samples);
                                k = 0;
                                ++path_count;
                            }
                        }
                        case 1: {
                            big_samples[0][k] = x_offset + cur_x_off + fsize_inv * seg[0];
                            big_samples[1][k] = -cur_y_off - fsize_inv * seg[1];
                            if (++k < big_len) break;
                            float[][] bs = new float[2][2 * big_len];
                            System.arraycopy(big_samples[0], 0, bs[0], 0, big_len);
                            System.arraycopy(big_samples[1], 0, bs[1], 0, big_len);
                            big_samples = bs;
                            big_len = 2 * big_len;
                            break;
                        }
                        case 4: {
                            if (k <= 0) break;
                            float[][] samples = new float[2][k];
                            System.arraycopy(big_samples[0], 0, samples[0], 0, k);
                            System.arraycopy(big_samples[1], 0, samples[1], 0, k);
                            samples_vector.addElement(samples);
                            k = 0;
                            ++path_count;
                        }
                    }
                    pi.next();
                }
                if (k <= 0) continue;
                float[][] samples = new float[2][k];
                System.arraycopy(big_samples[0], 0, samples[0], 0, k);
                System.arraycopy(big_samples[1], 0, samples[1], 0, k);
                samples_vector.addElement(samples);
                k = 0;
                ++path_count;
            }
            if (path_count == 1) {
                big_vector.addElement(samples_vector.elementAt(0));
            } else if (path_count > 1) {
                int i;
                float[][][] ss = new float[path_count][][];
                for (i = 0; i < path_count; ++i) {
                    ss[i] = (float[][])samples_vector.elementAt(i);
                }
                try {
                    if (path_count == 2 && !DelaunayCustom.inside(ss[0], ss[1][0][0], ss[1][1][0]) && !DelaunayCustom.inside(ss[1], ss[0][0][0], ss[0][1][0])) {
                        for (i = 0; i < path_count; ++i) {
                            big_vector.addElement(ss[i]);
                        }
                    } else {
                        big_vector.addElement(DelaunayCustom.link(ss));
                    }
                }
                catch (VisADException ex) {
                    System.out.println(ex);
                }
            }
            samples_vector.removeAllElements();
            x_offset += x_plus;
        }
        x_offset = justification == TextControl.Justification.CENTER ? -0.5f * x_offset : (justification == TextControl.Justification.RIGHT ? -1.0f * x_offset : 0.0f);
        float y_offset = (float)(0.8 * scale);
        y_offset = verticalJustification == TextControl.Justification.CENTER ? -0.5f * y_offset : (verticalJustification == TextControl.Justification.TOP ? -1.0f * y_offset : 0.0f);
        int n = big_vector.size();
        VisADGeometryArray[] arrays = new VisADTriangleArray[n];
        for (int i = 0; i < n; ++i) {
            float[][] samples = (float[][])big_vector.elementAt(i);
            int[][] tris = null;
            try {
                tris = DelaunayCustom.fillCheck(samples, false);
            }
            catch (VisADException ex) {
                // empty catch block
            }
            if (tris == null || tris.length == 0) continue;
            int m3 = tris.length;
            float[] coordinates = new float[9 * m3];
            for (int j = 0; j < m3; ++j) {
                int j9 = 9 * j;
                for (int tj = 0; tj < 3; ++tj) {
                    int j3 = j9 + 3 * tj;
                    coordinates[j3 + 0] = (float)(start_off[0] + base[0] * (double)(samples[0][tris[j][tj]] + x_offset) + up[0] * (double)(samples[1][tris[j][tj]] + y_offset));
                    coordinates[j3 + 1] = (float)(start_off[1] + base[1] * (double)(samples[0][tris[j][tj]] + x_offset) + up[1] * (double)(samples[1][tris[j][tj]] + y_offset));
                    coordinates[j3 + 2] = (float)(start_off[2] + base[2] * (double)(samples[0][tris[j][tj]] + x_offset) + up[2] * (double)(samples[1][tris[j][tj]] + y_offset));
                }
            }
            float[] normals = new float[9 * m3];
            for (int j = 0; j < 3 * m3; ++j) {
                int j3 = 3 * j;
                normals[j3 + 0] = 0.0f;
                normals[j3 + 1] = 0.0f;
                normals[j3 + 2] = 1.0f;
            }
            arrays[i] = new VisADTriangleArray();
            ((VisADTriangleArray)arrays[i]).vertexCount = 3 * m3;
            ((VisADTriangleArray)arrays[i]).coordinates = coordinates;
            ((VisADTriangleArray)arrays[i]).normals = normals;
        }
        array = new VisADTriangleArray();
        try {
            VisADGeometryArray.merge(arrays, array);
        }
        catch (VisADException ex) {
            array = new VisADTriangleArray();
        }
        if (array.coordinates == null) {
            return null;
        }
        return array;
    }
}

