/*
 * Decompiled with CFR 0.152.
 */
package visad.bom;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.CommonUnit;
import visad.ConstantMap;
import visad.CoordinateSystem;
import visad.DataDisplayLink;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.Display;
import visad.EarthVectorType;
import visad.FlatField;
import visad.FlowControl;
import visad.FunctionType;
import visad.Integer1DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.SetType;
import visad.ShadowType;
import visad.TupleType;
import visad.VisADException;
import visad.bom.BarbRenderer;
import visad.bom.ShadowBarbFunctionTypeJ3D;
import visad.bom.ShadowBarbRealTupleTypeJ3D;
import visad.bom.ShadowBarbRealTypeJ3D;
import visad.bom.ShadowBarbSetTypeJ3D;
import visad.bom.ShadowBarbTupleTypeJ3D;
import visad.bom.SwellManipulationRendererJ3D;
import visad.bom.WindPolarCoordinateSystem;
import visad.java3d.DefaultRendererJ3D;
import visad.java3d.DisplayImplJ3D;

public class SwellRendererJ3D
extends DefaultRendererJ3D
implements BarbRenderer {
    private SwellManipulationRendererJ3D smr = new SwellManipulationRendererJ3D();
    static final int N = 5;

    public ShadowType makeShadowFunctionType(FunctionType type, DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        return new ShadowBarbFunctionTypeJ3D(type, link, parent);
    }

    public ShadowType makeShadowRealTupleType(RealTupleType type, DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        return new ShadowBarbRealTupleTypeJ3D(type, link, parent);
    }

    public ShadowType makeShadowRealType(RealType type, DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        return new ShadowBarbRealTypeJ3D(type, link, parent);
    }

    public ShadowType makeShadowSetType(SetType type, DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        return new ShadowBarbSetTypeJ3D(type, link, parent);
    }

    public ShadowType makeShadowTupleType(TupleType type, DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        return new ShadowBarbTupleTypeJ3D(type, link, parent);
    }

    public void setKnotsConvert(boolean enable) {
        this.smr.setKnotsConvert(enable);
    }

    public boolean getKnotsConvert() {
        return this.smr.getKnotsConvert();
    }

    public float[] makeVector(boolean south, float x, float y, float z, float scale, float pt_size, float f0, float f1, float[] vx, float[] vy, float[] vz, int[] numv, float[] tx, float[] ty, float[] tz, int[] numt) {
        return this.smr.makeVector(south, x, y, z, scale, pt_size, f0, f1, vx, vy, vz, numv, tx, ty, tz, numt);
    }

    public Object clone() {
        return new SwellRendererJ3D();
    }

    public static void main(String[] args) throws VisADException, RemoteException {
        FlowControl flow_control;
        double mid_lat = -10.0;
        if (args.length > 0) {
            try {
                mid_lat = Double.valueOf(args[0]);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        RealType lat = RealType.Latitude;
        RealType lon = RealType.Longitude;
        RealType flowx = RealType.getRealType("flowx", CommonUnit.meterPerSecond);
        RealType flowy = RealType.getRealType("flowy", CommonUnit.meterPerSecond);
        RealType red = RealType.getRealType("red");
        RealType green = RealType.getRealType("green");
        RealType index = RealType.getRealType("index");
        EarthVectorType flowxy = new EarthVectorType(flowx, flowy);
        TupleType range = null;
        RealType flow_degree = RealType.getRealType("flow_degree", CommonUnit.degree);
        RealType flow_speed = RealType.getRealType("flow_speed", CommonUnit.meterPerSecond);
        if (args.length > 1) {
            System.out.println("polar winds");
            RealTupleType flowds = new RealTupleType(new RealType[]{flow_degree, flow_speed}, (CoordinateSystem)new WindPolarCoordinateSystem(flowxy), null);
            range = new TupleType(new MathType[]{lon, lat, flowds, red, green});
        } else {
            System.out.println("Cartesian winds");
            range = new TupleType(new MathType[]{lon, lat, flowxy, red, green});
        }
        FunctionType flow_field = new FunctionType(index, range);
        DisplayImplJ3D display = new DisplayImplJ3D("display1");
        ScalarMap xmap = new ScalarMap(lon, Display.XAxis);
        display.addMap(xmap);
        ScalarMap ymap = new ScalarMap(lat, Display.YAxis);
        display.addMap(ymap);
        if (args.length > 1) {
            ScalarMap flowd_map = new ScalarMap(flow_degree, Display.Flow1Azimuth);
            display.addMap(flowd_map);
            flowd_map.setRange(0.0, 360.0);
            ScalarMap flows_map = new ScalarMap(flow_speed, Display.Flow1Radial);
            display.addMap(flows_map);
            flows_map.setRange(0.0, 1.0);
            flow_control = (FlowControl)flows_map.getControl();
            flow_control.setFlowScale(0.1f);
        } else {
            ScalarMap flowx_map = new ScalarMap(flowx, Display.Flow1X);
            display.addMap(flowx_map);
            flowx_map.setRange(-1.0, 1.0);
            ScalarMap flowy_map = new ScalarMap(flowy, Display.Flow1Y);
            display.addMap(flowy_map);
            flowy_map.setRange(-1.0, 1.0);
            flow_control = (FlowControl)flowy_map.getControl();
            flow_control.setFlowScale(0.1f);
        }
        display.addMap(new ScalarMap(red, Display.Red));
        display.addMap(new ScalarMap(green, Display.Green));
        display.addMap(new ConstantMap(1.0, Display.Blue));
        Integer1DSet set = new Integer1DSet(25);
        double[][] values = new double[6][25];
        int m3 = 0;
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                double u = 2.0 * (double)i / 4.0 - 1.0;
                double v = 2.0 * (double)j / 4.0 - 1.0;
                values[0][m3] = 10.0 * u;
                values[1][m3] = 10.0 * v + mid_lat;
                double fx = 30.0 * u;
                double fy = 30.0 * v;
                if (args.length > 1) {
                    values[2][m3] = 57.29577951308232 * Math.atan2(-fx, -fy);
                    values[3][m3] = Math.sqrt(fx * fx + fy * fy);
                } else {
                    values[2][m3] = fx;
                    values[3][m3] = fy;
                }
                values[4][m3] = u;
                values[5][m3] = v;
                ++m3;
            }
        }
        FlatField field = new FlatField(flow_field, set);
        field.setSamples(values);
        DataReferenceImpl ref = new DataReferenceImpl("ref");
        ref.setData(field);
        SwellRendererJ3D renderer = new SwellRendererJ3D();
        display.addReferences((DataRenderer)renderer, ref);
        JFrame frame = new JFrame("test SwellRendererJ3D");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setAlignmentY(0.0f);
        panel.setAlignmentX(0.0f);
        frame.getContentPane().add(panel);
        panel.add(display.getComponent());
        frame.setSize(500, 500);
        frame.setVisible(true);
    }
}

