/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.cleaner.DbFileSummary;
import com.sleepycat.je.cleaner.FileSummary;
import com.sleepycat.je.cleaner.PackedOffsets;
import com.sleepycat.je.cleaner.TrackedFileSummary;
import com.sleepycat.je.cleaner.UtilizationProfile;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.SortedLSNTreeWalker;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.UtilizationFileReader;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.MapLN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.utilint.DbLsn;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerifyUtils {
    private static final boolean DEBUG = false;

    public static void checkLsns(Database db) throws DatabaseException {
        VerifyUtils.checkLsns(DbInternal.getDatabaseImpl(db), System.out);
    }

    public static void checkLsns(DatabaseImpl dbImpl, PrintStream out) throws DatabaseException {
        GatherLSNs gatherLsns = new GatherLSNs();
        long rootLsn = dbImpl.getTree().getRootLsn();
        ArrayList<DatabaseException> savedExceptions = new ArrayList<DatabaseException>();
        SortedLSNTreeWalker walker = new SortedLSNTreeWalker(dbImpl, false, rootLsn, gatherLsns, savedExceptions, null);
        walker.walk();
        if (savedExceptions.size() > 0) {
            out.println(savedExceptions.size() + " problems seen during tree walk for checkLsns");
            Iterator iter = savedExceptions.iterator();
            while (iter.hasNext()) {
                out.println("  " + iter.next());
            }
        }
        Set<Long> lsnsInTree = gatherLsns.getLsns();
        if (rootLsn != -1L) {
            lsnsInTree.add(rootLsn);
        }
        Iterator<Long> iter = lsnsInTree.iterator();
        HashSet<Long> fileNums = new HashSet<Long>();
        while (iter.hasNext()) {
            long lsn = iter.next();
            fileNums.add(DbLsn.getFileNumber(lsn));
        }
        iter = fileNums.iterator();
        HashSet<Long> obsoleteLsns = new HashSet<Long>();
        EnvironmentImpl envImpl = dbImpl.getDbEnvironment();
        UtilizationProfile profile = envImpl.getUtilizationProfile();
        while (iter.hasNext()) {
            Long fileNum = iter.next();
            PackedOffsets obsoleteOffsets = new PackedOffsets();
            TrackedFileSummary tfs = profile.getObsoleteDetail(fileNum, obsoleteOffsets, false);
            PackedOffsets.Iterator obsoleteIter = obsoleteOffsets.iterator();
            while (obsoleteIter.hasNext()) {
                long offset = obsoleteIter.next();
                Long oneLsn = DbLsn.makeLsn((long)fileNum, offset);
                obsoleteLsns.add(oneLsn);
            }
        }
        boolean error = false;
        for (Long lsn : lsnsInTree) {
            if (!obsoleteLsns.contains(lsn)) continue;
            out.println("Obsolete LSN set contains valid LSN " + DbLsn.getNoFormatString(lsn));
            error = true;
        }
        for (Long lsn : obsoleteLsns) {
            if (!lsnsInTree.contains(lsn)) continue;
            out.println("Tree contains obsolete LSN " + DbLsn.getNoFormatString(lsn));
            error = true;
        }
        if (error) {
            throw new EnvironmentFailureException(envImpl, EnvironmentFailureReason.LOG_INTEGRITY, "Lsn mismatch");
        }
        if (savedExceptions.size() > 0) {
            throw new EnvironmentFailureException(envImpl, EnvironmentFailureReason.LOG_INTEGRITY, "Sorted LSN Walk problem");
        }
    }

    public static void verifyUtilization(EnvironmentImpl envImpl, boolean expectAccurateObsoleteLNCount, boolean expectAccurateObsoleteLNSize, boolean expectAccurateDbUtilization) throws DatabaseException {
        SortedMap<Long, FileSummary> profileMap = envImpl.getCleaner().getUtilizationProfile().getFileSummaryMap(true);
        envImpl.getLogManager().flushNoSync();
        Map<Long, FileSummary> recalcMap = UtilizationFileReader.calcFileSummaryMap(envImpl);
        Map<Long, DbFileSummary> dbDerivedMap = null;
        if (expectAccurateDbUtilization) {
            dbDerivedMap = VerifyUtils.calcDbDerivedUtilization(envImpl);
        }
        for (Map.Entry entry : profileMap.entrySet()) {
            Long file = (Long)entry.getKey();
            String fileStr = file.toString();
            FileSummary profileSummary = (FileSummary)entry.getValue();
            FileSummary recalcSummary = recalcMap.remove(file);
            VerifyUtils.check(fileStr, recalcSummary != null);
            VerifyUtils.check(fileStr, recalcSummary.totalCount == profileSummary.totalCount);
            VerifyUtils.check(fileStr, recalcSummary.totalSize == profileSummary.totalSize);
            VerifyUtils.check(fileStr, recalcSummary.totalINCount == profileSummary.totalINCount);
            VerifyUtils.check(fileStr, recalcSummary.totalINSize == profileSummary.totalINSize);
            VerifyUtils.check(fileStr, recalcSummary.totalLNCount == profileSummary.totalLNCount);
            VerifyUtils.check(fileStr, recalcSummary.totalLNSize == profileSummary.totalLNSize);
            if (expectAccurateObsoleteLNCount) {
                VerifyUtils.check(fileStr, recalcSummary.obsoleteLNCount == profileSummary.obsoleteLNCount);
                if (expectAccurateObsoleteLNSize) {
                    VerifyUtils.check(fileStr, recalcSummary.getObsoleteLNSize() == profileSummary.obsoleteLNSize);
                }
            }
            if (!expectAccurateDbUtilization) continue;
            DbFileSummary dbSummary = dbDerivedMap.remove(file);
            if (dbSummary == null) {
                dbSummary = new DbFileSummary();
            }
            VerifyUtils.check(fileStr, profileSummary.totalINCount == dbSummary.totalINCount);
            VerifyUtils.check(fileStr, profileSummary.totalLNCount == dbSummary.totalLNCount);
            VerifyUtils.check(fileStr, profileSummary.totalINSize == dbSummary.totalINSize);
            VerifyUtils.check(fileStr, profileSummary.totalLNSize == dbSummary.totalLNSize);
            VerifyUtils.check(fileStr, profileSummary.obsoleteINCount == dbSummary.obsoleteINCount);
            if (!expectAccurateObsoleteLNCount) continue;
            VerifyUtils.check(fileStr, profileSummary.obsoleteLNCount == dbSummary.obsoleteLNCount);
            if (!expectAccurateObsoleteLNSize) continue;
            VerifyUtils.check(fileStr, profileSummary.obsoleteLNSize == dbSummary.obsoleteLNSize);
            VerifyUtils.check(fileStr, profileSummary.obsoleteLNSizeCounted == dbSummary.obsoleteLNSizeCounted);
        }
        VerifyUtils.check(recalcMap.toString(), recalcMap.isEmpty());
        if (expectAccurateDbUtilization) {
            VerifyUtils.check(dbDerivedMap.toString(), dbDerivedMap.isEmpty());
        }
    }

    private static void check(String errorMessage, boolean checkIsTrue) {
        if (!checkIsTrue) {
            throw EnvironmentFailureException.unexpectedState(errorMessage);
        }
    }

    private static Map<Long, DbFileSummary> calcDbDerivedUtilization(EnvironmentImpl envImpl) throws DatabaseException {
        final HashMap<Long, DbFileSummary> grandTotalsMap = new HashMap<Long, DbFileSummary>();
        DbTree dbTree = envImpl.getDbTree();
        VerifyUtils.addDbDerivedTotals(dbTree.getDb(DbTree.ID_DB_ID), grandTotalsMap);
        VerifyUtils.addDbDerivedTotals(dbTree.getDb(DbTree.NAME_DB_ID), grandTotalsMap);
        CursorImpl.traverseDbWithCursor(dbTree.getDb(DbTree.ID_DB_ID), LockType.NONE, true, new CursorImpl.WithCursor(){

            public boolean withCursor(CursorImpl cursor, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
                MapLN mapLN = (MapLN)cursor.getCurrentLN(LockType.NONE);
                VerifyUtils.addDbDerivedTotals(mapLN.getDatabase(), grandTotalsMap);
                return true;
            }
        });
        return grandTotalsMap;
    }

    private static void addDbDerivedTotals(DatabaseImpl dbImpl, Map<Long, DbFileSummary> grandTotalsMap) {
        for (Map.Entry<Long, DbFileSummary> entry : dbImpl.getDbFileSummaries().entrySet()) {
            Long fileNum = entry.getKey();
            DbFileSummary dbTotals = entry.getValue();
            DbFileSummary grandTotals = grandTotalsMap.get(fileNum);
            if (grandTotals == null) {
                grandTotals = new DbFileSummary();
                grandTotalsMap.put(fileNum, grandTotals);
            }
            grandTotals.add(dbTotals);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GatherLSNs
    implements SortedLSNTreeWalker.TreeNodeProcessor {
        private final Set<Long> lsns = new HashSet<Long>();

        private GatherLSNs() {
        }

        @Override
        public void processLSN(long childLSN, LogEntryType childType, Node ignore, byte[] ignore2) {
            this.lsns.add(childLSN);
        }

        @Override
        public void processDirtyDeletedLN(long childLsn, LN ln, byte[] lnKey) {
        }

        @Override
        public void processDupCount(int ignore) {
        }

        public Set<Long> getLsns() {
            return this.lsns;
        }
    }
}

