/*
 * Decompiled with CFR 0.152.
 */
package visad.browser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import visad.browser.Convert;
import visad.browser.Widget;

public class RangeSlider
extends Component
implements MouseListener,
MouseMotionListener {
    public static final String DEFAULT_NAME = "value";
    public static final int SLIDER_PREF_HEIGHT = 42;
    public static final int SLIDER_PREF_WIDTH = 300;
    public static final int GRIP_WIDTH = 9;
    public static final int GRIP_HEIGHT = 17;
    public static final int GRIP_TOP_Y = 4;
    public static final int GRIP_BOTTOM_Y = 21;
    public static final int GRIP_MIDDLE_Y = 12;
    public static final int SLIDER_LINE_HEIGHT = 19;
    public static final int SLIDER_LINE_WIDTH = 2;
    public static final int FONT_HEIGHT = 15;
    public static final int FONT_TOP_Y = 27;
    public static final int FONT_BOTTOM_Y = 40;
    protected float minValue = 0.0f;
    protected float maxValue = 100.0f;
    protected float minLimit = 0.0f;
    protected float maxLimit = 1.0f;
    protected int minGrip = 9;
    protected int maxGrip = 291;
    private boolean minSlide = false;
    private boolean maxSlide = false;
    protected boolean lSlideMoved = false;
    protected boolean rSlideMoved = false;
    protected boolean textChanged = false;
    private String name;
    private float lastMinLimit = 0.0f;
    private float lastMaxLimit = 0.0f;
    private String lastCurStr = "";
    protected Dimension minSize = null;
    protected Dimension prefSize = null;
    protected Dimension maxSize = null;
    private int oldX;

    public RangeSlider(String n, float min2, float max) {
        this.name = n;
        this.resetValues(min2, max);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public float[] getMinMaxValues() {
        return new float[]{this.minValue, this.maxValue};
    }

    protected void resetValues(float min2, float max) {
        this.minLimit = min2;
        this.maxLimit = max;
        this.minGrip = 9;
        this.maxGrip = this.getSize().width - 9;
        this.minSlide = false;
        this.maxSlide = false;
        this.lSlideMoved = true;
        this.rSlideMoved = true;
        this.textChanged = true;
        int w = this.getSize().width;
        this.minValue = this.gripToValue(this.minGrip, w);
        this.maxValue = this.gripToValue(this.maxGrip, w);
    }

    public void setName(String name) {
        this.name = name;
        this.textChanged = true;
        this.repaint();
    }

    public void setBounds(float min2, float max) {
        this.resetValues(min2, max);
        this.valuesUpdated();
        this.repaint();
    }

    public void setValues(float lo, float hi) {
        int w = this.getSize().width;
        this.minValue = lo;
        int g2 = this.minGrip;
        this.minGrip = this.valueToGrip(this.minValue, w);
        if (g2 != this.minGrip) {
            this.lSlideMoved = true;
        }
        this.maxValue = hi;
        g2 = this.maxGrip;
        this.maxGrip = this.valueToGrip(this.maxValue, w);
        if (g2 != this.maxGrip) {
            this.rSlideMoved = true;
        }
        this.textChanged = true;
        this.repaint();
    }

    public void setBounds(int x, int y, int w, int h2) {
        int lastW = this.getSize().width;
        super.setBounds(x, y, w, h2);
        if (lastW != w) {
            this.minGrip = this.valueToGrip(this.minValue, w);
            this.maxGrip = this.valueToGrip(this.maxValue, w);
            Graphics g2 = this.getGraphics();
            this.drawLabels(g2, lastW);
            if (g2 != null) {
                g2.dispose();
            }
        }
    }

    public void mousePressed(MouseEvent e) {
        int w = this.getSize().width;
        int x = e.getX();
        int y = e.getY();
        this.oldX = x;
        if (Widget.containedIn(x, y, this.minGrip - 8, 4, 9, 17)) {
            this.minSlide = true;
        } else if (Widget.containedIn(x, y, this.maxGrip, 4, 9, 17)) {
            this.maxSlide = true;
        } else if (Widget.containedIn(x, y, this.minGrip, 1, this.maxGrip - this.minGrip, 22)) {
            this.minSlide = true;
            this.maxSlide = true;
        } else if (Widget.containedIn(x, y, 0, 1, this.minGrip - 9, 22)) {
            this.minGrip = x < 9 ? 9 : x;
            this.minValue = this.gripToValue(this.minGrip, w);
            this.minSlide = true;
            this.lSlideMoved = true;
            this.valuesUpdated();
            this.repaint();
        } else if (Widget.containedIn(x, y, this.maxGrip + 1 - 9, 1, w - this.maxGrip + 9, 22)) {
            this.maxGrip = x > w - 9 ? w - 9 : x;
            this.maxValue = this.gripToValue(this.maxGrip, w);
            this.maxSlide = true;
            this.rSlideMoved = true;
            this.valuesUpdated();
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.minSlide = false;
        this.maxSlide = false;
        this.textChanged = true;
        this.repaint();
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        int w = this.getSize().width;
        int x = e.getX();
        int y = e.getY();
        if (this.minSlide && this.maxSlide) {
            int change = x - this.oldX;
            if (this.minGrip + change < 9) {
                change = 9 - this.minGrip;
            } else if (this.maxGrip + change > w - 9) {
                change = w - 9 - this.maxGrip;
            }
            if (change != 0) {
                this.minGrip += change;
                this.minValue = this.gripToValue(this.minGrip, w);
                this.maxGrip += change;
                this.maxValue = this.gripToValue(this.maxGrip, w);
                this.lSlideMoved = true;
                this.rSlideMoved = true;
                this.valuesUpdated();
                this.repaint();
            }
        } else if (this.minSlide) {
            this.minGrip = x < 9 ? 9 : (x >= this.maxGrip ? this.maxGrip - 1 : x);
            this.minValue = this.gripToValue(this.minGrip, w);
            this.lSlideMoved = true;
            this.valuesUpdated();
            this.repaint();
        } else if (this.maxSlide) {
            this.maxGrip = x > w - 9 ? w - 9 : (x <= this.minGrip ? this.minGrip + 1 : x);
            this.maxValue = this.gripToValue(this.maxGrip, w);
            this.rSlideMoved = true;
            this.valuesUpdated();
            this.repaint();
        }
        this.oldX = x;
    }

    public void mouseMoved(MouseEvent e) {
    }

    public Dimension getMinimumSize() {
        if (this.minSize == null) {
            this.minSize = new Dimension(0, 42);
        }
        return this.minSize;
    }

    public void setMinimumSize(Dimension dim) {
        this.minSize = dim;
    }

    public Dimension getPreferredSize() {
        if (this.prefSize == null) {
            this.prefSize = new Dimension(300, 42);
        }
        return this.prefSize;
    }

    public void setPreferredSize(Dimension dim) {
        this.prefSize = dim;
    }

    public Dimension getMaximumSize() {
        if (this.maxSize == null) {
            this.maxSize = new Dimension(Integer.MAX_VALUE, 42);
        }
        return this.maxSize;
    }

    public void setMaximumSize(Dimension dim) {
        this.maxSize = dim;
    }

    protected float gripToValue(int pos, int width) {
        float q = (float)(pos - 9) / (float)(width - 18);
        return (this.maxLimit - this.minLimit) * q + this.minLimit;
    }

    protected int valueToGrip(float value, int width) {
        float rfloat = (value - this.minLimit) * (float)(width - 18) / (this.maxLimit - this.minLimit);
        rfloat = rfloat < 0.0f ? (rfloat -= 0.5f) : (rfloat += 0.5f);
        return (int)rfloat + 9;
    }

    public void valuesUpdated() {
    }

    public void paint(Graphics g2) {
        int w = this.getSize().width;
        g2.setColor(Color.black);
        g2.fillRect(0, 0, w, 42);
        int right = w - 1;
        g2.setColor(Color.white);
        g2.drawLine(0, 12, right, 12);
        g2.drawLine(0, 0, 0, 23);
        g2.drawLine(0, 0, 2, 0);
        g2.drawLine(0, 23, 2, 23);
        g2.drawLine(right, 0, right, 23);
        g2.drawLine(right, 0, right - 2, 0);
        g2.drawLine(right, 23, right - 2, 23);
        this.lSlideMoved = true;
        this.rSlideMoved = true;
        this.textChanged = true;
        this.paintMinimum(g2);
    }

    public void repaint() {
        Graphics g2 = this.getGraphics();
        if (g2 != null) {
            this.paintMinimum(g2);
            g2.dispose();
        }
    }

    private void paintMinimum(Graphics g2) {
        int[] ypts;
        int[] xpts;
        int w = this.getSize().width;
        if (this.lSlideMoved) {
            g2.setColor(Color.black);
            g2.fillRect(2, 4, this.maxGrip - 3, 17);
            g2.setColor(Color.white);
            g2.drawLine(2, 12, this.maxGrip - 3, 12);
            g2.setColor(Color.yellow);
            xpts = new int[]{this.minGrip - 9, this.minGrip + 1, this.minGrip + 1};
            ypts = new int[]{12, 4, 21};
            g2.fillPolygon(xpts, ypts, 3);
        }
        if (this.rSlideMoved) {
            g2.setColor(Color.black);
            g2.fillRect(this.minGrip + 1, 4, w - this.minGrip - 3, 17);
            g2.setColor(Color.white);
            g2.drawLine(this.minGrip + 1, 12, w - 3, 12);
            g2.setColor(Color.yellow);
            xpts = new int[]{this.maxGrip + 9 - 1, this.maxGrip, this.maxGrip};
            ypts = new int[]{12, 4, 21};
            g2.fillPolygon(xpts, ypts, 3);
        }
        if (this.lSlideMoved || this.rSlideMoved) {
            g2.setColor(Color.pink);
            g2.fillRect(this.minGrip + 1, 12, this.maxGrip - this.minGrip - 1, 3);
        }
        if (this.textChanged) {
            this.drawLabels(g2, w);
        }
        this.lSlideMoved = false;
        this.rSlideMoved = false;
        this.textChanged = false;
    }

    private void drawLabels(Graphics g2, int lastW) {
        String maxStr;
        String minStr;
        String maxS;
        String minS;
        int sw;
        int w = this.getSize().width;
        FontMetrics fm = g2.getFontMetrics();
        if (this.lastMinLimit != this.minLimit || lastW != w) {
            g2.setColor(Color.black);
            sw = fm.stringWidth("" + this.lastMinLimit);
            g2.fillRect(1, 27, sw, 15);
            this.lastMinLimit = this.minLimit;
        }
        if (this.lastMaxLimit != this.maxLimit || lastW != w) {
            g2.setColor(Color.black);
            sw = fm.stringWidth("" + this.lastMaxLimit);
            g2.fillRect(lastW - 4 - sw, 27, sw, 15);
            this.lastMaxLimit = this.maxLimit;
        }
        if (this.minValue < this.maxValue) {
            minS = Convert.shortString(this.minValue, 2);
            maxS = Convert.shortString(this.maxValue, 3);
        } else {
            minS = Convert.shortString(this.minValue, 3);
            maxS = Convert.shortString(this.maxValue, 2);
        }
        String curStr = this.name + " = (" + minS + ", " + maxS + ")";
        if (!curStr.equals(this.lastCurStr) || lastW != w) {
            g2.setColor(Color.black);
            int sw2 = fm.stringWidth(this.lastCurStr);
            g2.fillRect((lastW - sw2) / 2, 27, sw2, 15);
            this.lastCurStr = curStr;
        }
        g2.setColor(Color.white);
        if (this.minLimit < this.maxLimit) {
            minStr = Convert.shortString(this.minLimit, 2);
            maxStr = Convert.shortString(this.maxLimit, 3);
        } else {
            minStr = Convert.shortString(this.minLimit, 2);
            maxStr = Convert.shortString(this.maxLimit, 3);
        }
        g2.drawString(minStr, 1, 40);
        g2.drawString(maxStr, w - 4 - fm.stringWidth(maxStr), 40);
        g2.drawString(curStr, (w - fm.stringWidth(curStr)) / 2, 40);
    }

    public static void main(String[] argv) {
        RangeSlider rs = new RangeSlider("", 0.0f, 100.0f);
        Frame f = new Frame("RangeSlider test");
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        f.add(rs);
        f.pack();
        f.setVisible(true);
        rs.setValues(22.2222f, 76.5432f);
    }
}

