/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import java.io.IOException;
import java.util.Formatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.constants.DataFormatType;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.GribUtils;
import ucar.nc2.grib.collection.GribCdmIndex;
import ucar.nc2.grib.collection.GribCollectionImmutable;
import ucar.nc2.grib.collection.GribIosp;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.grib.grib2.Grib2RecordScanner;
import ucar.nc2.grib.grib2.table.Grib2Customizer;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.io.http.HTTPRandomAccessFile;
import ucar.unidata.util.StringUtil2;

public class Grib2Iosp
extends GribIosp {
    private static final Logger logger = LoggerFactory.getLogger(Grib2Iosp.class);
    private Grib2Customizer cust;

    public static String makeVariableNameFromTable(Grib2Customizer cust, GribCollectionImmutable gribCollection, GribCollectionImmutable.VariableIndex vindex, boolean useGenType) {
        String statName;
        String intvName;
        String s2;
        Formatter f = new Formatter();
        GribTables.Parameter param = cust.getParameter(vindex.getDiscipline(), vindex.getCategory(), vindex.getParameter());
        if (param == null) {
            f.format("VAR%d-%d-%d_FROM_%d-%d-%d", vindex.getDiscipline(), vindex.getCategory(), vindex.getParameter(), gribCollection.getCenter(), gribCollection.getSubcenter(), vindex.getTableVersion());
        } else {
            f.format("%s", GribUtils.makeNameFromDescription(param.getName()));
        }
        if (vindex.getGenProcessType() == 6 || vindex.getGenProcessType() == 7) {
            f.format("_error", new Object[0]);
        } else if (useGenType && vindex.getGenProcessType() >= 0) {
            String genType = cust.getGeneratingProcessTypeName(vindex.getGenProcessType());
            s2 = StringUtil2.substitute(genType, " ", "_");
            f.format("_%s", s2);
        }
        if (vindex.getLevelType() != -9999) {
            f.format("_%s", cust.getLevelNameShort(vindex.getLevelType()));
            if (vindex.isLayer()) {
                f.format("_layer", new Object[0]);
            }
        }
        if ((intvName = vindex.getIntvName()) != null && !intvName.isEmpty()) {
            f.format("_%s", intvName);
        }
        if (vindex.getIntvType() >= 0 && (statName = cust.getStatisticNameShort(vindex.getIntvType())) != null) {
            f.format("_%s", statName);
        }
        if (vindex.getSpatialStatisticalProcessType() >= 0 && (statName = cust.getTableValue("4.10", vindex.getSpatialStatisticalProcessType())) != null) {
            f.format("_%s", statName);
        }
        if (vindex.getEnsDerivedType() >= 0) {
            f.format("_%s", cust.getProbabilityNameShort(vindex.getEnsDerivedType()));
        } else if (vindex.getProbabilityName() != null && vindex.getProbabilityName().length() > 0) {
            s2 = StringUtil2.substitute(vindex.getProbabilityName(), ".", "p");
            f.format("_probability_%s", s2);
        } else if (vindex.isEnsemble()) {
            f.format("_ens", new Object[0]);
        }
        return f.toString();
    }

    public static String makeVariableLongName(Grib2Customizer cust, GribCollectionImmutable.VariableIndex vindex, boolean useGenType) {
        String statName;
        String intvName;
        GribTables.Parameter gp;
        boolean isProb;
        Formatter f = new Formatter();
        boolean bl = isProb = vindex.getProbabilityName() != null && vindex.getProbabilityName().length() > 0;
        if (isProb) {
            f.format("Probability ", new Object[0]);
        }
        if ((gp = cust.getParameter(vindex.getDiscipline(), vindex.getCategory(), vindex.getParameter())) == null) {
            f.format("Unknown Parameter %d-%d-%d", vindex.getDiscipline(), vindex.getCategory(), vindex.getParameter());
        } else {
            f.format("%s", gp.getName());
        }
        if (vindex.getIntvType() >= 0 && vindex.getIntvName() != null && !vindex.getIntvName().isEmpty()) {
            intvName = cust.getStatisticNameShort(vindex.getIntvType());
            if (intvName == null || intvName.equalsIgnoreCase("Missing")) {
                intvName = cust.getStatisticNameShort(vindex.getIntvType());
            }
            if (intvName == null) {
                f.format(" (%s)", vindex.getIntvName());
            } else {
                f.format(" (%s %s)", vindex.getIntvName(), intvName);
            }
        } else if (vindex.getIntvType() >= 0) {
            intvName = cust.getStatisticNameShort(vindex.getIntvType());
            f.format(" (%s)", intvName);
        }
        if (vindex.getSpatialStatisticalProcessType() >= 0 && (statName = cust.getTableValue("4.10", vindex.getSpatialStatisticalProcessType())) != null) {
            f.format("_%s", statName);
        }
        if (vindex.getEnsDerivedType() >= 0) {
            f.format(" (%s)", cust.getTableValue("4.10", vindex.getEnsDerivedType()));
        } else if (isProb) {
            f.format(" %s %s", vindex.getProbabilityName(), Grib2Iosp.getVindexUnits(cust, vindex));
        }
        if (vindex.getGenProcessType() == 6 || vindex.getGenProcessType() == 7) {
            f.format(" error", new Object[0]);
        } else if (useGenType && vindex.getGenProcessType() >= 0) {
            f.format(" %s", cust.getGeneratingProcessTypeName(vindex.getGenProcessType()));
        }
        if (vindex.getLevelType() != -9999) {
            f.format(" @ %s", cust.getTableValue("4.5", vindex.getLevelType()));
            if (vindex.isLayer()) {
                f.format(" layer", new Object[0]);
            }
        }
        return f.toString();
    }

    @Override
    protected String makeVariableName(GribCollectionImmutable.VariableIndex vindex) {
        return Grib2Iosp.makeVariableNameFromTable(this.cust, this.gribCollection, vindex, this.gribCollection.config.gribConfig.useGenType);
    }

    @Override
    protected String makeVariableLongName(GribCollectionImmutable.VariableIndex vindex) {
        return Grib2Iosp.makeVariableLongName(this.cust, vindex, this.gribCollection.config.gribConfig.useGenType);
    }

    @Override
    protected String makeVariableUnits(GribCollectionImmutable.VariableIndex vindex) {
        return Grib2Iosp.makeVariableUnits(this.cust, vindex);
    }

    public static String makeVariableUnits(Grib2Customizer tables, GribCollectionImmutable.VariableIndex vindex) {
        if (vindex.getProbabilityName() != null && vindex.getProbabilityName().length() > 0) {
            return "%";
        }
        return Grib2Iosp.getVindexUnits(tables, vindex);
    }

    private static String getVindexUnits(Grib2Customizer tables, GribCollectionImmutable.VariableIndex vindex) {
        GribTables.Parameter gp = tables.getParameter(vindex.getDiscipline(), vindex.getCategory(), vindex.getParameter());
        String val = gp == null ? "" : gp.getUnit();
        return val == null ? "" : val;
    }

    @Override
    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        if (raf instanceof HTTPRandomAccessFile) {
            if (raf.length() > (long)raf.getBufferSize()) {
                return false;
            }
        } else {
            GribCdmIndex.GribCollectionType type = GribCdmIndex.getType(raf);
            if (type == GribCdmIndex.GribCollectionType.GRIB2) {
                return true;
            }
            if (type == GribCdmIndex.GribCollectionType.Partition2) {
                return true;
            }
        }
        return Grib2RecordScanner.isValidFile(raf);
    }

    @Override
    public String getFileTypeId() {
        return DataFormatType.GRIB2.getDescription();
    }

    @Override
    public String getFileTypeDescription() {
        return "GRIB2 Collection";
    }

    public Grib2Iosp() {
        super(false, logger);
    }

    public Grib2Iosp(GribCollectionImmutable.GroupGC gHcs, GribCollectionImmutable.Type gtype) {
        super(false, logger);
        this.gHcs = gHcs;
        this.owned = true;
        this.gtype = gtype;
    }

    public Grib2Iosp(GribCollectionImmutable gc) {
        super(false, logger);
        this.gribCollection = gc;
        this.owned = true;
    }

    @Override
    protected GribTables createCustomizer() {
        this.cust = Grib2Customizer.factory(this.gribCollection.getCenter(), this.gribCollection.getSubcenter(), this.gribCollection.getMaster(), this.gribCollection.getLocal(), this.gribCollection.getGenProcessId());
        return this.cust;
    }

    @Override
    protected String getVerticalCoordDesc(int vc_code) {
        return this.cust.getTableValue("4.5", vc_code);
    }

    @Override
    protected GribTables.Parameter getParameter(GribCollectionImmutable.VariableIndex vindex) {
        return this.cust.getParameter(vindex.getDiscipline(), vindex.getCategory(), vindex.getParameter());
    }

    @Override
    public Object getLastRecordRead() {
        return Grib2Record.lastRecordRead;
    }

    @Override
    public void clearLastRecordRead() {
        Grib2Record.lastRecordRead = null;
    }

    @Override
    public Object getGribCustomizer() {
        return this.cust;
    }
}

