/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib1;

import com.google.protobuf.ByteString;
import com.google.protobuf.GeneratedMessage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.inventory.CollectionUpdateType;
import ucar.nc2.constants.CDM;
import ucar.nc2.grib.GribIndex;
import ucar.nc2.grib.GribIndexCache;
import ucar.nc2.grib.grib1.Grib1IndexProto;
import ucar.nc2.grib.grib1.Grib1Record;
import ucar.nc2.grib.grib1.Grib1RecordScanner;
import ucar.nc2.grib.grib1.Grib1SectionBinaryData;
import ucar.nc2.grib.grib1.Grib1SectionBitMap;
import ucar.nc2.grib.grib1.Grib1SectionGridDefinition;
import ucar.nc2.grib.grib1.Grib1SectionIndicator;
import ucar.nc2.grib.grib1.Grib1SectionProductDefinition;
import ucar.nc2.stream.NcStream;
import ucar.unidata.io.RandomAccessFile;

public class Grib1Index
extends GribIndex {
    private static Logger logger = LoggerFactory.getLogger(Grib1Index.class);
    public static final String MAGIC_START = "Grib1Index";
    private static final int version = 5;
    private static final boolean debug = false;
    public static final int grib1index_proto_version = 3;
    private List<Grib1SectionGridDefinition> gdsList;
    private List<Grib1Record> records;

    public List<Grib1SectionGridDefinition> getGds() {
        return this.gdsList;
    }

    public List<Grib1Record> getRecords() {
        return this.records;
    }

    @Override
    public int getNRecords() {
        return this.records.size();
    }

    public boolean readIndex(String filename, long gribLastModified) throws IOException {
        return this.readIndex(filename, gribLastModified, CollectionUpdateType.test);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean readIndex(String filename, long gribLastModified, CollectionUpdateType force) throws IOException {
        File idxFile;
        String idxPath = filename;
        if (!idxPath.endsWith(".gbx9")) {
            idxPath = idxPath + ".gbx9";
        }
        if ((idxFile = GribIndexCache.getExistingFileOrCache(idxPath)) == null) {
            return false;
        }
        long idxModified = idxFile.lastModified();
        if (force != CollectionUpdateType.nocheck && idxModified < gribLastModified) {
            return false;
        }
        try (FileInputStream fin = new FileInputStream(idxFile);){
            if (!NcStream.readAndTest(fin, MAGIC_START.getBytes(CDM.utf8Charset))) {
                logger.info("Bad magic number of grib index, on file = {}", (Object)idxFile);
                boolean bl = false;
                return bl;
            }
            int v = NcStream.readVInt(fin);
            if (v != 5) {
                if (v == 0) throw new IOException("Grib1Index found version " + v + ", want version " + 5 + " on " + filename);
                if (v > 5) {
                    throw new IOException("Grib1Index found version " + v + ", want version " + 5 + " on " + filename);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Grib1Index found version " + v + ", want version " + 5 + " on " + filename);
                }
                boolean bl = false;
                return bl;
            }
            int size = NcStream.readVInt(fin);
            if (size <= 0 || size > 100000000) {
                logger.warn("Grib1Index bad size = {} for {} ", (Object)size, (Object)filename);
                boolean bl = false;
                return bl;
            }
            byte[] m3 = new byte[size];
            NcStream.readFully(fin, m3);
            Grib1IndexProto.Grib1Index proto = Grib1IndexProto.Grib1Index.parseFrom(m3);
            this.gdsList = new ArrayList<Grib1SectionGridDefinition>(proto.getGdsListCount());
            for (Grib1IndexProto.Grib1GdsSection pgds : proto.getGdsListList()) {
                Grib1SectionGridDefinition gds = this.readGds(pgds);
                this.gdsList.add(gds);
            }
            this.records = new ArrayList<Grib1Record>(proto.getRecordsCount());
            Iterator<GeneratedMessage> iterator = proto.getRecordsList().iterator();
            while (iterator.hasNext()) {
                Grib1IndexProto.Grib1Record precord = (Grib1IndexProto.Grib1Record)iterator.next();
                this.records.add(this.readRecord(precord));
            }
            return true;
        }
        catch (NegativeArraySizeException e) {
            logger.error("GribIndex failed on " + filename, e);
            return false;
        }
        catch (IOException e) {
            logger.error("GribIndex failed on " + filename, e);
            return false;
        }
    }

    private Grib1Record readRecord(Grib1IndexProto.Grib1Record p) {
        Grib1SectionIndicator is = new Grib1SectionIndicator(p.getGribMessageStart(), p.getGribMessageLength());
        Grib1SectionProductDefinition pds = new Grib1SectionProductDefinition(p.getPds().toByteArray());
        Grib1SectionGridDefinition gds = pds.gdsExists() ? this.gdsList.get(p.getGdsIdx()) : new Grib1SectionGridDefinition(pds);
        Grib1SectionBitMap bms = pds.bmsExists() ? new Grib1SectionBitMap(p.getBmsPos()) : null;
        Grib1SectionBinaryData dataSection = new Grib1SectionBinaryData(p.getDataPos(), p.getDataLen());
        return new Grib1Record(p.getHeader().toByteArray(), is, gds, pds, bms, dataSection);
    }

    private Grib1SectionGridDefinition readGds(Grib1IndexProto.Grib1GdsSection proto) {
        ByteString bytes = proto.getGds();
        return new Grib1SectionGridDefinition(bytes.toByteArray());
    }

    /*
     * Loose catch block
     */
    @Override
    public boolean makeIndex(String filename, RandomAccessFile dataRaf) throws IOException {
        boolean bl;
        Throwable throwable;
        FileOutputStream fout;
        RandomAccessFile raf;
        File idxFileTmp;
        File idxFile;
        block27: {
            Grib1Record r;
            String idxPath = filename;
            if (!idxPath.endsWith(".gbx9")) {
                idxPath = idxPath + ".gbx9";
            }
            idxFile = GribIndexCache.getFileOrCache(idxPath);
            idxFileTmp = GribIndexCache.getFileOrCache(idxPath + ".tmp");
            raf = null;
            fout = new FileOutputStream(idxFileTmp);
            throwable = null;
            fout.write(MAGIC_START.getBytes(CDM.utf8Charset));
            NcStream.writeVInt(fout, 5);
            HashMap<Long, Integer> gdsMap = new HashMap<Long, Integer>();
            this.gdsList = new ArrayList<Grib1SectionGridDefinition>();
            this.records = new ArrayList<Grib1Record>(200);
            Grib1IndexProto.Grib1Index.Builder rootBuilder = Grib1IndexProto.Grib1Index.newBuilder();
            rootBuilder.setFilename(filename);
            rootBuilder.setProtoVersion(3);
            if (dataRaf == null) {
                dataRaf = raf = RandomAccessFile.acquire(filename);
            }
            Grib1RecordScanner scan = new Grib1RecordScanner(dataRaf);
            while (scan.hasNext() && (r = scan.next()) != null) {
                this.records.add(r);
                Grib1SectionGridDefinition gdss = r.getGDSsection();
                Integer index = (Integer)gdsMap.get(gdss.calcCRC());
                if (gdss.getPredefinedGridDefinition() >= 0) {
                    index = 0;
                } else if (index == null) {
                    this.gdsList.add(gdss);
                    index = this.gdsList.size() - 1;
                    gdsMap.put(gdss.calcCRC(), index);
                    rootBuilder.addGdsList(this.makeGdsProto(gdss));
                }
                rootBuilder.addRecords(this.makeRecordProto(r, index));
            }
            if (this.records.isEmpty()) {
                throw new RuntimeException("No GRIB1 records found in " + dataRaf.getLocation());
            }
            Grib1IndexProto.Grib1Index index = rootBuilder.build();
            byte[] b = index.toByteArray();
            NcStream.writeVInt(fout, b.length);
            fout.write(b);
            logger.debug("  made gbx9 index for {} size={}", (Object)filename, (Object)b.length);
            bl = true;
            if (raf == null) break block27;
            raf.close();
        }
        RandomAccessFile.eject(idxFile.getPath());
        boolean deleteOk = !idxFile.exists() || idxFile.delete();
        boolean renameOk = idxFileTmp.renameTo(idxFile);
        if (!deleteOk) {
            logger.error("  could not delete Grib1Index= {}", (Object)idxFile.getPath());
        }
        if (!renameOk) {
            logger.error("  could not rename Grib1Index= {}", (Object)idxFile.getPath());
        }
        return bl;
        {
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (fout != null) {
                    if (throwable != null) {
                        try {
                            fout.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        fout.close();
                    }
                }
            }
            {
                catch (Throwable throwable4) {
                    if (raf != null) {
                        raf.close();
                    }
                    RandomAccessFile.eject(idxFile.getPath());
                    boolean deleteOk2 = !idxFile.exists() || idxFile.delete();
                    boolean renameOk2 = idxFileTmp.renameTo(idxFile);
                    if (!deleteOk2) {
                        logger.error("  could not delete Grib1Index= {}", (Object)idxFile.getPath());
                    }
                    if (!renameOk2) {
                        logger.error("  could not rename Grib1Index= {}", (Object)idxFile.getPath());
                    }
                    throw throwable4;
                }
            }
        }
    }

    private Grib1IndexProto.Grib1Record makeRecordProto(Grib1Record r, int gdsIndex) throws IOException {
        Grib1IndexProto.Grib1Record.Builder b = Grib1IndexProto.Grib1Record.newBuilder();
        b.setHeader(ByteString.copyFrom(r.getHeader()));
        b.setGribMessageStart(r.getIs().getStartPos());
        b.setGribMessageLength(r.getIs().getMessageLength());
        b.setGdsIdx(gdsIndex);
        Grib1SectionProductDefinition pds = r.getPDSsection();
        b.setPds(ByteString.copyFrom(pds.getRawBytes()));
        if (pds.bmsExists()) {
            Grib1SectionBitMap bms = r.getBitMapSection();
            b.setBmsPos(bms.getStartingPosition());
        }
        Grib1SectionBinaryData ds = r.getDataSection();
        b.setDataPos(ds.getStartingPosition());
        b.setDataLen(ds.getLength());
        return b.build();
    }

    private Grib1IndexProto.Grib1GdsSection makeGdsProto(Grib1SectionGridDefinition gds) throws IOException {
        Grib1IndexProto.Grib1GdsSection.Builder b = Grib1IndexProto.Grib1GdsSection.newBuilder();
        b.setGds(ByteString.copyFrom(gds.getRawBytes()));
        return b.build();
    }

    public static void main(String[] args) throws IOException {
        String gribName = args[0];
        new Grib1Index().makeIndex(gribName, null);
    }
}

