/*
 * Decompiled with CFR 0.152.
 */
package visad.data.amanda;

import java.rmi.RemoteException;
import visad.Data;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded1DSet;
import visad.Gridded3DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.SetType;
import visad.VisADException;
import visad.data.amanda.AmandaFile;
import visad.util.Util;

public abstract class BaseTrack
implements Comparable {
    public static final RealType indexType = RealType.getRealType("Track_Index");
    private static final RealType energyType = RealType.getRealType("Track_Energy");
    public static FunctionType functionType;
    public static FunctionType timeSequenceType;
    public static FieldImpl missing;
    private static FunctionType indexTupleType;
    private static final float LENGTH_SCALE = 1000.0f;
    private static final int X_SAMPLE = 0;
    private static final int Y_SAMPLE = 1;
    private static final int Z_SAMPLE = 2;
    private float xstart;
    private float ystart;
    private float zstart;
    private float zenith;
    private float azimuth;
    private float length;
    private float energy;
    private float time;
    private float maxLength;
    private float[] timeSteps;
    private float[][] samples;

    BaseTrack(float xstart, float ystart, float zstart, float zenith, float azimuth, float length, float energy, float time) {
        this.xstart = xstart;
        this.ystart = ystart;
        this.zstart = zstart;
        this.zenith = zenith;
        this.azimuth = azimuth;
        this.length = length;
        this.energy = energy;
        this.time = time;
        this.timeSteps = null;
        this.samples = null;
    }

    private static final int compareFloat(float f0, float f1) {
        if (Util.isApproximatelyEqual(f0, f1)) {
            return 0;
        }
        return f0 < f1 ? -1 : 1;
    }

    public int compareTo(Object obj) {
        if (obj instanceof BaseTrack) {
            return this.compareTo((BaseTrack)obj);
        }
        return this.getClass().getName().compareTo(obj.getClass().getName());
    }

    public int compareTo(BaseTrack t) {
        int cmp = BaseTrack.compareFloat(this.time, t.time);
        if (cmp == 0 && (cmp = BaseTrack.compareFloat(this.xstart, t.xstart)) == 0 && (cmp = BaseTrack.compareFloat(this.ystart, t.ystart)) == 0 && (cmp = BaseTrack.compareFloat(this.zstart, t.zstart)) == 0 && (cmp = BaseTrack.compareFloat(this.zenith, t.zenith)) == 0 && (cmp = BaseTrack.compareFloat(this.azimuth, t.azimuth)) == 0 && (cmp = -BaseTrack.compareFloat(this.energy, t.energy)) == 0) {
            cmp = -BaseTrack.compareFloat(this.length, t.length);
        }
        return cmp;
    }

    final void computeSamples(float[] timeSteps) {
        float zOrigin;
        float yOrigin;
        float xOrigin;
        float timeOrigin;
        double degrees2radians = Math.PI / 180;
        double sinZenith = Math.sin((double)this.zenith * (Math.PI / 180));
        double cosZenith = Math.cos((double)this.zenith * (Math.PI / 180));
        double sinAzimuth = Math.sin((double)this.azimuth * (Math.PI / 180));
        double cosAzimuth = Math.cos((double)this.azimuth * (Math.PI / 180));
        double SPEED_OF_LIGHT = 0.3;
        if (timeSteps.length == 0) {
            timeOrigin = this.time;
            xOrigin = this.xstart;
            yOrigin = this.ystart;
            zOrigin = this.zstart;
            this.samples = null;
        } else {
            timeOrigin = timeSteps[0];
            double length = (double)(timeOrigin - this.time) * 0.3;
            xOrigin = this.xstart + (float)(length * sinZenith * cosAzimuth);
            yOrigin = this.ystart + (float)(length * sinZenith * sinAzimuth);
            zOrigin = this.zstart + (float)(length * cosZenith);
            this.samples = new float[timeSteps.length + 1][3];
            this.samples[0][0] = xOrigin;
            this.samples[0][1] = yOrigin;
            this.samples[0][2] = zOrigin;
        }
        for (int i = 0; i < timeSteps.length; ++i) {
            double length = (double)(timeSteps[i] - timeOrigin) * 0.3;
            float xDelta = (float)(length * sinZenith * cosAzimuth);
            float yDelta = (float)(length * sinZenith * sinAzimuth);
            float zDelta = (float)(length * cosZenith);
            this.samples[i][0] = xOrigin + xDelta;
            this.samples[i][1] = yOrigin + yDelta;
            this.samples[i][2] = zOrigin + zDelta;
        }
        this.timeSteps = timeSteps;
    }

    public boolean equals(Object obj) {
        return this.compareTo(obj) == 0;
    }

    public final float getEnergy() {
        return this.energy;
    }

    public final float getLength() {
        return this.length;
    }

    private final float getMaxSample(int sample, float dfltValue) {
        if (this.samples == null) {
            System.err.println("BaseTrack.getMaxSample() called before BaseTrack.computeSamples()");
            Thread.dumpStack();
            return dfltValue;
        }
        float max = this.samples[0][sample];
        for (int i = 1; i < this.samples.length; ++i) {
            if (!(this.samples[i][sample] > max)) continue;
            max = this.samples[i][sample];
        }
        return max;
    }

    private final float getMinSample(int sample, float dfltValue) {
        if (this.samples == null) {
            System.err.println("BaseTrack.getMinSample() called before BaseTrack.computeSamples()");
            Thread.dumpStack();
            return dfltValue;
        }
        float min2 = this.samples[0][sample];
        for (int i = 1; i < this.samples.length; ++i) {
            if (!(this.samples[i][sample] < min2)) continue;
            min2 = this.samples[i][sample];
        }
        return min2;
    }

    public final float getXMax() {
        return this.getMaxSample(0, this.xstart);
    }

    public final float getXMin() {
        return this.getMinSample(0, this.xstart);
    }

    public final float getYMax() {
        return this.getMaxSample(1, this.xstart);
    }

    public final float getYMin() {
        return this.getMinSample(1, this.ystart);
    }

    public final float getZMax() {
        return this.getMaxSample(2, this.xstart);
    }

    public final float getZMin() {
        return this.getMinSample(2, this.zstart);
    }

    abstract FlatField makeData() throws VisADException;

    final FlatField makeData(float maxLength) throws VisADException {
        float fldLength = this.length;
        if (fldLength > maxLength) {
            fldLength = maxLength;
        } else if (fldLength != fldLength) {
            fldLength = -1.0f;
        }
        float fldEnergy = this.energy;
        if (fldEnergy != fldEnergy) {
            fldEnergy = 1.0f;
        }
        float zs = (float)Math.sin((double)this.zenith * (Math.PI / 180));
        float zc = (float)Math.cos((double)this.zenith * (Math.PI / 180));
        float as = (float)Math.sin((double)this.azimuth * (Math.PI / 180));
        float ac = (float)Math.cos((double)this.azimuth * (Math.PI / 180));
        float zinc = fldLength * zc;
        float xinc = fldLength * zs * ac;
        float yinc = fldLength * zs * as;
        float[][] locs = new float[][]{{this.xstart - 1000.0f * xinc, this.xstart + 1000.0f * xinc}, {this.ystart - 1000.0f * yinc, this.ystart + 1000.0f * yinc}, {this.zstart - 1000.0f * zinc, this.zstart + 1000.0f * zinc}};
        Gridded3DSet set = new Gridded3DSet((MathType)AmandaFile.xyzType, (float[][])locs, 2);
        FlatField field = new FlatField(functionType, set);
        float[][] values = new float[][]{{this.time, this.time}, {fldEnergy, fldEnergy}};
        try {
            field.setSamples(values, false);
        }
        catch (RemoteException re) {
            re.printStackTrace();
            return null;
        }
        return field;
    }

    final FieldImpl makeTimeSequence(float[] timeSteps) {
        FieldImpl fld;
        Gridded1DSet set;
        if (timeSteps == null || timeSteps.length == 0) {
            return null;
        }
        double degrees2radians = Math.PI / 180;
        double z2 = ((double)this.zenith + 180.0) % 360.0;
        double a2 = this.azimuth;
        double sinZenith = Math.sin(z2 * (Math.PI / 180));
        double cosZenith = Math.cos(z2 * (Math.PI / 180));
        double sinAzimuth = Math.sin(a2 * (Math.PI / 180));
        double cosAzimuth = Math.cos(a2 * (Math.PI / 180));
        double SPEED_OF_LIGHT = 0.3;
        Data[] sets = new Gridded3DSet[timeSteps.length];
        Gridded3DSet missingSet = null;
        float timeOrigin = timeSteps[0];
        float timeFinal = timeSteps[timeSteps.length - 1];
        double baseTime = timeOrigin - this.time;
        double baseLength = baseTime * 0.3;
        float xOrigin = this.xstart + (float)(baseLength * sinZenith * cosAzimuth);
        float yOrigin = this.ystart + (float)(baseLength * sinZenith * sinAzimuth);
        float zOrigin = this.zstart + (float)(baseLength * cosZenith);
        double preTime = baseTime - (double)(timeFinal - timeOrigin) / 2.0;
        double preLength = preTime * 0.3;
        float xPreOrigin = this.xstart + (float)(preLength * sinZenith * cosAzimuth);
        float yPreOrigin = this.ystart + (float)(preLength * sinZenith * sinAzimuth);
        float zPreOrigin = this.zstart + (float)(preLength * cosZenith);
        for (int i = 0; i < timeSteps.length; ++i) {
            Gridded3DSet subSet;
            double length = (double)(timeSteps[i] - timeOrigin) * 0.3;
            float xEndpoint = xOrigin + (float)(length * sinZenith * cosAzimuth);
            float yEndpoint = yOrigin + (float)(length * sinZenith * sinAzimuth);
            float zEndpoint = zOrigin + (float)(length * cosZenith);
            float[][] locs = new float[][]{{xPreOrigin, xEndpoint}, {yPreOrigin, yEndpoint}, {zPreOrigin, zEndpoint}};
            try {
                subSet = new Gridded3DSet((MathType)AmandaFile.xyzType, (float[][])locs, 2);
            }
            catch (VisADException ve) {
                ve.printStackTrace();
                if (missingSet == null) {
                    try {
                        missingSet = new Gridded3DSet((MathType)AmandaFile.xyzType, new float[3][1], 1);
                    }
                    catch (VisADException ve2) {
                        ve2.printStackTrace();
                    }
                }
                subSet = missingSet;
            }
            sets[i] = subSet;
        }
        try {
            set = new Gridded1DSet((MathType)RealType.Time, (float[][])new float[][]{timeSteps}, timeSteps.length);
        }
        catch (VisADException ve) {
            ve.printStackTrace();
            set = null;
        }
        try {
            fld = new FieldImpl(timeSequenceType, set);
            fld.setSamples(sets, false);
        }
        catch (VisADException ve) {
            ve.printStackTrace();
            fld = missing;
        }
        catch (RemoteException re) {
            re.printStackTrace();
            fld = missing;
        }
        return fld;
    }

    public String toString() {
        String fullName = this.getClass().getName();
        int pt = fullName.lastIndexOf(46);
        int ds = fullName.lastIndexOf(36);
        if (ds > pt) {
            pt = ds;
        }
        String className = fullName.substring(pt == -1 ? 0 : pt + 1);
        return className + "[" + this.xstart + "," + this.ystart + "," + this.zstart + " LA#" + this.zenith + " LO#" + this.azimuth + " LE#" + this.length + " NRG#" + this.energy + " TIM#" + this.time + "]";
    }

    static {
        try {
            functionType = new FunctionType(AmandaFile.xyzType, new RealTupleType(RealType.Time, energyType));
            timeSequenceType = new FunctionType(RealType.Time, new SetType(AmandaFile.xyzType));
            Gridded1DSet set = new Gridded1DSet((MathType)RealType.Time, new float[1][1], 1);
            missing = new FieldImpl(timeSequenceType, set);
        }
        catch (VisADException ve) {
            ve.printStackTrace();
            functionType = null;
            indexTupleType = null;
            timeSequenceType = null;
            missing = null;
        }
    }
}

