/*
 * Decompiled with CFR 0.152.
 */
package visad.java3d;

import java.rmi.RemoteException;
import java.util.Vector;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.Switch;
import visad.BadMappingException;
import visad.Data;
import visad.DataDisplayLink;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayImpl;
import visad.Field;
import visad.MathType;
import visad.ScalarMap;
import visad.Set;
import visad.ShadowFunctionOrSetType;
import visad.ShadowRealType;
import visad.ShadowType;
import visad.VisADException;
import visad.java3d.AVControlJ3D;
import visad.java3d.AnimationControlJ3D;
import visad.java3d.AnimationRendererJ3D;
import visad.java3d.RendererJ3D;
import visad.java3d.ShadowFunctionTypeJ3D;
import visad.java3d.VisADBranchGroup;

public class ShadowAnimationFunctionTypeJ3D
extends ShadowFunctionTypeJ3D {
    private static final int MISSING1 = -128;

    public ShadowAnimationFunctionTypeJ3D(MathType t, DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        super(t, link, parent);
    }

    public boolean doTransform(Object group, Data data, float[] value_array, float[] default_values, DataRenderer renderer) throws VisADException, RemoteException {
        DataDisplayLink link = renderer.getLink();
        if (data.isMissing()) {
            ((AnimationRendererJ3D)renderer).markMissingVisADBranch();
            return false;
        }
        if (this.getLevelOfDifficulty() == 6) {
            return false;
        }
        ShadowFunctionOrSetType adaptedShadowType = (ShadowFunctionOrSetType)this.getAdaptedShadowType();
        DisplayImpl display = this.getDisplay();
        Set domain_set = ((Field)data).getDomainSet();
        ShadowRealType[] DomainComponents = adaptedShadowType.getDomainComponents();
        if (((AnimationRendererJ3D)renderer).animation1D) {
            int i;
            ScalarMap map;
            Vector domain_maps = DomainComponents[0].getSelectedMapVector();
            ScalarMap amap = null;
            if (domain_set.getDimension() == 1 && domain_maps.size() == 1 && Display.Animation.equals((map = (ScalarMap)domain_maps.elementAt(0)).getDisplayScalar())) {
                amap = map;
            }
            if (amap == null) {
                throw new BadMappingException("time must be mapped to Animation");
            }
            AnimationControlJ3D control = (AnimationControlJ3D)amap.getControl();
            ((AnimationRendererJ3D)renderer).animation1D = false;
            Switch old_swit = null;
            BranchGroup[] old_nodes = null;
            double[] old_times = null;
            boolean[] old_mark = null;
            int old_len = 0;
            boolean reuse = ((AnimationRendererJ3D)renderer).getReUseFrames();
            if (group instanceof BranchGroup && ((BranchGroup)group).numChildren() > 0) {
                Node g2 = ((BranchGroup)group).getChild(0);
                if (g2 instanceof BranchGroup && ((BranchGroup)g2).numChildren() > 0) {
                    g2 = ((BranchGroup)g2).getChild(0);
                }
                if (g2 instanceof Switch && (old_len = (old_swit = (Switch)g2).numChildren()) > 0) {
                    int i2;
                    old_nodes = new BranchGroup[old_len];
                    for (i2 = 0; i2 < old_len; ++i2) {
                        old_nodes[i2] = (BranchGroup)old_swit.getChild(i2);
                    }
                    for (i2 = 0; i2 < old_len; ++i2) {
                        old_nodes[i2].detach();
                    }
                    old_times = new double[old_len];
                    old_mark = new boolean[old_len];
                    for (i2 = 0; i2 < old_len; ++i2) {
                        old_mark[i2] = false;
                        old_times[i2] = old_nodes[i2] instanceof VisADBranchGroup && reuse ? ((VisADBranchGroup)old_nodes[i2]).getTime() : Double.NaN;
                    }
                }
            }
            double[][] values = domain_set.getDoubles();
            double[] times = values[0];
            int len = times.length;
            double delta = Math.abs((times[len - 1] - times[0]) / (1000.0 * (double)len));
            Switch swit = null;
            if (old_swit != null) {
                swit = old_swit;
                control.addPair(swit, domain_set, renderer);
                ((AVControlJ3D)control).init();
            } else {
                swit = (Switch)this.makeSwitch();
                swit.setCapability(14);
                swit.setCapability(12);
                swit.setCapability(13);
                this.addSwitch(group, swit, control, domain_set, renderer);
            }
            VisADBranchGroup[] nodes = new VisADBranchGroup[len];
            boolean[] mark = new boolean[len];
            for (i = 0; i < len; ++i) {
                for (int j = 0; j < old_len; ++j) {
                    if (old_mark[j] || !(Math.abs(times[i] - old_times[j]) < delta)) continue;
                    old_mark[j] = true;
                    nodes[i] = (VisADBranchGroup)old_nodes[j];
                    break;
                }
                if (nodes[i] != null) {
                    mark[i] = true;
                } else {
                    mark[i] = false;
                    nodes[i] = new VisADBranchGroup(times[i]);
                    nodes[i].setCapability(17);
                    nodes[i].setCapability(14);
                    nodes[i].setCapability(12);
                    nodes[i].setCapability(13);
                    this.ensureNotEmpty((Object)nodes[i]);
                }
                this.addToSwitch(swit, (Object)nodes[i]);
            }
            for (int j = 0; j < old_len; ++j) {
                if (old_mark[j]) continue;
                ((RendererJ3D)renderer).flush((Group)old_nodes[j]);
                old_nodes[j] = null;
            }
            if (group instanceof BranchGroup) {
                ((AnimationRendererJ3D)renderer).setBranchEarly((BranchGroup)group);
            }
            if (((AnimationRendererJ3D)renderer).getReUseFrames() && ((AnimationRendererJ3D)renderer).getSetSetOnReUseFrames()) {
                control.setSet(domain_set, true);
            } else {
                control.setCurrent(0);
            }
            old_nodes = null;
            old_times = null;
            old_mark = null;
            for (i = 0; i < len; ++i) {
                if (mark[i]) continue;
                BranchGroup branch = (BranchGroup)this.makeBranch();
                ((AnimationRendererJ3D)renderer).setVisADBranch(nodes[i]);
                this.recurseRange(branch, ((Field)data).getSample(i), value_array, default_values, renderer);
                ((AnimationRendererJ3D)renderer).setVisADBranch(null);
                nodes[i].addChild((Node)branch);
            }
        } else {
            super.doTransform(group, data, value_array, default_values, renderer);
        }
        this.ensureNotEmpty(group);
        return false;
    }
}

