/*
 * Decompiled with CFR 0.152.
 */
package ucar.jpeg.colorspace.boxes;

import java.io.IOException;
import ucar.jpeg.colorspace.ColorSpace;
import ucar.jpeg.colorspace.ColorSpaceException;
import ucar.jpeg.colorspace.boxes.JP2Box;
import ucar.jpeg.icc.ICCProfile;
import ucar.jpeg.jj2000.j2k.io.RandomAccessIO;
import ucar.jpeg.jj2000.j2k.util.FacilityManager;

public final class ColorSpecificationBox
extends JP2Box {
    private ColorSpace.MethodEnum method = null;
    private ColorSpace.CSEnum colorSpace = null;
    private byte[] iccProfile = null;
    private int cs;
    private int rawmethod;
    private int approxAccuracy;

    public ColorSpecificationBox(RandomAccessIO in, int boxStart) throws IOException, ColorSpaceException {
        super(in, boxStart);
        this.readBox();
    }

    private void readBox() throws IOException, ColorSpaceException {
        byte[] boxHeader = new byte[256];
        this.in.seek(this.dataStart);
        this.in.readFully(boxHeader, 0, 11);
        this.rawmethod = boxHeader[0];
        this.approxAccuracy = boxHeader[2];
        block0 : switch (this.rawmethod) {
            case 1: {
                this.cs = ICCProfile.getInt(boxHeader, 3);
                switch (this.cs) {
                    case 16: {
                        this.colorSpace = ColorSpace.sRGB;
                        break block0;
                    }
                    case 17: {
                        this.colorSpace = ColorSpace.GreyScale;
                        break block0;
                    }
                    case 18: {
                        this.colorSpace = ColorSpace.sYCC;
                        break block0;
                    }
                }
                FacilityManager.getMsgLogger().printmsg(2, "Unknown enumerated colorspace (" + this.cs + ") in color specification box");
                this.colorSpace = ColorSpace.Unknown;
                break;
            }
            case 2: {
                this.method = ColorSpace.ICC_PROFILED;
                this.cs = -1;
                int size = ICCProfile.getInt(boxHeader, 3);
                this.iccProfile = new byte[size];
                this.in.seek(this.dataStart + 3);
                this.in.readFully(this.iccProfile, 0, size);
                break;
            }
            default: {
                throw new ColorSpaceException("Bad specification method (" + boxHeader[0] + ") in " + this);
            }
        }
    }

    public ColorSpace.MethodEnum getMethod() {
        return this.method;
    }

    public ColorSpace.CSEnum getColorSpace() {
        return this.colorSpace;
    }

    public int getRawMethod() {
        return this.rawmethod;
    }

    public int getRawApproximationAccuracy() {
        return this.approxAccuracy;
    }

    public int getRawColorSpace() {
        return this.cs;
    }

    public String getColorSpaceString() {
        return this.colorSpace.value;
    }

    public String getMethodString() {
        return this.method.value;
    }

    public byte[] getICCProfile() {
        return this.iccProfile;
    }

    public String toString() {
        StringBuffer rep = new StringBuffer("[ColorSpecificationBox ");
        rep.append("method= ").append(String.valueOf(this.method)).append(", ");
        rep.append("ucar.jpeg.colorspace= ").append(String.valueOf(this.colorSpace)).append("]");
        return rep.toString();
    }

    static {
        type = 1668246642;
    }
}

