/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft;

import java.io.IOException;
import java.util.Formatter;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetFactory;
import ucar.nc2.ft2.simpgeometry.SimpleGeometryFeatureDataset;
import ucar.nc2.ft2.simpgeometry.adapter.SimpleGeometryCSBuilder;
import ucar.nc2.util.CancelTask;

public class SimpleGeometryStandardFactory
implements FeatureDatasetFactory {
    @Override
    public Object isMine(FeatureType wantFeatureType, NetcdfDataset ncd, Formatter errlog) throws IOException {
        SimpleGeometryCSBuilder sgCoverage = SimpleGeometryCSBuilder.classify(ncd, errlog);
        if (sgCoverage == null || sgCoverage.getFeatureType() == null) {
            return null;
        }
        if (!this.match(wantFeatureType, sgCoverage.getFeatureType())) {
            return null;
        }
        return sgCoverage;
    }

    private boolean match(FeatureType wantFeatureType, FeatureType covType) {
        if (wantFeatureType == null || wantFeatureType == FeatureType.ANY) {
            return true;
        }
        return true;
    }

    @Override
    public FeatureDataset open(FeatureType ftype, NetcdfDataset ncd, Object analysis, CancelTask task, Formatter errlog) throws IOException {
        return new SimpleGeometryFeatureDataset(ncd);
    }

    @Override
    public FeatureType[] getFeatureTypes() {
        return new FeatureType[]{FeatureType.SIMPLE_GEOMETRY};
    }
}

