/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft2.simpgeometry;

import java.io.IOException;
import ucar.ma2.Array;
import ucar.nc2.Variable;

public class SimpleGeometryIndexFinder {
    private final int INVALID_INDEX = -10;
    private Array nodeCount = null;
    private int pastIndex;
    private int previousEnd;
    private int previousBegin;

    private int getNodeCount(int index) {
        return this.nodeCount.getInt(index);
    }

    public int getBeginning(int index) {
        if (index == this.pastIndex + 1) {
            return this.previousEnd + 1;
        }
        int newBeginning = 0;
        for (int i = 0; i < index; ++i) {
            newBeginning += this.getNodeCount(i);
        }
        this.pastIndex = index;
        this.previousBegin = newBeginning;
        return newBeginning;
    }

    public int getEnd(int index) {
        if (index == this.pastIndex - 1) {
            return this.previousBegin - 1;
        }
        int new_end = 0;
        for (int i = 0; i < index + 1; ++i) {
            new_end += this.getNodeCount(i);
        }
        this.pastIndex = index;
        this.previousEnd = new_end;
        return new_end - 1;
    }

    public SimpleGeometryIndexFinder(Variable node_count) {
        try {
            this.nodeCount = node_count.read();
        }
        catch (IOException e) {
            this.nodeCount = null;
            e.printStackTrace();
        }
        this.pastIndex = -10;
        this.previousEnd = -10;
        this.previousBegin = -10;
    }
}

