/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.util.ArrowSlider;
import visad.util.Slider;
import visad.util.SliderChangeEvent;
import visad.util.SliderChangeListener;

public class SliderLabel
extends JPanel
implements SliderChangeListener {
    private Slider slider;
    private String label;
    private boolean rangeVisible;
    private Color background;
    private Color text;
    Dimension minSize = null;
    Dimension prefSize = null;
    Dimension maxSize = null;
    private boolean rangeChanged;
    private String drawmin;
    private String drawmax;
    private String drawval;

    public SliderLabel(Slider slider) {
        this(slider, slider.getName());
    }

    public SliderLabel(Slider slider, Color background, Color text) {
        this(slider, slider.getName(), background, text);
    }

    public SliderLabel(Slider slider, String label, Color background, Color text) {
        this(slider, label, true, background, text);
    }

    public SliderLabel(Slider slider, String label) {
        this(slider, label, true);
    }

    public SliderLabel(Slider slider, String label, boolean rangeVisible) {
        this(slider, label, rangeVisible, Color.black, Color.white);
    }

    public SliderLabel(Slider slider, String label, boolean rangeVisible, Color background, Color text) {
        this.slider = slider;
        this.label = label;
        this.rangeVisible = rangeVisible;
        this.background = background;
        this.text = text;
        slider.addSliderChangeListener(this);
    }

    public void sliderChanged(SliderChangeEvent e) {
        if (e.type != 1) {
            this.rangeChanged = true;
        }
        this.validate();
        this.repaint();
    }

    public void update(Graphics g2) {
        FontMetrics fm = g2.getFontMetrics();
        if (this.rangeVisible) {
            if (this.rangeChanged) {
                g2.setColor(this.background);
                if (this.drawmin == null) {
                    this.drawmin = "null";
                }
                if (this.drawmax == null) {
                    this.drawmax = "null";
                }
                g2.drawString(this.drawmin, 3, this.getBounds().height - 1 - fm.getDescent());
                g2.drawString(this.drawmax, this.getBounds().width - 4 - fm.stringWidth(this.drawmax), this.getBounds().height - 1 - fm.getDescent());
                this.rangeChanged = false;
            }
            g2.setColor(this.text);
            String min2 = Float.toString(this.slider.getMinimum());
            g2.drawString(min2, 3, this.getBounds().height - 1 - fm.getDescent());
            this.drawmin = min2;
            String max = Float.toString(this.slider.getMaximum());
            g2.drawString(max, this.getBounds().width - 4 - fm.stringWidth(max), this.getBounds().height - 1 - fm.getDescent());
            this.drawmax = max;
        }
        g2.setColor(this.background);
        if (this.drawval == null) {
            this.drawval = "null";
        }
        g2.drawString(this.drawval, this.getBounds().width / 2 - fm.stringWidth(this.drawval) / 2 + 3, this.getBounds().height - 1 - fm.getDescent());
        g2.setColor(this.text);
        String val = new String(this.label + " = " + this.slider.getValue());
        g2.drawString(val, this.getBounds().width / 2 - fm.stringWidth(val) / 2 + 3, this.getBounds().height - 1 - fm.getDescent());
        this.drawval = val;
    }

    public void paint(Graphics g2) {
        g2.setColor(this.background);
        g2.fillRect(0, 0, this.getBounds().width, this.getBounds().height);
        g2.setColor(this.text);
        FontMetrics fm = g2.getFontMetrics();
        if (this.rangeVisible) {
            String min2 = Float.toString(this.slider.getMinimum());
            g2.drawString(min2, 3, this.getBounds().height - 1 - fm.getDescent());
            this.drawmin = min2;
            String max = Float.toString(this.slider.getMaximum());
            g2.drawString(max, this.getBounds().width - 4 - fm.stringWidth(max), this.getBounds().height - 1 - fm.getDescent());
            this.drawmax = max;
        }
        String val = new String(this.label + " = " + this.slider.getValue());
        g2.drawString(val, this.getBounds().width / 2 - fm.stringWidth(val) / 2 + 3, this.getBounds().height - 1 - fm.getDescent());
        this.drawval = val;
    }

    public Dimension getPreferredSize() {
        if (this.prefSize == null) {
            this.prefSize = new Dimension(256, 18);
        }
        return this.prefSize;
    }

    public void setPreferredSize(Dimension dim) {
        this.prefSize = dim;
    }

    public Dimension getMaximumSize() {
        if (this.maxSize == null) {
            this.maxSize = new Dimension(Integer.MAX_VALUE, 18);
        }
        return this.maxSize;
    }

    public void setMaximumSize(Dimension dim) {
        this.maxSize = dim;
    }

    public Dimension getMinimumSize() {
        if (this.minSize == null) {
            this.minSize = new Dimension(100, 18);
        }
        return this.minSize;
    }

    public void setMinimumSize(Dimension dim) {
        this.minSize = dim;
    }

    public static void main(String[] argc) {
        ArrowSlider slider = new ArrowSlider();
        SliderLabel label = new SliderLabel(slider, "test");
        JFrame f = new JFrame("Visad Slider Label");
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        f.setLayout(new BorderLayout());
        f.add((Component)label, "South");
        f.add((Component)slider, "North");
        int height = ((JComponent)slider).getPreferredSize().height + label.getPreferredSize().height;
        int width = Math.max(((JComponent)slider).getPreferredSize().width, label.getPreferredSize().height);
        f.setSize(new Dimension(width, height + 27));
        f.setVisible(true);
    }
}

