/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft2.simpgeometry;

import java.io.IOException;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft2.simpgeometry.CFSimpleGeometryHelper;
import ucar.nc2.ft2.simpgeometry.GeometryType;
import ucar.nc2.ft2.simpgeometry.Point;
import ucar.nc2.ft2.simpgeometry.SimpleGeometryIndexFinder;
import ucar.nc2.ft2.simpgeometry.exception.InvalidDataseriesException;

public class CFPoint
implements Point {
    private double x;
    private double y;
    private Point next;
    private Point prev;
    private Array data;

    public GeometryType getGeometryType() {
        return GeometryType.POINT;
    }

    @Override
    public Array getData() {
        return this.data;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public Point getNext() {
        return this.next;
    }

    @Override
    public Point getPrev() {
        return this.prev;
    }

    @Override
    public void setData(Array arr) {
        this.data = arr;
    }

    @Override
    public void setX(double x) {
        this.x = x;
    }

    @Override
    public void setY(double y) {
        this.y = y;
    }

    @Override
    public void setNext(Point next) {
        this.next = next;
    }

    @Override
    public void setPrev(Point prev) {
        this.prev = prev;
    }

    @Override
    public Point setupPoint(NetcdfDataset dataset, Variable vari, int index) {
        block17: {
            int ind = index;
            boolean multi = false;
            SimpleGeometryIndexFinder indexFinder = null;
            List<CoordinateAxis> axes = dataset.getCoordinateAxes();
            CoordinateAxis x = null;
            CoordinateAxis y = null;
            String[] nodeCoords = vari.findAttributeIgnoreCase("node_coordinates").getStringValue().split(" ");
            for (CoordinateAxis ax : axes) {
                if (ax.getFullName().equals(nodeCoords[0])) {
                    x = ax;
                }
                if (!ax.getFullName().equals(nodeCoords[1])) continue;
                y = ax;
            }
            String node_c_str = vari.findAttValueIgnoreCase("node_count", "");
            if (!node_c_str.equals("")) {
                Variable nodeCounts = dataset.findVariable(node_c_str);
                indexFinder = new SimpleGeometryIndexFinder(nodeCounts);
                multi = true;
            }
            try {
                Array yPts;
                Array xPts;
                if (multi) {
                    xPts = x.read(indexFinder.getBeginning(index) + ":" + indexFinder.getEnd(index)).reduce();
                    yPts = y.read(indexFinder.getBeginning(index) + ":" + indexFinder.getEnd(index)).reduce();
                } else {
                    xPts = x.read(Integer.toString(ind)).reduce();
                    yPts = y.read(Integer.toString(ind)).reduce();
                    this.x = xPts.getDouble(0);
                    this.y = yPts.getDouble(0);
                }
                if (!multi) {
                    this.x = xPts.getDouble(0);
                    this.y = yPts.getDouble(0);
                    switch (vari.getRank()) {
                        case 2: {
                            this.setData(vari.read(CFSimpleGeometryHelper.getSubsetString(vari, index)).reduce());
                            break block17;
                        }
                        case 1: {
                            this.setData(vari.read("" + index));
                            break block17;
                        }
                        default: {
                            throw new InvalidDataseriesException("Error: Only dataseries of rank 1 or 2 are allowed for simple geometry.");
                        }
                    }
                }
                IndexIterator itrX = xPts.getIndexIterator();
                IndexIterator itrY = yPts.getIndexIterator();
                this.next = null;
                this.prev = null;
                Point point = this;
                while (itrX.hasNext()) {
                    point.setX(itrX.getDoubleNext());
                    point.setY(itrY.getDoubleNext());
                    switch (vari.getRank()) {
                        case 2: {
                            point.setData(vari.read(CFSimpleGeometryHelper.getSubsetString(vari, index)).reduce());
                            break;
                        }
                        case 1: {
                            point.setData(vari.read("" + index));
                            break;
                        }
                        default: {
                            throw new InvalidDataseriesException("Error: Only dataseries of rank 1 or 2 are allowed for simple geometry.");
                        }
                    }
                    point.setNext(new CFPoint());
                    point = point.getNext();
                }
                point = point.getPrev();
                point.setNext(null);
            }
            catch (IOException | InvalidRangeException | InvalidDataseriesException e) {
                e.printStackTrace();
                return null;
            }
        }
        return this;
    }

    @Override
    public double[] getBBUpper() {
        double[] bbUpper = new double[]{this.getX() + 10.0, this.getY() + 10.0};
        return bbUpper;
    }

    @Override
    public double[] getBBLower() {
        double[] bbLower = new double[]{this.getX() - 10.0, this.getY() - 10.0};
        return bbLower;
    }

    public CFPoint(double x, double y, Point prev, Point next, Array data) {
        this.next = next;
        this.prev = prev;
        if (next != null) {
            next.setPrev(this);
        }
        if (prev != null) {
            prev.setNext(this);
        }
        this.x = x;
        this.y = y;
        this.data = data;
    }

    public CFPoint() {
        this(0.0, 0.0, null, null, null);
    }
}

