/*
 * Decompiled with CFR 0.152.
 */
package ucar.mcidas;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import ucar.mcidas.McIDASException;

public class EnhancementTable {
    private int[][] rgbValues = null;
    private DataInputStream dataStream;

    public EnhancementTable() {
        this.rgbValues = new int[3][256];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 256; ++j) {
                this.rgbValues[i][j] = j;
            }
        }
    }

    public EnhancementTable(String source) throws McIDASException {
        try {
            this.dataStream = new DataInputStream(new BufferedInputStream(new FileInputStream(source)));
        }
        catch (Exception e) {
            try {
                this.dataStream = new DataInputStream(new BufferedInputStream(new URL(source).openStream()));
            }
            catch (Exception e2) {
                throw new McIDASException("Unable to open enhancement table " + source);
            }
        }
        this.readRGBValues();
    }

    public EnhancementTable(File file) throws McIDASException {
        try {
            this.dataStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        }
        catch (Exception e) {
            throw new McIDASException("Unable to open enhancement table " + file);
        }
        this.readRGBValues();
    }

    public EnhancementTable(URL url) throws McIDASException {
        try {
            this.dataStream = new DataInputStream(new BufferedInputStream(url.openStream()));
        }
        catch (Exception e) {
            throw new McIDASException("Unable to open enhancement table at URL" + url);
        }
        this.readRGBValues();
    }

    private void readRGBValues() throws McIDASException {
        this.rgbValues = new int[3][256];
        try {
            int reservedWord = this.dataStream.readInt();
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 256; ++j) {
                    this.rgbValues[i][j] = this.dataStream.readInt();
                }
            }
        }
        catch (Exception e) {
            throw new McIDASException("Invalid enhancement table");
        }
    }

    public int[][] getRGBValues() {
        return this.rgbValues;
    }

    public int getIndex(int red, int green, int blue) {
        for (int inx = 0; inx < 256; ++inx) {
            if (this.rgbValues[0][inx] != red || this.rgbValues[1][inx] != green || this.rgbValues[2][inx] != blue) continue;
            return inx;
        }
        return -1;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(" Brightness  Red       Green      Blue ");
        sb.append("\n");
        sb.append("  min max   min max   min max   min max");
        sb.append("\n");
        sb.append("  --- ---   --- ---   --- ---   --- ---");
        sb.append("\n");
        for (int i = 0; i < 256; ++i) {
            sb.append(" " + i + "  " + this.rgbValues[0][i] + " " + this.rgbValues[1][i] + " " + this.rgbValues[2][i]);
            sb.append("\n");
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        try {
            EnhancementTable et = args.length == 0 ? new EnhancementTable() : new EnhancementTable(args[0]);
            System.out.println(et.toString());
        }
        catch (McIDASException e) {
            System.out.println(e.toString());
        }
    }
}

