/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.vertical;

import java.io.IOException;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.unidata.geoloc.vertical.VerticalTransformImpl;
import ucar.unidata.util.Parameter;

public class OceanS
extends VerticalTransformImpl {
    public static final String ETA = "Eta_variableName";
    public static final String S = "S_variableName";
    public static final String DEPTH = "Depth_variableName";
    public static final String DEPTH_C = "Depth_c_variableName";
    public static final String A = "A_variableName";
    public static final String B = "B_variableName";
    private double depth_c;
    private Variable etaVar;
    private Variable sVar;
    private Variable depthVar;
    private Variable aVar;
    private Variable bVar;
    private Variable depthCVar;
    private Array c;

    public OceanS(NetcdfFile ds, Dimension timeDim, List<Parameter> params) {
        super(timeDim);
        String etaName = this.getParameterStringValue(params, ETA);
        String sName = this.getParameterStringValue(params, S);
        String depthName = this.getParameterStringValue(params, DEPTH);
        String aName = this.getParameterStringValue(params, A);
        String bName = this.getParameterStringValue(params, B);
        String depthCName = this.getParameterStringValue(params, DEPTH_C);
        this.etaVar = ds.findVariable(etaName);
        this.sVar = ds.findVariable(sName);
        this.depthVar = ds.findVariable(depthName);
        this.aVar = ds.findVariable(aName);
        this.bVar = ds.findVariable(bName);
        this.depthCVar = ds.findVariable(depthCName);
        this.units = ds.findAttValueIgnoreCase(this.depthVar, "units", "none");
    }

    @Override
    public ArrayDouble.D3 getCoordinateArray(int timeIndex) throws IOException, InvalidRangeException {
        Array etaArray = this.readArray(this.etaVar, timeIndex);
        Array sArray = this.readArray(this.sVar, timeIndex);
        Array depthArray = this.readArray(this.depthVar, timeIndex);
        if (null == this.c) {
            double a = this.aVar.readScalarDouble();
            double b = this.bVar.readScalarDouble();
            this.depth_c = this.depthCVar.readScalarDouble();
            this.c = this.makeC(sArray, a, b);
        }
        return this.makeHeight(etaArray, sArray, depthArray, this.c, this.depth_c);
    }

    @Override
    public ArrayDouble.D1 getCoordinateArray1D(int timeIndex, int xIndex, int yIndex) throws IOException, InvalidRangeException {
        Array etaArray = this.readArray(this.etaVar, timeIndex);
        Array sArray = this.readArray(this.sVar, timeIndex);
        Array depthArray = this.readArray(this.depthVar, timeIndex);
        if (null == this.c) {
            double a = this.aVar.readScalarDouble();
            double b = this.bVar.readScalarDouble();
            this.depth_c = this.depthCVar.readScalarDouble();
            this.c = this.makeC(sArray, a, b);
        }
        return this.makeHeight1D(etaArray, sArray, depthArray, this.c, this.depth_c, xIndex, yIndex);
    }

    private Array makeC(Array s2, double a, double b) {
        int nz = (int)s2.getSize();
        Index sIndex = s2.getIndex();
        if (a == 0.0) {
            return s2;
        }
        ArrayDouble.D1 c = new ArrayDouble.D1(nz);
        double fac1 = 1.0 - b;
        double denom1 = 1.0 / Math.sinh(a);
        double denom2 = 1.0 / (2.0 * Math.tanh(0.5 * a));
        for (int i = 0; i < nz; ++i) {
            double sz = s2.getDouble(sIndex.set(i));
            double term1 = fac1 * Math.sinh(a * sz) * denom1;
            double term2 = b * (Math.tanh(a * (sz + 0.5)) * denom2 - 0.5);
            c.set(i, term1 + term2);
        }
        return c;
    }

    private ArrayDouble.D3 makeHeight(Array eta, Array s2, Array depth, Array c, double depth_c) {
        int nz = (int)s2.getSize();
        Index sIndex = s2.getIndex();
        Index cIndex = c.getIndex();
        int[] shape2D = eta.getShape();
        int ny = shape2D[0];
        int nx = shape2D[1];
        Index etaIndex = eta.getIndex();
        Index depthIndex = depth.getIndex();
        ArrayDouble.D3 height = new ArrayDouble.D3(nz, ny, nx);
        for (int z = 0; z < nz; ++z) {
            double sz = s2.getDouble(sIndex.set(z));
            double cz = c.getDouble(cIndex.set(z));
            double term1 = depth_c * sz;
            for (int y = 0; y < ny; ++y) {
                for (int x = 0; x < nx; ++x) {
                    double fac1 = depth.getDouble(depthIndex.set(y, x));
                    double term2 = (fac1 - depth_c) * cz;
                    double Sterm = term1 + term2;
                    double term3 = eta.getDouble(etaIndex.set(y, x));
                    double term4 = 1.0 + Sterm / fac1;
                    double hterm = Sterm + term3 * term4;
                    height.set(z, y, x, hterm);
                }
            }
        }
        return height;
    }

    private ArrayDouble.D1 makeHeight1D(Array eta, Array s2, Array depth, Array c, double depth_c, int x_index, int y_index) {
        int nz = (int)s2.getSize();
        Index sIndex = s2.getIndex();
        Index cIndex = c.getIndex();
        Index etaIndex = eta.getIndex();
        Index depthIndex = depth.getIndex();
        ArrayDouble.D1 height = new ArrayDouble.D1(nz);
        for (int z = 0; z < nz; ++z) {
            double sz = s2.getDouble(sIndex.set(z));
            double cz = c.getDouble(cIndex.set(z));
            double term1 = depth_c * sz;
            double fac1 = depth.getDouble(depthIndex.set(y_index, x_index));
            double term2 = (fac1 - depth_c) * cz;
            double Sterm = term1 + term2;
            double term3 = eta.getDouble(etaIndex.set(y_index, x_index));
            double term4 = 1.0 + Sterm / fac1;
            double hterm = Sterm + term3 * term4;
            height.set(z, hterm);
        }
        return height;
    }
}

