/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.io.http;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import ucar.httpservices.HTTPFactory;
import ucar.httpservices.HTTPMethod;
import ucar.httpservices.HTTPSession;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.Urlencoded;

public class HTTPRandomAccessFile
extends RandomAccessFile {
    public static final int defaultHTTPBufferSize = 20000;
    public static final int maxHTTPBufferSize = Integer.parseInt(System.getProperty("ucar.unidata.io.http.maxHttpBufferSize", "10000000"));
    private static final boolean debug = false;
    private static final boolean debugDetails = false;
    private String url;
    private HTTPSession session;
    private long total_length;

    public HTTPRandomAccessFile(String url) throws IOException {
        this(url, 20000);
        this.location = url;
    }

    @Urlencoded
    public HTTPRandomAccessFile(String url, int bufferSize) throws IOException {
        super(bufferSize);
        this.file = null;
        this.url = url;
        this.location = url;
        if (debugLeaks) {
            allFiles.add(this.location);
        }
        this.session = HTTPFactory.newSession(url);
        boolean needtest = true;
        try (HTTPMethod method = HTTPFactory.Head(this.session, url);){
            this.doConnect(method);
            Optional<String> acceptRangesOpt = method.getResponseHeaderValue("Accept-Ranges");
            if (!acceptRangesOpt.isPresent()) {
                needtest = true;
            } else {
                String acceptRanges = acceptRangesOpt.get();
                if (acceptRanges.equalsIgnoreCase("bytes")) {
                    needtest = false;
                } else if (acceptRanges.equalsIgnoreCase("none")) {
                    throw new IOException("Server does not support byte Ranges");
                }
            }
            try {
                this.total_length = method.getResponseHeaderValue("Content-Length").map(Long::parseLong).orElseThrow(() -> new IOException("Server does not support Content-Length"));
            }
            catch (NumberFormatException e) {
                throw new IOException("Server has malformed Content-Length header");
            }
        }
        if (this.total_length == 0L) {
            needtest = true;
        }
        if (needtest && !this.rangeOk(url)) {
            throw new IOException("Server does not support byte Ranges");
        }
        if (this.total_length > 0L) {
            int useBuffer = (int)Math.min(this.total_length, (long)maxHTTPBufferSize);
            useBuffer = Math.max(useBuffer, 20000);
            this.setBufferSize(useBuffer);
        }
        if (debugLeaks) {
            openFiles.add(this.location);
        }
    }

    @Override
    public void close() {
        if (debugLeaks) {
            openFiles.remove(this.location);
        }
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean rangeOk(String url) {
        try (HTTPMethod method = HTTPFactory.Get(this.session, url);){
            method.setRange(0L, 0L);
            this.doConnect(method);
            int code = method.getStatusCode();
            if (code != 206) {
                throw new IOException("Server does not support Range requests, code= " + code);
            }
            this.total_length = method.getResponseHeaderValue("Content-Range").map(r -> Long.parseLong(r.substring(r.lastIndexOf("/") + 1))).orElseThrow(() -> new IOException("Server did not return a Content-Range"));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    private void doConnect(HTTPMethod method) throws IOException {
        int statusCode = method.execute();
        if (statusCode == 404) {
            throw new FileNotFoundException(this.url + " " + method.getStatusLine());
        }
        if (statusCode >= 300) {
            throw new IOException(this.url + " " + method.getStatusLine());
        }
    }

    private void printHeaders(String title, Collection<Map.Entry<String, String>> headers) {
        if (headers.isEmpty()) {
            return;
        }
        System.out.println(title);
        for (Map.Entry<String, String> entry : headers) {
            System.out.println(String.format("  %s = %s" + entry.getKey(), entry.getValue()));
        }
    }

    @Override
    protected int read_(long pos, byte[] buff, int offset, int len) throws IOException {
        long end = pos + (long)len - 1L;
        if (end >= this.total_length) {
            end = this.total_length - 1L;
        }
        try (HTTPMethod method = HTTPFactory.Get(this.session, this.url);){
            method.setFollowRedirects(true);
            method.setRange(pos, end);
            this.doConnect(method);
            int code = method.getStatusCode();
            if (code != 206) {
                throw new IOException("Server does not support Range requests, code= " + code);
            }
            int readLen = method.getResponseHeaderValue("Content-Length").map(Integer::parseInt).orElseThrow(() -> new IOException("Server did not return a Content-Length"));
            readLen = Math.min(len, readLen);
            InputStream is = method.getResponseAsStream();
            int n = readLen = this.copy(is, buff, offset, readLen);
            return n;
        }
    }

    private int copy(InputStream in, byte[] buff, int offset, int want) throws IOException {
        int bytesRead;
        int done = 0;
        while (want > 0 && (bytesRead = in.read(buff, offset + done, want)) != -1) {
            done += bytesRead;
            want -= bytesRead;
        }
        return done;
    }

    @Override
    public long readToByteChannel(WritableByteChannel dest, long offset, long nbytes) throws IOException {
        int n = (int)nbytes;
        byte[] buff = new byte[n];
        int done = this.read_(offset, buff, 0, n);
        dest.write(ByteBuffer.wrap(buff));
        return done;
    }

    @Override
    public long length() {
        long fileLength = this.total_length;
        if (fileLength < this.dataEnd) {
            return this.dataEnd;
        }
        return fileLength;
    }

    @Override
    public long getLastModified() {
        return 0L;
    }
}

